<?php

if ( !defined( 'ABSPATH' ) ) {
    exit;
}
require_once ORADEL_PATH . 'includes/helpers.php';
class Oradel_Heading_Widget extends \Elementor\Widget_Base {
    public function get_name() {
        return 'oradel_heading';
    }

    public function get_title() {
        return esc_html__( 'Advanced Heading', 'orange-addons-for-elementor' );
    }

    public function get_icon() {
        return 'eicon-heading';
    }

    public function get_categories() {
        return ['oradel-plugin'];
    }

    public function get_keywords() {
        return ['heading'];
    }

    public function get_custom_help_url() {
        return 'https://orange-addons.com/docs/';
    }

    public function get_style_depends() {
        return ['oea-advanced-heading'];
    }

    public function get_script_depends() {
        return ['oea-scroll-animations'];
    }

    protected function register_controls() {
        $this->start_controls_section( 'section_content', [
            'label' => __( 'Content', 'orange-addons-for-elementor' ),
        ] );
        $this->add_control( 'enable_dual_heading', [
            'label'     => __( 'Enable Dual Heading', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::SWITCHER,
            'label_on'  => __( 'Yes', 'orange-addons-for-elementor' ),
            'label_off' => __( 'No', 'orange-addons-for-elementor' ),
            'default'   => '',
        ] );
        $this->add_control( 'enable_background_text', [
            'label'     => __( 'Enable Background Text', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::SWITCHER,
            'label_on'  => __( 'Yes', 'orange-addons-for-elementor' ),
            'label_off' => __( 'No', 'orange-addons-for-elementor' ),
            'default'   => '',
        ] );
        $this->add_control( 'background_text', [
            'label'       => __( 'Background Text', 'orange-addons-for-elementor' ),
            'type'        => \Elementor\Controls_Manager::TEXT,
            'default'     => __( 'Background', 'orange-addons-for-elementor' ),
            'placeholder' => __( 'Enter background text', 'orange-addons-for-elementor' ),
            'condition'   => [
                'enable_background_text' => 'yes',
            ],
        ] );
        $this->add_control( 'show_description', [
            'label'     => __( 'Show Description', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::SWITCHER,
            'label_on'  => __( 'Yes', 'orange-addons-for-elementor' ),
            'label_off' => __( 'No', 'orange-addons-for-elementor' ),
            'default'   => 'yes',
        ] );
        $this->add_control( 'subheading_text', [
            'label'       => __( 'Description Text', 'orange-addons-for-elementor' ),
            'type'        => \Elementor\Controls_Manager::TEXTAREA,
            'default'     => '',
            'placeholder' => __( 'Enter description text', 'orange-addons-for-elementor' ),
            'condition'   => [
                'show_description' => 'yes',
            ],
        ] );
        $this->add_control( 'heading_text', [
            'label'       => __( 'Heading Text', 'orange-addons-for-elementor' ),
            'type'        => \Elementor\Controls_Manager::TEXT,
            'default'     => __( 'Your Heading', 'orange-addons-for-elementor' ),
            'placeholder' => __( 'Enter heading text', 'orange-addons-for-elementor' ),
            'condition'   => [
                'enable_dual_heading' => '',
            ],
        ] );
        $this->add_control( 'heading_text_part1', [
            'label'       => __( 'Heading Text Part 1', 'orange-addons-for-elementor' ),
            'type'        => \Elementor\Controls_Manager::TEXT,
            'default'     => __( 'Your', 'orange-addons-for-elementor' ),
            'placeholder' => __( 'Enter first part of heading', 'orange-addons-for-elementor' ),
            'condition'   => [
                'enable_dual_heading' => 'yes',
            ],
        ] );
        $this->add_control( 'heading_text_part2', [
            'label'       => __( 'Heading Text Part 2', 'orange-addons-for-elementor' ),
            'type'        => \Elementor\Controls_Manager::TEXT,
            'default'     => __( 'Heading', 'orange-addons-for-elementor' ),
            'placeholder' => __( 'Enter second part of heading', 'orange-addons-for-elementor' ),
            'condition'   => [
                'enable_dual_heading' => 'yes',
            ],
        ] );
        $this->add_control( 'heading_tag', [
            'label'   => __( 'HTML Tag', 'orange-addons-for-elementor' ),
            'type'    => \Elementor\Controls_Manager::SELECT,
            'default' => 'h2',
            'options' => [
                'h1'   => 'H1',
                'h2'   => 'H2',
                'h3'   => 'H3',
                'h4'   => 'H4',
                'h5'   => 'H5',
                'h6'   => 'H6',
                'div'  => 'div',
                'span' => 'span',
            ],
        ] );
        $this->add_control( 'underline_style', [
            'label'   => __( 'Underline Style', 'orange-addons-for-elementor' ),
            'type'    => \Elementor\Controls_Manager::SELECT,
            'default' => 'none',
            'options' => [
                'none'           => __( 'None', 'orange-addons-for-elementor' ),
                'full-border'    => __( 'Full Width Border', 'orange-addons-for-elementor' ),
                'water-wave'     => __( 'Water Wave', 'orange-addons-for-elementor' ),
                'rounded-line'   => __( 'Rounded Line', 'orange-addons-for-elementor' ),
                'line-with-text' => __( 'Line With Text', 'orange-addons-for-elementor' ),
                'torn-paper'     => __( 'Torn Paper', 'orange-addons-for-elementor' ),
                'fade-line'      => __( 'Fade Line', 'orange-addons-for-elementor' ),
                'wave-animation' => __( 'Wave Animation', 'orange-addons-for-elementor' ),
            ],
        ] );
        $this->add_control( 'underline_text', [
            'label'       => __( 'Underline Text', 'orange-addons-for-elementor' ),
            'type'        => \Elementor\Controls_Manager::TEXT,
            'default'     => __( 'NEWS', 'orange-addons-for-elementor' ),
            'placeholder' => __( 'Enter your underline text', 'orange-addons-for-elementor' ),
            'condition'   => [
                'underline_style' => 'line-with-text',
            ],
            'selectors'   => [
                '{{WRAPPER}} .custom-heading .heading-underline.line-with-text::after' => 'content: "{{VALUE}}";',
            ],
        ] );
        $this->add_control( 'element_order_preset', [
            'label'       => __( 'Element Order', 'orange-addons-for-elementor' ),
            'type'        => \Elementor\Controls_Manager::SELECT,
            'options'     => [
                'icon-heading-underline-description' => __( 'Icon — Heading — Underline — Description', 'orange-addons-for-elementor' ),
                'icon-heading-description-underline' => __( 'Icon — Heading — Description — Underline', 'orange-addons-for-elementor' ),
                'icon-underline-heading-description' => __( 'Icon — Underline — Heading — Description', 'orange-addons-for-elementor' ),
                'icon-description-heading-underline' => __( 'Icon — Description — Heading — Underline', 'orange-addons-for-elementor' ),
                'heading-icon-underline-description' => __( 'Heading — Icon — Underline — Description', 'orange-addons-for-elementor' ),
                'heading-icon-description-underline' => __( 'Heading — Icon — Description — Underline', 'orange-addons-for-elementor' ),
                'heading-underline-icon-description' => __( 'Heading — Underline — Icon — Description', 'orange-addons-for-elementor' ),
                'heading-description-icon-underline' => __( 'Heading — Description — Icon — Underline', 'orange-addons-for-elementor' ),
                'description-icon-heading-underline' => __( 'Description — Icon — Heading — Underline', 'orange-addons-for-elementor' ),
                'description-heading-icon-underline' => __( 'Description — Heading — Icon — Underline', 'orange-addons-for-elementor' ),
                'underline-icon-heading-description' => __( 'Underline — Icon — Heading — Description', 'orange-addons-for-elementor' ),
                'underline-heading-icon-description' => __( 'Underline — Heading — Icon — Description', 'orange-addons-for-elementor' ),
                'underline-heading-description-icon' => __( 'Underline — Heading — Description — Icon', 'orange-addons-for-elementor' ),
                'icon-underline-description-heading' => __( 'Icon — Underline — Description — Heading', 'orange-addons-for-elementor' ),
                'description-underline-icon-heading' => __( 'Description — Underline — Icon — Heading', 'orange-addons-for-elementor' ),
                'description-underline-heading-icon' => __( 'Description — Underline — Heading — Icon', 'orange-addons-for-elementor' ),
            ],
            'default'     => 'icon-heading-underline-description',
            'label_block' => true,
        ] );
        $this->end_controls_section();
        $this->start_controls_section( 'section_style_container', [
            'label' => __( 'Container', 'orange-addons-for-elementor' ),
            'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
        ] );
        $this->add_responsive_control( 'heading_margin', [
            'label'      => __( 'Margin', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px', '%', 'em'],
            'selectors'  => [
                '{{WRAPPER}} .custom-heading' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->add_responsive_control( 'heading_padding', [
            'label'      => __( 'Padding', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px', '%', 'em'],
            'selectors'  => [
                '{{WRAPPER}} .custom-heading' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->add_responsive_control( 'text_alignment', [
            'label'     => __( 'Text Alignment', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::CHOOSE,
            'options'   => [
                'left'   => [
                    'title' => __( 'Left', 'orange-addons-for-elementor' ),
                    'icon'  => 'eicon-text-align-left',
                ],
                'center' => [
                    'title' => __( 'Center', 'orange-addons-for-elementor' ),
                    'icon'  => 'eicon-text-align-center',
                ],
                'right'  => [
                    'title' => __( 'Right', 'orange-addons-for-elementor' ),
                    'icon'  => 'eicon-text-align-right',
                ],
            ],
            'default'   => 'left',
            'selectors' => [
                '{{WRAPPER}} .custom-heading' => 'text-align: {{VALUE}};',
            ],
        ] );
        $this->add_group_control( \Elementor\Group_Control_Background::get_type(), [
            'name'     => 'container_background',
            'label'    => __( 'Container Background', 'orange-addons-for-elementor' ),
            'types'    => ['classic', 'gradient'],
            'selector' => '{{WRAPPER}} .custom-heading',
            'exclude'  => ['video'],
        ] );
        $this->end_controls_section();
        $this->start_controls_section( 'section_single_heading_style', [
            'label'     => __( 'Heading', 'orange-addons-for-elementor' ),
            'tab'       => \Elementor\Controls_Manager::TAB_STYLE,
            'condition' => [
                'enable_dual_heading' => '',
            ],
        ] );
        $this->add_group_control( \Elementor\Group_Control_Typography::get_type(), [
            'name'     => 'heading_typography_single',
            'selector' => '{{WRAPPER}} .custom-heading .title-text',
        ] );
        $this->add_control( 'single_text_color_type', [
            'label'   => __( 'Text Color Type', 'orange-addons-for-elementor' ),
            'type'    => \Elementor\Controls_Manager::SELECT,
            'default' => 'solid',
            'options' => [
                'solid'    => __( 'Solid', 'orange-addons-for-elementor' ),
                'gradient' => __( 'Gradient', 'orange-addons-for-elementor' ),
                'image'    => __( 'Image', 'orange-addons-for-elementor' ),
            ],
        ] );
        $this->add_control( 'single_text_color', [
            'label'     => __( 'Text Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'default'   => '#333333',
            'condition' => [
                'single_text_color_type' => 'solid',
            ],
            'selectors' => [
                '{{WRAPPER}} .custom-heading .title-text' => 'color: {{VALUE}};',
            ],
        ] );
        $this->add_control( 'single_text_gradient_color1', [
            'label'     => __( 'Text Gradient Color 1', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'default'   => '#ff7e00',
            'condition' => [
                'single_text_color_type' => 'gradient',
            ],
        ] );
        $this->add_control( 'single_text_gradient_color2', [
            'label'     => __( 'Text Gradient Color 2', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'default'   => '#ffcc00',
            'condition' => [
                'single_text_color_type' => 'gradient',
            ],
        ] );
        $this->add_control( 'single_text_gradient_color3', [
            'label'     => __( 'Text Gradient Color 3', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'default'   => '',
            'condition' => [
                'single_text_color_type' => 'gradient',
            ],
        ] );
        $this->add_control( 'single_text_gradient_color4', [
            'label'     => __( 'Text Gradient Color 4', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'default'   => '',
            'condition' => [
                'single_text_color_type' => 'gradient',
            ],
        ] );
        $this->add_control( 'single_text_gradient_angle', [
            'label'     => __( 'Text Gradient Angle', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::SLIDER,
            'default'   => [
                'size' => 45,
                'unit' => 'deg',
            ],
            'range'     => [
                'deg' => [
                    'min' => 0,
                    'max' => 360,
                ],
            ],
            'condition' => [
                'single_text_color_type' => 'gradient',
            ],
        ] );
        $this->add_control( 'hr_animate', [
            'type'      => \Elementor\Controls_Manager::DIVIDER,
            'condition' => [
                'single_text_color_type' => 'gradient',
            ],
        ] );
        $animate_gradient_config = apply_filters( 'oradel_animate_gradient_control_config', [
            'label'     => __( 'Animate Gradient', 'orange-addons-for-elementor' ) . ' <i class="eicon-pro-icon"></i>',
            'type'      => \Elementor\Controls_Manager::SWITCHER,
            'default'   => '',
            'condition' => [
                'single_text_color_type' => 'gradient',
            ],
            'classes'   => 'elementor-control-disabled',
        ] );
        $this->add_control( 'single_gradient_animation', $animate_gradient_config );
        $premium_notice = apply_filters( 'oradel_animate_gradient_premium_notice', Oradel_Plugin_Helper::create_premium_notice( 
            /* translators: %s: Premium upgrade URL */
            __( 'Animate Gradient is available in the <a href="%s" target="_blank">Premium version</a>', 'orange-addons-for-elementor' ),
            'advanced-heading',
            'info'
         ) );
        if ( $premium_notice !== null ) {
            $this->add_control( 'oea_premium_notice', array_merge( $premium_notice, [
                'condition' => [
                    'single_text_color_type' => 'gradient',
                ],
            ] ) );
        }
        $this->add_control( 'hr_animate2', [
            'type'      => \Elementor\Controls_Manager::DIVIDER,
            'condition' => [
                'single_text_color_type' => 'gradient',
            ],
        ] );
        $this->add_control( 'single_gradient_animation_speed', [
            'label'     => __( 'Gradient Animation Speed', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::SLIDER,
            'default'   => [
                'size' => 5,
                'unit' => 's',
            ],
            'range'     => [
                's' => [
                    'min'  => 1,
                    'max'  => 10,
                    'step' => 0.1,
                ],
            ],
            'condition' => [
                'single_text_color_type'    => 'gradient',
                'single_gradient_animation' => 'yes',
            ],
        ] );
        $this->add_control( 'single_gradient_animation_easing', [
            'label'     => __( 'Gradient Animation Easing', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::SELECT,
            'default'   => 'ease',
            'options'   => [
                'linear'      => __( 'Linear', 'orange-addons-for-elementor' ),
                'ease'        => __( 'Ease', 'orange-addons-for-elementor' ),
                'ease-in'     => __( 'Ease In', 'orange-addons-for-elementor' ),
                'ease-out'    => __( 'Ease Out', 'orange-addons-for-elementor' ),
                'ease-in-out' => __( 'Ease In Out', 'orange-addons-for-elementor' ),
            ],
            'condition' => [
                'single_text_color_type'    => 'gradient',
                'single_gradient_animation' => 'yes',
            ],
        ] );
        $premium_notice_bg = apply_filters( 'oradel_single_text_background_image_premium_notice', Oradel_Plugin_Helper::create_premium_notice( 
            /* translators: %s: Premium upgrade URL */
            __( 'Text Background Image is available in the <a href="%s" target="_blank">Premium version</a>', 'orange-addons-for-elementor' ),
            'advanced-heading',
            'info'
         ) );
        if ( $premium_notice_bg !== null ) {
            $this->add_control( 'single_text_background_image_background', [
                'label'     => __( 'Image Background', 'orange-addons-for-elementor' ) . ' <i class="eicon-pro-icon"></i>',
                'type'      => \Elementor\Controls_Manager::CHOOSE,
                'options'   => [
                    'classic' => [
                        'title' => __( 'Classic', 'orange-addons-for-elementor' ),
                        'icon'  => 'eicon-paint-brush',
                    ],
                ],
                'condition' => [
                    'single_text_color_type' => 'image',
                ],
                'classes'   => 'elementor-control-disabled',
            ] );
            $this->add_control( 'oea_premium_notice_single_bg', array_merge( $premium_notice_bg, [
                'condition' => [
                    'single_text_color_type' => 'image',
                ],
            ] ) );
        } else {
            do_action( 'oradel_register_single_text_background_image_control', $this );
        }
        $this->add_control( 'single_text_stroke_width', [
            'label'      => __( 'Text Stroke Width', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['px'],
            'range'      => [
                'px' => [
                    'min'  => 0,
                    'max'  => 10,
                    'step' => 0.5,
                ],
            ],
            'default'    => [
                'size' => 0,
                'unit' => 'px',
            ],
        ] );
        $this->add_control( 'single_text_stroke_color', [
            'label'     => __( 'Text Stroke Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'default'   => '#000000',
            'condition' => [
                'single_text_stroke_width[size]!' => '0',
            ],
        ] );
        $this->add_control( 'heading_rotation', [
            'label'      => __( 'Heading Rotation', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['deg'],
            'range'      => [
                'deg' => [
                    'min'  => -360,
                    'max'  => 360,
                    'step' => 1,
                ],
            ],
            'default'    => [
                'size' => 0,
                'unit' => 'deg',
            ],
        ] );
        $this->end_controls_section();
        $this->start_controls_section( 'section_single_wrapper_style', [
            'label'     => __( 'Heading Wrapper', 'orange-addons-for-elementor' ),
            'tab'       => \Elementor\Controls_Manager::TAB_STYLE,
            'condition' => [
                'enable_dual_heading' => '',
            ],
        ] );
        $this->add_group_control( \Elementor\Group_Control_Background::get_type(), [
            'name'     => 'wrapper_background',
            'label'    => __( 'Wrapper Background', 'orange-addons-for-elementor' ),
            'types'    => ['classic', 'gradient'],
            'selector' => '{{WRAPPER}} .custom-heading .title-text-wrapper',
            'exclude'  => ['video'],
        ] );
        $this->add_group_control( \Elementor\Group_Control_Border::get_type(), [
            'name'     => 'wrapper_border',
            'selector' => '{{WRAPPER}} .custom-heading .title-text-wrapper',
        ] );
        $this->add_responsive_control( 'wrapper_border_radius', [
            'label'      => __( 'Wrapper Border Radius', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px', '%'],
            'selectors'  => [
                '{{WRAPPER}} .custom-heading .title-text-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->add_responsive_control( 'wrapper_padding', [
            'label'      => __( 'Wrapper Padding', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px', '%', 'em'],
            'selectors'  => [
                '{{WRAPPER}} .custom-heading .title-text-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->end_controls_section();
        $this->start_controls_section( 'section_dual_heading_style_part1', [
            'label'     => __( 'Heading Part 1', 'orange-addons-for-elementor' ),
            'tab'       => \Elementor\Controls_Manager::TAB_STYLE,
            'condition' => [
                'enable_dual_heading' => 'yes',
            ],
        ] );
        $this->add_control( 'text_color_type_part1', [
            'label'   => __( 'Text Color Type', 'orange-addons-for-elementor' ),
            'type'    => \Elementor\Controls_Manager::SELECT,
            'default' => 'solid',
            'options' => [
                'solid'    => __( 'Solid', 'orange-addons-for-elementor' ),
                'gradient' => __( 'Gradient', 'orange-addons-for-elementor' ),
                'image'    => __( 'Image', 'orange-addons-for-elementor' ),
            ],
        ] );
        $this->add_control( 'text_color_part1', [
            'label'     => __( 'Text Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'default'   => '#333333',
            'condition' => [
                'text_color_type_part1' => 'solid',
            ],
            'selectors' => [
                '{{WRAPPER}} .custom-heading .title-text-part1' => 'color: {{VALUE}};',
            ],
        ] );
        $this->add_control( 'text_gradient_color1_part1', [
            'label'     => __( 'Text Gradient Color 1', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'default'   => '#ff7e00',
            'condition' => [
                'text_color_type_part1' => 'gradient',
            ],
        ] );
        $this->add_control( 'text_gradient_color2_part1', [
            'label'     => __( 'Text Gradient Color 2', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'default'   => '#ffcc00',
            'condition' => [
                'text_color_type_part1' => 'gradient',
            ],
        ] );
        $this->add_control( 'text_gradient_color3_part1', [
            'label'     => __( 'Text Gradient Color 3', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'default'   => '',
            'condition' => [
                'text_color_type_part1' => 'gradient',
            ],
        ] );
        $this->add_control( 'text_gradient_color4_part1', [
            'label'     => __( 'Text Gradient Color 4', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'default'   => '',
            'condition' => [
                'text_color_type_part1' => 'gradient',
            ],
        ] );
        $this->add_control( 'text_gradient_angle_part1', [
            'label'     => __( 'Text Gradient Angle', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::SLIDER,
            'default'   => [
                'size' => 45,
                'unit' => 'deg',
            ],
            'range'     => [
                'deg' => [
                    'min' => 0,
                    'max' => 360,
                ],
            ],
            'condition' => [
                'text_color_type_part1' => 'gradient',
            ],
        ] );
        $this->add_control( 'hr_animate3', [
            'type'      => \Elementor\Controls_Manager::DIVIDER,
            'condition' => [
                'text_color_type_part1' => 'gradient',
            ],
        ] );
        $animate_gradient_part1_config = apply_filters( 'oradel_animate_gradient_part1_control_config', [
            'label'     => __( 'Animate Gradient', 'orange-addons-for-elementor' ) . ' <i class="eicon-pro-icon"></i>',
            'type'      => \Elementor\Controls_Manager::SWITCHER,
            'default'   => '',
            'condition' => [
                'text_color_type_part1' => 'gradient',
            ],
            'classes'   => 'elementor-control-disabled',
        ] );
        $this->add_control( 'gradient_animation_part1', $animate_gradient_part1_config );
        $premium_notice_part1 = apply_filters( 'oradel_animate_gradient_part1_premium_notice', Oradel_Plugin_Helper::create_premium_notice( 
            /* translators: %s: Premium upgrade URL */
            __( 'Animate Gradient is available in the <a href="%s" target="_blank">Premium version</a>', 'orange-addons-for-elementor' ),
            'advanced-heading',
            'info'
         ) );
        if ( $premium_notice_part1 !== null ) {
            $this->add_control( 'oea_premium_notice2', array_merge( $premium_notice_part1, [
                'condition' => [
                    'text_color_type_part1' => 'gradient',
                ],
            ] ) );
        }
        $this->add_control( 'hr_animate4', [
            'type'      => \Elementor\Controls_Manager::DIVIDER,
            'condition' => [
                'text_color_type_part1' => 'gradient',
            ],
        ] );
        $this->add_control( 'gradient_animation_speed_part1', [
            'label'     => __( 'Gradient Animation Speed', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::SLIDER,
            'default'   => [
                'size' => 5,
                'unit' => 's',
            ],
            'range'     => [
                's' => [
                    'min'  => 1,
                    'max'  => 10,
                    'step' => 0.1,
                ],
            ],
            'condition' => [
                'text_color_type_part1'    => 'gradient',
                'gradient_animation_part1' => 'yes',
            ],
        ] );
        $this->add_control( 'gradient_animation_easing_part1', [
            'label'     => __( 'Gradient Animation Easing', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::SELECT,
            'default'   => 'ease',
            'options'   => [
                'linear'      => __( 'Linear', 'orange-addons-for-elementor' ),
                'ease'        => __( 'Ease', 'orange-addons-for-elementor' ),
                'ease-in'     => __( 'Ease In', 'orange-addons-for-elementor' ),
                'ease-out'    => __( 'Ease Out', 'orange-addons-for-elementor' ),
                'ease-in-out' => __( 'Ease In Out', 'orange-addons-for-elementor' ),
            ],
            'condition' => [
                'text_color_type_part1'    => 'gradient',
                'gradient_animation_part1' => 'yes',
            ],
        ] );
        do_action( 'oradel_register_text_background_image_part1_control', $this );
        $premium_notice_part1_bg = apply_filters( 'oradel_text_background_image_part1_premium_notice', Oradel_Plugin_Helper::create_premium_notice( 
            /* translators: %s: Premium upgrade URL */
            __( 'Text Background Image is available in the <a href="%s" target="_blank">Premium version</a>', 'orange-addons-for-elementor' ),
            'advanced-heading',
            'info'
         ) );
        if ( $premium_notice_part1_bg !== null ) {
            $this->add_control( 'text_background_image_part1_background', [
                'label'     => __( 'Image Background', 'orange-addons-for-elementor' ) . ' <i class="eicon-pro-icon"></i>',
                'type'      => \Elementor\Controls_Manager::CHOOSE,
                'options'   => [
                    'classic' => [
                        'title' => __( 'Classic', 'orange-addons-for-elementor' ),
                        'icon'  => 'eicon-paint-brush',
                    ],
                ],
                'condition' => [
                    'text_color_type_part1' => 'image',
                ],
                'classes'   => 'elementor-control-disabled',
            ] );
            $this->add_control( 'oea_premium_notice_part1_bg', array_merge( $premium_notice_part1_bg, [
                'condition' => [
                    'text_color_type_part1' => 'image',
                ],
            ] ) );
        }
        $this->add_control( 'text_stroke_width_part1', [
            'label'      => __( 'Text Stroke Width', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['px'],
            'range'      => [
                'px' => [
                    'min'  => 0,
                    'max'  => 10,
                    'step' => 0.5,
                ],
            ],
            'default'    => [
                'size' => 0,
                'unit' => 'px',
            ],
        ] );
        $this->add_control( 'text_stroke_color_part1', [
            'label'     => __( 'Text Stroke Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'default'   => '#000000',
            'condition' => [
                'text_stroke_width_part1[size]!' => '0',
            ],
        ] );
        $this->add_control( 'heading_rotation_part1', [
            'label'      => __( 'Heading Rotation (Part 1)', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['deg'],
            'range'      => [
                'deg' => [
                    'min'  => -360,
                    'max'  => 360,
                    'step' => 1,
                ],
            ],
            'default'    => [
                'size' => 0,
                'unit' => 'deg',
            ],
        ] );
        $this->add_group_control( \Elementor\Group_Control_Typography::get_type(), [
            'name'     => 'heading_typography_part1',
            'selector' => '{{WRAPPER}} .custom-heading .title-text-part1',
        ] );
        $this->end_controls_section();
        $this->start_controls_section( 'section_dual_wrapper_style_part1', [
            'label'     => __( 'Heading Part 1 Wrapper', 'orange-addons-for-elementor' ),
            'tab'       => \Elementor\Controls_Manager::TAB_STYLE,
            'condition' => [
                'enable_dual_heading' => 'yes',
            ],
        ] );
        $this->add_group_control( \Elementor\Group_Control_Background::get_type(), [
            'name'     => 'wrapper_background_part1',
            'label'    => __( 'Wrapper Background', 'orange-addons-for-elementor' ),
            'types'    => ['classic', 'gradient'],
            'selector' => '{{WRAPPER}} .custom-heading .heading-bg-wrapper-part1',
            'exclude'  => ['video'],
        ] );
        $this->add_group_control( \Elementor\Group_Control_Border::get_type(), [
            'name'     => 'wrapper_border_part1',
            'selector' => '{{WRAPPER}} .custom-heading .heading-bg-wrapper-part1',
        ] );
        $this->add_responsive_control( 'wrapper_border_radius_part1', [
            'label'      => __( 'Wrapper Border Radius', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px', '%'],
            'selectors'  => [
                '{{WRAPPER}} .custom-heading .heading-bg-wrapper-part1' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->add_responsive_control( 'wrapper_padding_part1', [
            'label'      => __( 'Wrapper Padding', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px', '%', 'em'],
            'selectors'  => [
                '{{WRAPPER}} .custom-heading .heading-bg-wrapper-part1' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->end_controls_section();
        $this->start_controls_section( 'section_dual_heading_style_part2', [
            'label'     => __( 'Heading Part 2', 'orange-addons-for-elementor' ),
            'tab'       => \Elementor\Controls_Manager::TAB_STYLE,
            'condition' => [
                'enable_dual_heading' => 'yes',
            ],
        ] );
        $this->add_control( 'text_color_type_part2', [
            'label'   => __( 'Text Color Type', 'orange-addons-for-elementor' ),
            'type'    => \Elementor\Controls_Manager::SELECT,
            'default' => 'solid',
            'options' => [
                'solid'    => __( 'Solid', 'orange-addons-for-elementor' ),
                'gradient' => __( 'Gradient', 'orange-addons-for-elementor' ),
                'image'    => __( 'Image', 'orange-addons-for-elementor' ),
            ],
        ] );
        $this->add_control( 'text_color_part2', [
            'label'     => __( 'Text Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'default'   => '#333333',
            'condition' => [
                'text_color_type_part2' => 'solid',
            ],
            'selectors' => [
                '{{WRAPPER}} .custom-heading .title-text-part2' => 'color: {{VALUE}};',
            ],
        ] );
        $this->add_control( 'text_gradient_color1_part2', [
            'label'     => __( 'Text Gradient Color 1', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'default'   => '#ff7e00',
            'condition' => [
                'text_color_type_part2' => 'gradient',
            ],
        ] );
        $this->add_control( 'text_gradient_color2_part2', [
            'label'     => __( 'Text Gradient Color 2', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'default'   => '#ffcc00',
            'condition' => [
                'text_color_type_part2' => 'gradient',
            ],
        ] );
        $this->add_control( 'text_gradient_color3_part2', [
            'label'     => __( 'Text Gradient Color 3', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'default'   => '',
            'condition' => [
                'text_color_type_part2' => 'gradient',
            ],
        ] );
        $this->add_control( 'text_gradient_color4_part2', [
            'label'     => __( 'Text Gradient Color 4', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'default'   => '',
            'condition' => [
                'text_color_type_part2' => 'gradient',
            ],
        ] );
        $this->add_control( 'text_gradient_angle_part2', [
            'label'     => __( 'Text Gradient Angle', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::SLIDER,
            'default'   => [
                'size' => 45,
                'unit' => 'deg',
            ],
            'range'     => [
                'deg' => [
                    'min' => 0,
                    'max' => 360,
                ],
            ],
            'condition' => [
                'text_color_type_part2' => 'gradient',
            ],
        ] );
        $this->add_control( 'hr_animate5', [
            'type'      => \Elementor\Controls_Manager::DIVIDER,
            'condition' => [
                'text_color_type_part2' => 'gradient',
            ],
        ] );
        $animate_gradient_part2_config = apply_filters( 'oradel_animate_gradient_part2_control_config', [
            'label'     => __( 'Animate Gradient', 'orange-addons-for-elementor' ) . ' <i class="eicon-pro-icon"></i>',
            'type'      => \Elementor\Controls_Manager::SWITCHER,
            'default'   => '',
            'condition' => [
                'text_color_type_part2' => 'gradient',
            ],
            'classes'   => 'elementor-control-disabled',
        ] );
        $this->add_control( 'gradient_animation_part2', $animate_gradient_part2_config );
        $premium_notice_part2 = apply_filters( 'oradel_animate_gradient_part2_premium_notice', Oradel_Plugin_Helper::create_premium_notice( 
            /* translators: %s: Premium upgrade URL */
            __( 'Animate Gradient is available in the <a href="%s" target="_blank">Premium version</a>', 'orange-addons-for-elementor' ),
            'advanced-heading',
            'info'
         ) );
        if ( $premium_notice_part2 !== null ) {
            $this->add_control( 'oea_premium_notice3', array_merge( $premium_notice_part2, [
                'condition' => [
                    'text_color_type_part2' => 'gradient',
                ],
            ] ) );
        }
        $this->add_control( 'hr_animate6', [
            'type'      => \Elementor\Controls_Manager::DIVIDER,
            'condition' => [
                'text_color_type_part2' => 'gradient',
            ],
        ] );
        $this->add_control( 'gradient_animation_speed_part2', [
            'label'     => __( 'Gradient Animation Speed', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::SLIDER,
            'default'   => [
                'size' => 5,
                'unit' => 's',
            ],
            'range'     => [
                's' => [
                    'min'  => 1,
                    'max'  => 10,
                    'step' => 0.1,
                ],
            ],
            'condition' => [
                'text_color_type_part2'    => 'gradient',
                'gradient_animation_part2' => 'yes',
            ],
        ] );
        $this->add_control( 'gradient_animation_easing_part2', [
            'label'     => __( 'Gradient Animation Easing', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::SELECT,
            'default'   => 'ease',
            'options'   => [
                'linear'      => __( 'Linear', 'orange-addons-for-elementor' ),
                'ease'        => __( 'Ease', 'orange-addons-for-elementor' ),
                'ease-in'     => __( 'Ease In', 'orange-addons-for-elementor' ),
                'ease-out'    => __( 'Ease Out', 'orange-addons-for-elementor' ),
                'ease-in-out' => __( 'Ease In Out', 'orange-addons-for-elementor' ),
            ],
            'condition' => [
                'text_color_type_part2'    => 'gradient',
                'gradient_animation_part2' => 'yes',
            ],
        ] );
        do_action( 'oradel_register_text_background_image_part2_control', $this );
        $premium_notice_part2_bg = apply_filters( 'oradel_text_background_image_part2_premium_notice', Oradel_Plugin_Helper::create_premium_notice( 
            /* translators: %s: Premium upgrade URL */
            __( 'Text Background Image is available in the <a href="%s" target="_blank">Premium version</a>', 'orange-addons-for-elementor' ),
            'advanced-heading',
            'info'
         ) );
        if ( $premium_notice_part2_bg !== null ) {
            $this->add_control( 'text_background_image_part2_background', [
                'label'     => __( 'Image Background', 'orange-addons-for-elementor' ) . ' <i class="eicon-pro-icon"></i>',
                'type'      => \Elementor\Controls_Manager::CHOOSE,
                'options'   => [
                    'classic' => [
                        'title' => __( 'Classic', 'orange-addons-for-elementor' ),
                        'icon'  => 'eicon-paint-brush',
                    ],
                ],
                'condition' => [
                    'text_color_type_part2' => 'image',
                ],
                'classes'   => 'elementor-control-disabled',
            ] );
            $this->add_control( 'oea_premium_notice_part2_bg', array_merge( $premium_notice_part2_bg, [
                'condition' => [
                    'text_color_type_part2' => 'image',
                ],
            ] ) );
        }
        $this->add_control( 'text_stroke_width_part2', [
            'label'      => __( 'Text Stroke Width', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['px'],
            'range'      => [
                'px' => [
                    'min'  => 0,
                    'max'  => 10,
                    'step' => 0.5,
                ],
            ],
            'default'    => [
                'size' => 0,
                'unit' => 'px',
            ],
        ] );
        $this->add_control( 'text_stroke_color_part2', [
            'label'     => __( 'Text Stroke Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'default'   => '#000000',
            'condition' => [
                'text_stroke_width_part2[size]!' => '0',
            ],
        ] );
        $this->add_control( 'heading_rotation_part2', [
            'label'      => __( 'Heading Rotation (Part 2)', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['deg'],
            'range'      => [
                'deg' => [
                    'min'  => -360,
                    'max'  => 360,
                    'step' => 1,
                ],
            ],
            'default'    => [
                'size' => 0,
                'unit' => 'deg',
            ],
        ] );
        $this->add_group_control( \Elementor\Group_Control_Typography::get_type(), [
            'name'     => 'heading_typography_part2',
            'selector' => '{{WRAPPER}} .custom-heading .title-text-part2',
        ] );
        $this->end_controls_section();
        $this->start_controls_section( 'section_dual_wrapper_style_part2', [
            'label'     => __( 'Heading Part 2 Wrapper', 'orange-addons-for-elementor' ),
            'tab'       => \Elementor\Controls_Manager::TAB_STYLE,
            'condition' => [
                'enable_dual_heading' => 'yes',
            ],
        ] );
        $this->add_group_control( \Elementor\Group_Control_Background::get_type(), [
            'name'     => 'wrapper_background_part2',
            'label'    => __( 'Wrapper Background', 'orange-addons-for-elementor' ),
            'types'    => ['classic', 'gradient'],
            'selector' => '{{WRAPPER}} .custom-heading .heading-bg-wrapper-part2',
            'exclude'  => ['video'],
        ] );
        $this->add_group_control( \Elementor\Group_Control_Border::get_type(), [
            'name'     => 'wrapper_border_part2',
            'selector' => '{{WRAPPER}} .custom-heading .heading-bg-wrapper-part2',
        ] );
        $this->add_responsive_control( 'wrapper_border_radius_part2', [
            'label'      => __( 'Wrapper Border Radius', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px', '%'],
            'selectors'  => [
                '{{WRAPPER}} .custom-heading .heading-bg-wrapper-part2' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->add_responsive_control( 'wrapper_padding_part2', [
            'label'      => __( 'Wrapper Padding', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px', '%', 'em'],
            'selectors'  => [
                '{{WRAPPER}} .custom-heading .heading-bg-wrapper-part2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->end_controls_section();
        $this->start_controls_section( 'section_background_text_style', [
            'label'     => __( 'Background Text', 'orange-addons-for-elementor' ),
            'tab'       => \Elementor\Controls_Manager::TAB_STYLE,
            'condition' => [
                'enable_background_text' => 'yes',
            ],
        ] );
        $this->add_group_control( \Elementor\Group_Control_Typography::get_type(), [
            'name'     => 'background_text_typography',
            'selector' => '{{WRAPPER}} .custom-heading .background-text',
        ] );
        $this->add_control( 'background_text_color', [
            'label'     => __( 'Background Text Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'default'   => '#f1f1f1',
            'selectors' => [
                '{{WRAPPER}} .custom-heading .background-text' => 'color: {{VALUE}};',
            ],
        ] );
        $this->add_control( 'background_text_stroke_width', [
            'label'      => __( 'Background Text Stroke Width', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['px'],
            'range'      => [
                'px' => [
                    'min'  => 0,
                    'max'  => 10,
                    'step' => 0.5,
                ],
            ],
            'default'    => [
                'size' => 0,
                'unit' => 'px',
            ],
        ] );
        $this->add_control( 'background_text_stroke_color', [
            'label'     => __( 'Background Text Stroke Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'default'   => '#000000',
            'condition' => [
                'background_text_stroke_width[size]!' => '0',
            ],
            'selectors' => [
                '{{WRAPPER}} .custom-heading .background-text' => '-webkit-text-stroke-color: {{VALUE}}; text-stroke-color: {{VALUE}};',
            ],
        ] );
        $this->add_responsive_control( 'background_text_offset_x', [
            'label'      => __( 'Horizontal Offset', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['px', '%'],
            'range'      => [
                'px' => [
                    'min' => -200,
                    'max' => 200,
                ],
                '%'  => [
                    'min' => -50,
                    'max' => 50,
                ],
            ],
            'default'    => [
                'size' => 0,
                'unit' => 'px',
            ],
        ] );
        $this->add_responsive_control( 'background_text_offset_y', [
            'label'      => __( 'Vertical Offset', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['px', '%'],
            'range'      => [
                'px' => [
                    'min' => -200,
                    'max' => 200,
                ],
                '%'  => [
                    'min' => -50,
                    'max' => 50,
                ],
            ],
            'default'    => [
                'size' => 0,
                'unit' => 'px',
            ],
        ] );
        $this->add_responsive_control( 'background_text_rotation', [
            'label'      => __( 'Background Text Rotation', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['deg'],
            'range'      => [
                'deg' => [
                    'min'  => -360,
                    'max'  => 360,
                    'step' => 1,
                ],
            ],
            'default'    => [
                'size' => 0,
                'unit' => 'deg',
            ],
        ] );
        $this->add_control( 'background_text_blend_mode', [
            'label'   => __( 'Background Text Blend Mode', 'orange-addons-for-elementor' ),
            'type'    => \Elementor\Controls_Manager::SELECT,
            'default' => 'normal',
            'options' => [
                'normal'      => __( 'Normal', 'orange-addons-for-elementor' ),
                'multiply'    => __( 'Multiply', 'orange-addons-for-elementor' ),
                'screen'      => __( 'Screen', 'orange-addons-for-elementor' ),
                'overlay'     => __( 'Overlay', 'orange-addons-for-elementor' ),
                'darken'      => __( 'Darken', 'orange-addons-for-elementor' ),
                'lighten'     => __( 'Lighten', 'orange-addons-for-elementor' ),
                'color-dodge' => __( 'Color Dodge', 'orange-addons-for-elementor' ),
                'color-burn'  => __( 'Color Burn', 'orange-addons-for-elementor' ),
                'hard-light'  => __( 'Hard Light', 'orange-addons-for-elementor' ),
                'soft-light'  => __( 'Soft Light', 'orange-addons-for-elementor' ),
                'difference'  => __( 'Difference', 'orange-addons-for-elementor' ),
                'exclusion'   => __( 'Exclusion', 'orange-addons-for-elementor' ),
                'hue'         => __( 'Hue', 'orange-addons-for-elementor' ),
                'saturation'  => __( 'Saturation', 'orange-addons-for-elementor' ),
                'color'       => __( 'Color', 'orange-addons-for-elementor' ),
                'luminosity'  => __( 'Luminosity', 'orange-addons-for-elementor' ),
            ],
        ] );
        $this->add_responsive_control( 'background_text_opacity', [
            'label'      => __( 'Background Text Opacity', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['%'],
            'range'      => [
                '%' => [
                    'min'  => 0,
                    'max'  => 100,
                    'step' => 1,
                ],
            ],
            'default'    => [
                'size' => 15,
                'unit' => '%',
            ],
        ] );
        $this->end_controls_section();
        $this->start_controls_section( 'section_description_text_style', [
            'label' => __( 'Description Text', 'orange-addons-for-elementor' ),
            'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
        ] );
        $this->add_control( 'description_text_color', [
            'label'     => __( 'Text Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'default'   => '#333333',
            'selectors' => [
                '{{WRAPPER}} .custom-heading .subheading-text' => 'color: {{VALUE}};',
            ],
        ] );
        $this->add_group_control( \Elementor\Group_Control_Typography::get_type(), [
            'name'     => 'description_text_typography',
            'selector' => '{{WRAPPER}} .custom-heading .subheading-text',
        ] );
        $this->add_responsive_control( 'description_text_padding', [
            'label'      => __( 'Padding', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px', '%', 'em'],
            'selectors'  => [
                '{{WRAPPER}} .custom-heading .subheading-text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ] );
        $this->end_controls_section();
        $this->start_controls_section( 'section_heading_underline_style', [
            'label'     => __( 'Heading Underline', 'orange-addons-for-elementor' ),
            'tab'       => \Elementor\Controls_Manager::TAB_STYLE,
            'condition' => [
                'underline_style!' => 'none',
            ],
        ] );
        $this->add_control( 'underline_thickness', [
            'label'      => __( 'Underline Thickness', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['px'],
            'selectors'  => [
                '{{WRAPPER}} .custom-heading .heading-underline' => '--heading-underline-thickness: {{SIZE}}{{UNIT}};',
            ],
            'condition'  => [
                'underline_style!' => [
                    'torn-paper',
                    'wave-animation',
                    'water-wave',
                    'none'
                ],
            ],
        ] );
        $this->add_control( 'underline_color', [
            'label'     => __( 'Underline Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'default'   => '#000',
            'selectors' => [
                '{{WRAPPER}} .custom-heading .heading-underline' => '--heading-underline-color: {{VALUE}};',
            ],
        ] );
        $this->end_controls_section();
        $this->start_controls_section( 'section_icon', [
            'label' => __( 'Icon', 'orange-addons-for-elementor' ),
            'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
        ] );
        $this->add_control( 'show_icon', [
            'label'   => __( 'Show Icon', 'orange-addons-for-elementor' ),
            'type'    => \Elementor\Controls_Manager::SWITCHER,
            'default' => '',
        ] );
        $this->add_control( 'icon', [
            'label'     => __( 'Icon', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::ICONS,
            'default'   => [
                'value'   => 'fas fa-star',
                'library' => 'fa-solid',
            ],
            'condition' => [
                'show_icon' => 'yes',
            ],
        ] );
        $this->add_responsive_control( 'icon_size', [
            'label'      => __( 'Icon Size', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['px', 'em', 'rem'],
            'range'      => [
                'px'  => [
                    'min' => 10,
                    'max' => 100,
                ],
                'em'  => [
                    'min'  => 0.5,
                    'max'  => 5,
                    'step' => 0.1,
                ],
                'rem' => [
                    'min'  => 0.5,
                    'max'  => 5,
                    'step' => 0.1,
                ],
            ],
            'default'    => [
                'unit' => 'px',
                'size' => 32,
            ],
            'selectors'  => [
                '{{WRAPPER}} .custom-heading .oea-heading-icon'     => 'font-size: {{SIZE}}{{UNIT}};',
                '{{WRAPPER}} .custom-heading .oea-heading-icon svg' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
            ],
            'condition'  => [
                'show_icon' => 'yes',
            ],
        ] );
        $this->add_control( 'icon_color', [
            'label'     => __( 'Icon Color', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'default'   => '#333333',
            'selectors' => [
                '{{WRAPPER}} .custom-heading .oea-heading-icon'     => 'color: {{VALUE}};',
                '{{WRAPPER}} .custom-heading .oea-heading-icon svg' => 'fill: {{VALUE}};',
            ],
            'condition' => [
                'show_icon' => 'yes',
            ],
        ] );
        $this->end_controls_section();
        $this->start_controls_section( 'section_spacing', [
            'label' => __( 'Element Spacing', 'orange-addons-for-elementor' ),
            'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
        ] );
        $this->add_responsive_control( 'icon_spacing_after', [
            'label'      => __( 'Icon Spacing After', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['px', 'em', 'rem'],
            'range'      => [
                'px'  => [
                    'min' => 0,
                    'max' => 100,
                ],
                'em'  => [
                    'min'  => 0,
                    'max'  => 5,
                    'step' => 0.1,
                ],
                'rem' => [
                    'min'  => 0,
                    'max'  => 5,
                    'step' => 0.1,
                ],
            ],
            'default'    => [
                'unit' => 'px',
                'size' => 0,
            ],
            'selectors'  => [
                '{{WRAPPER}} .custom-heading .oea-heading-icon' => 'margin-bottom: {{SIZE}}{{UNIT}};',
            ],
        ] );
        $this->add_responsive_control( 'heading_spacing_after', [
            'label'      => __( 'Heading Spacing After', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['px', 'em', 'rem'],
            'range'      => [
                'px'  => [
                    'min' => 0,
                    'max' => 100,
                ],
                'em'  => [
                    'min'  => 0,
                    'max'  => 5,
                    'step' => 0.1,
                ],
                'rem' => [
                    'min'  => 0,
                    'max'  => 5,
                    'step' => 0.1,
                ],
            ],
            'default'    => [
                'unit' => 'px',
                'size' => 0,
            ],
            'selectors'  => [
                '{{WRAPPER}} .custom-heading .heading-rotator, {{WRAPPER}} .custom-heading .heading-rotator-part1, {{WRAPPER}} .custom-heading .heading-rotator-part2' => 'margin-bottom: {{SIZE}}{{UNIT}};',
            ],
        ] );
        $this->add_responsive_control( 'description_spacing_after', [
            'label'      => __( 'Description Spacing After', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['px', 'em', 'rem'],
            'range'      => [
                'px'  => [
                    'min' => 0,
                    'max' => 100,
                ],
                'em'  => [
                    'min'  => 0,
                    'max'  => 5,
                    'step' => 0.1,
                ],
                'rem' => [
                    'min'  => 0,
                    'max'  => 5,
                    'step' => 0.1,
                ],
            ],
            'default'    => [
                'unit' => 'px',
                'size' => 0,
            ],
            'selectors'  => [
                '{{WRAPPER}} .custom-heading .subheading-text' => 'margin-bottom: {{SIZE}}{{UNIT}};',
            ],
        ] );
        $this->add_responsive_control( 'underline_margin_bottom', [
            'label'      => __( 'Underline Spacing After', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['px', 'em', 'rem'],
            'range'      => [
                'px'  => [
                    'min' => 0,
                    'max' => 100,
                ],
                'em'  => [
                    'min'  => 0,
                    'max'  => 5,
                    'step' => 0.1,
                ],
                'rem' => [
                    'min'  => 0,
                    'max'  => 5,
                    'step' => 0.1,
                ],
            ],
            'default'    => [
                'unit' => 'px',
                'size' => 10,
            ],
            'selectors'  => [
                '{{WRAPPER}} .custom-heading .heading-underline' => 'margin-bottom: {{SIZE}}{{UNIT}};',
            ],
        ] );
        $this->end_controls_section();
        $this->start_controls_section( 'animations_section', [
            'label' => __( 'Animations', 'orange-addons-for-elementor' ),
            'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
        ] );
        $this->add_control( 'heading_animation', [
            'label'   => __( 'Heading Animation', 'orange-addons-for-elementor' ),
            'type'    => \Elementor\Controls_Manager::SELECT,
            'default' => 'none',
            'options' => [
                'none'              => __( 'None', 'orange-addons-for-elementor' ),
                'oea-fade-in'       => __( 'Fade In', 'orange-addons-for-elementor' ),
                'oea-fade-in-up'    => __( 'Fade In Up', 'orange-addons-for-elementor' ),
                'oea-fade-in-down'  => __( 'Fade In Down', 'orange-addons-for-elementor' ),
                'oea-fade-in-left'  => __( 'Fade In Left', 'orange-addons-for-elementor' ),
                'oea-fade-in-right' => __( 'Fade In Right', 'orange-addons-for-elementor' ),
                'oea-zoom-in'       => __( 'Zoom In', 'orange-addons-for-elementor' ),
                'oea-bounce-in'     => __( 'Bounce In', 'orange-addons-for-elementor' ),
                'oea-flip-in'       => __( 'Flip In', 'orange-addons-for-elementor' ),
                'oea-rotate-in'     => __( 'Rotate In', 'orange-addons-for-elementor' ),
            ],
        ] );
        $this->add_control( 'heading_animation_duration', [
            'label'      => __( 'Heading Animation Duration', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['s'],
            'range'      => [
                's' => [
                    'min'  => 0.1,
                    'max'  => 3,
                    'step' => 0.1,
                ],
            ],
            'default'    => [
                'unit' => 's',
                'size' => 0.8,
            ],
            'selectors'  => [
                '{{WRAPPER}} .title-text-wrapper, {{WRAPPER}} .heading-bg-wrapper-part1, {{WRAPPER}} .heading-bg-wrapper-part2' => 'animation-duration: {{SIZE}}{{UNIT}};',
            ],
            'condition'  => [
                'heading_animation!' => 'none',
            ],
        ] );
        $this->add_control( 'heading_animation_delay', [
            'label'      => __( 'Heading Animation Delay', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['s'],
            'range'      => [
                's' => [
                    'min'  => 0,
                    'max'  => 2,
                    'step' => 0.1,
                ],
            ],
            'default'    => [
                'unit' => 's',
                'size' => 0,
            ],
            'selectors'  => [
                '{{WRAPPER}} .title-text-wrapper, {{WRAPPER}} .heading-bg-wrapper-part1, {{WRAPPER}} .heading-bg-wrapper-part2' => 'animation-delay: {{SIZE}}{{UNIT}};',
            ],
            'condition'  => [
                'heading_animation!' => 'none',
            ],
        ] );
        $this->add_control( 'animations_hr1', [
            'type' => \Elementor\Controls_Manager::DIVIDER,
        ] );
        $this->add_control( 'description_animation', [
            'label'     => __( 'Description Animation', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::SELECT,
            'default'   => 'none',
            'options'   => [
                'none'              => __( 'None', 'orange-addons-for-elementor' ),
                'oea-fade-in'       => __( 'Fade In', 'orange-addons-for-elementor' ),
                'oea-fade-in-up'    => __( 'Fade In Up', 'orange-addons-for-elementor' ),
                'oea-fade-in-down'  => __( 'Fade In Down', 'orange-addons-for-elementor' ),
                'oea-fade-in-left'  => __( 'Fade In Left', 'orange-addons-for-elementor' ),
                'oea-fade-in-right' => __( 'Fade In Right', 'orange-addons-for-elementor' ),
                'oea-zoom-in'       => __( 'Zoom In', 'orange-addons-for-elementor' ),
                'oea-bounce-in'     => __( 'Bounce In', 'orange-addons-for-elementor' ),
                'oea-flip-in'       => __( 'Flip In', 'orange-addons-for-elementor' ),
                'oea-rotate-in'     => __( 'Rotate In', 'orange-addons-for-elementor' ),
            ],
            'condition' => [
                'subheading_text!' => '',
            ],
        ] );
        $this->add_control( 'description_animation_duration', [
            'label'      => __( 'Description Animation Duration', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['s'],
            'range'      => [
                's' => [
                    'min'  => 0.1,
                    'max'  => 3,
                    'step' => 0.1,
                ],
            ],
            'default'    => [
                'unit' => 's',
                'size' => 0.8,
            ],
            'selectors'  => [
                '{{WRAPPER}} .subheading-text' => 'animation-duration: {{SIZE}}{{UNIT}};',
            ],
            'condition'  => [
                'description_animation!' => 'none',
                'subheading_text!'       => '',
            ],
        ] );
        $this->add_control( 'description_animation_delay', [
            'label'      => __( 'Description Animation Delay', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['s'],
            'range'      => [
                's' => [
                    'min'  => 0,
                    'max'  => 2,
                    'step' => 0.1,
                ],
            ],
            'default'    => [
                'unit' => 's',
                'size' => 0.3,
            ],
            'selectors'  => [
                '{{WRAPPER}} .subheading-text' => 'animation-delay: {{SIZE}}{{UNIT}};',
            ],
            'condition'  => [
                'description_animation!' => 'none',
                'subheading_text!'       => '',
            ],
        ] );
        $this->add_control( 'animations_hr2', [
            'type' => \Elementor\Controls_Manager::DIVIDER,
        ] );
        $this->add_control( 'underline_animation', [
            'label'   => __( 'Underline Animation', 'orange-addons-for-elementor' ),
            'type'    => \Elementor\Controls_Manager::SELECT,
            'default' => 'none',
            'options' => [
                'none'              => __( 'None', 'orange-addons-for-elementor' ),
                'oea-fade-in'       => __( 'Fade In', 'orange-addons-for-elementor' ),
                'oea-fade-in-up'    => __( 'Fade In Up', 'orange-addons-for-elementor' ),
                'oea-fade-in-down'  => __( 'Fade In Down', 'orange-addons-for-elementor' ),
                'oea-fade-in-left'  => __( 'Fade In Left', 'orange-addons-for-elementor' ),
                'oea-fade-in-right' => __( 'Fade In Right', 'orange-addons-for-elementor' ),
                'oea-zoom-in'       => __( 'Zoom In', 'orange-addons-for-elementor' ),
                'oea-bounce-in'     => __( 'Bounce In', 'orange-addons-for-elementor' ),
                'oea-flip-in'       => __( 'Flip In', 'orange-addons-for-elementor' ),
                'oea-rotate-in'     => __( 'Rotate In', 'orange-addons-for-elementor' ),
            ],
        ] );
        $this->add_control( 'underline_animation_duration', [
            'label'      => __( 'Animation Duration', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['s'],
            'range'      => [
                's' => [
                    'min'  => 0.1,
                    'max'  => 3,
                    'step' => 0.1,
                ],
            ],
            'default'    => [
                'unit' => 's',
                'size' => 0.8,
            ],
            'selectors'  => [
                '{{WRAPPER}} .custom-heading .heading-underline' => 'animation-duration: {{SIZE}}{{UNIT}};',
            ],
            'condition'  => [
                'underline_animation!' => 'none',
            ],
        ] );
        $this->add_control( 'underline_animation_delay', [
            'label'      => __( 'Animation Delay', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['s'],
            'range'      => [
                's' => [
                    'min'  => 0,
                    'max'  => 2,
                    'step' => 0.1,
                ],
            ],
            'default'    => [
                'unit' => 's',
                'size' => 0.5,
            ],
            'selectors'  => [
                '{{WRAPPER}} .custom-heading .heading-underline' => 'animation-delay: {{SIZE}}{{UNIT}};',
            ],
            'condition'  => [
                'underline_animation!' => 'none',
            ],
        ] );
        $this->add_control( 'animations_hr3', [
            'type' => \Elementor\Controls_Manager::DIVIDER,
        ] );
        $this->add_control( 'icon_animation', [
            'label'     => __( 'Icon Animation', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::SELECT,
            'default'   => 'none',
            'options'   => [
                'none'              => __( 'None', 'orange-addons-for-elementor' ),
                'oea-fade-in'       => __( 'Fade In', 'orange-addons-for-elementor' ),
                'oea-fade-in-up'    => __( 'Fade In Up', 'orange-addons-for-elementor' ),
                'oea-fade-in-down'  => __( 'Fade In Down', 'orange-addons-for-elementor' ),
                'oea-fade-in-left'  => __( 'Fade In Left', 'orange-addons-for-elementor' ),
                'oea-fade-in-right' => __( 'Fade In Right', 'orange-addons-for-elementor' ),
                'oea-zoom-in'       => __( 'Zoom In', 'orange-addons-for-elementor' ),
                'oea-bounce-in'     => __( 'Bounce In', 'orange-addons-for-elementor' ),
                'oea-flip-in'       => __( 'Flip In', 'orange-addons-for-elementor' ),
                'oea-rotate-in'     => __( 'Rotate In', 'orange-addons-for-elementor' ),
            ],
            'condition' => [
                'show_icon' => 'yes',
            ],
        ] );
        $this->add_control( 'icon_animation_duration', [
            'label'      => __( 'Icon Animation Duration', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['s'],
            'range'      => [
                's' => [
                    'min'  => 0.1,
                    'max'  => 3,
                    'step' => 0.1,
                ],
            ],
            'default'    => [
                'unit' => 's',
                'size' => 0.8,
            ],
            'selectors'  => [
                '{{WRAPPER}} .custom-heading .oea-heading-icon' => 'animation-duration: {{SIZE}}{{UNIT}};',
            ],
            'condition'  => [
                'show_icon'       => 'yes',
                'icon_animation!' => 'none',
            ],
        ] );
        $this->add_control( 'icon_animation_delay', [
            'label'      => __( 'Icon Animation Delay', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['s'],
            'range'      => [
                's' => [
                    'min'  => 0,
                    'max'  => 2,
                    'step' => 0.1,
                ],
            ],
            'default'    => [
                'unit' => 's',
                'size' => 0,
            ],
            'selectors'  => [
                '{{WRAPPER}} .custom-heading .oea-heading-icon' => 'animation-delay: {{SIZE}}{{UNIT}};',
            ],
            'condition'  => [
                'show_icon'       => 'yes',
                'icon_animation!' => 'none',
            ],
        ] );
        $this->add_control( 'animations_hr4', [
            'type' => \Elementor\Controls_Manager::DIVIDER,
        ] );
        $this->add_control( 'background_text_animation', [
            'label'     => __( 'Background Text Animation', 'orange-addons-for-elementor' ),
            'type'      => \Elementor\Controls_Manager::SELECT,
            'default'   => 'none',
            'options'   => [
                'none'              => __( 'None', 'orange-addons-for-elementor' ),
                'oea-fade-in'       => __( 'Fade In', 'orange-addons-for-elementor' ),
                'oea-fade-in-up'    => __( 'Fade In Up', 'orange-addons-for-elementor' ),
                'oea-fade-in-down'  => __( 'Fade In Down', 'orange-addons-for-elementor' ),
                'oea-fade-in-left'  => __( 'Fade In Left', 'orange-addons-for-elementor' ),
                'oea-fade-in-right' => __( 'Fade In Right', 'orange-addons-for-elementor' ),
                'oea-zoom-in'       => __( 'Zoom In', 'orange-addons-for-elementor' ),
                'oea-bounce-in'     => __( 'Bounce In', 'orange-addons-for-elementor' ),
                'oea-flip-in'       => __( 'Flip In', 'orange-addons-for-elementor' ),
                'oea-rotate-in'     => __( 'Rotate In', 'orange-addons-for-elementor' ),
            ],
            'condition' => [
                'enable_background_text' => 'yes',
            ],
        ] );
        $this->add_control( 'background_text_animation_duration', [
            'label'      => __( 'Background Text Animation Duration', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['s'],
            'range'      => [
                's' => [
                    'min'  => 0.1,
                    'max'  => 3,
                    'step' => 0.1,
                ],
            ],
            'default'    => [
                'unit' => 's',
                'size' => 0.8,
            ],
            'selectors'  => [
                '{{WRAPPER}} .custom-heading .background-text' => 'animation-duration: {{SIZE}}{{UNIT}};',
            ],
            'condition'  => [
                'enable_background_text'     => 'yes',
                'background_text_animation!' => 'none',
            ],
        ] );
        $this->add_control( 'background_text_animation_delay', [
            'label'      => __( 'Background Text Animation Delay', 'orange-addons-for-elementor' ),
            'type'       => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['s'],
            'range'      => [
                's' => [
                    'min'  => 0,
                    'max'  => 2,
                    'step' => 0.1,
                ],
            ],
            'default'    => [
                'unit' => 's',
                'size' => 0.2,
            ],
            'selectors'  => [
                '{{WRAPPER}} .custom-heading .background-text' => 'animation-delay: {{SIZE}}{{UNIT}};',
            ],
            'condition'  => [
                'enable_background_text'     => 'yes',
                'background_text_animation!' => 'none',
            ],
        ] );
        $this->add_control( 'animation_on_scroll', [
            'label'       => __( 'Animate Only When Visible', 'orange-addons-for-elementor' ),
            'type'        => \Elementor\Controls_Manager::SWITCHER,
            'label_on'    => __( 'Yes', 'orange-addons-for-elementor' ),
            'label_off'   => __( 'No', 'orange-addons-for-elementor' ),
            'default'     => '',
            'description' => __( 'Animation will start only when element enters the viewport.', 'orange-addons-for-elementor' ),
        ] );
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $heading_tag = $settings['heading_tag'];
        $wrapper_classes = 'custom-heading';
        $gradient_style = '';
        if ( empty( $settings['enable_dual_heading'] ) && 'gradient' === $settings['single_text_color_type'] ) {
            $angle = ( isset( $settings['single_text_gradient_angle']['size'] ) ? $settings['single_text_gradient_angle']['size'] : 45 );
            $colors = [];
            if ( !empty( $settings['single_text_gradient_color1'] ) ) {
                $colors[] = $settings['single_text_gradient_color1'];
            }
            if ( !empty( $settings['single_text_gradient_color2'] ) ) {
                $colors[] = $settings['single_text_gradient_color2'];
            }
            if ( !empty( $settings['single_text_gradient_color3'] ) ) {
                $colors[] = $settings['single_text_gradient_color3'];
            }
            if ( !empty( $settings['single_text_gradient_color4'] ) ) {
                $colors[] = $settings['single_text_gradient_color4'];
            }
            $count = count( $colors );
            if ( $count > 0 ) {
                $stops = [];
                if ( $count > 1 ) {
                    foreach ( $colors as $index => $color ) {
                        $position = round( $index * 100 / ($count - 1), 2 );
                        $stops[] = $color . ' ' . $position . '%';
                    }
                } else {
                    $stops[] = $colors[0];
                }
                $gradient_stops = implode( ', ', array_map( 'esc_attr', $stops ) );
                $gradient_style = 'background: -webkit-linear-gradient(' . esc_attr( $angle ) . 'deg, ' . $gradient_stops . '); -webkit-background-clip: text; -webkit-text-fill-color: transparent;';
            }
        }
        $single_stroke_style = '';
        if ( !empty( $settings['single_text_stroke_width']['size'] ) && $settings['single_text_stroke_width']['size'] > 0 ) {
            $strokeColor = ( !empty( $settings['single_text_stroke_color'] ) ? esc_attr( $settings['single_text_stroke_color'] ) : '#000' );
            $single_stroke_style = '-webkit-text-stroke: ' . esc_attr( $settings['single_text_stroke_width']['size'] ) . esc_attr( $settings['single_text_stroke_width']['unit'] ) . ' ' . $strokeColor . '; text-stroke: ' . esc_attr( $settings['single_text_stroke_width']['size'] ) . esc_attr( $settings['single_text_stroke_width']['unit'] ) . ' ' . $strokeColor . ';';
        }
        $heading_rotation = ( isset( $settings['heading_rotation']['size'] ) ? esc_attr( $settings['heading_rotation']['size'] ) . esc_attr( $settings['heading_rotation']['unit'] ) : '0deg' );
        $rotation_style = 'transform: rotate(' . $heading_rotation . ');';
        $offset_x = ( isset( $settings['background_text_offset_x']['size'] ) ? esc_attr( $settings['background_text_offset_x']['size'] ) . esc_attr( $settings['background_text_offset_x']['unit'] ) : '0px' );
        $offset_y = ( isset( $settings['background_text_offset_y']['size'] ) ? esc_attr( $settings['background_text_offset_y']['size'] ) . esc_attr( $settings['background_text_offset_y']['unit'] ) : '0px' );
        $background_text_rotation = ( isset( $settings['background_text_rotation']['size'] ) ? esc_attr( $settings['background_text_rotation']['size'] ) . esc_attr( $settings['background_text_rotation']['unit'] ) : '0deg' );
        $background_text_blend_mode = ( isset( $settings['background_text_blend_mode'] ) ? esc_attr( $settings['background_text_blend_mode'] ) : 'normal' );
        $background_transform = "translate(calc(-50% + {$offset_x}), calc(-50% + {$offset_y})) rotate({$background_text_rotation})";
        $background_opacity = (( isset( $settings['background_text_opacity']['size'] ) ? esc_attr( $settings['background_text_opacity']['size'] ) : 15 )) / 100;
        $bg_stroke_style = '';
        if ( !empty( $settings['background_text_stroke_width']['size'] ) && $settings['background_text_stroke_width']['size'] > 0 ) {
            $bg_stroke_color = ( !empty( $settings['background_text_stroke_color'] ) ? esc_attr( $settings['background_text_stroke_color'] ) : '#000' );
            $bg_stroke_style = '-webkit-text-stroke: ' . esc_attr( $settings['background_text_stroke_width']['size'] ) . esc_attr( $settings['background_text_stroke_width']['unit'] ) . ' ' . $bg_stroke_color . '; text-stroke: ' . esc_attr( $settings['background_text_stroke_width']['size'] ) . esc_attr( $settings['background_text_stroke_width']['unit'] ) . ' ' . $bg_stroke_color . ';';
        }
        $heading_animation_class = ( $settings['heading_animation'] && $settings['heading_animation'] !== 'none' ? esc_attr( $settings['heading_animation'] ) : '' );
        $description_animation_class = ( $settings['description_animation'] && $settings['description_animation'] !== 'none' ? esc_attr( $settings['description_animation'] ) : '' );
        if ( !empty( $settings['animation_on_scroll'] ) && $settings['animation_on_scroll'] === 'yes' ) {
            $wrapper_classes .= ' oea-animate-on-scroll';
        }
        ?>

        <div class="<?php 
        echo esc_attr( $wrapper_classes );
        ?>" style="position: relative;">
            <?php 
        $icon_html = '';
        if ( !empty( $settings['show_icon'] ) && $settings['show_icon'] === 'yes' && !empty( $settings['icon']['value'] ) ) {
            $icon_animation_class = ( $settings['icon_animation'] && $settings['icon_animation'] !== 'none' ? esc_attr( $settings['icon_animation'] ) : '' );
            $icon_html = '<span class="oea-heading-icon ' . esc_attr( $icon_animation_class ) . '" aria-hidden="true">';
            ob_start();
            \Elementor\Icons_Manager::render_icon( $settings['icon'], [
                'aria-hidden' => 'true',
            ] );
            $icon_html .= ob_get_clean();
            $icon_html .= '</span>';
        }
        ob_start();
        if ( 'yes' === $settings['enable_dual_heading'] ) {
            echo '<' . esc_html( $heading_tag ) . ' style="position: relative; z-index: 1;">';
            $gradient_style_part1 = '';
            if ( 'gradient' === $settings['text_color_type_part1'] ) {
                $angle = ( isset( $settings['text_gradient_angle_part1']['size'] ) ? $settings['text_gradient_angle_part1']['size'] : 45 );
                $colors = [];
                if ( !empty( $settings['text_gradient_color1_part1'] ) ) {
                    $colors[] = $settings['text_gradient_color1_part1'];
                }
                if ( !empty( $settings['text_gradient_color2_part1'] ) ) {
                    $colors[] = $settings['text_gradient_color2_part1'];
                }
                if ( !empty( $settings['text_gradient_color3_part1'] ) ) {
                    $colors[] = $settings['text_gradient_color3_part1'];
                }
                if ( !empty( $settings['text_gradient_color4_part1'] ) ) {
                    $colors[] = $settings['text_gradient_color4_part1'];
                }
                $count = count( $colors );
                if ( $count > 0 ) {
                    $stops = [];
                    if ( $count > 1 ) {
                        foreach ( $colors as $index => $color ) {
                            $position = round( $index * 100 / ($count - 1), 2 );
                            $stops[] = $color . ' ' . $position . '%';
                        }
                    } else {
                        $stops[] = $colors[0];
                    }
                    $gradient_stops = implode( ', ', array_map( 'esc_attr', $stops ) );
                    $gradient_style_part1 = 'background: -webkit-linear-gradient(' . esc_attr( $angle ) . 'deg, ' . $gradient_stops . '); -webkit-background-clip: text; -webkit-text-fill-color: transparent;';
                }
            } elseif ( 'image' === $settings['text_color_type_part1'] ) {
            }
            $stroke_style_part1 = '';
            if ( !empty( $settings['text_stroke_width_part1']['size'] ) && $settings['text_stroke_width_part1']['size'] > 0 ) {
                $strokeColor1 = ( !empty( $settings['text_stroke_color_part1'] ) ? esc_attr( $settings['text_stroke_color_part1'] ) : '#000' );
                $stroke_style_part1 = '-webkit-text-stroke: ' . esc_attr( $settings['text_stroke_width_part1']['size'] ) . esc_attr( $settings['text_stroke_width_part1']['unit'] ) . ' ' . $strokeColor1 . '; text-stroke: ' . esc_attr( $settings['text_stroke_width_part1']['size'] ) . esc_attr( $settings['text_stroke_width_part1']['unit'] ) . ' ' . $strokeColor1 . ';';
            }
            $heading_rotation_part1 = ( isset( $settings['heading_rotation_part1']['size'] ) ? esc_attr( $settings['heading_rotation_part1']['size'] ) . esc_attr( $settings['heading_rotation_part1']['unit'] ) : '0deg' );
            $rotation_style_part1 = 'transform: rotate(' . $heading_rotation_part1 . '); display: inline-block;';
            echo '<span class="heading-rotator-part1" style="' . esc_attr( $rotation_style_part1 ) . '">';
            echo '<span class="heading-bg-wrapper-part1 ' . esc_attr( $heading_animation_class ) . '" style="display:inline-block;">';
            echo '<span class="title-text-part1" style="' . esc_attr( $gradient_style_part1 . ' ' . $stroke_style_part1 ) . '">' . wp_kses_post( $settings['heading_text_part1'] ) . '</span>';
            echo '</span>';
            echo '</span> ';
            $gradient_style_part2 = '';
            if ( 'gradient' === $settings['text_color_type_part2'] ) {
                $angle = ( isset( $settings['text_gradient_angle_part2']['size'] ) ? $settings['text_gradient_angle_part2']['size'] : 45 );
                $colors = [];
                if ( !empty( $settings['text_gradient_color1_part2'] ) ) {
                    $colors[] = $settings['text_gradient_color1_part2'];
                }
                if ( !empty( $settings['text_gradient_color2_part2'] ) ) {
                    $colors[] = $settings['text_gradient_color2_part2'];
                }
                if ( !empty( $settings['text_gradient_color3_part2'] ) ) {
                    $colors[] = $settings['text_gradient_color3_part2'];
                }
                if ( !empty( $settings['text_gradient_color4_part2'] ) ) {
                    $colors[] = $settings['text_gradient_color4_part2'];
                }
                $count = count( $colors );
                if ( $count > 0 ) {
                    $stops = [];
                    if ( $count > 1 ) {
                        foreach ( $colors as $index => $color ) {
                            $position = round( $index * 100 / ($count - 1), 2 );
                            $stops[] = $color . ' ' . $position . '%';
                        }
                    } else {
                        $stops[] = $colors[0];
                    }
                    $gradient_stops = implode( ', ', array_map( 'esc_attr', $stops ) );
                    $gradient_style_part2 = 'background: -webkit-linear-gradient(' . esc_attr( $angle ) . 'deg, ' . $gradient_stops . '); -webkit-background-clip: text; -webkit-text-fill-color: transparent;';
                }
            } elseif ( 'image' === $settings['text_color_type_part2'] ) {
            }
            $stroke_style_part2 = '';
            if ( !empty( $settings['text_stroke_width_part2']['size'] ) && $settings['text_stroke_width_part2']['size'] > 0 ) {
                $strokeColor2 = ( !empty( $settings['text_stroke_color_part2'] ) ? esc_attr( $settings['text_stroke_color_part2'] ) : '#000' );
                $stroke_style_part2 = '-webkit-text-stroke: ' . esc_attr( $settings['text_stroke_width_part2']['size'] ) . esc_attr( $settings['text_stroke_width_part2']['unit'] ) . ' ' . $strokeColor2 . '; text-stroke: ' . esc_attr( $settings['text_stroke_width_part2']['size'] ) . esc_attr( $settings['text_stroke_width_part2']['unit'] ) . ' ' . $strokeColor2 . ';';
            }
            $heading_rotation_part2 = ( isset( $settings['heading_rotation_part2']['size'] ) ? esc_attr( $settings['heading_rotation_part2']['size'] ) . esc_attr( $settings['heading_rotation_part2']['unit'] ) : '0deg' );
            $rotation_style_part2 = 'transform: rotate(' . $heading_rotation_part2 . '); display: inline-block;';
            echo '<span class="heading-rotator-part2" style="' . esc_attr( $rotation_style_part2 ) . '">';
            echo '<span class="heading-bg-wrapper-part2 ' . esc_attr( $heading_animation_class ) . '" style="display:inline-block;">';
            echo '<span class="title-text-part2" style="' . esc_attr( $gradient_style_part2 . ' ' . $stroke_style_part2 ) . '">' . wp_kses_post( $settings['heading_text_part2'] ) . '</span>';
            echo '</span>';
            echo '</span>';
            echo '</' . esc_html( $heading_tag ) . '>';
        } else {
            echo '<' . esc_html( $heading_tag ) . ' style="position: relative; z-index: 1;">';
            $heading_rotation = ( isset( $settings['heading_rotation']['size'] ) ? esc_attr( $settings['heading_rotation']['size'] ) . esc_attr( $settings['heading_rotation']['unit'] ) : '0deg' );
            $rotation_style = 'transform: rotate(' . $heading_rotation . '); display: inline-block;';
            echo '<span class="heading-rotator" style="' . esc_attr( $rotation_style ) . '">';
            echo '<span class="title-text-wrapper ' . esc_attr( $heading_animation_class ) . '" style="display:inline-block;">';
            if ( 'image' === $settings['single_text_color_type'] ) {
            }
            echo '<span class="title-text" style="' . esc_attr( $gradient_style . ' ' . $single_stroke_style ) . (( isset( $single_bg_style ) ? esc_attr( $single_bg_style ) : '' )) . '">';
            echo wp_kses_post( $settings['heading_text'] );
            echo '</span>';
            echo '</span>';
            echo '</span>';
            echo '</' . esc_html( $heading_tag ) . '>';
        }
        $heading_html = ob_get_clean();
        $desc_html = '';
        if ( !empty( $settings['show_description'] ) && $settings['show_description'] === 'yes' && !empty( $settings['subheading_text'] ) ) {
            $description_animation_class = ( $settings['description_animation'] && $settings['description_animation'] !== 'none' ? esc_attr( $settings['description_animation'] ) : '' );
            $desc_html = '<div class="subheading-text ' . esc_attr( $description_animation_class ) . '">' . wp_kses_post( $settings['subheading_text'] ) . '</div>';
        }
        $underline_html = '';
        if ( isset( $settings['underline_style'] ) && 'none' !== $settings['underline_style'] ) {
            $underline_type = esc_attr( $settings['underline_style'] );
            $underline_animation_class = ( $settings['underline_animation'] && $settings['underline_animation'] !== 'none' ? esc_attr( $settings['underline_animation'] ) : '' );
            $underline_html = '<div class="heading-underline ' . $underline_type . ' ' . $underline_animation_class . '"></div>';
        }
        $element_map = [
            'icon'        => $icon_html,
            'heading'     => $heading_html,
            'description' => $desc_html,
            'underline'   => $underline_html,
        ];
        $order_presets = [
            'icon-heading-underline-description' => [
                'icon',
                'heading',
                'underline',
                'description'
            ],
            'icon-heading-description-underline' => [
                'icon',
                'heading',
                'description',
                'underline'
            ],
            'icon-underline-heading-description' => [
                'icon',
                'underline',
                'heading',
                'description'
            ],
            'icon-description-heading-underline' => [
                'icon',
                'description',
                'heading',
                'underline'
            ],
            'heading-icon-underline-description' => [
                'heading',
                'icon',
                'underline',
                'description'
            ],
            'heading-icon-description-underline' => [
                'heading',
                'icon',
                'description',
                'underline'
            ],
            'heading-underline-icon-description' => [
                'heading',
                'underline',
                'icon',
                'description'
            ],
            'heading-description-icon-underline' => [
                'heading',
                'description',
                'icon',
                'underline'
            ],
            'description-icon-heading-underline' => [
                'description',
                'icon',
                'heading',
                'underline'
            ],
            'description-heading-icon-underline' => [
                'description',
                'heading',
                'icon',
                'underline'
            ],
            'underline-icon-heading-description' => [
                'underline',
                'icon',
                'heading',
                'description'
            ],
            'underline-heading-icon-description' => [
                'underline',
                'heading',
                'icon',
                'description'
            ],
            'underline-heading-description-icon' => [
                'underline',
                'heading',
                'description',
                'icon'
            ],
            'icon-underline-description-heading' => [
                'icon',
                'underline',
                'description',
                'heading'
            ],
            'description-underline-icon-heading' => [
                'description',
                'underline',
                'icon',
                'heading'
            ],
            'description-underline-heading-icon' => [
                'description',
                'underline',
                'heading',
                'icon'
            ],
        ];
        $order = ( isset( $order_presets[$settings['element_order_preset']] ) ? $order_presets[$settings['element_order_preset']] : $order_presets['icon-heading-underline-description'] );
        $allowed_element_html = $this->get_output_allowed_html();
        $style_filter = [$this, 'extend_safe_style_css'];
        add_filter( 'safe_style_css', $style_filter );
        add_filter( 'safecss_filter_attr_allow_css', '__return_true' );
        foreach ( $order as $el ) {
            if ( !empty( $element_map[$el] ) ) {
                echo wp_kses( $element_map[$el], $allowed_element_html );
            }
        }
        remove_filter( 'safecss_filter_attr_allow_css', '__return_true' );
        remove_filter( 'safe_style_css', $style_filter );
        if ( 'yes' === $settings['enable_background_text'] && !empty( $settings['background_text'] ) ) {
            $background_animation_class = ( $settings['background_text_animation'] && $settings['background_text_animation'] !== 'none' ? esc_attr( $settings['background_text_animation'] ) : '' );
            echo '<div class="background-text-wrapper" style="position: absolute; top: 50%; left: 50%; width: 100%; transform: ' . esc_attr( $background_transform ) . '; opacity: ' . esc_attr( $background_opacity ) . '; z-index: 0; pointer-events: none;">';
            echo '<div class="background-text ' . esc_attr( $background_animation_class ) . '" style="width: 100%; mix-blend-mode: ' . esc_attr( $background_text_blend_mode ) . '; ' . esc_attr( $bg_stroke_style ) . ';">' . wp_kses_post( $settings['background_text'] ) . '</div>';
            echo '</div>';
        }
        ?>
        </div>
        <?php 
    }

    private function get_output_allowed_html() {
        $allowed = wp_kses_allowed_html( 'post' );
        $allowed['div'] = ( isset( $allowed['div'] ) ? array_merge( $allowed['div'], [
            'class'        => true,
            'id'           => true,
            'style'        => true,
            'aria-hidden'  => true,
            'data-element' => true,
        ] ) : [
            'class'        => true,
            'id'           => true,
            'style'        => true,
            'aria-hidden'  => true,
            'data-element' => true,
        ] );
        $allowed['span'] = ( isset( $allowed['span'] ) ? array_merge( $allowed['span'], [
            'class'          => true,
            'id'             => true,
            'style'          => true,
            'aria-hidden'    => true,
            'role'           => true,
            'data-element'   => true,
            'data-animation' => true,
        ] ) : [
            'class'          => true,
            'id'             => true,
            'style'          => true,
            'aria-hidden'    => true,
            'role'           => true,
            'data-element'   => true,
            'data-animation' => true,
        ] );
        $allowed['i'] = ( isset( $allowed['i'] ) ? array_merge( $allowed['i'], [
            'class'       => true,
            'aria-hidden' => true,
            'style'       => true,
            'data-icon'   => true,
            'data-prefix' => true,
            'data-id'     => true,
        ] ) : [
            'class'       => true,
            'aria-hidden' => true,
            'style'       => true,
            'data-icon'   => true,
            'data-prefix' => true,
            'data-id'     => true,
        ] );
        $allowed['svg'] = array_merge( ( isset( $allowed['svg'] ) ? $allowed['svg'] : [] ), [
            'class'               => true,
            'aria-hidden'         => true,
            'role'                => true,
            'focusable'           => true,
            'xmlns'               => true,
            'xmlns:xlink'         => true,
            'width'               => true,
            'height'              => true,
            'viewbox'             => true,
            'viewBox'             => true,
            'style'               => true,
            'fill'                => true,
            'stroke'              => true,
            'stroke-width'        => true,
            'stroke-linecap'      => true,
            'stroke-linejoin'     => true,
            'preserveAspectRatio' => true,
            'data-icon'           => true,
            'data-prefix'         => true,
            'data-name'           => true,
            'data-id'             => true,
            'x'                   => true,
            'y'                   => true,
            'id'                  => true,
            'version'             => true,
        ] );
        $allowed['path'] = array_merge( ( isset( $allowed['path'] ) ? $allowed['path'] : [] ), [
            'd'                 => true,
            'fill'              => true,
            'stroke'            => true,
            'stroke-width'      => true,
            'stroke-linecap'    => true,
            'stroke-linejoin'   => true,
            'stroke-miterlimit' => true,
            'stroke-dasharray'  => true,
            'stroke-dashoffset' => true,
            'fill-rule'         => true,
            'clip-rule'         => true,
            'style'             => true,
            'transform'         => true,
            'opacity'           => true,
        ] );
        $allowed['g'] = array_merge( ( isset( $allowed['g'] ) ? $allowed['g'] : [] ), [
            'fill'              => true,
            'stroke'            => true,
            'stroke-width'      => true,
            'stroke-linecap'    => true,
            'stroke-linejoin'   => true,
            'stroke-miterlimit' => true,
            'stroke-dasharray'  => true,
            'stroke-dashoffset' => true,
            'style'             => true,
            'class'             => true,
            'clip-path'         => true,
            'transform'         => true,
            'opacity'           => true,
        ] );
        $allowed['use'] = array_merge( ( isset( $allowed['use'] ) ? $allowed['use'] : [] ), [
            'href'       => true,
            'xlink:href' => true,
            'x'          => true,
            'y'          => true,
        ] );
        $allowed['title'] = array_merge( ( isset( $allowed['title'] ) ? $allowed['title'] : [] ), [
            'id'    => true,
            'class' => true,
        ] );
        $allowed['circle'] = array_merge( ( isset( $allowed['circle'] ) ? $allowed['circle'] : [] ), [
            'cx'           => true,
            'cy'           => true,
            'r'            => true,
            'fill'         => true,
            'stroke'       => true,
            'stroke-width' => true,
            'style'        => true,
            'opacity'      => true,
            'transform'    => true,
        ] );
        $allowed['rect'] = array_merge( ( isset( $allowed['rect'] ) ? $allowed['rect'] : [] ), [
            'x'            => true,
            'y'            => true,
            'width'        => true,
            'height'       => true,
            'rx'           => true,
            'ry'           => true,
            'fill'         => true,
            'stroke'       => true,
            'stroke-width' => true,
            'style'        => true,
            'opacity'      => true,
            'transform'    => true,
        ] );
        $allowed['polygon'] = array_merge( ( isset( $allowed['polygon'] ) ? $allowed['polygon'] : [] ), [
            'points'       => true,
            'fill'         => true,
            'stroke'       => true,
            'stroke-width' => true,
            'style'        => true,
            'opacity'      => true,
            'transform'    => true,
        ] );
        $allowed['polyline'] = array_merge( ( isset( $allowed['polyline'] ) ? $allowed['polyline'] : [] ), [
            'points'       => true,
            'fill'         => true,
            'stroke'       => true,
            'stroke-width' => true,
            'style'        => true,
            'opacity'      => true,
            'transform'    => true,
        ] );
        $allowed['line'] = array_merge( ( isset( $allowed['line'] ) ? $allowed['line'] : [] ), [
            'x1'           => true,
            'y1'           => true,
            'x2'           => true,
            'y2'           => true,
            'stroke'       => true,
            'stroke-width' => true,
            'style'        => true,
            'opacity'      => true,
            'transform'    => true,
        ] );
        return $allowed;
    }

    public function extend_safe_style_css( $styles ) {
        $custom = [
            'background',
            'background-image',
            'background-position',
            'background-repeat',
            'background-size',
            'background-clip',
            '-webkit-background-clip',
            'background-origin',
            'background-attachment',
            '-webkit-text-fill-color',
            '-webkit-text-stroke',
            '-webkit-text-stroke-color',
            '-webkit-text-stroke-width',
            'text-stroke',
            'text-stroke-color',
            'text-stroke-width',
            'text-fill-color',
            'animation',
            'animation-delay',
            'animation-direction',
            'animation-duration',
            'animation-fill-mode',
            'animation-iteration-count',
            'animation-name',
            'animation-play-state',
            'animation-timing-function',
            'transform',
            'transform-origin',
            'display',
            'position',
            'top',
            'right',
            'bottom',
            'left',
            'width',
            'height',
            'opacity',
            'z-index',
            'pointer-events',
            'mix-blend-mode',
            'color',
            'fill',
            'stroke',
            'stroke-linecap',
            'stroke-linejoin',
            'stroke-width',
            'stroke-dasharray',
            'stroke-dashoffset',
            'stroke-miterlimit',
            'clip-path',
            'filter'
        ];
        return array_unique( array_merge( $styles, $custom ) );
    }

}
