<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class Oradel_Accordion_Widget extends \Elementor\Widget_Base
{


    public function get_name()
    {
        return 'oradel_accordion';
    }


    public function get_title()
    {
        return esc_html__('Accordion', 'orange-addons-for-elementor');
    }


    public function get_icon()
    {
        return 'eicon-accordion';
    }


    public function get_categories()
    {
        return ['oradel-plugin'];
    }


    public function get_keywords()
    {
        return ['accordion'];
    }


    public function get_custom_help_url()
    {
        return 'https://orange-addons.com/docs/';
    }

    public function get_style_depends()
    {
        return ['oea-accordion'];
    }

    public function get_script_depends()
    {
        return ['oea-accordion'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content', 'orange-addons-for-elementor'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'item_title',
            [
                'label' => esc_html__('Title', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('List Title', 'orange-addons-for-elementor'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'item_content',
            [
                'label' => esc_html__('Description', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'rows' => 10,
                'default' => esc_html__('Default description', 'orange-addons-for-elementor'),
                'placeholder' => esc_html__('Type your description here', 'orange-addons-for-elementor'),
            ]
        );

        $repeater->add_control(
            'item_icon',
            [
                'label' => esc_html__('Icon', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-circle',
                    'library' => 'fa-solid',
                ],
                'recommended' => [
                    'fa-solid' => [
                        'circle',
                        'dot-circle',
                        'square-full',
                    ],
                    'fa-regular' => [
                        'circle',
                        'dot-circle',
                        'square-full',
                    ],
                ],
            ]
        );

        $this->add_control(
            'accordion_list',
            [
                'label' => esc_html__('Accordion', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'item_title' => esc_html__('Title #1', 'orange-addons-for-elementor'),
                        'item_content' => esc_html__('Item content. Click the edit button to change this text.', 'orange-addons-for-elementor'),
                    ],
                    [
                        'item_title' => esc_html__('Title #2', 'orange-addons-for-elementor'),
                        'item_content' => esc_html__('Item content. Click the edit button to change this text.', 'orange-addons-for-elementor'),
                    ],
                ],
                'title_field' => '{{{ item_title }}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('Settings', 'orange-addons-for-elementor'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'active_tab',
            [
                'label' => esc_html__('Active Tab', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'default' => 1,
            ]
        );

        $this->add_control(
            'auto_collapse',
            [
                'label' => esc_html__('Auto Collapse', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'orange-addons-for-elementor'),
                'label_off' => esc_html__('No', 'orange-addons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'title_html_tag',
            [
                'label' => esc_html__('Title HTML Tag', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'span' => esc_html__('Span', 'orange-addons-for-elementor'),
                    'h1' => esc_html__('H1', 'orange-addons-for-elementor'),
                    'h2' => esc_html__('H2', 'orange-addons-for-elementor'),
                    'h3' => esc_html__('H3', 'orange-addons-for-elementor'),
                    'h4' => esc_html__('H4', 'orange-addons-for-elementor'),
                    'h5' => esc_html__('H5', 'orange-addons-for-elementor'),
                    'h6' => esc_html__('H6', 'orange-addons-for-elementor')
                ],
                'default' => 'span',
            ]
        );

        $this->add_control(
            'show_icon',
            [
                'label' => esc_html__('Show Icon', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'orange-addons-for-elementor'),
                'label_off' => esc_html__('Hide', 'orange-addons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'icon_reverse',
            [
                'label' => esc_html__('Icon Reverse', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'orange-addons-for-elementor'),
                'label_off' => esc_html__('No', 'orange-addons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_responsive_control(
            'tab_gap',
            [
                'label' => esc_html__('Tab gap', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'rem', 'em'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 0,
                ],
                'selectors' => [
                    '{{WRAPPER}} .aoe-second-accordion .tab' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'accordion_border_type',
            [
                'label' => esc_html__('Border Type', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'solid',
                'options' => [
                    'none' => esc_html__('None', 'orange-addons-for-elementor'),
                    'solid' => esc_html__('Solid', 'orange-addons-for-elementor'),
                    'double' => esc_html__('Double', 'orange-addons-for-elementor'),
                    'dotted' => esc_html__('Dotted', 'orange-addons-for-elementor'),
                    'dashed' => esc_html__('Dashed', 'orange-addons-for-elementor'),
                    'groove' => esc_html__('Groove', 'orange-addons-for-elementor'),
                ],
                'selectors' => [
                    '{{WRAPPER}} .aoe-second-accordion .tab, {{WRAPPER}} .aoe-second-accordion.no-gap' => 'border-style: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'accordion_border_width',
            [
                'label' => esc_html__('Border Width', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em'],
                'default' => [
                    'top' => '2',
                    'right' => '2',
                    'bottom' => '2',
                    'left' => '2',
                    'unit' => 'px',
                    'isLinked' => true,
                ],
                'selectors' => [
                    '{{WRAPPER}} .aoe-second-accordion .tab, {{WRAPPER}} .aoe-second-accordion.no-gap' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'accordion_border_type!' => 'none',
                ],
            ]
        );

        $this->add_control(
            'accordion_border_color',
            [
                'label' => esc_html__('Border Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#227093',
                'selectors' => [
                    '{{WRAPPER}} .aoe-second-accordion .tab, {{WRAPPER}} .aoe-second-accordion.no-gap' => 'border-color: {{VALUE}}; background-color: {{VALUE}};',
                ],
                'condition' => [
                    'accordion_border_type!' => 'none',
                ],
            ]
        );

        $this->add_responsive_control(
            'accordion_width',
            [
                'label' => esc_html__('Accordion Width', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em', 'rem', 'vw'],
                'range' => [
                    'px' => [
                        'min' => 100,
                        'max' => 2000,
                        'step' => 10,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                    'vw' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 100,
                ],
                'selectors' => [
                    '{{WRAPPER}} .aoe-second-accordion' => 'width: {{SIZE}}{{UNIT}};',
                ],
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'accordion_alignment',
            [
                'label' => esc_html__('Accordion Alignment', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'orange-addons-for-elementor'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'orange-addons-for-elementor'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'orange-addons-for-elementor'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'center',
                'prefix_class' => 'aoe-accordion-align-',
                'selectors' => [
                    '{{WRAPPER}}.aoe-accordion-align-left .aoe-second-accordion' => 'margin-right: auto; margin-left: 0;',
                    '{{WRAPPER}}.aoe-accordion-align-center .aoe-second-accordion' => 'margin-left: auto; margin-right: auto;',
                    '{{WRAPPER}}.aoe-accordion-align-right .aoe-second-accordion' => 'margin-left: auto; margin-right: 0;',
                ],
            ]
        );

        $this->add_control(
            'border_radius',
            [
                'label' => esc_html__('Border Radius', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 7,
                ],
                'selectors' => [
                    '{{WRAPPER}} .aoe-second-accordion.no-gap' => 'border-radius: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .aoe-second-accordion .tab' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background',
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .tab__label',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'selector' => '{{WRAPPER}} .aoe-second-accordion.no-gap, {{WRAPPER}} .aoe-second-accordion:not(.no-gap) .tab',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'icon_style_section',
            [
                'label' => esc_html__('Icon Style', 'orange-addons-for-elementor'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs(
            'icon_style_tabs'
        );

        $this->start_controls_tab(
            'style_icon_normal_tab',
            [
                'label' => esc_html__('Normal', 'orange-addons-for-elementor'),
            ]
        );

        $this->add_control(
            'icon_normal_size',
            [
                'label' => esc_html__('Icon Size', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 20,
                ],
                'selectors' => [
                    '{{WRAPPER}} .accordion-icon svg' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'main_icon_normal_color',
            [
                'label' => esc_html__('Main Icon Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .accordion-icon svg' => 'fill: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'toggle_icon_size',
            [
                'label' => esc_html__('Toggle Icon Size', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', 'rem'],
                'range' => [
                    'px' => ['min' => 5, 'max' => 50],
                    'em' => ['min' => 0.5, 'max' => 5, 'step' => 0.1],
                    'rem' => ['min' => 0.5, 'max' => 5, 'step' => 0.1],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 16,
                ],
                'selectors' => [
                    '{{WRAPPER}} .tab__label .toggle-icon' => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .tab__label .toggle-icon svg' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'toggle_icon_normal_color',
            [
                'label' => esc_html__('Toggle Icon Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tab__label .toggle-icon .normal-icon' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .tab__label .toggle-icon .normal-icon svg' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'toggle_icon_normal',
            [
                'label' => esc_html__('Toggle Icon (Normal)', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-chevron-down',
                    'library' => 'fa-solid',
                ],
                'recommended' => [
                    'fa-solid' => ['chevron-down', 'angle-down', 'arrow-down', 'caret-down', 'plus'],
                ],
                'separator' => 'before',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'style_icon_hover_tab',
            [
                'label' => esc_html__('Hover', 'orange-addons-for-elementor'),
            ]
        );

        $this->add_control(
            'icon_hover_size',
            [
                'label' => esc_html__('Icon Size', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 20,
                ],
                'selectors' => [
                    '{{WRAPPER}} .tab__label:hover .accordion-icon svg' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'main_icon_hover_color',
            [
                'label' => esc_html__('Main Icon Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tab__label:hover .accordion-icon svg' => 'fill: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'toggle_icon_hover_color',
            [
                'label' => esc_html__('Toggle Icon Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tab__label:hover .toggle-icon' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .tab__label:hover .toggle-icon svg' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'toggle_icon_hover_animation',
            [
                'label' => esc_html__('Enable Hover Animation', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'orange-addons-for-elementor'),
                'label_off' => esc_html__('No', 'orange-addons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'yes',
                'prefix_class' => 'oea-toggle-icon-hover-anim-',
                'separator' => 'before',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'style_icon_active_tab',
            [
                'label' => esc_html__('Active', 'orange-addons-for-elementor'),
            ]
        );

        $this->add_control(
            'icon_active_size',
            [
                'label' => esc_html__('Icon Size', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 20,
                ],
                'selectors' => [
                    '{{WRAPPER}} input:checked + .tab__label .accordion-icon svg' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'main_icon_active_color',
            [
                'label' => esc_html__('Main Icon Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} input:checked  + .tab__label .accordion-icon svg' => 'fill: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'toggle_icon_active_color',
            [
                'label' => esc_html__('Toggle Icon Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} input:checked + .tab__label .toggle-icon .active-icon' => 'color: {{VALUE}};',
                    '{{WRAPPER}} input:checked + .tab__label .toggle-icon .active-icon svg' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'toggle_icon_active',
            [
                'label' => esc_html__('Toggle Icon (Active)', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-chevron-up',
                    'library' => 'fa-solid',
                ],
                'recommended' => [
                    'fa-solid' => ['chevron-up', 'angle-up', 'arrow-up', 'caret-up', 'minus'],
                ],
                'separator' => 'before',
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();


        $this->end_controls_section();

        $this->start_controls_section(
            'title_style_section',
            [
                'label' => esc_html__('Title Style', 'orange-addons-for-elementor'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs(
            'title_style_tabs'
        );

        $this->start_controls_tab(
            'style_title_normal_tab',
            [
                'label' => esc_html__('Normal', 'orange-addons-for-elementor'),
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'title_normal_border',
                'selector' => '{{WRAPPER}} .aoe-second-accordion .tab__label',
            ]
        );

        $this->add_responsive_control(
            'title_normal_border_radius',
            [
                'label' => esc_html__('Border Radius', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'default' => [
                    'unit' => 'px',
                    'isLinked' => true,
                ],
                'selectors' => [
                    '{{WRAPPER}} .aoe-second-accordion .tab__label' => 'border-top-left-radius: {{TOP}}{{UNIT}}; border-bottom-left-radius: {{RIGHT}}{{UNIT}}; border-top-right-radius: {{BOTTOM}}{{UNIT}}; border-bottom-right-radius: {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'title_normal_box_shadow',
                'selector' => '{{WRAPPER}} .aoe-second-accordion .tab__label',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'accordion_title_normal_typography',
                'selector' => '{{WRAPPER}} .aoe-second-accordion .tab__label',
            ]
        );

        $this->add_control(
            'title_normal_color',
            [
                'label' => esc_html__('Title Text Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .aoe-second-accordion .tab__label' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'title_normal_background',
                'types' => ['classic', 'gradient', 'video'],
                'selector' => '{{WRAPPER}} .aoe-second-accordion .tab__label',
            ]
        );

        $this->add_responsive_control(
            'title_normal_padding',
            [
                'label' => esc_html__('Title Padding', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'default' => [
                    'top' => 1,
                    'right' => 1,
                    'bottom' => 1,
                    'left' => 1,
                    'unit' => 'rem',
                    'isLinked' => true,
                ],
                'selectors' => [
                    '{{WRAPPER}} .aoe-second-accordion .tab__label' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'title_style_hover_tab',
            [
                'label' => esc_html__('Hover', 'orange-addons-for-elementor'),
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'title_hover_border',
                'selector' => '{{WRAPPER}} .aoe-second-accordion .tab__label:hover',
            ]
        );

        $this->add_responsive_control(
            'title_hover_border_radius',
            [
                'label' => esc_html__('Border Radius', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'default' => [
                    'unit' => 'px',
                    'isLinked' => true,
                ],
                'selectors' => [
                    '{{WRAPPER}} .aoe-second-accordion .tab__label:hover' => 'border-top-left-radius: {{TOP}}{{UNIT}}; border-bottom-left-radius: {{RIGHT}}{{UNIT}}; border-top-right-radius: {{BOTTOM}}{{UNIT}}; border-bottom-right-radius: {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'title_hover_box_shadow',
                'selector' => '{{WRAPPER}} .aoe-second-accordion .tab__label:hover',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'accordion_title_hover_typography',
                'selector' => '{{WRAPPER}} .aoe-second-accordion .tab__label:hover',
            ]
        );

        $this->add_control(
            'title_hover_color',
            [
                'label' => esc_html__('Title Text Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .aoe-second-accordion .tab__label:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'title_hover_background',
                'types' => ['classic', 'gradient', 'video'],
                'selector' => '{{WRAPPER}} .aoe-second-accordion .tab__label:hover',
            ]
        );

        $this->add_responsive_control(
            'title_hover_padding',
            [
                'label' => esc_html__('Title Padding', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'default' => [
                    'top' => 1,
                    'right' => 1,
                    'bottom' => 1,
                    'left' => 1,
                    'unit' => 'rem',
                    'isLinked' => true,
                ],
                'selectors' => [
                    '{{WRAPPER}} .aoe-second-accordion .tab__label:hover' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'style_active_tab',
            [
                'label' => esc_html__('Active', 'orange-addons-for-elementor'),
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'title_active_border',
                'selector' => '{{WRAPPER}} input:checked + .tab__label',
            ]
        );

        $this->add_responsive_control(
            'title_active_border_radius',
            [
                'label' => esc_html__('Border Radius', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'default' => [
                    'unit' => 'px',
                    'isLinked' => true,
                ],
                'selectors' => [
                    '{{WRAPPER}} input:checked + .tab__label' => 'border-top-left-radius: {{TOP}}{{UNIT}}; border-bottom-left-radius: {{RIGHT}}{{UNIT}}; border-top-right-radius: {{BOTTOM}}{{UNIT}}; border-bottom-right-radius: {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'title_active_box_shadow',
                'selector' => '{{WRAPPER}} input:checked + .tab__label',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'accordion_title_active_typography',
                'selector' => '{{WRAPPER}} input:checked + .tab__label',
            ]
        );

        $this->add_control(
            'title_active_color',
            [
                'label' => esc_html__('Title Text Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} input:checked + .tab__label' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'title_active_background',
                'types' => ['classic', 'gradient', 'video'],
                'selector' => '{{WRAPPER}} input:checked + .tab__label',
            ]
        );

        $this->add_responsive_control(
            'title_active_padding',
            [
                'label' => esc_html__('Title Padding', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'default' => [
                    'top' => 1,
                    'right' => 1,
                    'bottom' => 1,
                    'left' => 1,
                    'unit' => 'rem',
                    'isLinked' => true,
                ],
                'selectors' => [
                    '{{WRAPPER}} input:checked + .tab__label' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_control(
            'hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );

        $this->add_control(
            'title_transition',
            [
                'label' => esc_html__('Transition', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 0.3,
                'min' => 0,
                'max' => 5,
                'step' => 0.1,
                'selectors' => [
                    '{{WRAPPER}} .aoe-second-accordion .tab__label' => 'transition: all {{VALUE}}s ease-in-out;',
                    '{{WRAPPER}} .aoe-second-accordion .tab__label span svg' => 'transition: all {{VALUE}}s ease-in-out;'
                ]
            ]
        );

        $this->add_responsive_control(
            'title_left_distance',
            [
                'label' => esc_html__('Title Left Distance', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 10,
                ],
                'selectors' => [
                    '{{WRAPPER}} .aoe-second-accordion .tab__label .label-title' => 'margin-left: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'title_right_distance',
            [
                'label' => esc_html__('Title Right Distance', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 10,
                ],
                'selectors' => [
                    '{{WRAPPER}} .aoe-second-accordion .tab__label .label-title' => 'margin-right: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'content_style_section',
            [
                'label' => esc_html__('Content Style', 'orange-addons-for-elementor'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'content_normal_border',
                'selector' => '{{WRAPPER}} .aoe-second-accordion .tab__content',
            ]
        );

        $this->add_responsive_control(
            'content_normal_border_radius',
            [
                'label' => esc_html__('Border Radius', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'default' => [
                    'unit' => 'px',
                    'isLinked' => true,
                ],
                'selectors' => [
                    '{{WRAPPER}} .aoe-second-accordion .tab__content' => 'border-top-left-radius: {{TOP}}{{UNIT}}; border-bottom-left-radius: {{RIGHT}}{{UNIT}}; border-top-right-radius: {{BOTTOM}}{{UNIT}}; border-bottom-right-radius: {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'content_normal_box_shadow',
                'selector' => '{{WRAPPER}} .aoe-second-accordion input:checked ~ .tab__content',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'accordion_content_normal_typography',
                'selector' => '{{WRAPPER}} .aoe-second-accordion input:checked ~ .tab__content',
            ]
        );

        $this->add_control(
            'content_normal_color',
            [
                'label' => esc_html__('Content Text Color', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .aoe-second-accordion input:checked ~ .tab__content' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'content_normal_background',
                'types' => ['classic', 'gradient', 'video'],
                'selector' => '{{WRAPPER}} .aoe-second-accordion .tab__content',
                'fields_options' => [
                    'background' => [
                        'default' => 'classic',
                    ],
                    'color' => [
                        'default' => '#ffffff',
                    ],
                ],
            ]
        );

        $this->add_responsive_control(
            'content_normal_padding',
            [
                'label' => esc_html__('Content Padding', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1
                    ],
                    'em' => [
                        'min' => 0,
                        'max' => 10,
                        'step' => 0.1
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 10,
                        'step' => 0.1
                    ]
                ],
                'default' => [
                    'top' => 1,
                    'right' => 1,
                    'bottom' => 1,
                    'left' => 1,
                    'unit' => 'rem',
                    'isLinked' => true,
                ],
                'selectors' => [
                    '{{WRAPPER}} .aoe-second-accordion .tab__content .tab__content-inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );

        $this->add_control(
            'content_transition',
            [
                'label' => esc_html__('Transition', 'orange-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 0.3,
                'min' => 0,
                'max' => 5,
                'step' => 0.1,
                'selectors' => [
                    '{{WRAPPER}} .aoe-second-accordion' => '--oea-transition-speed: {{VALUE}};'
                ]
            ]
        );

        $this->end_controls_section();


    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $active_tab = $settings['active_tab'];
        $auto_collapse = $settings['auto_collapse'] === 'yes' ? 'radio' : 'checkbox';
        $icon_reverse_class = $settings['icon_reverse'] === 'yes' ? 'icon-reverse' : '';
        $uniqueName = uniqid();

        ?>

        <section class="aoe-second-accordion <?php echo esc_attr($icon_reverse_class); ?>">
            <?php if ($settings['accordion_list']) {
                foreach ($settings['accordion_list'] as $index => $item) {
                    $isActive = ($index + 1 == $active_tab) ? 'checked' : '';
                    ?>
                    <div class="tab">
                        <input type="<?php echo esc_attr($auto_collapse); ?>" name="accordion-<?php echo esc_attr($uniqueName); ?>"
                            id="cb-<?php echo esc_attr($uniqueName); ?>-<?php echo esc_attr($index); ?>" <?php echo esc_attr($isActive); ?>>
                        <label for="cb-<?php echo esc_attr($uniqueName); ?>-<?php echo esc_attr($index); ?>" class="tab__label">
                            <?php if ($settings['show_icon'] === "yes"): ?>
                                <span class="accordion-icon">
                                    <?php \Elementor\Icons_Manager::render_icon($item['item_icon'], ['aria-hidden' => 'true']); ?></span>
                            <?php endif; ?>
                            <<?php echo esc_attr($settings['title_html_tag']); ?> class="label-title">
                                <?php echo esc_attr($item['item_title']); ?>
                            </<?php echo esc_attr($settings['title_html_tag']); ?>>
                            <span class="toggle-icon">
                                <span
                                    class="normal-icon"><?php \Elementor\Icons_Manager::render_icon($settings['toggle_icon_normal'], ['aria-hidden' => 'true']); ?></span>
                                <span
                                    class="active-icon"><?php \Elementor\Icons_Manager::render_icon($settings['toggle_icon_active'], ['aria-hidden' => 'true']); ?></span>
                            </span>
                        </label>
                        <div class="tab__content">
                            <div class="tab__content-inner"><?php echo wp_kses_post($item['item_content']); ?></div>
                        </div>
                    </div>
                <?php }
            } ?>
        </section>
        <?php

    }

}