<?php

if ( !defined( 'ABSPATH' ) ) {
    exit;
    // Exit if accessed directly
}
$background_image = get_the_post_thumbnail_url( get_the_ID(), $args['image_size'] );
$category = get_the_category();
$categories_count = ( !empty( $args['categories_count'] ) ? $args['categories_count'] : 1 );
$categories_to_display = [];
if ( !empty( $category ) ) {
    $limit = min( $categories_count, count( $category ) );
    for ($i = 0; $i < $limit; $i++) {
        $categories_to_display[] = $category[$i];
    }
}
$post_elements_order = ( !empty( $args['post_elements_order'] ) ? $args['post_elements_order'] : [] );
$post_link = get_permalink();
$link_target = ( $args['open_in_new_tab'] === 'yes' ? 'target="_blank"' : '' );
$loading_attr = '';
if ( isset( $args['lazy_loading'] ) ) {
}
?>

<div class="oea-post-grid-list">
    <div class="post">
        <?php 
if ( $args['show_image'] === 'yes' ) {
    ?>
            <div class="post-image-wrapper">
                <?php 
    if ( !empty( $categories_to_display ) && $args['category_position'] === 'top' ) {
        ?>
                    <div class="post-categories cat-top">
                        <?php 
        foreach ( $categories_to_display as $cat ) {
            ?>
                            <span class="post-category"><?php 
            echo esc_html( $cat->name );
            ?></span>
                        <?php 
        }
        ?>
                    </div>
                <?php 
    }
    ?>
                <a href="<?php 
    echo esc_url( $post_link );
    ?>" <?php 
    echo wp_kses_post( $link_target );
    ?>>
                    <img src="<?php 
    echo esc_url( $background_image );
    ?>" alt="<?php 
    the_title_attribute();
    ?>"
                        class="post-image" <?php 
    echo wp_kses_post( $loading_attr );
    ?>>
                    <div class="post-image-overlay"></div>
                </a>
            </div>
        <?php 
}
?>

        <div class="post-content">
            <?php 
foreach ( $post_elements_order as $element ) {
    ?>
                <?php 
    $responsive_classes = '';
    if ( !empty( $element['hide_on_devices'] ) ) {
        foreach ( $element['hide_on_devices'] as $device ) {
            $responsive_classes .= ' hide-on-' . esc_attr( $device );
        }
    }
    ?>

                <?php 
    if ( $element['element_type'] === 'category' && $args['category_position'] === 'bottom' ) {
        ?>
                    <?php 
        if ( !empty( $categories_to_display ) ) {
            ?>
                        <div class="post-categories<?php 
            echo esc_attr( $responsive_classes );
            ?>">
                            <?php 
            foreach ( $categories_to_display as $cat ) {
                ?>
                                <span class="post-category"><?php 
                echo esc_html( $cat->name );
                ?></span>
                            <?php 
            }
            ?>
                        </div>
                    <?php 
        }
        ?>
                <?php 
    } elseif ( $element['element_type'] === 'title' ) {
        ?>
                    <<?php 
        echo esc_attr( $element['title_tag'] );
        ?>
                        class="post-title<?php 
        echo esc_attr( $responsive_classes );
        ?>">
                        <a href="<?php 
        echo esc_url( $post_link );
        ?>" <?php 
        echo wp_kses_post( $link_target );
        ?>><?php 
        the_title();
        ?></a>
                    </<?php 
        echo esc_attr( $element['title_tag'] );
        ?>>
                <?php 
    } elseif ( $element['element_type'] === 'author' ) {
        ?>
                    <span class="post-meta post-author<?php 
        echo esc_attr( $responsive_classes );
        ?>">
                        <?php 
        if ( !empty( $element['author_icon_enabled'] ) && $element['author_icon_enabled'] === 'yes' ) {
            echo get_avatar( get_the_author_meta( 'ID' ), 16 );
        }
        ?>
                        <?php 
        $text_before_author = esc_html( $element['text_before_author'] );
        $author_name = get_the_author();
        if ( !empty( $element['author_link_enabled'] ) && $element['author_link_enabled'] === 'yes' ) {
            echo sprintf(
                '<span>%s</span> <a href="%s" %s><span>%s</span></a>',
                esc_html( $text_before_author ),
                esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),
                wp_kses_post( $link_target ),
                esc_html( $author_name )
            );
        } else {
            echo sprintf( '<span>%s%s</span>', esc_html( $text_before_author ), esc_html( $author_name ) );
        }
        ?>
                    </span>
                <?php 
    } elseif ( $element['element_type'] === 'date' ) {
        ?>
                    <span
                        class="post-meta post-date<?php 
        echo esc_attr( $responsive_classes );
        ?>"><span><?php 
        echo get_the_date();
        ?></span></span>
                <?php 
    } elseif ( $element['element_type'] === 'comments' ) {
        ?>
                    <span
                        class="post-meta post-comments<?php 
        echo esc_attr( $responsive_classes );
        ?>"><span><?php 
        comments_number();
        ?></span></span>
                <?php 
    } elseif ( $element['element_type'] === 'excerpt' ) {
        ?>
                    <span class="post-excerpt<?php 
        echo esc_attr( $responsive_classes );
        ?>"><?php 
        the_excerpt();
        ?></span>
                <?php 
    } elseif ( $element['element_type'] === 'read_more' ) {
        ?>
                    <a href="<?php 
        echo esc_url( $post_link );
        ?>" class="read-more<?php 
        echo esc_attr( $responsive_classes );
        ?>"
                        <?php 
        echo ( $args['open_in_new_tab'] ? 'target="_blank"' : '' );
        ?>>
                        <?php 
        echo ( !empty( $element['read_more_text'] ) ? esc_html( $element['read_more_text'] ) : esc_html__( 'Read more', 'orange-addons-for-elementor' ) );
        ?>
                    </a>
                <?php 
    }
    ?>
            <?php 
}
?>
        </div>
    </div>
</div>