<?php

if ( !defined( 'ABSPATH' ) ) {
    exit;
    // Exit if accessed directly.
}
class Oradel_Plugin_Helper {
    const BASE_UPGRADE_URL = 'https://orange-addons.com/';

    const WIDGET_REF_MAP = [
        'pros-cons'        => 'pros-cons',
        'verdict'          => 'verdict',
        'comparison-table' => 'comparison-table',
        'benefits'         => 'benefits',
        'button'           => 'button',
        'accordion'        => 'accordion',
        'advanced-heading' => 'advanced-heading',
        'hero-block'       => 'hero-block',
        'icon-menu'        => 'icon-menu',
        'iconbox'          => 'iconbox',
        'image-accordion'  => 'image-accordion',
        'offer-listing'    => 'offer-listing',
        'posts-grid'       => 'posts-grid',
        'pricing-plans'    => 'pricing-plans',
        'testimonials'     => 'testimonials',
    ];

    public static function get_upgrade_url( $widget_name = '' ) {
        $ref = ( !empty( $widget_name ) ? "?ref=oradel-widget-{$widget_name}#pricing-plans" : '#pricing-plans' );
        return self::BASE_UPGRADE_URL . $ref;
    }

    public static function get_widget_upgrade_url( $widget_key ) {
        $widget_name = ( isset( self::WIDGET_REF_MAP[$widget_key] ) ? self::WIDGET_REF_MAP[$widget_key] : $widget_key );
        return self::get_upgrade_url( $widget_name );
    }

    public static function is_premium() {
        return (bool) apply_filters( 'oradel_plugin/premium/is_available', false );
    }

    public static function create_premium_notice( $message, $widget_key, $alert_type = 'info' ) {
        $alert_classes = [
            'info'    => 'elementor-panel-alert elementor-panel-alert-info',
            'warning' => 'elementor-panel-alert elementor-panel-alert-warning',
            'error'   => 'elementor-panel-alert elementor-panel-alert-danger',
        ];
        return [
            'type'            => \Elementor\Controls_Manager::RAW_HTML,
            'raw'             => sprintf( $message, self::get_widget_upgrade_url( $widget_key ) ),
            'content_classes' => $alert_classes[$alert_type] ?? $alert_classes['info'],
        ];
    }

    private static function register_switcher_control(
        $feature_name,
        $label,
        $label_on,
        $label_off,
        $default = 'no',
        $condition = []
    ) {
        $config = [
            'label'        => $label,
            'type'         => \Elementor\Controls_Manager::SWITCHER,
            'label_on'     => $label_on,
            'label_off'    => $label_off,
            'return_value' => 'yes',
            'default'      => $default,
        ];
        if ( !empty( $condition ) ) {
            $config['condition'] = $condition;
        }
        add_filter( "oradel_{$feature_name}_control_config", function ( $existing_config ) use($config) {
            return $config;
        } );
        add_filter( "oradel_{$feature_name}_premium_notice", function ( $notice ) {
            return null;
        } );
        add_filter(
            "oradel_enable_{$feature_name}_render",
            function ( $default, $user_setting, $settings ) {
                return $user_setting;
            },
            10,
            3
        );
    }

    private static function register_options_filter( $feature_name, $options, $merge = true ) {
        add_filter( "oradel_{$feature_name}_options", function ( $existing_options ) use($options, $merge) {
            return ( $merge ? array_merge( $existing_options, $options ) : $options );
        } );
        add_filter( "oradel_{$feature_name}_premium_notice", function ( $notice ) {
            return null;
        } );
    }

    private static function register_clean_options_filter( $feature_name, $num_params = 3 ) {
        add_filter( "oradel_{$feature_name}_options", function ( $options ) {
            $clean_options = [];
            foreach ( $options as $key => $label ) {
                $clean_options[$key] = str_replace( ' (Premium)', '', $label );
            }
            return $clean_options;
        } );
        add_filter( "oradel_{$feature_name}_premium_notice", function ( $notice ) {
            return null;
        } );
        add_filter(
            "oradel_enable_{$feature_name}_render",
            function ( $default, $user_setting ) {
                return $user_setting;
            },
            10,
            $num_params
        );
    }

    private static function register_render_filter( $feature_name, $num_params = 3, $param_name = 'user_setting' ) {
        add_filter(
            "oradel_enable_{$feature_name}_render",
            function ( $default, $value ) use($param_name) {
                return $value;
            },
            10,
            $num_params
        );
    }

    public static function register_premium_features() {
    }

}
