(function ($) {

    window.initMobileCardsScrollAnimation = function () {
        const VIEWPORT_MARGIN_RATIO = 0.35;
        const CENTER_THRESHOLD_RATIO = 0.2;
        const isMobile = window.innerWidth <= 768;
        const THROTTLE_DELAY = isMobile ? 150 : 50;

        const $window = $(window);
        const postGridCards = $('.oea-post-grid-cards .post');

        if (!postGridCards.length || !isMobile) return;

        function showPostContent($postCard) {
            const $postContent = $postCard.find('.post-content');
            $postCard.addClass('content-visible');
            $postContent.css({
                'opacity': '1',
                'transform': 'translateY(0)',
                'visibility': 'visible'
            });
        }

        function hidePostContent($postCard) {
            const $postContent = $postCard.find('.post-content');
            $postCard.removeClass('content-visible');
            $postContent.css({
                'opacity': '0',
                'transform': 'translateY(20px)',
                'visibility': 'hidden'
            });
        }

        function checkElementsVisibility() {
            const windowHeight = $window.height();
            const scrollTop = $window.scrollTop();
            const windowCenter = scrollTop + (windowHeight / 2);
            const centerThreshold = windowHeight * CENTER_THRESHOLD_RATIO;

            postGridCards.each(function () {
                const $postCard = $(this);
                const elementTop = $postCard.offset().top;
                const elementHeight = $postCard.outerHeight();
                const elementCenter = elementTop + (elementHeight / 2);
                const isInCenter = Math.abs(windowCenter - elementCenter) < centerThreshold;

                if (isInCenter && !$postCard.hasClass('content-visible')) {
                    showPostContent($postCard);
                } else if (!isInCenter && $postCard.hasClass('content-visible')) {
                    hidePostContent($postCard);
                }
            });
        }

        postGridCards.each(function () {
            const $postCard = $(this);
            hidePostContent($postCard);

            const $postContent = $postCard.find('.post-content');
            $postContent.css({
                'transition': 'all 0.3s ease-in-out',
                'opacity': '0',
                'transform': 'translateY(20px)',
                'visibility': 'hidden'
            });
        });

        if ('IntersectionObserver' in window) {
            const viewportHeight = window.innerHeight;
            const centerMargin = Math.floor(viewportHeight * VIEWPORT_MARGIN_RATIO);
            const rootMargin = `-${centerMargin}px 0px -${centerMargin}px 0px`;

            const observerOptions = {
                root: null,
                rootMargin: rootMargin,
                threshold: [0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1]
            };

            if (window.mobileCardsObserver) {
                window.mobileCardsObserver.disconnect();
            }

            window.mobileCardsObserver = new IntersectionObserver(function (entries) {
                entries.forEach(function (entry) {
                    const $postCard = $(entry.target);
                    if (entry.isIntersecting) {
                        showPostContent($postCard);
                    } else {
                        hidePostContent($postCard);
                    }
                });
            }, observerOptions);

            postGridCards.each(function () {
                window.mobileCardsObserver.observe(this);
            });

        } else {
            checkElementsVisibility();
            $window.off('scroll.mobileCards');
            $window.on('scroll.mobileCards', throttle(checkElementsVisibility, THROTTLE_DELAY));
        }
    };

    $(document).ready(function () {
        const ANIMATION_CLASSES = '[class*="oea-fade-"], [class*="oea-zoom-"], [class*="oea-bounce-"], [class*="oea-flip-"], [class*="oea-rotate-"]';
        const VIEWPORT_MARGIN_RATIO = 0.35;
        const CENTER_THRESHOLD_RATIO = 0.2;
        const isMobile = window.innerWidth <= 767;
        const THROTTLE_DELAY = isMobile ? 150 : 50;

        const $window = $(window);
        const $document = $(document);
        const animatedElements = $('.oea-animate-on-scroll');

        if (!animatedElements.length) {
            window.initMobileCardsScrollAnimation();
            return;
        }

        function showAnimatedElements($element) {
            if ($element.hasClass('oea-is-animated')) {
                return;
            }

            if ($element.hasClass('oea-offer-listing')) {
                const animationDelay = parseFloat($element.data('animation-delay')) || 0.2;
                const $items = $element.find('.item-animation-wrapper');
                $items.each(function (index) {
                    const $item = $(this);
                    const itemIndex = parseInt($item.data('index')) || index;
                    const delay = itemIndex * animationDelay;
                    $item.css({ 'visibility': 'visible', 'animation-play-state': 'running', 'animation-delay': delay + 's' });
                });
            }

            if ($element.hasClass('menu-container')) {
                const isMobile = window.innerWidth <= 767;
                const disableMobileAnimation = $element.hasClass('oea-disable-load-animation-mobile');

                if (isMobile && disableMobileAnimation) {
                    $element.find('.menu-item').css({ 'visibility': 'visible', 'opacity': '1', 'transform': 'none' });
                } else {
                    const isV2 = $element.hasClass('v2-css-driven');
                    let $itemsToAnimate;

                    if (isV2) {
                        const width = window.innerWidth;
                        let deviceClass = 'desktop';
                        if (width <= 767) deviceClass = 'mobile';
                        else if (width <= 1024) deviceClass = 'tablet';
                        $itemsToAnimate = $element.find(`.slide-${deviceClass}[data-slide="0"] .menu-item`);
                    } else {
                        $itemsToAnimate = $element.find('.slide:first-child .menu-item');
                    }

                    $itemsToAnimate.each(function () {
                        const $item = $(this);
                        requestAnimationFrame(function () {
                            $item.css({ 'visibility': 'visible', 'animation-play-state': 'running' });
                        });
                    });
                }
            }

            if ($element.hasClass('benefit-grid')) {
                $element.find('.benefit-card').css({ 'visibility': 'visible', 'animation-play-state': 'running' });
            }

            const $generalAnimatedElements = $element.find(ANIMATION_CLASSES);
            if ($generalAnimatedElements.length > 0) {
                $generalAnimatedElements.css({ 'visibility': 'visible', 'animation-play-state': 'running' });
            }

            $element.addClass('oea-is-animated');
        }

        function hideAnimatedElements($element) {
            if ($element.hasClass('oea-is-animated')) {
                return;
            }

            if ($element.hasClass('oea-offer-listing')) {
                $element.find('.item-animation-wrapper').css({
                    'visibility': 'hidden',
                    'animation-play-state': 'paused'
                });
            }

            if ($element.hasClass('menu-container')) {
                const isMobile = window.innerWidth <= 767;
                const disableMobileAnimation = $element.hasClass('oea-disable-load-animation-mobile');

                if (isMobile && disableMobileAnimation) {
                    $element.find('.menu-item').css({
                        'visibility': 'visible',
                        'opacity': '1',
                        'transform': 'none'
                    });
                } else {
                    $element.find('.menu-item').css({
                        'visibility': 'hidden',
                        'animation-play-state': 'paused'
                    });
                }
            }

            if ($element.hasClass('benefit-grid')) {
                $element.find('.benefit-card').css({
                    'visibility': 'hidden',
                    'animation-play-state': 'paused'
                });
            }

            $element.find(ANIMATION_CLASSES).css({
                'visibility': 'hidden',
                'animation-play-state': 'paused'
            });
        }

        let lastAnimationCall = 0;

        function checkElementsVisibility() {
            const now = Date.now();
            if (now - lastAnimationCall < 200) {
                return;
            }

            const windowHeight = $window.height();
            const scrollTop = $window.scrollTop();
            const windowCenter = scrollTop + (windowHeight / 2);
            const centerThreshold = windowHeight * CENTER_THRESHOLD_RATIO;

            animatedElements.each(function () {
                const $element = $(this);

                if ($element.hasClass('oea-is-animated')) {
                    return;
                }

                const elementTop = $element.offset().top;
                const elementHeight = $element.outerHeight();
                const elementCenter = elementTop + (elementHeight / 2);
                const isInCenter = Math.abs(windowCenter - elementCenter) < centerThreshold;

                if (isInCenter) {
                    showAnimatedElements($element);
                    lastAnimationCall = now;
                    $element.removeClass('oea-animate-on-scroll');
                }
            });
        }

        if ('IntersectionObserver' in window) {
            const viewportHeight = window.innerHeight;
            const centerMargin = Math.floor(viewportHeight * VIEWPORT_MARGIN_RATIO);
            const rootMargin = `-${centerMargin}px 0px -${centerMargin}px 0px`;

            const observerOptions = {
                root: null,
                rootMargin: rootMargin,
                threshold: [0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1]
            };

            const observer = new IntersectionObserver(function (entries) {
                entries.forEach(function (entry) {
                    if (entry.isIntersecting) {
                        const $element = $(entry.target);

                        if ($element.hasClass('oea-is-animated')) {
                            observer.unobserve(entry.target);
                            return;
                        }

                        showAnimatedElements($element);
                        observer.unobserve(entry.target);
                    }
                });
            }, observerOptions);

            animatedElements.each(function () {
                const $element = $(this);

                if ($element.hasClass('oea-is-animated')) {
                    return;
                }

                const isMobile = window.innerWidth <= 767;
                const isMenuContainer = $element.hasClass('menu-container');
                const disableMobileAnimation = $element.hasClass('oea-disable-load-animation-mobile');

                if (isMobile && isMenuContainer && disableMobileAnimation) {
                    $element.find('.menu-item').css({
                        'visibility': 'visible',
                        'opacity': '1',
                        'transform': 'none'
                    });
                    $element.removeClass('oea-animate-on-scroll');
                    $element.addClass('oea-is-animated');
                } else {
                    hideAnimatedElements($element);
                    observer.observe(this);
                }
            });

        } else {
            checkElementsVisibility();
            $window.on('scroll', throttle(checkElementsVisibility, THROTTLE_DELAY));
        }

        window.initMobileCardsScrollAnimation();
    });
})(jQuery);