(function ($) {
    $(document).ready(function () {

        const $pricingGrid = $('.pricing-grid');
        const $toggleContainer = $('.toggle-container');
        const $toggleBtns = $('.toggle-btn');
        const $priceCards = $('.price-card');

        const defaultPeriod = $pricingGrid.data('default-period');

        function setActivePeriod(period) {
            $toggleBtns.removeClass('active')
                .filter(`[data-period="${period}"]`)
                .addClass('active');

            $toggleContainer.toggleClass('active-lifetime', period === 'lifetime');

            $priceCards.each(function () {
                const $card = $(this);
                const $price = $card.find('.price');
                const $button = $card.find('.price-button');

                const priceData = $price.data(period);
                if (priceData) {
                    $price.text(priceData);
                }

                const buttonUrl = $button.data(period + '-url');
                if (buttonUrl) {
                    $button.attr('href', buttonUrl);
                }

                const buttonTarget = $button.data(period + '-target');
                if (buttonTarget) {
                    $button.attr('target', buttonTarget);
                } else {
                    $button.removeAttr('target');
                }

                const buttonRel = $button.data(period + '-rel');
                if (buttonRel) {
                    $button.attr('rel', buttonRel);
                } else {
                    $button.removeAttr('rel');
                }
            });
        }

        if (defaultPeriod) {
            setActivePeriod(defaultPeriod);
        }

        $toggleContainer.on('click', '.toggle-btn', function (e) {
            e.preventDefault();
            const period = $(this).data('period');
            if (period) {
                setActivePeriod(period);
            }
        });
    });
})(jQuery);