(function ($) {
    $(document).ready(function () {
        function handleHoverInteraction(e) {
            const $accordion = $(e.target).closest('.oea-image-accordion-hover-interaction');
            if (!$accordion.length) return;
            const $item = $(e.target).closest('.item');
            const $allItems = $accordion.find('.item');
            const $defaultActiveItem = $allItems.eq($accordion.data('active-image') - 1);

            if (e.type === 'mouseenter' && $item.length) {
                $allItems.find('h2, p').css({
                    'opacity': '0',
                    'transition': 'opacity 0.3s ease'
                });
                let activeBackgroundColor = null;
                const $activeItem = $allItems.filter('.animation');
                if ($activeItem.length) {
                    activeBackgroundColor = window.getComputedStyle($activeItem[0]).getPropertyValue('background-color');
                }
                $allItems.removeClass('animation');
                if (activeBackgroundColor) {
                    $item.css('background-color', activeBackgroundColor);
                    setTimeout(() => {
                        $item.css('background-color', '');
                    }, 50);
                }
                $item.addClass('animation');
                $item.find('h2').css({
                    'opacity': '1',
                    'transition': 'all var(--title-animation-duration) ease var(--grow-transition)'
                });
                $item.find('p').css({
                    'opacity': '1',
                    'transition': 'all var(--description-animation-duration) ease var(--grow-transition)'
                });
            } else if (e.type === 'mouseleave' && $accordion.length) {
                $allItems.removeClass('animation');
                $allItems.find('h2, p').css({
                    'opacity': '0',
                    'transition': 'opacity 0.3s ease'
                });
                $defaultActiveItem.addClass('animation');
                $defaultActiveItem.find('h2').css({
                    'opacity': '1',
                    'transition': 'all var(--title-animation-duration) ease var(--grow-transition)'
                });
                $defaultActiveItem.find('p').css({
                    'opacity': '1',
                    'transition': 'all var(--description-animation-duration) ease var(--grow-transition)'
                });
            }
        }

        $(document).on('mouseenter', '.oea-image-accordion-hover-interaction .item', handleHoverInteraction);
        $(document).on('mouseleave', '.oea-image-accordion-hover-interaction', handleHoverInteraction);
    });
})(jQuery);