(function ($) {
    $(document).ready(function () {
        $(window).on('click touchend', function (e) {
            const $accordion = $(e.target).closest('.oea-image-accordion');
            if ($accordion.length && !$accordion.hasClass('oea-image-accordion-hover-interaction')) {
                imageAccordion(e);
            }
        });

        function imageAccordion(e) {
            const $item = $(e.target).closest('.oea-image-accordion .item');
            if (!$item.length) return;

            const $currentAccordion = $item.closest('.oea-image-accordion');

            if ($item.hasClass('animation')) {
                const $link = $item.find('a');
                if ($link.length) {
                    e.preventDefault();
                    const target = $link.attr('target') || '_self';
                    if (target === '_blank') {
                        window.open($link.attr('href'), '_blank');
                    } else {
                        window.location.href = $link.attr('href');
                    }
                }
            } else {
                e.preventDefault();
                const $allItems = $currentAccordion.find('.item');

                $allItems.removeClass('animation');

                $allItems.removeAttr('style');
                $allItems.find('h2, p').removeAttr('style');

                requestAnimationFrame(function () {
                    $item.addClass('animation');

                    setTimeout(function () {
                        if ($item.hasClass('animation')) {
                        }
                    }, 50);
                });
            }
        }
    });
})(jQuery);