jQuery(document).ready(function ($) {
    loadTabContent('general');

    $('.oea-tab-link').on('click', function (e) {
        e.preventDefault();
        $('.oea-tab-link').removeClass('active');
        $(this).addClass('active');
        var tab = $(this).data('tab');
        loadTabContent(tab);
    });

    function loadTabContent(tab) {
        $.ajax({
            url: oradelAjax.ajaxurl,
            type: 'POST',
            data: {
                action: 'oradel_load_tab_content',
                tab: tab,
                nonce: oradelAjax.nonce
            },
            beforeSend: function () {
                $('#oea-tab-content').html('<p>Loading...</p>');
            },
            success: function (response) {
                if (response.success) {
                    $('#oea-tab-content').html(response.data.html);
                    bindFormSubmit();
                } else {
                    $('#oea-tab-content').html('<p>Error loading content: ' + response.data + '</p>');
                }
            },
            error: function (xhr, status, error) {
                $('#oea-tab-content').html('<p>AJAX error: ' + error + '</p>');
            }
        });
    }

    function bindFormSubmit() {
        $('#oea-widgets-form').off('submit').on('submit', function (e) {
            e.preventDefault();

            var formData = $(this).serialize();
            var $button = $(this).find('#submit');

            $.ajax({
                url: oradelAjax.ajaxurl,
                type: 'POST',
                data: {
                    action: 'oradel_save_widgets_settings',
                    nonce: oradelAjax.nonce,
                    form_data: formData
                },
                beforeSend: function () {
                    $button
                        .prop('disabled', true)
                        .addClass('oea-saving')
                        .html('<span class="dashicons dashicons-update oea-spin"></span> Saving...');
                },
                success: function (response) {
                    if (response.success) {
                        $button
                            .removeClass('oea-saving')
                            .addClass('oea-saved')
                            .html('<span class="dashicons dashicons-yes"></span> Saved!');

                        setTimeout(function () {
                            $button
                                .removeClass('oea-saved')
                                .html('Save Changes')
                                .prop('disabled', false);
                        }, 2000);
                    } else {
                        $button
                            .removeClass('oea-saving')
                            .html('Error: ' + (response.data && response.data.message ? response.data.message : 'Unknown error'))
                            .prop('disabled', false);
                    }
                },
                error: function (xhr, status, error) {
                    $button
                        .removeClass('oea-saving')
                        .html('AJAX Error: ' + error)
                        .prop('disabled', false);
                }
            });
        });
    }
});