(function ($) {
    $(document).ready(function () {
        $('.aoe-second-accordion').each(function () {
            var $accordion = $(this);
            var $tabs = $accordion.find('.tab');
            var $inputs = $tabs.find('input[type="radio"], input[type="checkbox"]');
            var transitionSpeed = parseFloat($accordion.data('transition-speed') || $accordion.css('--oea-transition-speed')) || 0.35;

            $accordion[0].style.setProperty('--oea-transition-speed', transitionSpeed + 's');

            function setContentHeight($input) {
                var $contentWrapper = $input.siblings('.tab__content');
                var $contentInner = $contentWrapper.find('.tab__content-inner');

                if ($contentInner.length === 0) {
                    $contentInner = $contentWrapper;
                }

                if ($input.is(':checked')) {
                    if ($contentWrapper.css('display') === 'none') {
                        $contentWrapper.css('display', 'block');
                    }
                    $contentWrapper[0].offsetHeight;
                    var contentHeight = $contentInner[0].scrollHeight;
                    var borderTop = parseFloat($contentWrapper.css('borderTopWidth')) || 0;
                    var borderBottom = parseFloat($contentWrapper.css('borderBottomWidth')) || 0;
                    var finalHeight = contentHeight + borderTop + borderBottom;
                    finalHeight = finalHeight > 0 ? finalHeight : 'auto';

                    var currentMaxHeight = $contentWrapper.css('max-height');
                    var wasClosed = (currentMaxHeight === '0px' || !currentMaxHeight || currentMaxHeight === 'none');

                    if (wasClosed) {
                        requestAnimationFrame(() => {
                            $contentWrapper.css('max-height', finalHeight + (typeof finalHeight === 'number' ? 'px' : ''));
                        });
                    } else {
                        $contentWrapper.css('max-height', finalHeight + (typeof finalHeight === 'number' ? 'px' : ''));
                    }
                } else {
                    $contentWrapper.css('max-height', '0px');
                }
            }

            $tabs.find('.tab__content')
                .off('transitionend.aoeAccordion')
                .on('transitionend.aoeAccordion', function (event) {
                    if (event.target === this && event.originalEvent.propertyName === 'max-height') {
                        var $contentWrapper = $(this);
                        var currentMaxHeight = parseFloat($contentWrapper.css('max-height'));

                        if (currentMaxHeight <= 0.1) {
                            $contentWrapper.css('display', 'none');
                        }
                    }
                });

            $inputs.filter(':checked').each(function () {
                $(this).siblings('.tab__content').css('display', '');
                setContentHeight($(this));
            });

            $(window).on('load', function () {
                $accordion.find('input[type="radio"]:checked, input[type="checkbox"]:checked').each(function () {
                    const $input = $(this);
                    setContentHeight($input);
                });
            });

            $accordion.on('change', 'input[type="radio"], input[type="checkbox"]', function (event) {
                var $changedInput = $(event.target);
                var isRadio = $changedInput.attr('type') === 'radio';

                if (isRadio) {
                    $accordion.find('input[type="radio"][name="' + $changedInput.attr('name') + '"]').not($changedInput).each(function () {
                        $(this).siblings('.tab__content').css('max-height', '0px');
                    });
                }

                setContentHeight($changedInput);
            });

            if ($tabs.length > 0 && $tabs.first().css('marginBottom') === '0px') {
                $accordion.addClass('no-gap');
            }
        });
    });
})(jQuery);