<?php
/**
 * File Name: onid-saml-service-provider-setup.php
 * Description: This file has the frontend of the Service Provider Setup.
 *
 * @package onid-sso-by-saml-2-0/views
 */

/**
 * Service Provider Setup Tab
 *
 * @return void
 */
function onid_saml_apps_config_saml() {

//	const SP_ENTITY_ID = 'onid_saml_sp_entity_id';

	$onid_saml_sp_entity_id 						= get_option( Onid_Saml_Options_Enum_Service_Provider::SP_ENTITY_ID );
	$onid_saml_consumer_url                         = get_option( Onid_Saml_Options_Enum_Service_Provider::CONSUMER_URL );
	$onid_saml_identity_name                        = get_option( Onid_Saml_Options_Enum_Service_Provider::IDENTITY_NAME );
	$onid_saml_login_url                            = get_option( Onid_Saml_Options_Enum_Service_Provider::LOGIN_URL );
	$onid_saml_issuer                               = get_option( Onid_Saml_Options_Enum_Service_Provider::ISSUER );
	$onid_saml_x509_certificate                     = maybe_unserialize( get_option( Onid_Saml_Options_Enum_Service_Provider::X509_CERTIFICATE ) );
	$onid_saml_x509_certificate                     = ! is_array( $onid_saml_x509_certificate ) ? array( 0 => $onid_saml_x509_certificate ) : $onid_saml_x509_certificate;
	$onid_saml_identity_provider_identifier_name 	= ! empty( trim( get_option( Onid_Saml_Options_Enum_Service_Provider::IDENTITY_PROVIDER_NAME ) ) ) ? get_option( Onid_Saml_Options_Enum_Service_Provider::IDENTITY_PROVIDER_NAME ) : '';

	$saml_is_encoding_enabled     = get_option( Onid_Saml_Options_Enum_Service_Provider::IS_ENCODING_ENABLED ) !== false ? get_option( Onid_Saml_Options_Enum_Service_Provider::IS_ENCODING_ENABLED ) : 'checked';
	$saml_assertion_time_validity = get_option( 'onid_saml_assertion_time_validity' ) !== false ? get_option( 'onid_saml_assertion_time_validity' ) : 'checked';



	//////////////////////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////////////////////
	/////		ONID: no way, overwrite
	//////////////////////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////////////////////
	$onid_saml_sp_entity_id 									= Onid_Saml_Options_Enum_Service_Provider::SP_ENTITY_ID_DEFAULT;
	$onid_saml_issuer 											= Onid_Saml_Options_Enum_Service_Provider::ISSUER_DEFAULT;
	$onid_saml_login_url 										= Onid_Saml_Options_Enum_Service_Provider::LOGIN_URL_DEFAULT;
	$onid_saml_x509_certificate 								= Onid_Saml_Options_Enum_Service_Provider::X509_CERTIFICATE_DEFAULT;
	$onid_saml_x509_certificate                     			= ! is_array( $onid_saml_x509_certificate ) ? array( 0 => $onid_saml_x509_certificate ) : $onid_saml_x509_certificate;

	//////////////////////////////////////////////////////////////////////////////////////
	/////		ONID: overwrite ONLY IF empty
	//////////////////////////////////////////////////////////////////////////////////////
	if( empty($onid_saml_identity_provider_identifier_name )) 	{ $onid_saml_identity_provider_identifier_name = Onid_Saml_Options_Enum_Service_Provider::IDENTITY_PROVIDER_NAME_DEFAULT; }
	if( empty($saml_is_encoding_enabled)) 						{ $saml_is_encoding_enabled = Onid_Saml_Options_Enum_Service_Provider::IS_ENCODER_ENABLED_DEFAULT; };
	if( empty($saml_assertion_time_validity)) 					{ $saml_assertion_time_validity = Onid_Saml_Options_Enum_Service_Provider::ASSERTION_TIME_VALIDITY_DEFAULT; };


/*
	//////////////////////////////////////////////////////////////////////////////////////
	/////		ONID: reset to factory default
	//////////////////////////////////////////////////////////////////////////////////////

	$onid_saml_sp_entity_id 									= Onid_Saml_Options_Enum_Service_Provider::SP_ENTITY_ID_DEFAULT;
	$onid_saml_issuer 											= Onid_Saml_Options_Enum_Service_Provider::ISSUER_DEFAULT;
	$onid_saml_login_url 										= Onid_Saml_Options_Enum_Service_Provider::LOGIN_URL_DEFAULT;
	$onid_saml_x509_certificate 								= Onid_Saml_Options_Enum_Service_Provider::X509_CERTIFICATE_DEFAULT;
	$onid_saml_identity_provider_identifier_name 				= Onid_Saml_Options_Enum_Service_Provider::IDENTITY_PROVIDER_NAME_DEFAULT;
	$saml_is_encoding_enabled 									= Onid_Saml_Options_Enum_Service_Provider::IS_ENCODER_ENABLED_DEFAULT;
	$saml_assertion_time_validity 								= Onid_Saml_Options_Enum_Service_Provider::ASSERTION_TIME_VALIDITY_DEFAULT;
*/



	$onid_saml_login_url_base = $onid_saml_login_url;
	if(strpos($onid_saml_login_url_base, "?") !==false) {
		$onid_saml_login_url_base = substr($onid_saml_login_url_base, 0, strpos($onid_saml_login_url_base, "?"));
	};
	if( ( ! empty($onid_saml_consumer_url)) && (strpos($onid_saml_login_url, "?")==false)) { 
		$onid_saml_login_url .= "?consumerURL=".$onid_saml_consumer_url;
	};
	?>
	<div class="onid-saml-bootstrap-row onid-saml-bootstrap-container-fluid" id="cstm-idp-section">
		<div class="onid-saml-bootstrap-col-md-8 onid-saml-bootstrap-mt-4 onid-saml-bootstrap-ms-5">
			<?php
			onid_saml_display_idp_selector();
			onid_saml_display_sp_configuration( $onid_saml_sp_entity_id, $onid_saml_login_url_base, $onid_saml_consumer_url, $onid_saml_identity_name, $onid_saml_login_url, $onid_saml_issuer, $onid_saml_x509_certificate, $onid_saml_identity_provider_identifier_name, $saml_is_encoding_enabled, $saml_assertion_time_validity );
			?>

		</div>
	</div>
	<?php
}

/**
 * Select the IDP from dropdown
 *
 * @return void
 */
function onid_saml_display_idp_selector() {
	?>
	<?php
}

/**
 * Display the IDP terms
 *
 * @param string $onid_saml_identity_name Name of IDP.
 * @param string $onid_saml_login_url Login URL of IDP.
 * @param string $onid_saml_issuer SAML Issuer of IDP.
 * @param array  $onid_saml_x509_certificate x509 certificate of IDP.
 * @param string $onid_saml_identity_provider_identifier_name Name of IDP.
 * @param string $saml_is_encoding_enabled Character Encoding of IDP.
 * @param string $saml_assertion_time_validity Assertion Time Valadity Toggle.
 * @return void
 */
function onid_saml_display_sp_configuration( $onid_saml_sp_entity_id, $onid_saml_login_url_base, $onid_saml_consumer_url, $onid_saml_identity_name, $onid_saml_login_url, $onid_saml_issuer, $onid_saml_x509_certificate, $onid_saml_identity_provider_identifier_name, $saml_is_encoding_enabled, $saml_assertion_time_validity ) {
	?>
	<div class="onid-saml-bootstrap-p-4 shadow-cstm onid-saml-bootstrap-bg-white onid-saml-bootstrap-rounded onid-saml-bootstrap-mt-4" id="idp_scroll_saml">
<!--
		<div class="onid-saml-bootstrap-row onid-saml-bootstrap-align-items-center onid-saml-bootstrap-mt-5 onid-saml-bootstrap-mb-5" id="onid_saml_selected_idp_div" style="display: none;">
			<div class="onid-saml-bootstrap-col-md-4">
				<div class="onid-saml-bootstrap-text-center onid-saml-bootstrap-rounded onid-saml-bootstrap-w-50 shadow-cstm onid-saml-bootstrap-p-1" id="onid_saml_selected_idp_icon_div">
					<img width="55" src="" alt="" class="onid-saml-bootstrap-p-1">
				</div>
			</div>
			<div class="onid-saml-bootstrap-col-md-4">
				<a target="_blank" href="" id="saml_idp_guide_link" class="onid-saml-bootstrap-text-white onid-saml-bootstrap-px-4 onid-saml-bootstrap-py-2 onid-saml-bootstrap-rounded onid-saml-bootstrap-bg-info"><svg width="16" height="16" fill="currentColor" class="bi bi-wrench" viewBox="0 0 16 16">
						<path d="M.102 2.223A3.004 3.004 0 0 0 3.78 5.897l6.341 6.252A3.003 3.003 0 0 0 13 16a3 3 0 1 0-.851-5.878L5.897 3.781A3.004 3.004 0 0 0 2.223.1l2.141 2.142L4 4l-1.757.364L.102 2.223zm13.37 9.019.528.026.287.445.445.287.026.529L15 13l-.242.471-.026.529-.445.287-.287.445-.529.026L13 15l-.471-.242-.529-.026-.287-.445-.445-.287-.026-.529L11 13l.242-.471.026-.529.445-.287.287-.445.529-.026L13 11l.471.242z" />
					</svg> &nbsp;<?php esc_html_e( 'Setup Guide', 'onid-sso-by-saml-2-0' ); ?></a>
			</div>
			<div class="onid-saml-bootstrap-col-md-4">
				<a target="_blank" href="" id="saml_idp_video_link" class="onid-saml-bootstrap-text-white onid-saml-bootstrap-px-4 onid-saml-bootstrap-py-2 onid-saml-bootstrap-rounded onid-saml-bootstrap-bg-danger"><svg width="16" height="16" fill="currentColor" class="bi bi-youtube" viewBox="0 0 16 16">
						<path d="M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.007 2.007 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.007 2.007 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31.4 31.4 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.007 2.007 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A99.788 99.788 0 0 1 7.858 2h.193zM6.4 5.209v4.818l4.157-2.408L6.4 5.209z" />
					</svg> &nbsp;<?php esc_html_e( 'Video Guide', 'onid-sso-by-saml-2-0' ); ?></a>
			</div>
		</div>
-->
		<div class="onid-saml-sp-tab-container onid-saml-bootstrap-mt-4">
<!--
			<ul class="switch-tab-sp onid-saml-bootstrap-text-center">
				<li class="onid-saml-current"><a href="#onid-saml-idp-manual-tab" class="onid-saml-bs-btn"><?php esc_html_e( 'Enter IDP Metadata Manually', 'onid-sso-by-saml-2-0' ); ?></a></li>
				<li class="onid-saml-bootstrap-col-md-2 or"><?php esc_html_e( 'OR', 'onid-sso-by-saml-2-0' ); ?></li>
				<li><a href="#onid-saml-upload-idp-tab" class="onid-saml-bs-btn"><?php esc_html_e( 'Upload IDP Metadata', 'onid-sso-by-saml-2-0' ); ?></a></li>
			</ul>
-->				

			<div class="onid-saml-sp-tab">
				<input type="hidden" id="onid-saml-test-window-url" value="<?php echo esc_url( onid_saml_get_test_url() ); ?>">
				<input type="hidden" id="onid-saml-attribute-mapping-url" value="<?php echo esc_url( onid_saml_get_attribute_mapping_url() ); ?>">
				<input type="hidden" id="onid-saml-service-provider-url" value="<?php echo esc_url( onid_saml_get_service_provider_url() ); ?>">
				<input type="hidden" id="onid-saml-redirect-sso-url" value="<?php echo esc_url( onid_saml_get_redirection_sso_url() ); ?>">
				<form method="post" action="">
					<?php
					if ( function_exists( 'wp_nonce_field' ) ) {
						wp_nonce_field( 'login_widget_saml_save_settings' );
					}
					?>
					<input type="hidden" name="option" value="login_widget_saml_save_settings" />
					
					<div id="onid-saml-idp-manual-tab" class="onid-saml-tab-content">
						<input type="hidden" name="onid_saml_identity_provider_identifier_name" id="onid_saml_identity_provider_identifier_name" value="<?php echo esc_attr( $onid_saml_identity_provider_identifier_name ); ?>" />



						<div class="onid-saml-bootstrap-row align-items-top onid-saml-bootstrap-mt-5">
							<div class="onid-saml-bootstrap-col-md-3 onid-saml-bootstrap-pe-0">
								<h6 class="onid-saml-bootstrap-text-secondary"><?php esc_html_e( 'Identity Provider Name', 'onid-sso-by-saml-2-0' ); ?><span style="color: red;">*</span> :</h6>
							</div>
							<div class="onid-saml-bootstrap-col-md-7">
								<input type="text" name="onid_saml_identity_name" placeholder="<?php esc_html_e( 'Identity Provider name like ADFS, SimpleSAML, Salesforce', 'onid-sso-by-saml-2-0' ); ?>" class="onid-saml-bootstrap-w-100" value="<?php echo esc_attr( $onid_saml_identity_name ); ?>" required pattern="\w+" title="Only alphabets, numbers and underscore is allowed">
							</div>
						</div>

						<div class="onid-saml-bootstrap-row align-items-top onid-saml-bootstrap-mt-5">
							<div class="onid-saml-bootstrap-col-md-3 onid-saml-bootstrap-pe-0">
								<h6 class="onid-saml-bootstrap-text-secondary"><?php esc_html_e( 'Return URL', 'onid-sso-by-saml-2-0' ); ?><span style="color: red;">*</span> :</h6>
							</div>
							<div class="onid-saml-bootstrap-col-md-7">
								<input onchange="	document.getElementById('onid_saml_login_url').value = document.getElementById('onid_saml_login_url_base').value+'?consumerURL='+document.getElementById('onid_saml_consumer_url').value;"
									type="text" id="onid_saml_consumer_url" name="onid_saml_consumer_url" placeholder="" class="onid-saml-bootstrap-w-100" value="<?php echo esc_attr( $onid_saml_consumer_url); ?>" required pattern="[^\s]+\s*$" title="">
							</div>
						</div>
				
						<div hidden>
							<div class="onid-saml-bootstrap-row align-items-top onid-saml-bootstrap-mt-5">
								<div class="onid-saml-bootstrap-col-md-3">
									<h6 class="onid-saml-bootstrap-text-secondary"><?php esc_html_e( 'SP EntityID / Issuer', 'onid-sso-by-saml-2-0' ); ?><span style="color: red;">*</span> :</h6>
								</div>
								<div class="onid-saml-bootstrap-col-md-7">
									<input readonly type="text" name="onid_saml_sp_entity_id" title="Please enter a valid value" pattern="[^\s]+\s*$" placeholder="Enter Service Provider Entity ID" class="onid-saml-bootstrap-w-100" value="<?php echo esc_attr( $onid_saml_sp_entity_id ); ?>" required>
								</div>
							</div>
						</div>
						<div hidden>
							<div class="onid-saml-bootstrap-row align-items-top onid-saml-bootstrap-mt-5">
								<div class="onid-saml-bootstrap-col-md-3">
									<h6 class="onid-saml-bootstrap-text-secondary"><?php esc_html_e( 'IdP Entity ID or Issuer', 'onid-sso-by-saml-2-0' ); ?><span style="color: red;">*</span> :</h6>
								</div>
								<div class="onid-saml-bootstrap-col-md-7">
									<input readonly type="text" title="Please enter a valid value" name="onid_saml_issuer" id="onid_saml_issuer" pattern="[^\s]+\s*$" placeholder="Identity Provider Entity ID or Issuer" class="onid-saml-bootstrap-w-100" value="<?php echo esc_attr( $onid_saml_issuer ); ?>" required="">
								</div>
							</div>
						</div>
						<div hidden>
							<div class="onid-saml-bootstrap-row align-items-top onid-saml-bootstrap-mt-5">
								<div class="onid-saml-bootstrap-col-md-3">
									<h6 class="onid-saml-bootstrap-text-secondary"><?php esc_html_e( 'SAML Login URL', 'onid-sso-by-saml-2-0' ); ?><span style="color: red;">*</span> :</h6>
								</div>
								<div class="onid-saml-bootstrap-col-md-7">
									<input readonly type="url" id="onid_saml_login_url_base" pattern="[^\s]+\s*$" placeholder="" class="onid-saml-bootstrap-w-100" value="<?php echo esc_attr( $onid_saml_login_url_base ); ?>" required="">
									<input hidden type="url" title="Please enter a valid value" id="onid_saml_login_url" name="onid_saml_login_url" pattern="[^\s]+\s*$" placeholder="Single Sign On Service URL (HTTP-Redirect binding) of your IdP" class="onid-saml-bootstrap-w-100" value="<?php echo esc_attr( $onid_saml_login_url ); ?>" required="">
								</div>
							</div>
						</div>
						
						<?php
						foreach ( $onid_saml_x509_certificate as $key => $value ) {
							?>
							<div hidden>
							<div class="onid-saml-bootstrap-row align-items-top onid-saml-bootstrap-mt-5">
								<div class="onid-saml-bootstrap-col-md-3">
									<h6 class="onid-saml-bootstrap-text-secondary"><?php esc_html_e( 'X.509 Certificate', 'onid-sso-by-saml-2-0' ); ?><span style="color: red;">*</span> :</h6>
								</div>
								<div class="onid-saml-bootstrap-col-md-7">
									<textarea readonly rows="4" cols="5" name="onid_saml_x509_certificate[<?php esc_attr( $key ); ?>]" id="onid_saml_x509_certificate" onkeyup="removeCertificateErrorClass();" placeholder="Copy and Paste the content from the downloaded certificate or copy the content enclosed in X509Certificate tag (has parent tag KeyDescriptor use=signing) in IdP-Metadata XML file" class="onid-saml-bootstrap-w-100" required=""><?php echo esc_html( $value ); ?></textarea>


									<span class="onid-saml-error-tip">
										<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="#ffa300" class="bi bi-exclamation-square-fill" viewBox="0 0 16 16">
											<path d="M2 0a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2H2zm6 4c.535 0 .954.462.9.995l-.35 3.507a.552.552 0 0 1-1.1 0L7.1 4.995A.905.905 0 0 1 8 4zm.002 6a1 1 0 1 1 0 2 1 1 0 0 1 0-2z"></path>
										</svg>&nbsp; <?php esc_html_e( 'Invalid Certificate', 'onid-sso-by-saml-2-0' ); ?>
									</span>
								</div>
							</div>
							</div>
							<?php
						}
						?>
						<div hidden>
							<div class="onid-saml-bootstrap-row align-items-top onid-saml-bootstrap-mt-5">
								<div class="onid-saml-bootstrap-col-md-3">
									<h6 class="onid-saml-bootstrap-text-secondary"><?php esc_html_e( 'Character encoding :', 'onid-sso-by-saml-2-0' ); ?></h6>
								</div>
								<div class="onid-saml-bootstrap-col-md-8">
									<input type="checkbox" id="switch" name="onid_saml_encoding_enabled" class="onid-saml-switch" <?php echo esc_attr( $saml_is_encoding_enabled ); ?> /><label class="onid-saml-switch-label" for="switch">Toggle</label>
								</div>
							</div>
							<div class="onid-saml-bootstrap-row onid-saml-bootstrap-align-items-top onid-saml-bootstrap-mt-5">
								<div class="onid-saml-bootstrap-col-md-3">
									<h6 class="onid-saml-bootstrap-text-secondary"><?php esc_html_e( 'Assertion Time Validity:', 'onid-sso-by-saml-2-0' ); ?></h6>
								</div>
								<div class="onid-saml-bootstrap-col-md-8">
									<input type="checkbox" id="switch_sync" name="onid_saml_assertion_time_validity" class="onid-saml-switch" <?php echo esc_attr( $saml_assertion_time_validity ); ?> /><label class="onid-saml-switch-label" for="switch_sync">Toggle</label>
								</div>
							</div>
						</div>
						<div class="onid-saml-bootstrap-row align-items-top mt-2">
							<div class="onid-saml-bootstrap-col-md-3"></div>
							<div class="onid-saml-bootstrap-col-md-9">
								<input type="submit" class="onid-saml-bs-bs-btn btn-cstm onid-saml-bootstrap-rounded onid-saml-bootstrap-mt-3 onid-saml-bootstrap-me-3 onid-saml-w-186" name="submit" value="<?php esc_html_e( 'Save', 'onid-sso-by-saml-2-0' ); ?>">
								<input type="button" class="onid-saml-bs-bs-btn btn-cstm onid-saml-bootstrap-rounded onid-saml-bootstrap-mt-3 onid-saml-w-186" id="test_config" 
								<?php
								if ( ! Onid_SAML_Utilities::onid_saml_is_sp_configured() || ! get_option( Onid_Saml_Options_Enum_Service_Provider::X509_CERTIFICATE ) || ! Onid_SAML_Utilities::onid_saml_is_openssl_installed() ) {
									echo 'disabled';}
								?>
									title="You can only test your Configuration after saving your Service Provider Settings." onclick="onid_saml_show_test_window();" value="<?php esc_html_e( 'Test Configuration', 'onid-sso-by-saml-2-0' ); ?>">
							</div>
						</div>


					</div>
				</form>

				<div id="onid-saml-upload-idp-tab" class="onid-saml-tab-content">
				</div>
			</div>
		</div>
	</div>
	<?php
}
