<?php
/**
 * This file contains the functions to display the plugin's core components.
 *
 * @package onid-sso-by-saml-2-0\views
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
/**
 * Displays warnings for missing dependencies.
 *
 * @return void
 */
function onid_saml_display_plugin_dependency_warning() {
	if ( ! Onid_SAML_Utilities::onid_saml_is_curl_installed() ) {
		?>
		<p><span style="color: #FF0000; ">(Warning: <a href="http://php.net/manual/en/curl.installation.php" target="_blank" rel="noopener noreferrer">PHP
					cURL extension</a> is not installed or disabled)</span></p>
		<?php
	}

	if ( ! Onid_SAML_Utilities::onid_saml_is_openssl_installed() ) {
		?>
		<p><span style="color: #FF0000; ">(Warning: <a href="http://php.net/manual/en/openssl.installation.php" target="_blank" rel="noopener noreferrer">PHP
					openssl extension</a> is not installed or disabled)</span></p>
		<?php
	}

	if ( ! Onid_SAML_Utilities::onid_saml_is_dom_installed() ) {
		?>
		<p><span style="color: #FF0000; ">(Warning: PHP
				dom extension is not installed or disabled)</span></p>
		<?php
	}
}

/**
 * Renders the Plugin header.
 *
 * @return void
 */
function onid_saml_display_plugin_header() {

	$sandbox_url =  Onid_Saml_External_Links::PRICING_PAGE;
	$version     = 'v' . Onid_Saml_Options_Plugin_Constants::VERSION;
	?>
	<div class="wrap shadow-cstm onid-saml-bootstrap-p-3 onid-saml-bootstrap-me-0 onid-saml-bootstrap-mt-0 onid-saml-margin-left">
		<div class="onid-saml-bootstrap-row align-items-top">
			<div class="onid-saml-bootstrap-col-md-5 onid-saml-bootstrap-h3 onid-saml-bootstrap-ps-4">
				<?php esc_html_e( 'onID SSO by SAML 2.0', 'onid-sso-by-saml-2-0' ); ?>
				<span class="onid_saml_version_display"> <?php echo '[ ' . esc_html( $version ) . ' ]'; ?> </span>
			</div>
			<div class="onid-saml-bootstrap-col-md-3 onid-saml-bootstrap-text-end onid-saml-bootstrap-d-flex onid-saml-bootstrap-align-items-center">
				<a class="onid-saml-bootstrap-text-white onid-saml-bootstrap-ps-4 onid-saml-bootstrap-pe-4 onid-saml-bootstrap-pt-2 onid-saml-bootstrap-pb-2 btn-prem prem-btn-cstm" target="_blank" href="<?php echo esc_url( $sandbox_url ); ?>"><?php esc_html_e( 'Try Paid Features', 'onid-sso-by-saml-2-0' ); ?></a>
			</div>
		</div>
	</div>
	<?php
}

/**
 * Renders the plugin tabs.
 *
 * @param string $active_tab Contains the id of the current tab.
 * @return void
 */
function onid_saml_display_plugin_tabs( $active_tab ) {
	?>
	<div class="bg-main-cstm onid-saml-bootstrap-pb-4 onid-saml-margin-left" id="container">
		<span id="onid-saml-message"></span>
		<div id="onid-saml-tabs" class="onid-saml-bootstrap-d-flex onid-saml-bootstrap-text-center onid-saml-bootstrap-pt-3 onid-saml-bootstrap-border-bottom onid_saml_padding_left_2">
			<a id="sp-setup-tab" class="onid-saml-nav-tab-cstm <?php echo esc_html( ( 'save' === $active_tab ? 'onid-saml-nav-tab-active' : '' ) ); ?>" href="<?php echo isset( $_SERVER['REQUEST_URI'] ) ? esc_url( add_query_arg( array( 'tab' => 'save' ), esc_url_raw( wp_unslash( $_SERVER['REQUEST_URI'] ) ) ) ) : ''; ?>"><?php esc_html_e( 'Service Provider Setup', 'onid-sso-by-saml-2-0' ); ?></a>
<!--
			<a id="sp-meta-tab" class="onid-saml-nav-tab-cstm <?php echo esc_html( ( 'config' === $active_tab ? 'onid-saml-nav-tab-active' : '' ) ); ?>" href="<?php echo isset( $_SERVER['REQUEST_URI'] ) ? esc_url( add_query_arg( array( 'tab' => 'config' ), esc_url_raw( wp_unslash( $_SERVER['REQUEST_URI'] ) ) ) ) : ''; ?>"><?php esc_html_e( 'Service Provider Metadata', 'onid-sso-by-saml-2-0' ); ?></a>
			<a id="attr-role-tab" class="onid-saml-nav-tab-cstm <?php echo esc_html( ( 'opt' === $active_tab ? 'onid-saml-nav-tab-active' : '' ) ); ?>" href="<?php echo isset( $_SERVER['REQUEST_URI'] ) ? esc_url( add_query_arg( array( 'tab' => 'opt' ), esc_url_raw( wp_unslash( $_SERVER['REQUEST_URI'] ) ) ) ) : ''; ?>"><?php esc_html_e( 'Attribute/Role Mapping', 'onid-sso-by-saml-2-0' ); ?></a>
			<a id="redir-sso-tab" class="onid-saml-nav-tab-cstm <?php echo esc_html( ( 'general' === $active_tab ? 'onid-saml-nav-tab-active' : '' ) ); ?>" href="<?php echo isset( $_SERVER['REQUEST_URI'] ) ? esc_url( add_query_arg( array( 'tab' => 'general' ), esc_url_raw( wp_unslash( $_SERVER['REQUEST_URI'] ) ) ) ) : ''; ?>"><?php esc_html_e( 'Redirection & SSO Links', 'onid-sso-by-saml-2-0' ); ?></a>
			<a id="addon-tab" class="onid-saml-nav-tab-cstm <?php echo esc_html( ( 'addons' === $active_tab ? 'onid-saml-nav-tab-active' : '' ) ); ?>" href="<?php echo isset( $_SERVER['REQUEST_URI'] ) ? esc_url( add_query_arg( array( 'tab' => 'addons' ), esc_url_raw( wp_unslash( $_SERVER['REQUEST_URI'] ) ) ) ) : ''; ?>"><?php esc_html_e( 'Add-Ons', 'onid-sso-by-saml-2-0' ); ?></a>
			<a id="acc-tab" class="onid-saml-nav-tab-cstm <?php echo esc_html( ( 'account-setup' === $active_tab ? 'onid-saml-nav-tab-active' : '' ) ); ?>" href="<?php echo isset( $_SERVER['REQUEST_URI'] ) ? esc_url( add_query_arg( array( 'tab' => 'account-setup' ), esc_url_raw( wp_unslash( $_SERVER['REQUEST_URI'] ) ) ) ) : ''; ?>"><?php esc_html_e( 'Account Setup', 'onid-sso-by-saml-2-0' ); ?></a>
-->			
		</div>
		<?php
			onid_saml_apps_config_saml();
		?>
		<a class="contact-us-cstm onid-saml-bootstrap-d-none">
			<span class="onid-saml-bootstrap-d-flex onid-saml-bootstrap-justify-content-center onid-saml-bootstrap-align-items-center onid-saml-bootstrap-pt-3 onid-saml-bootstrap-text-white">
				<svg width="16" height="16" fill="currentColor" class="onid-saml-bootstrap-mt-1" viewBox="0 0 16 16">
					<path d="M8 1a5 5 0 0 0-5 5v1h1a1 1 0 0 1 1 1v3a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1V6a6 6 0 1 1 12 0v6a2.5 2.5 0 0 1-2.5 2.5H9.366a1 1 0 0 1-.866.5h-1a1 1 0 1 1 0-2h1a1 1 0 0 1 .866.5H11.5A1.5 1.5 0 0 0 13 12h-1a1 1 0 0 1-1-1V8a1 1 0 0 1 1-1h1V6a5 5 0 0 0-5-5z" />
				</svg> &nbsp;&nbsp;<?php esc_html_e( 'onID Support', 'onid-sso-by-saml-2-0' ); ?>
			</span>
		</a>
	</div>
	<?php
}

/**
 * Displays the troubleshoot section.
 *
 * @return void
 */
function onid_saml_troubleshoot_card() {
	?>
	<div class="onid-saml-bootstrap-bg-white onid-saml-bootstrap-text-center shadow-cstm onid-saml-bootstrap-rounded contact-form-cstm onid-saml-bootstrap-mt-4 onid-saml-bootstrap-p-4">
		<div class="onid-saml-call-setup onid-saml-bootstrap-p-3">
			<h6><?php esc_html_e( 'Facing issues? Check out the Troubleshooting options available in the plugin', 'onid-sso-by-saml-2-0' ); ?></h6>
			<hr />
			<div class="onid-saml-bootstrap-row onid-saml-bootstrap-align-items-center onid-saml-bootstrap-mt-3 onid-saml-bootstrap-justify-content-center">
				<a href="?page=onid_saml_enable_debug_logs&tab=debug-logs" class="onid-saml-bs-btn btn-cstm onid-saml-bootstrap-text-white onid-saml-bootstrap-w-50"><?php esc_html_e( 'Troubleshoot', 'onid-sso-by-saml-2-0' ); ?></a>
			</div>
		</div>
	</div>
	<?php
}

/**
 * Displays IDP related integration based on the selected IDP.
 *
 * @return void
 */
function onid_saml_display_suggested_idp_integration() {
	?>
	<div class="onid-saml-card-glass onid-saml-bootstrap-mt-4" id="onid-saml-ads-text">
		<div class="onid-saml-ads-text">
			<h5 class="onid-saml-bootstrap-text-center" id="onid-saml-ads-head"><?php esc_html_e( 'Wait! You have more to explore', 'onid-sso-by-saml-2-0' ); ?></h5>
			<hr />
			<ul class="onid-saml-bootstrap-ps-1">
				<p id="onid-saml-ads-cards-text"></p>
				<a target="_blank" rel="noopener noreferrer" href="" class="onid-saml-bootstrap-text-warning" id="ads-text-link"><?php esc_html_e( 'Azure AD / Office 365 Sync', 'onid-sso-by-saml-2-0' ); ?></a>
				<a target="_blank" rel="noopener noreferrer" href="" class="onid-saml-bootstrap-text-warning onid-saml-bootstrap-float-end" id="ads-knw-more-link"><?php esc_html_e( 'Azure AD / Office 365 Sync', 'onid-sso-by-saml-2-0' ); ?></a>
			</ul>
		</div>
	</div>
	<?php
}

/**
 * Displays recommended add-ons based on the installed plugins.
 *
 * @return void
 */
function onid_saml_display_suggested_add_ons() {
}
