<?php
/**
 * This file runs automatically when the user deletes the plugin in order to clear out any plugin options and/or settings specific to the plugin.
 *
 * @package onid-sso-by-saml-2-0
 */

if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
	exit();
}

require_once __DIR__ . '/includes/lib/class-onid-saml-options-enum.php';
if ( ! ( get_option( 'onid_saml_keep_settings_on_deletion' ) === 'true' ) ) {

	if ( is_multisite() ) {
		$original_blog_id = get_current_blog_id();
		switch_to_blog( $original_blog_id );
	}
	onid_saml_delete_configuration_array();
}
/**
 * Deletes the configuration of the plugin.
 *
 * @return void
 */
function onid_saml_delete_configuration_array() {
	$tab_class_names_array = array(
		'Onid_Saml_Options_Test_Configuration',
		'Onid_Saml_Options_Enum',
		'Onid_Saml_Options_Enum_Service_Provider',
		'Onid_Saml_Options_Enum_Service_Provider',
		'Onid_Saml_Sso_Constants',
		'Onid_Saml_Options_Enum_Attribute_Mapping',
		'Onid_Saml_Options_Enum_Role_Mapping',
		'Onid_Saml_Options_Enum_Sso_Login',
	);
	foreach ( $tab_class_names_array as $class_name ) {
		$class_object = call_user_func( $class_name . '::get_constants' );
		foreach ( $class_object as $key => $value ) {
			delete_option( $value );
		}
	}
}
