<?php
/**
 * This file initiates the display for all the tabs.
 *
 * @package onid-sso-by-saml-2-0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

require_once 'onid-saml-import-export.php';

foreach ( glob( plugin_dir_path( __FILE__ ) . 'views' . DIRECTORY_SEPARATOR . '*.php' ) as $filename ) {
	include_once $filename;
}
/**
 * The function displays the tabs in the plugin and then renders the associated data.
 */
function onid_saml_register_saml_sso($inNonce) {
	if(! wp_verify_nonce($inNonce, 'onid_login_widget_saml_options')) {
		die("nonce fail: onid_login_widget_saml_options");
	}


	$nonce = wp_create_nonce('onid_saml_register_saml_sso');
	Onid_SAML_Utilities::onid_saml_extension_disabled_modal($nonce);
	if ( isset( $_GET['tab'] ) ) {
		$active_tab = sanitize_text_field( wp_unslash( $_GET['tab'] ) );
		if ( 'addons' === $active_tab ) {
		}
	} else {
		$active_tab = 'save';
	}
	?>
	<?php

	onid_saml_display_plugin_dependency_warning();

	?>
	<div id="onid_saml_settings" >
		<?php
		if ( ! Onid_SAML_Utilities::onid_saml_is_sp_configured() ) {
		}

		onid_saml_display_plugin_header();
		?>

	</div>

	<?php
	onid_saml_display_plugin_tabs( $active_tab );
}

/**
 * This function returns attribute mapping url.
 */
function onid_saml_get_attribute_mapping_url() {
	if ( isset( $_SERVER['REQUEST_URI'] ) ) {
		return add_query_arg( array( 'tab' => 'opt' ), sanitize_text_field( wp_unslash( $_SERVER['REQUEST_URI'] ) ) );
	} else {
			$server_url = '';
	}
}

/**
 * This function returns service provider url.
 */
function onid_saml_get_service_provider_url() {
	if ( isset( $_SERVER['REQUEST_URI'] ) ) {
			return add_query_arg( array( 'tab' => 'save' ), sanitize_text_field( wp_unslash( $_SERVER['REQUEST_URI'] ) ) );
	} else {
			$server_url = '';
	}
}
/**
 * This function returns redirection sso url.
 */
function onid_saml_get_redirection_sso_url() {
	if ( isset( $_SERVER['REQUEST_URI'] ) ) {
			return add_query_arg( array( 'tab' => 'general' ), sanitize_text_field( wp_unslash( $_SERVER['REQUEST_URI'] ) ) );
	} else {
		$server_url = '';
	}
}
/**
 * This function returns test url.
 */
function onid_saml_get_test_url() {

		$url = site_url() . '/?option=testConfig';

	return $url;
}

/**
 * This function displays test configuration error.
 *
 * @param string $error_code error code .
 * @param string $display_metadata_mismatch The metadata recieved in SMAL response and stored in plugin if the error corresponds to a mismatched metadata .
 * @param string $status_message The status sent by Identity Provider.
 */
function onid_saml_display_test_config_error_page( $error_code, $display_metadata_mismatch = '', $status_message = '' ) {
	$error_fix     = $error_code['fix'];
	$error_cause   = $error_code['cause'];
	$error_message = empty( $status_message ) && ! empty( $error_code['testconfig_msg'] ) ? $error_code['testconfig_msg'] : $status_message;
	if ( ob_get_level() > 0 ) {
		ob_end_clean();
	}

	echo '<div style="font-family:Calibri;padding:0 3%;">';
	echo '<div style="color: #a94442;background-color: #f2dede;padding: 15px;margin-bottom: 20px;text-align:center;border:1px solid #E6B3B2;font-size:18pt;"> ERROR ' . esc_html( $error_code['code'] ) . '</div>
	<div style="color: #a94442;font-size:14pt; margin-bottom:20px;"><p><strong>Error: </strong>' . wp_kses_post( $error_cause ) . '</p>
	<p>Please contact your administrator and report the following error:</p>
	<p><strong>Possible Cause: </strong>' . esc_html( $error_message ) . '</p>';
	if ( ! empty( $status_message ) ) {
		echo '<p><strong>Status Message in the SAML Response:</strong> <br/>' . esc_html( $status_message ) . '</p><br>';
	}
	if ( ! empty( $display_metadata_mismatch ) ) {
		echo wp_kses(
			$display_metadata_mismatch,
			array(
				'p'      => array(
					'strong' => array(),
				),
				'strong' => array(),
			)
		);
	}
	echo '<p><strong>Solution:</strong></p>
		' . wp_kses_post( $error_fix ) . '
	</div>
	<div style="margin:3%;display:block;text-align:center;">';
	echo '<div style="margin:3%;display:block;text-align:center;"><input style="padding:1%;width:100px;background: #0091CD none repeat scroll 0% 0%;cursor: pointer;font-size:15px;border-width: 1px;border-style: solid;border-radius: 3px;white-space: nowrap;box-sizing: border-box;border-color: #0073AA;box-shadow: 0px 1px 0px rgba(120, 200, 230, 0.6) inset;color: #FFF;"type="button" value="Done" onClick="self.close();"></div>';
	echo '</div>';
	exit;
}

?>
