<?php
/**
 * File Name: onid-saml-import-export.php
 * Description: This file will import and export the configuration
 *
 * @package onid-sso-by-saml-2-0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit();
}

require_once __DIR__ . '/includes/lib/class-onid-saml-options-enum.php';

$tab_class_names_array = array(
	'SSO_Login'         => 'Onid_Saml_Options_Enum_Sso_Login',
	'Identity_Provider' => 'Onid_Saml_Options_Enum_Service_Provider',
	'Service_Provider'  => 'Onid_Saml_Options_Enum_Service_Provider',
	'Attribute_Mapping' => 'Onid_Saml_Options_Enum_Attribute_Mapping',
	'Role_Mapping'      => 'Onid_Saml_Options_Enum_Role_Mapping',
);

if ( get_option( Onid_Saml_Sso_Constants::ONID_SAML_TEST_STATUS ) !== 1 ) {

	$tab_class_names_array['Test_Configuration'] = 'Onid_Saml_Options_Test_Configuration';
}

define( 'ONID_ONID_TAB_CLASS_NAMES', maybe_serialize( $tab_class_names_array ) );


