<?php // phpcs:ignore WordPress.Files.FileName.InvalidClassFileName -- cannot change main file's name
/**
 * Plugin Name: onID SSO by SAML 2.0
 * Plugin URI: https://onboardingidentity.com/docs/plugin/
 * Description: onID SAML plugin allows sso/login using SimpleSAMLphp
 *  Version: 3.1.13
 * Author: onID
 * Author URI: https://onboardingidentity.com/docs/author/
 * License: MIT
 * License URI: https://onboardingidentity.com/docs/mit-license
 * Text Domain: onid-sso-by-saml-2-0
 *
 * @package onid-sso-by-saml-2-0
 */


if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

define( 'ONID_SAML_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
require_once 'handlers/class-onid-saml-base-handler.php';
require_once 'class-onid-saml-login-validate.php';
require_once 'onid-saml-settings-page.php';
require_once 'class-onid-saml-utilities.php';
require_once 'class-onid-saml-wp-config-editor.php';

/**
 * The Main class of the onID SAML SSO Plugin.
 */

class Onid_Saml_Login {

	/**
	 * The Constructor for the main class. This takes care of initializing all the hooks used by the plugin.
	 */
	public function __construct() {
		add_action( 'admin_enqueue_scripts', array( $this, 'plugin_settings_script' ) );
		add_action( 'admin_enqueue_scripts', array( $this, 'plugin_settings_style' ) );
		register_activation_hook( __FILE__, array( $this, 'onid_saml_sso_activate' ) );
		add_action( 'admin_init', array( Onid_SAML_Base_Handler::class, 'onid_saml_save_settings_handler' ) );
		add_action( 'admin_init', array( $this, 'onid_saml_do_plugin_extension_checks' ) );
		//add_action( 'admin_footer', array( $this, 'feedback_request' ) );
		add_action( 'admin_menu', array( $this, 'onid_sso_menu' ) );
		add_action( 'admin_notices', array( $this, 'onid_saml_idp_notice' ) );
		add_action( 'login_form', array( $this, 'onid_saml_modify_login_form' ) );
		add_action( 'plugin_action_links_' . plugin_basename( __FILE__ ), array( $this, 'onid_saml_plugin_action_links' ) );
		add_action( 'plugins_loaded', array( $this, 'onid_saml_load_translations' ) );
		add_action( 'wp_authenticate', array( $this, 'onid_saml_authenticate' ) );
		register_deactivation_hook( __FILE__, array( $this, 'onid_saml_deactivate' ) );
		register_shutdown_function( array( $this, 'log_errors' ) );
		remove_action( 'admin_notices', array( Onid_SAML_Utilities::class, 'onid_saml_error_message' ) );
		remove_action( 'admin_notices', array( Onid_SAML_Utilities::class, 'onid_saml_success_message' ) );		
	}

	/**
	 * This function is responsible for redirecting the admin to the SAML SSO plugin settings after the plugin is activated.
	 *
	 * @param string $plugin The activated plugin's name.
	 * @param bool   $network_wide If the plugin was activated network wide or not.
	 * @return void
	 */
	public function onid_saml_redirect_after_activation( $plugin, $network_wide ) {
/*		
		//phpcs:ignore WordPress.Security.NonceVerification.Recommended -- Reading GET parameter from the URL for checking if multiple plugins were activated, doesn't require nonce verification. 
		if ( ! isset( $_GET['activate-multi'] ) && 'onid-sso-by-saml-2-0/login.php' === $plugin && ! $network_wide ) {
			$nonce = wp_create_nonce('onid_saml_redirect_after_activation');
error_log(">>>>>>>>>>>>>>>>>>>>>>> onid_saml_redirect_after_activation !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");			
			wp_safe_redirect( self_admin_url() . 'admin.php?page=onid_saml_settings&onid_saml_redirect_after_activation='.$nonce );
			exit;
		}
*/			
	}

	/**
	 * This function enabled the keep setting intact toggle if it is disabled when activating the plugin.
	 */
	public function onid_saml_sso_activate() {
		if ( ! get_option( Onid_Saml_Options_Enum_Sso_Login::ONID_SAML_KEEP_SETTINGS_DELETION ) ) {
			add_option( Onid_Saml_Options_Enum_Sso_Login::ONID_SAML_KEEP_SETTINGS_DELETION, 'true' );
		}
		
		$this->onid_saml_reset_to_factory_default();
	}

/*
	//////////////////////////////////////////////////////////////////////////////////////
	/////		by_ONID: START reset to factory default
	//////////////////////////////////////////////////////////////////////////////////////
*/
	public static function onid_saml_reset_to_factory_default() {
		$db_handler = new Onid_SAML_Database_Handler();
		$onid_saml_consumer_url										= site_url()."/wp-admin/";  // "wp-login.php" or "/wp-admin/" - mind the final slash !!!
		$onid_saml_sp_entity_id 									= Onid_Saml_Options_Enum_Service_Provider::SP_ENTITY_ID_DEFAULT;
		$onid_saml_issuer 											= Onid_Saml_Options_Enum_Service_Provider::ISSUER_DEFAULT;
		$onid_saml_login_url 										= Onid_Saml_Options_Enum_Service_Provider::LOGIN_URL_DEFAULT;
		$onid_saml_x509_certificate 								= Onid_Saml_Options_Enum_Service_Provider::X509_CERTIFICATE_DEFAULT;
		$onid_saml_identity_provider_identifier_name 				= Onid_Saml_Options_Enum_Service_Provider::IDENTITY_PROVIDER_NAME_DEFAULT;
		$onid_saml_is_encoding_enabled 								= Onid_Saml_Options_Enum_Service_Provider::IS_ENCODER_ENABLED_DEFAULT;
		$onid_saml_assertion_time_validity 							= Onid_Saml_Options_Enum_Service_Provider::ASSERTION_TIME_VALIDITY_DEFAULT;
	
		$save_array = array();
		$save_array[ Onid_Saml_Options_Enum_Service_Provider::CONSUMER_URL ]     		= $onid_saml_consumer_url;
		$save_array[ Onid_Saml_Options_Enum_Service_Provider::SP_ENTITY_ID ]     		= $onid_saml_sp_entity_id;
		$save_array[ Onid_Saml_Options_Enum_Service_Provider::ISSUER ]           		= $onid_saml_issuer;
		$save_array[ Onid_Saml_Options_Enum_Service_Provider::LOGIN_URL ]        		= $onid_saml_login_url;
		$save_array[ Onid_Saml_Options_Enum_Service_Provider::X509_CERTIFICATE ] 		= $onid_saml_x509_certificate;
		$save_array[ Onid_Saml_Options_Enum_Service_Provider::IDENTITY_NAME ]    		= $onid_saml_identity_provider_identifier_name;
		$save_array[ Onid_Saml_Options_Enum_Service_Provider::IS_ENCODING_ENABLED ] 	= $onid_saml_is_encoding_enabled;
		$save_array[ Onid_Saml_Options_Enum_Service_Provider::ASSERTION_TIME_VALIDITY ] = $onid_saml_assertion_time_validity;
		
		$save_array[ Onid_Saml_Options_Enum_Service_Provider::IDENTITY_PROVIDER_NAME ] 	= $onid_saml_identity_provider_identifier_name;

		$save_array[ Onid_Saml_Options_Enum_Sso_Login::SSO_BUTTON ] = 'true';
		$db_handler->onid_saml_save_options( $save_array );
	}
/*
	//////////////////////////////////////////////////////////////////////////////////////
	/////		by_ONID: END reset to factory default
	//////////////////////////////////////////////////////////////////////////////////////
*/







	/**
	 * Ensures fatal errors are logged so they can be picked up in the status report.
	 *
	 * @since 4.9.09
	 */
	public function log_errors() {
	}

	/**
	 * Takes care of loading the pot files for translations.
	 *
	 * @return void
	 */
	public function onid_saml_load_translations() {
		load_plugin_textdomain( 'onid-sso-by-saml-2-0', false, dirname( plugin_basename( __FILE__ ) ) . '/resources/lang/' );
	}

	/**
	 * Function to display the notice on the specific pages.
	 */
	public function onid_saml_do_plugin_extension_checks() {
		$valid_pages = 'onid_saml_settings';
        // phpcs:ignore WordPress.Security.NonceVerification.Recommended -- reading page parameter.
		if ( ! ( ! empty( $_GET['page'] ) && ( $_GET['page'] === $valid_pages ) ) && current_user_can( 'manage_options' ) ) {
			add_action( 'admin_notices', array( $this, 'onid_saml_show_disabled_extension_notice' ) );
		}
	}

	/**
	 * Function shows a notice incase any required extensions are not enabled.
	 */
	public function onid_saml_show_disabled_extension_notice() {
		$disable_extension = Onid_SAML_Utilities::onid_saml_get_disabled_extensions();

		if ( ! empty( $disable_extension ) ) {
			$extension_display_line = implode( ', ', $disable_extension );
			echo '
            <div class="notice notice-warning onid-saml-trial-notice-banner">
                <div class="onid-saml-notice-content">
                    <img src="' . esc_attr( plugin_dir_url( __FILE__ ) ) . 'images/onid_logo.webp" class="onid-saml-logo">
                    <span class="onid-saml-warning-text">
                        <span class="onid-saml-warning-title">Warning:</span> Following PHP extensions (<i class="onid-saml-extension-list">' . esc_attr( $extension_display_line ) . '</i>) are disabled which are important for SSO configuration. Please enable these extensions to continue using SSO on your site.
                    </span>
                </div>
            </div>';
		}
	}

	/**
	 * Displays the feedback form upon plugin deactivation.
	 *
	 * @return void
	 */
	public function feedback_request() {
		//onid_saml_display_saml_feedback_form();
	}

	/**
	 * The callback function for the plugin menu page. This is the starting point for displaying the plugin settings.
	 *
	 * @return void
	 */
	public function onid_login_widget_saml_options() {
		global $wpdb;
		$nonce = wp_create_nonce('onid_login_widget_saml_options');
		onid_saml_register_saml_sso($nonce);
	}

	/**
	 * Takes care of cleaning some logger constant and welcome page flag once the plugin is deactivated.
	 *
	 * @return void
	 */
	public function onid_saml_deactivate() {
		delete_option( Onid_Saml_Options_Enum::NEW_USER );
		if ( ! Onid_SAML_Utilities::onid_saml_is_curl_installed() ) {
			return;
		}

		$site_home_path   = get_home_path();
		$wp_config_path   = $site_home_path . 'wp-config.php';
		$wp_config_editor = new Onid_SAML_WP_Config_Editor( $wp_config_path );

		if ( wp_is_writable( $wp_config_path ) ) {
			$wp_config_editor->onid_saml_wp_config_update( 'ONID_SAML_LOGGING', 'false' );
		}
		wp_safe_redirect( 'plugins.php' );
	}

	/**
	 * Enqueues all the css files required by the plugin
	 *
	 * @param string $page Contains the value of the page parameter from the URL along with its level and is used to make sure the css is loaded only where it is required.
	 * @return void
	 */
	public function plugin_settings_style( $page ) {
		wp_enqueue_style( 'onid_saml_notice_style', plugins_url( 'includes/css/notice.min.css', __FILE__ ), array(), Onid_Saml_Options_Plugin_Constants::VERSION, 'all' );
		if ( 'toplevel_page_onid_saml_settings' !== $page && 'onid-saml-2-0-sso_page_onid_saml_enable_debug_logs' !== $page ) {
			return;
		} else {
			wp_enqueue_style( 'onid_saml_bootstrap_css', plugins_url( 'includes/css/bootstrap/onid-saml-bootstrap.min.css', __FILE__ ), array(), Onid_Saml_Options_Plugin_Constants::VERSION, 'all' );
			wp_enqueue_style( 'onid_saml_jquery_ui_style', plugins_url( 'includes/css/jquery-ui.min.css', __FILE__ ), array(), Onid_Saml_Options_Plugin_Constants::VERSION, 'all' );
			wp_enqueue_style( 'onid_saml_admin_settings_style', plugins_url( 'includes/css/style_settings.min.css', __FILE__ ), array(), Onid_Saml_Options_Plugin_Constants::VERSION, 'all' );
			wp_enqueue_style( 'onid_saml_admin_settings_phone_style', plugins_url( 'includes/css/phone.min.css', __FILE__ ), array(), Onid_Saml_Options_Plugin_Constants::VERSION, 'all' );
			wp_enqueue_style( 'onid_saml_wpb-fa', plugins_url( 'includes/css/style-icon.min.css', __FILE__ ), array(), Onid_Saml_Options_Plugin_Constants::VERSION, 'all' );
		}
	}

	/**
	 * Enqueues all the js files required by the plugin
	 *
	 * @param string $page Contains the value of the page parameter from the URL along with its level and is used to make sure the js is loaded only where it is required.
	 * @return void
	 */
	public function plugin_settings_script( $page ) {
		if ( 'toplevel_page_onid_saml_settings' === $page || 'onid-saml-2-0-sso_page_onid_saml_enable_debug_logs' === $page ) {
			wp_enqueue_script( 'jquery-ui-core' );
			wp_enqueue_script( 'jquery-ui-autocomplete' );
			wp_enqueue_script( 'jquery-ui-datepicker' );
			wp_enqueue_script( 'onid_saml_timepicker_script', plugins_url( 'includes/js/jquery.timepicker.min.js', __FILE__ ), array(), Onid_Saml_Options_Plugin_Constants::VERSION, false );
			wp_enqueue_script( 'onid_saml_admin_settings_script', plugins_url( 'includes/js/settings.min.js', __FILE__ ), array(), Onid_Saml_Options_Plugin_Constants::VERSION, false );
			wp_enqueue_script( 'onid_saml_admin_settings_phone_script', plugins_url( 'includes/js/phone.min.js', __FILE__ ), array(), Onid_Saml_Options_Plugin_Constants::VERSION, false );

			wp_enqueue_script( 'onid_saml_generic_script', plugins_url( 'includes/js/onid.js', __FILE__ ), array(), Onid_Saml_Options_Plugin_Constants::VERSION, false );

		}
		wp_enqueue_script( 'onid_saml_notice_script', plugins_url( 'includes/js/notice.min.js', __FILE__ ), array(), Onid_Saml_Options_Plugin_Constants::VERSION, false );
	}

	/**
	 * This function is responsible for adding the SSO button on the WordPress login page.
	 *
	 * @return void
	 */
	public function onid_saml_modify_login_form() {
		$sso_button = get_option( Onid_Saml_Options_Enum_Sso_Login::SSO_BUTTON );
		if ( 'false' !== $sso_button && Onid_SAML_Utilities::onid_saml_is_sp_configured() ) {
			$this->onid_saml_add_sso_button();
		}
	}

	/**
	 * Renders the SSO button for the configured IDP.
	 *
	 * @return void
	 */
	public function onid_saml_add_sso_button() {
		if ( ! is_user_logged_in() ) {
			$saml_idp_name      = get_option( Onid_Saml_Options_Enum_Service_Provider::IDENTITY_NAME );
			$custom_button_text = isset( $saml_idp_name ) ? 'Login with ' . $saml_idp_name : 'Login with SSO';
			wp_enqueue_script( 'onid_saml_login_button_script', plugins_url( 'includes/js/sso_button.min.js', __FILE__ ), array(), Onid_Saml_Options_Plugin_Constants::VERSION, false );
			echo '
                <input id="saml_user_login_input" type="hidden" name="option" value="">


                <div id="onid_saml_button" style="height:88px;">
                	<div id="onid_saml_login_sso_button" style="width:100%;display:flex;justify-content:center;align-items:center;font-size:14px;margin-bottom:1.3rem" class="button button-primary">
                    <img style="width:20px;height:15px;padding-right:1px" src="' . esc_url( Onid_SAML_Utilities::onid_saml_get_plugin_dir_url() ) . 'images/lock-icon.webp">' . esc_html( $custom_button_text ) . '
                	</div>
                	<div style="padding:5px;font-size:14px;height:20px;text-align:center"><b>OR</b></div>
            	</div>';
		}
	}

	/**
	 * Takes care of displaying IDP specific solutions and add-ons in the admin notice bar.
	 *
	 * @return void
	 */
	public function onid_saml_idp_notice() {
		$onid_date_current_notice = gmdate( 'Y-m-d' );

		if ( isset( $_POST['onid_idp_close_notice_nonce'] ) && check_admin_referer( 'onid_idp_close_notice', 'onid_idp_close_notice_nonce' ) ) {
			$onid_date_expire_notice = gmdate( 'Y-m-d', strtotime( $onid_date_current_notice . '+7 day' ) );
			update_option( Onid_Saml_Sso_Constants::ONID_SAML_EXPIRE_NOTICE, $onid_date_expire_notice );
			update_option( Onid_Saml_Sso_Constants::ONID_SAML_CLOSE_NOTICE, 1 );
		}
		$onid_saml_identity_provider_identifier_name = get_option( Onid_Saml_Options_Enum_Service_Provider::IDENTITY_PROVIDER_NAME );?>
		<input type="hidden" name="onid_saml_identity_provider_identifier" id="onid_saml_identity_provider_identifier" value="<?php echo esc_attr( $onid_saml_identity_provider_identifier_name ); ?>" />
		<input type="hidden" name="idp_specific" id="idp_specific" value='<?php echo esc_attr( wp_json_encode( Onid_Saml_Options_Plugin_Idp::$idp_list ) ); ?>' />
		<?php
		$display = 'none';
		//phpcs:ignore WordPress.Security.NonceVerification.Recommended -- Reading GET parameter from the URL for checking tab name, doesn't require nonce verification.
		if ( ! empty( Onid_Saml_Options_Plugin_Idp::$idp_list[ $onid_saml_identity_provider_identifier_name ] ) && ( ! isset( $_GET['tab'] ) || 'addons' !== $_GET['tab'] ) ) {
			$display = 'block';
		}

		if ( $onid_date_current_notice < get_option( Onid_Saml_Sso_Constants::ONID_SAML_EXPIRE_NOTICE ) && ! empty( get_option( Onid_Saml_Sso_Constants::ONID_SAML_CLOSE_NOTICE ) ) && get_option( Onid_Saml_Sso_Constants::ONID_SAML_CLOSE_NOTICE ) ) {
			$display = 'none';
		}

	}

	/**
	 * Adds the menu and submenu for the onID SAML SSO plugin.
	 *
	 * @return void
	 */
	public function onid_sso_menu() {
		$slug = 'onid_saml_settings';
		add_menu_page(
			'onID SAML Settings ' . __( 'Configure SAML Identity Provider for SSO', 'onid-sso-by-saml-2-0' ),
			'onID SAML 2.0 SSO',
			'manage_options',
			$slug,
			array(
				$this,
				'onid_login_widget_saml_options',
			),
			Onid_SAML_Utilities::onid_saml_get_plugin_dir_url() . 'images/onid.webp'
		);
		add_submenu_page(
			$slug,
			'onID SAML 2.0 SSO',
			__( 'Plugin Configuration', 'onid-sso-by-saml-2-0' ),
			'manage_options',
			'onid_saml_settings',
			array( $this, 'onid_login_widget_saml_options' )
		);
	}

	/**
	 * Handles redirection of a logged in user.
	 *
	 * @return void
	 */
	public function onid_saml_authenticate() {
		$redirect_to = '';
		//phpcs:ignore WordPress.Security.NonceVerification.Recommended -- Reading GET parameter from the URL for checking the redirect_to parameter, doesn't require nonce verification.
		if ( isset( $_GET['redirect_to'] ) ) {
			//phpcs:ignore WordPress.Security.NonceVerification.Recommended -- Reading GET parameter from the URL for checking the redirect_to parameter, doesn't require nonce verification.
			$redirect_to = esc_url_raw( wp_unslash( $_GET['redirect_to'] ) );
		}

		if ( is_user_logged_in() ) {
			$this->onid_saml_login_redirect( $redirect_to );
		}
	}

	/**
	 * Redirects the user to the redirect_to parameter after SSO.
	 *
	 * @param string $redirect_to The redirect_to query parameter from the URL.
	 * @return void
	 */
	public function onid_saml_login_redirect( $redirect_to ) {
		$is_admin_url = false;

		if ( strcmp( admin_url(), $redirect_to ) === 0 || strcmp( wp_login_url(), $redirect_to ) === 0 ) {
			$is_admin_url = true;
		}

		if ( ! empty( $redirect_to ) && ! $is_admin_url ) {
			wp_safe_redirect( $redirect_to );
		} else {
			wp_safe_redirect( site_url() );
		}
		exit();
	}

	/**
	 * Provides additional links for Settings and Premium Plans for the plugin listed under the Installed Plugins section.
	 *
	 * @param array $links The default links provided by WordPress for Settings and Deactivate.
	 * @return array
	 */
	public function onid_saml_plugin_action_links( $links ): array {

		$settings_link = array( '<a href="' . esc_url( admin_url( 'admin.php?page=onid_saml_settings' ) ) . '">' . __( 'Settings', 'onid-sso-by-saml-2-0' ) . '</a>' );
		$license_link  = '<a href="' . Onid_Saml_External_Links::PRICING_PAGE . '" target="_blank">' . esc_html__( 'Premium Plans', 'onid-sso-by-saml-2-0' ) . '</a>';

		$links = array_merge( $settings_link, $links );

		array_push(
			$links,
			$license_link
		);
		return $links;
	}
}
new Onid_Saml_Login();
