<?php
/**
 * This file is responsible for writing options to the options table.
 *
 * @package onid-sso-by-saml-2-0\handlers
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Used to write options to database.
 */
class Onid_SAML_Database_Handler {

	/**
	 * Contains the option handler type.
	 *
	 * @var string
	 */
	private $option_handler_type;

	/**
	 * Initializes the option handler type.
	 */
	public function __construct() {
		$this->option_handler_type = 'DB_OPTION';
	}

	/**
	 * Saves one or many options to the options table.
	 *
	 * @param array $save_array Options and their values to be stored.
	 * @return void
	 */
	public function onid_saml_save_options( $save_array ) {
		if ( ! empty( $save_array ) ) {
			foreach ( $save_array as $key => $value ) {
				update_option( $key, $value );
			}
		}
	}
}
