<?php
/**
 * Handles all the form submissions in the plugin.
 *
 * @package onid-sso-by-saml-2-0\handlers
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

require_once __DIR__ . '/class-onid-saml-database-handler.php';
require_once __DIR__ . '/class-onid-saml-post-save-handler.php';
require_once __DIR__ . '/class-onid-saml-service-provider-settings-handler.php';
require_once __DIR__ . '/class-onid-saml-sso-settings-handler.php';

/**
 * Main Form Handler class used to handle all the form submissions in the plugin.
 */
class Onid_SAML_Base_Handler {

	/**
	 * This function is responsible for verifying the nonce and calling the corresponding handlers when a form is submitted.
	 *
	 * @return void
	 */
	public static function onid_saml_save_settings_handler() {
		$nonce = wp_create_nonce('onid_saml_save_settings_handler');
		if ( isset( $_SERVER['QUERY_STRING'] ) && ! Onid_SAML_Utilities::onid_saml_is_plugin_page( sanitize_text_field( wp_unslash( $_SERVER['QUERY_STRING'] ) ), $nonce ) ) {
			return;
		}

		if ( ! current_user_can( 'manage_options' ) ) {
			wp_die( 'You do not have permission to view this page' );
		}

		$db_handler = new Onid_SAML_Database_Handler();

		$option = '';
		if ( isset( $_POST['option'] ) ) {
			$option = sanitize_text_field( wp_unslash( $_POST['option'] ) );
			if ( 'onid_saml_register_customer' === $option ) {
				check_admin_referer( $option, $option . '_nonce' );
			} else {
				check_admin_referer( $option );
			}
		}

		$post_array = Onid_SAML_Utilities::onid_saml_sanitize_post_array( $_POST );
		switch ( $option ) {
			case 'login_widget_saml_save_settings':
				Onid_SAML_Service_Provider_Settings_Handler::onid_saml_service_provider_save_settings( $post_array, $db_handler );
				break;
			case 'clear_attrs_list':
				Onid_SAML_Attribute_Mapping_Handler::clear_attr_list();
				break;
			case 'onid_saml_add_sso_button_wp_option':
				Onid_SAML_SSO_Settings_Handler::onid_saml_add_sso_button( $post_array, $db_handler );
				break;
			default:
				break;
		}
	}
}
