<?php

add_action('woocommerce_login_form_start', 'onguard_add_otp_nonce_to_login_form');

add_action( 'woocommerce_login_form_start', 'onguard_add_otp_fields_to_woocommerce' );

function onguard_add_otp_fields_to_woocommerce() {
    wp_nonce_field( 'otp_login_action', 'otp_login_nonce' );

    if ( ! empty( $_SESSION['otp_required'] ) ) {
        echo '<p class="form-row form-row-wide">';
        echo    '<label for="otp">' . esc_html__( 'Code OTP', 'onguard' ) . '</label>';
        echo    '<input type="text" class="input-text" name="otp" id="otp" />';
        echo '</p>';
    }
}

add_action( 'woocommerce_login_form_end', 'onguard_prefill_credentials_and_otp_woocommerce' );

function onguard_prefill_credentials_and_otp_woocommerce() {
    if ( ! empty( $_SESSION['credentials_correct'] ) ) {
        $user = isset($_SESSION['stored_username']) ? sanitize_text_field($_SESSION['stored_username']) : '';
        $pass = isset($_SESSION['stored_password']) ? sanitize_text_field($_SESSION['stored_password']) : '';
        // Clear the flag so we don't loop
        unset( $_SESSION['credentials_correct'], $_SESSION['stored_username'], $_SESSION['stored_password'] );

        $inline_js = "
        document.addEventListener('DOMContentLoaded', function(){
            document.getElementById('username').value = '{$user}';
            document.getElementById('password').value = '{$pass}';
        });";

        // Enqueue and inline it
        wp_register_script('onguard-login-prefill', '', [], $script_version, true);
        wp_enqueue_script(  'onguard-login-prefill' );
        wp_add_inline_script( 'onguard-login-prefill', $inline_js );
    }
}
