<?php
// Language map for translations
function onguard_get_language_map() {
    return [
        'en' => [ // English
            'otp_required' => 'We have just sent you a 6-digit code to the e-mail address %s. Please enter this code to finalize your connection.',
            'otp_label' => '6-digit code',
            'otp_invalid' => 'The code you entered is invalid. Please try again.',
            'otp_already_validated' => 'The code you entered has already been validated. Please log in to continue.',
            'otp_too_many_tries' => 'You have exceeded the maximum number of attempts. Please request a new code.',
            'otp_expired' => 'The code you entered has expired. Please request a new code.',
            'password_not_safe' => 'The password you entered is not safe enough. Please choose a stronger password.',
        ],
        'fr' => [ // French
            'otp_required' => 'Nous venons de vous envoyer un code à 6 chiffres à l\'adresse e-mail %s. Veuillez entrer ce code pour finaliser votre connexion.',
            'otp_label' => 'Code à 6 chiffres',
            'otp_invalid' => 'Le code que vous avez entré est invalide. Veuillez réessayer.',
            'otp_already_validated' => 'Le code que vous avez entré a déjà été validé. Veuillez vous connecter pour continuer.',
            'otp_too_many_tries' => 'Vous avez dépassé le nombre maximum de tentatives. Veuillez demander un nouveau code.',
            'otp_expired' => 'Le code que vous avez entré a expiré. Veuillez demander un nouveau code.',
        ],
        'es' => [ // Spanish
            'otp_required' => 'Te acabamos de enviar un código de 6 dígitos a la dirección de correo electrónico %s. Por favor, introduce este código para finalizar tu conexión.',
            'otp_label' => 'Código de 6 dígitos',
            'otp_invalid' => 'El código que ingresaste es inválido. Por favor, inténtalo de nuevo.',
            'otp_already_validated' => 'El código que ingresaste ya ha sido validado. Por favor, inicia sesión para continuar.',
            'otp_too_many_tries' => 'Has superado el número máximo de intentos. Por favor, solicita un nuevo código.',
            'otp_expired' => 'El código que ingresaste ha caducado. Por favor, solicita un nuevo código.',
        ],
        'de' => [ // German
            'otp_required' => 'Wir haben Ihnen gerade einen 6-stelligen Code an die E-Mail-Adresse %s gesendet. Bitte geben Sie diesen Code ein, um Ihre Verbindung abzuschließen.',
            'otp_label' => '6-stelliger Code',
            'otp_invalid' => 'Der eingegebene Code ist ungültig. Bitte versuchen Sie es erneut.',
            'otp_already_validated' => 'Der eingegebene Code wurde bereits validiert. Bitte melden Sie sich an, um fortzufahren.',
            'otp_too_many_tries' => 'Sie haben die maximale Anzahl von Versuchen überschritten. Bitte fordern Sie einen neuen Code an.',
            'otp_expired' => 'Der eingegebene Code ist abgelaufen. Bitte fordern Sie einen neuen Code an.',
        ],
        'it' => [ // Italian
            'otp_required' => 'Ti abbiamo appena inviato un codice a 6 cifre all\'indirizzo e-mail %s. Inserisci questo codice per completare la connessione.',
            'otp_label' => 'Codice a 6 cifre',
            'otp_invalid' => 'Il codice inserito non è valido. Riprova.',
            'otp_already_validated' => 'Il codice inserito è già stato validato. Accedi per continuare.',
            'otp_too_many_tries' => 'Hai superato il numero massimo di tentativi. Richiedi un nuovo codice.',
            'otp_expired' => 'Il codice inserito è scaduto. Richiedi un nuovo codice.',
        ],
        'pt' => [ // Portuguese
            'otp_required' => 'Acabamos de enviar um código de 6 dígitos para o endereço de e-mail %s. Por favor, insira este código para finalizar sua conexão.',
            'otp_label' => 'Código de 6 dígitos',
            'otp_invalid' => 'O código que você inseriu é inválido. Tente novamente.',
            'otp_already_validated' => 'O código que você inseriu já foi validado. Faça login para continuar.',
            'otp_too_many_tries' => 'Você excedeu o número máximo de tentativas. Solicite um novo código.',
            'otp_expired' => 'O código que você inseriu expirou. Solicite um novo código.',
        ],
        'nl' => [ // Dutch
            'otp_required' => 'We hebben zojuist een 6-cijferige code naar het e-mailadres %s gestuurd. Voer deze code in om uw verbinding te voltooien.',
            'otp_label' => '6-cijferige code',
            'otp_invalid' => 'De ingevoerde code is ongeldig. Probeer het opnieuw.',
            'otp_already_validated' => 'De ingevoerde code is al gevalideerd. Log in om door te gaan.',
            'otp_too_many_tries' => 'U heeft het maximale aantal pogingen overschreden. Vraag een nieuwe code aan.',
            'otp_expired' => 'De ingevoerde code is verlopen. Vraag een nieuwe code aan.',
        ],
        'ru' => [ // Russian
            'otp_required' => 'Мы только что отправили вам 6-значный код на адрес электронной почты %s. Пожалуйста, введите этот код, чтобы завершить подключение.',
            'otp_label' => '6-значный код',
            'otp_invalid' => 'Введенный вами код недействителен. Пожалуйста, попробуйте еще раз.',
            'otp_already_validated' => 'Введенный вами код уже был подтвержден. Пожалуйста, войдите в систему, чтобы продолжить.',
            'otp_too_many_tries' => 'Вы превысили максимальное количество попыток. Пожалуйста, запросите новый код.',
            'otp_expired' => 'Введенный вами код истек. Пожалуйста, запросите новый код.',
        ],
        'zh-CN' => [ // Chinese (Simplified)
            'otp_required' => '我们刚刚向您的电子邮件地址 %s 发送了一个 6 位数的验证码。请输入此验证码以完成连接。',
            'otp_label' => '6 位数验证码',
            'otp_invalid' => '您输入的验证码无效。请重试。',
            'otp_already_validated' => '您输入的验证码已经验证过。请登录以继续。',
            'otp_too_many_tries' => '您已超过最大尝试次数。请重新获取验证码。',
            'otp_expired' => '您输入的验证码已过期。请重新获取验证码。',
        ],
        'zh-TW' => [ // Chinese (Traditional)
            'otp_required' => '我們剛剛向您的電子郵件地址 %s 發送了一個 6 位數的驗證碼。請輸入此驗證碼以完成連接。',
            'otp_label' => '6 位數驗證碼',
            'otp_invalid' => '您輸入的驗證碼無效。請重試。',
            'otp_already_validated' => '您輸入的驗證碼已經驗證過。請登入以繼續。',
            'otp_too_many_tries' => '您已超過最大嘗試次數。請重新獲取驗證碼。',
            'otp_expired' => '您輸入的驗證碼已過期。請重新獲取驗證碼。',
        ],
        'ja' => [ // Japanese
            'otp_required' => 'あなたのメールアドレス %s に6桁のコードを送信しました。このコードを入力して接続を完了してください。',
            'otp_label' => '6桁のコード',
            'otp_invalid' => '入力されたコードは無効です。再度お試しください。',
            'otp_already_validated' => '入力されたコードはすでに検証されています。続行するにはログインしてください。',
            'otp_too_many_tries' => '試行回数の上限を超えました。新しいコードをリクエストしてください。',
            'otp_expired' => '入力されたコードの有効期限が切れました。新しいコードをリクエストしてください。',
        ],
        'ko' => [ // Korean
            'otp_required' => '이메일 주소 %s 로 6자리 코드를 보냈습니다. 이 코드를 입력하여 연결을 완료하세요.',
            'otp_label' => '6자리 코드',
            'otp_invalid' => '입력하신 코드가 잘못되었습니다. 다시 시도해 주세요.',
            'otp_already_validated' => '입력하신 코드는 이미 검증되었습니다. 계속하려면 로그인하세요.',
            'otp_too_many_tries' => '최대 시도 횟수를 초과했습니다. 새로운 코드를 요청하세요.',
            'otp_expired' => '입력하신 코드의 유효 기간이 만료되었습니다. 새로운 코드를 요청하세요.',
        ],
        'ar' => [ // Arabic
            'otp_required' => 'لقد أرسلنا للتو رمزًا مكونًا من 6 أرقام إلى عنوان البريد الإلكتروني %s. يرجى إدخال هذا الرمز لإكمال الاتصال.',
            'otp_label' => 'رمز مكون من 6 أرقام',
            'otp_invalid' => 'الرمز الذي أدخلته غير صالح. يرجى المحاولة مرة أخرى.',
            'otp_already_validated' => 'تم التحقق من الرمز الذي أدخلته مسبقًا. يرجى تسجيل الدخول للمتابعة.',
            'otp_too_many_tries' => 'لقد تجاوزت الحد الأقصى لعدد المحاولات. يرجى طلب رمز جديد.',
            'otp_expired' => 'انتهت صلاحية الرمز الذي أدخلته. يرجى طلب رمز جديد.',
        ],
        'tr' => [ // Turkish
            'otp_required' => 'E-posta adresinize %s 6 haneli bir kod gönderdik. Bağlantınızı tamamlamak için lütfen bu kodu girin.',
            'otp_label' => '6 haneli kod',
            'otp_invalid' => 'Girdiğiniz kod geçersiz. Lütfen tekrar deneyin.',
            'otp_already_validated' => 'Girdiğiniz kod zaten doğrulandı. Devam etmek için lütfen giriş yapın.',
            'otp_too_many_tries' => 'Maksimum deneme sayısını aştınız. Lütfen yeni bir kod talep edin.',
            'otp_expired' => 'Girdiğiniz kodun süresi doldu. Lütfen yeni bir kod talep edin.',
        ],
        'pl' => [ // Polish
            'otp_required' => 'Właśnie wysłaliśmy Ci 6-cyfrowy kod na adres e-mail %s. Wprowadź ten kod, aby zakończyć połączenie.',
            'otp_label' => '6-cyfrowy kod',
            'otp_invalid' => 'Wprowadzony kod jest nieprawidłowy. Spróbuj ponownie.',
            'otp_already_validated' => 'Wprowadzony kod został już zweryfikowany. Zaloguj się, aby kontynuować.',
            'otp_too_many_tries' => 'Przekroczyłeś maksymalną liczbę prób. Poproś o nowy kod.',
            'otp_expired' => 'Wprowadzony kod wygasł. Poproś o nowy kod.',
        ],
        'sv' => [ // Swedish
            'otp_required' => 'Vi har precis skickat en 6-siffrig kod till e-postadressen %s. Ange denna kod för att slutföra din anslutning.',
            'otp_label' => '6-siffrig kod',
            'otp_invalid' => 'Den inmatade koden är ogiltig. Försök igen.',
            'otp_already_validated' => 'Den inmatade koden har redan validerats. Logga in för att fortsätta.',
            'otp_too_many_tries' => 'Du har överskridit det maximala antalet försök. Vänligen begär en ny kod.',
            'otp_expired' => 'Den inmatade koden har gått ut. Vänligen begär en ny kod.',
        ],
        'da' => [ // Danish
            'otp_required' => 'Vi har lige sendt dig en 6-cifret kode til e-mailadressen %s. Indtast venligst denne kode for at afslutte din forbindelse.',
            'otp_label' => '6-cifret kode',
            'otp_invalid' => 'Den indtastede kode er ugyldig. Prøv igen.',
            'otp_already_validated' => 'Den indtastede kode er allerede blevet valideret. Log ind for at fortsætte.',
            'otp_too_many_tries' => 'Du har overskredet det maksimale antal forsøg. Anmod om en ny kode.',
            'otp_expired' => 'Den indtastede kode er udløbet. Anmod om en ny kode.',
        ],
        'fi' => [ // Finnish
            'otp_required' => 'Olemme juuri lähettäneet sinulle 6-numeroisen koodin sähköpostiosoitteeseen %s. Syötä tämä koodi viimeistelläksesi yhteyden.',
            'otp_label' => '6-numeroinen koodi',
            'otp_invalid' => 'Annettu koodi on virheellinen. Yritä uudelleen.',
            'otp_already_validated' => 'Annettu koodi on jo vahvistettu. Kirjaudu sisään jatkaaksesi.',
            'otp_too_many_tries' => 'Olet ylittänyt yritysten enimmäismäärän. Pyydä uutta koodia.',
            'otp_expired' => 'Annettu koodi on vanhentunut. Pyydä uutta koodia.',
        ],
        'cs' => [ // Czech
            'otp_required' => 'Právě jsme vám poslali 6místný kód na e-mailovou adresu %s. Zadejte tento kód pro dokončení připojení.',
            'otp_label' => '6místný kód',
            'otp_invalid' => 'Zadaný kód je neplatný. Zkuste to znovu.',
            'otp_already_validated' => 'Zadaný kód již byl ověřen. Přihlašte se pro pokračování.',
            'otp_too_many_tries' => 'Překročili jste maximální počet pokusů. Požádejte o nový kód.',
            'otp_expired' => 'Zadaný kód vypršel. Požádejte o nový kód.',
        ],
        'hu' => [ // Hungarian
            'otp_required' => 'Most küldtünk egy 6 számjegyű kódot a(z) %s e-mail címre. Kérjük, írja be ezt a kódot a kapcsolat befejezéséhez.',
            'otp_label' => '6 számjegyű kód',
            'otp_invalid' => 'A megadott kód érvénytelen. Kérjük, próbálja újra.',
            'otp_already_validated' => 'A megadott kód már ellenőrzött. Kérjük, jelentkezzen be a folytatáshoz.',
            'otp_too_many_tries' => 'Túllépte a maximális próbálkozási számot. Kérjen új kódot.',
            'otp_expired' => 'A megadott kód lejárt. Kérjen új kódot.',
        ],
        'el' => [ // Greek
            'otp_required' => 'Σας στείλαμε μόλις έναν 6ψήφιο κωδικό στη διεύθυνση e-mail %s. Παρακαλώ εισάγετε αυτόν τον κωδικό για να ολοκληρώσετε τη σύνδεσή σας.',
            'otp_label' => '6ψήφιος κωδικός',
            'otp_invalid' => 'Ο κωδικός που εισάγατε δεν είναι έγκυρος. Παρακαλώ προσπαθήστε ξανά.',
            'otp_already_validated' => 'Ο κωδικός που εισάγατε έχει ήδη επικυρωθεί. Παρακαλώ συνδεθείτε για να συνεχίσετε.',
            'otp_too_many_tries' => 'Έχετε ξεπεράσει τον μέγιστο αριθμό προσπαθειών. Παρακαλώ ζητήστε έναν νέο κωδικό.',
            'otp_expired' => 'Ο κωδικός που εισάγατε έχει λήξει. Παρακαλώ ζητήστε έναν νέο κωδικό.',
        ],
        'ro' => [ // Romanian
            'otp_required' => 'Tocmai ți-am trimis un cod din 6 cifre la adresa de e-mail %s. Te rugăm să introduci acest cod pentru a finaliza conexiunea.',
            'otp_label' => 'Cod de 6 cifre',
            'otp_invalid' => 'Codul introdus este invalid. Vă rugăm să încercați din nou.',
            'otp_already_validated' => 'Codul introdus a fost deja validat. Vă rugăm să vă autentificați pentru a continua.',
            'otp_too_many_tries' => 'Ați depășit numărul maxim de încercări. Solicitați un nou cod.',
            'otp_expired' => 'Codul introdus a expirat. Solicitați un nou cod.',
        ],
        'id' => [ // Indonesian
            'otp_required' => 'Kami baru saja mengirimkan kode 6 digit ke alamat email %s. Silakan masukkan kode ini untuk menyelesaikan koneksi Anda.',
            'otp_label' => 'Kode 6 digit',
            'otp_invalid' => 'Kode yang Anda masukkan tidak valid. Silakan coba lagi.',
            'otp_already_validated' => 'Kode yang Anda masukkan sudah divalidasi. Silakan masuk untuk melanjutkan.',
            'otp_too_many_tries' => 'Anda telah melebihi jumlah percobaan maksimum. Silakan minta kode baru.',
            'otp_expired' => 'Kode yang Anda masukkan telah kedaluwarsa. Silakan minta kode baru.',
        ],
        'vi' => [ // Vietnamese
            'otp_required' => 'Chúng tôi vừa gửi một mã 6 chữ số đến địa chỉ email %s. Vui lòng nhập mã này để hoàn tất kết nối của bạn.',
            'otp_label' => 'Mã 6 chữ số',
            'otp_invalid' => 'Mã bạn nhập không hợp lệ. Vui lòng thử lại.',
            'otp_already_validated' => 'Mã bạn nhập đã được xác minh. Vui lòng đăng nhập để tiếp tục.',
            'otp_too_many_tries' => 'Bạn đã vượt quá số lần thử tối đa. Vui lòng yêu cầu mã mới.',
            'otp_expired' => 'Mã bạn nhập đã hết hạn. Vui lòng yêu cầu mã mới.',
        ],
        'th' => [ // Thai
            'otp_required' => 'เราเพิ่งส่งรหัส 6 หลักไปยังที่อยู่อีเมล %s โปรดป้อนรหัสนี้เพื่อเสร็จสิ้นการเชื่อมต่อของคุณ',
            'otp_label' => 'รหัส 6 หลัก',
            'otp_invalid' => 'รหัสที่คุณป้อนไม่ถูกต้อง โปรดลองอีกครั้ง',
            'otp_already_validated' => 'รหัสที่คุณป้อนได้รับการยืนยันแล้ว โปรดเข้าสู่ระบบเพื่อดำเนินการต่อ',
            'otp_too_many_tries' => 'คุณได้ลองเกินจำนวนครั้งสูงสุดแล้ว โปรดขอรหัสใหม่',
            'otp_expired' => 'รหัสที่คุณป้อนหมดอายุแล้ว โปรดขอรหัสใหม่',
        ],
    ];
}
