<?php

add_action('login_enqueue_scripts', 'onguard_enqueue_password_check_script');

function onguard_enqueue_password_check_script() {
    if (in_array($GLOBALS['pagenow'], ['wp-login.php']) && isset($_GET['action']) && $_GET['action'] === 'rp') {
        onguard_add_password_listener();
    }
}

function onguard_add_password_listener() {
    wp_enqueue_script(
        'onguard-custom-password-check',
        plugin_dir_url(__FILE__) . '../js/password-check.js',
        ['jquery'],
        time(),
        true
    );
    wp_localize_script('onguard-custom-password-check', 'passwordCheckAjax', [
        'ajax_url' => admin_url('admin-ajax.php'),
        'nonce'    => wp_create_nonce('password_check_nonce'),
    ]);
}

add_action('wp_ajax_check_pwned_password', 'onguard_check_pwned_password_handler');       // For logged-in users
add_action('wp_ajax_nopriv_check_pwned_password', 'onguard_check_pwned_password_handler'); // For guests (like on reset page)

function onguard_check_pwned_password_handler() {
    check_ajax_referer('password_check_nonce', 'nonce');

    $new_pass = isset($_POST['password']) ? sanitize_text_field(wp_unslash($_POST['password'])) : '';
    if (empty($new_pass)) {
        wp_send_json_error(['message' => 'No password provided']);
    }
    // Hash the new password using SHA-1
    $hashed_password = sha1($new_pass);
    $client_id = get_option('on_guard_client_id');
    $client_secret = get_option('on_guard_client_secret');
    $basic_auth_header = '';

    // Check if both Client ID and Client Secret are set
    if ($client_id && $client_secret) {
        // Concatenate the Client ID and Client Secret with a colon
        $credentials = $client_id . ':' . $client_secret;
        // Encode the credentials in Base64
        $base64_credentials = base64_encode($credentials);
        // Create the Basic Auth header
        $basic_auth_header = 'Basic ' . $base64_credentials;
    } else {
        return;
    }

    $response = wp_remote_get('https://api.on-guard.eu/guard/v1/check/password?hash_password=' . $hashed_password, array(
        'headers' => array(
            'Authorization' => $basic_auth_header
        ),
    ));

    // Check for WP errors
    if (!is_wp_error($response)) {
        // Decode the response body
        $body = wp_remote_retrieve_body($response);
        $data = json_decode($body, true);

        // Check the safe_password field
        if (isset($data['safe_password'])) {
            wp_send_json_success(['pwned' => $data['safe_password'] === false]);
        }
    }
}
