<?php
/**
* Plugin Name: OnGuard
* Description: Advanced login fraud detection system based on billions of data points. <strong>You must create an account on <a href="https://www.on-guard.eu/">On Guard</a> and copy your client credentials on <a href="/wp-admin/admin.php?page=on-guard-settings">Settings</a> to enable it</strong>.
* Version: 1.1
* Author: <a href="https://www.on-guard.eu/">On Guard</a>
* License: GPL2
* @package OnGuard
*/

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Prevent direct access.
}

// Define the plugin basename
$on_guard_basename = plugin_basename(__FILE__);

// Include the admin menu file
require_once plugin_dir_path(__FILE__) . 'admin-menu.php';

// Include the login handler middleware
require_once plugin_dir_path(__FILE__) . 'sources/login-handler.php';

// Include the login handler middleware
require_once plugin_dir_path(__FILE__) . 'sources/reset-password-handler.php';

// Include the translations
require_once plugin_dir_path(__FILE__) . 'sources/translations.php';

// Woo Commerce compatibility
require_once plugin_dir_path(__FILE__) . 'sources/woocommerce/login-handler.php';
require_once plugin_dir_path(__FILE__) . 'sources/woocommerce/reset-password-handler.php';

