jQuery(document).ready(function ($) {
    const $passwordInput = $('#pass1').length
        ? $('#pass1')
        : $('#password_1'); // For woocommerce
    const $customWarning = $('<div id="custom-pwned-warning" style="color: red; margin-top: 10px;"></div>');

    if (!$passwordInput.length) {
        console.warn('No #pass1 input found');
        return;
    }

    $passwordInput.after($customWarning);

    let timeout = null;

    $passwordInput.on('input', function () {
        clearTimeout(timeout);

        const password = $(this).val();
        $customWarning.text('');

        if (password.length < 8) return;

        timeout = setTimeout(() => {
            // Use standard jQuery AJAX with proper form encoding
            $.ajax({
                type: 'POST',
                url: passwordCheckAjax.ajax_url,
                data: {
                    action: 'check_pwned_password',
                    nonce: passwordCheckAjax.nonce,
                    password: password
                },
                success: function (response) {
                    if (response.success && response.data.pwned) {
                        $customWarning.text('⚠️ This password has been hacked on other websites.');
                    } else {
                        $customWarning.text('');
                    }
                },
                error: function (xhr, status, error) {
                    console.error('AJAX Error:', status, error);
                }
            });
        }, 500);
    });
});
