<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Prevent direct access.
}

// Hook to add an admin menu item
add_action('admin_menu', 'onguard_add_admin_menu');

function onguard_add_admin_menu() {
    add_menu_page(
        'On Guard Settings',  // Page title
        'On Guard',           // Menu title in admin
        'manage_options',     // Required capability
        'on-guard-settings',  // Slug
        'onguard_settings_page', // Callback function to render settings page
        'dashicons-admin-generic', // Icon
        20                     // Position in the menu
    );

    // Register settings
    add_action('admin_init', 'onguard_register_settings');
}

function onguard_register_settings() {
    register_setting('on_guard_options_group', 'on_guard_client_id', 'sanitize_text_field');
    register_setting('on_guard_options_group', 'on_guard_client_secret', 'sanitize_text_field');
}

// Function to display the custom admin page
function onguard_settings_page() {
    ?>
    <div class="wrap">
        <h1>On Guard Settings</h1>
        <form method="post" action="options.php">
            <?php
            settings_fields('on_guard_options_group');
            do_settings_sections('on-guard-settings');
            ?>
            <table class="form-table">
                <tr valign="top">
                    <th scope="row">Client ID</th>
                    <td><input type="text" name="on_guard_client_id" value="<?php echo esc_attr(get_option('on_guard_client_id')); ?>" /></td>
                </tr>
                <tr valign="top">
                    <th scope="row">Client Secret</th>
                    <td><input type="text" name="on_guard_client_secret" value="<?php echo esc_attr(get_option('on_guard_client_secret')); ?>" /></td>
                </tr>
            </table>
            <?php submit_button(); ?>
        </form>
        <p>To create an account and having credentials, visit our <a href="https://www.on-guard.eu/" target="_blank">website</a>.</p>
    </div>
    <?php
}

// Add Settings link to the plugin actions list (Plugins page)
function onguard_add_action_link($links) {
    // Create the Settings link
    $settings_link = '<a href="' . admin_url('admin.php?page=on-guard-settings') . '">Settings</a>';

    // Move the Settings link before Deactivate by swapping the positions
    array_splice($links, array_search('deactivate', array_keys($links)), 0, array($settings_link));

    return $links;
}

// Use the global variable defined in the main plugin file
add_filter('plugin_action_links_' . $on_guard_basename, 'onguard_add_action_link');
