<?php
/**
 * Settings page for One Click Delete Page and Post
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

add_action( 'admin_menu', 'dpp_add_settings_page' );
add_action( 'admin_init', 'dpp_register_settings' );

function dpp_add_settings_page() {
	add_options_page(
		__( 'One Click Delete Page and Post Settings', 'oneclick-delete-page-and-post' ),
		__( 'One Click Delete Page and Post', 'oneclick-delete-page-and-post' ),
		'manage_options',
		'dpp-settings',
		'dpp_render_settings_page'
	);
}

function dpp_register_settings() {
	register_setting(
		'dpp_settings_group',
		'dpp_show_confirm',
		array(
			'type'              => 'boolean',
			'description'       => __( 'Show confirmation before deleting a page or post', 'oneclick-delete-page-and-post' ),
			'sanitize_callback' => 'dpp_sanitize_show_confirm',
			'default'           => true,
		)
	);

	add_settings_section(
		'dpp_main_section',
		'',
		'__return_false',
		'dpp-settings'
	);

	add_settings_field(
		'dpp_show_confirm_field',
		__( 'Confirmation on delete', 'oneclick-delete-page-and-post' ),
		'dpp_render_show_confirm_field',
		'dpp-settings',
		'dpp_main_section'
	);
}

function dpp_sanitize_show_confirm( $value ) {
	if ( $value === '1' || $value === 1 || $value === true || $value === 'true' ) {
		return '1';
	}
	return '0';
}

function dpp_render_show_confirm_field() {
	$option = get_option( 'dpp_show_confirm', '1' );
	?>
	<label for="dpp_show_confirm">
		<input type="checkbox" id="dpp_show_confirm" name="dpp_show_confirm" value="1" <?php checked( '1', $option ); ?> />
		<?php esc_html_e( 'Show a confirmation dialog before deleting (recommended)', 'oneclick-delete-page-and-post' ); ?>
	</label>
	<p class="description">
		<?php esc_html_e( 'When enabled — a confirmation dialog is displayed before deleting pages or posts. If disabled — pages and posts will be deleted immediately without any confirmation.', 'oneclick-delete-page-and-post' ); ?>
	</p>
	<?php
}

function dpp_render_settings_page() {
	if ( ! current_user_can( 'manage_options' ) ) {
		return;
	}
	?>
	<div class="wrap">
		<h1><?php esc_html_e( 'One Click Delete Page and Post — Settings', 'oneclick-delete-page-and-post' ); ?></h1>

		<form method="post" action="options.php">
			<?php
			settings_fields( 'dpp_settings_group' );
			do_settings_sections( 'dpp-settings' );
			submit_button();
			?>

			<hr />

			<div style="background: #fff3cd; border-left: 4px solid #ffeeba; padding: 12px; margin-top: 16px;">
				<strong><?php esc_html_e( 'Warning!', 'oneclick-delete-page-and-post' ); ?></strong>
				<p style="margin:8px 0 0;">
					<?php esc_html_e( 'If you disable the confirmation dialog, pages and posts will be deleted immediately without any warning. This is potentially dangerous and increases the risk of accidental content loss. It is recommended to keep the confirmation enabled.', 'oneclick-delete-page-and-post' ); ?>
				</p>
			</div>
		</form>
	</div>
	<?php
}
