<?php
/**
 * Plugin Name:       NoBS-Mail View - Email Fallback Viewer in Browser
 * Plugin URI:        https://wpspins.com/?ref=nobs-mail-view-email-fallback-viewer-in-browser-plugin
 * Description:       Adds a "View in Browser" link to WordPress emails, solving HTML rendering issues by providing a browser-based fallback for email viewing.
 * Version:           1.0.1
 * Requires at least: 5.0
 * Requires PHP:      7.4
 * Author:            WPspin LLC
 * Author URI:        https://wpspins.com/
 * License:           GPL v2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       nobs-mail-view-email-fallback-viewer-in-browser
 * Domain Path:       /languages
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Define plugin constants
define( 'NOBSMV_VERSION', '1.0.1' );
define( 'NOBSMV_PLUGIN_FILE', __FILE__ );
define( 'NOBSMV_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'NOBSMV_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'NOBSMV_PLUGIN_BASENAME', plugin_basename( __FILE__ ) );

// Load core storage class
require_once NOBSMV_PLUGIN_DIR . 'includes/class-email-storage.php';

// Initialize email storage
$nobsmv_storage = new NOBSMV_Email_Storage();

// Load email interceptor (runs everywhere - emails can be sent from admin or frontend)
require_once NOBSMV_PLUGIN_DIR . 'includes/class-email-interceptor.php';
new NOBSMV_Email_Interceptor( $nobsmv_storage );

// Load settings page only in admin
if ( is_admin() ) {
	require_once NOBSMV_PLUGIN_DIR . 'includes/class-settings.php';
	new NOBSMV_Settings();
}

// Load frontend viewer only on frontend
if ( ! is_admin() ) {
	require_once NOBSMV_PLUGIN_DIR . 'includes/class-email-viewer.php';
	new NOBSMV_Email_Viewer( $nobsmv_storage );
}
