<?php
/**
 * Email Interceptor
 *
 * @package Email_Safe_View_Fallback_Viewer
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class NOBSMV_Email_Interceptor
 *
 * Intercepts outgoing emails and adds browser view link
 */
class NOBSMV_Email_Interceptor {

	/**
	 * Email storage instance
	 *
	 * @var NOBSMV_Email_Storage
	 */
	private $storage;

	/**
	 * Initialize the class
	 *
	 * @param NOBSMV_Email_Storage $storage Email storage instance
	 */
	public function __construct( $storage ) {
		$this->storage = $storage;
		add_filter( 'wp_mail', [ $this, 'intercept_outgoing_email' ], 9999 );
	}

	/**
	 * Intercept outgoing emails and add browser view link
	 *
	 * @param array $args wp_mail arguments
	 * @return array Modified wp_mail arguments
	 */
	public function intercept_outgoing_email( $args ) {
		// Check if plugin is enabled
		if ( ! get_option( 'nobsmv_enabled', true ) ) {
			return $args;
		}

		// Extract email details
		$to          = isset( $args['to'] ) ? $args['to'] : '';
		$subject     = isset( $args['subject'] ) ? $args['subject'] : '';
		$message     = isset( $args['message'] ) ? $args['message'] : '';
		$headers     = isset( $args['headers'] ) ? $args['headers'] : '';
		$attachments = isset( $args['attachments'] ) ? $args['attachments'] : [];

		// Handle multiple recipients
		$recipient_email = is_array( $to ) ? $to[0] : $to;

		// Store email and get post ID
		$post_id = $this->storage->store_email( $recipient_email, $subject, $message, $headers, $attachments );

		if ( ! $post_id ) {
			return $args;
		}

		// Get the generated token
		$token = get_post_meta( $post_id, '_nobsmv_access_token', true );

		// Generate browser view URL
		$view_url = home_url( '/email/?mid=' . $token );

		// Get custom message template
		$message_template = get_option( 'nobsmv_custom_message', 'Not seeing the email correctly. Use this link to read: {email_link}' );

		// Replace shortcode with actual URL
		$browser_link = str_replace( '{email_link}', $view_url, $message_template ) . "\n\n";

		// Get link position
		$position = get_option( 'nobsmv_link_position', 'prepend' );

		// Add browser link based on position
		if ( 'append' === $position ) {
			$args['message'] = $message . "\n\n" . $browser_link;
		} else {
			$args['message'] = $browser_link . $message;
		}

		return $args;
	}
}
