<?php
/*
 * Template Name: no-ai-article-template
 * Template Post Type: post
 */
if ( ! defined( 'ABSPATH' ) ) { exit; }
get_header();

// Get article folder ID from meta (e.g., article_1)
$article_folder = get_post_meta(get_the_ID(), 'noai_article_folder', true);

// If the meta exists, build CSS and font paths
if ($article_folder) {
    $base_url = site_url('/wp-content/uploads/noai-articles/' . $article_folder);
    $article_css_url = $base_url . '/style.css';
    $font_url = $base_url . '/Poppins-Regular.ttf';

    // Load CSS and font
    echo "<link rel='stylesheet' href='" . esc_url($article_css_url) . "'>";
    echo "<style>
        @font-face {
            font-family: 'Poppins';
            src: url('" . esc_url($font_url) . "') format('truetype');
        }
    </style>";
} else {
    echo '<!-- ⚠️ Meta "noai_article_folder" not found -->';
}
?>

<div class="noai-article-content">
  <?php the_content(); ?>
</div>

<!-- ✅ Show last 5 posts in grid -->
<?php
$cat_id = intval(get_option('noai_site_category', 0));
$args = [
    'post_type'      => 'post',
    'posts_per_page' => 5,
    'cat'            => $cat_id,
    'post_status'    => 'publish',
    'orderby'        => 'date',
    'order'          => 'DESC',
    'post__not_in'   => [get_the_ID()]
];
$q = new WP_Query($args);

if ($q->have_posts()):
?>
<div class="noai-grid-wrap">
  <?php while ($q->have_posts()): $q->the_post(); ?>
    <div class="noai-grid-item">
      <a href="<?php the_permalink(); ?>" rel="follow">
        <?php if (has_post_thumbnail()): ?>
          <?php the_post_thumbnail('large', ['class' => 'noai-grid-img']); ?>
        <?php endif; ?>
        <div class="noai-grid-text">
          <h3><?php the_title(); ?></h3>
          <p><?php echo get_the_date(); ?></p>
        </div>
      </a>
    </div>
  <?php endwhile; wp_reset_postdata(); ?>
</div>
<?php endif; ?>

<style>
.noai-grid-wrap {
  display: flex;
  flex-wrap: wrap;
  gap: 15px;
  margin: 40px 0;
  direction: ltr; /* ✅ English layout */
  font-family: 'Poppins', sans-serif;
}

.noai-grid-item {
  flex: 1 1 calc(20% - 15px); /* Default: 5 per row */
  background: #fff;
  border-radius: 12px;
  overflow: hidden;
  box-shadow: 0 6px 16px rgba(0,0,0,0.2);
}

.noai-grid-img {
  width: 100%;
  height: 150px;
  object-fit: cover;
}

.noai-grid-text {
  padding: 10px;
}

.noai-grid-text h3 {
  font-size: 14px;
  margin-bottom: 6px;
}

.noai-grid-text p {
  font-size: 12px;
  color: #666;
}

/* 📱 Mobile */
@media (max-width: 600px) {
  .noai-grid-item {
    flex: 1 1 100%; /* 1 card */
  }
  .noai-grid-img {
    height: 200px;
  }
}

/* 📲 Small tablet */
@media (min-width: 601px) and (max-width: 900px) {
  .noai-grid-item {
    flex: 1 1 calc(50% - 15px); /* 2 cards */
  }
}

/* 💻 Large tablet */
@media (min-width: 901px) and (max-width: 1200px) {
  .noai-grid-item {
    flex: 1 1 calc(33.333% - 15px); /* 3 cards */
  }
}

/* 🖥 Desktop */
@media (min-width: 1201px) {
  .noai-grid-item {
    flex: 1 1 calc(20% - 15px); /* 5 cards */
  }
}
</style>

<script>
document.addEventListener("DOMContentLoaded", function() {
  const faqs = document.querySelectorAll('.noai-faq-acc-q');
  faqs.forEach(btn => {
    btn.addEventListener('click', function() {
      let next = btn.nextElementSibling;
      while (next && !next.classList.contains('noai-faq-acc-a')) {
        next = next.nextElementSibling;
      }
      if (next) {
        btn.classList.toggle('active');
        next.style.display = (next.style.display === "block") ? "none" : "block";
      }
    });
  });
});
</script>

<?php get_footer(); ?>   