<?php
/**
 * @package           PluginPackage
 * @author            Jeroen Visbeek
 * @copyright         2025 Zodisign
 * @license           GPL-2.0-or-later
 *
 * @wordpress-plugin  
 * Plugin Name:       Nine Star Ki
 * Plugin URI:        https://wordpress.org/plugins/nine-star-ki/
 * Description:       Insert the Nine Star Ki calculator in a page with a shortcode.
 * Version:           1.1.1
 * Requires at least: 6.8
 * Requires PHP:      7.0
 * Author:            Jeroen Visbeek
 * Author URI:        https://wp-plugins.zodisign.fr
 * Text Domain:       nine-star-ki
 * Domain Path:       /languages
 * License:           GPL v2 or later
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt

WordPress short code: [ninestarki]
 */

// Prevent direct access to the file
if (!defined("ABSPATH")) {
    exit();
}

// Add settings page
function ninestarki_settings_menu()
{
    add_options_page(
        "Ninestarki Settings",
        "Nine Star Ki",
        "manage_options",
        "ninestarki-settings",
        "ninestarki_settings_page"
    );
}   
add_action("admin_menu", "ninestarki_settings_menu");

// Set language
if (
    get_option("ninestarki_language") == ""
        ? ($nstarki_taal = str_replace("-", "_", get_bloginfo("language")))
        : ($nstarki_taal = get_option("ninestarki_language"))
);
if (!file_exists(dirname(__FILE__) . "/languages/" . $nstarki_taal . "-nsk.php")) {
 	$nstarki_taal = "en_EN";
}
if (file_exists(dirname(__FILE__) . "/languages/custom-nsk.php")) {
    $nstarki_taal = "custom";
}
include dirname(__FILE__) . "/languages/" . $nstarki_taal . "-nsk.php";

// Show link settings page on plugin page
function ninestarki_settings_page()
{
?>
<div class="wrap">
  <h1>Ninestarki Calculator Settings</h1>
  <form method="post" action="options.php">
    <?php
    settings_fields("ninestarki_options_group");
    do_settings_sections("ninestarki-settings");
    submit_button();
    echo "Help to improve the translations, please send your improved translation to <a href='mailto:info@zodisign.fr'>info@zodisign.fr</a>.";?>
  </form>
</div>
<?php
}

//Register settings
function ninestarki_register_settings()
{
    global $nstarki_lang;
    
	add_option( "ninestarki_first_install", true, "", "yes" );
	
    //restore defaulst or save options once on activation
	
    if (get_option("ninestarki_restore_defaults") == 1 || get_option("ninestarki_first_install") == true ) {
        update_option(
            "ninestarki_title_year",
            $nstarki_lang["TEXT_NAME_FIRST_NUMBER"]
        );
        update_option(
            "ninestarki_title_month",
            $nstarki_lang["TEXT_NAME_SECOND_NUMBER"]
        );
        update_option(
            "ninestarki_title_expression",
            $nstarki_lang["TEXT_NAME_THIRD_NUMBER"]
        );
        update_option(
            "ninestarki_character_first_number_1",
            $nstarki_lang["TEXT_NAME_FIRST_NUMBER_1"]
        );
        update_option(
            "ninestarki_character_first_number_2",
            $nstarki_lang["TEXT_NAME_FIRST_NUMBER_2"]
        );
        update_option(
            "ninestarki_character_first_number_3",
            $nstarki_lang["TEXT_NAME_FIRST_NUMBER_3"]
        );
        update_option(
            "ninestarki_character_first_number_4",
            $nstarki_lang["TEXT_NAME_FIRST_NUMBER_4"]
        );
        update_option(
            "ninestarki_character_first_number_5",
            $nstarki_lang["TEXT_NAME_FIRST_NUMBER_5"]
        );
        update_option(
            "ninestarki_character_first_number_6",
            $nstarki_lang["TEXT_NAME_FIRST_NUMBER_6"]
        );
        update_option(
            "ninestarki_character_first_number_7",
            $nstarki_lang["TEXT_NAME_FIRST_NUMBER_7"]
        );
        update_option(
            "ninestarki_character_first_number_8",
            $nstarki_lang["TEXT_NAME_FIRST_NUMBER_8"]
        );
        update_option(
            "ninestarki_character_first_number_9",
            $nstarki_lang["TEXT_NAME_FIRST_NUMBER_9"]
        );
		update_option(
            "ninestarki_description_1",
            $nstarki_lang["TEXT_DESCRIPTION_CHARACTER_NUMBER_1"]
        );
        update_option(
            "ninestarki_description_2",
            $nstarki_lang["TEXT_DESCRIPTION_CHARACTER_NUMBER_2"]
        );
        update_option(
            "ninestarki_description_3",
            $nstarki_lang["TEXT_DESCRIPTION_CHARACTER_NUMBER_3"]
        );
        update_option(
            "ninestarki_description_4",
            $nstarki_lang["TEXT_DESCRIPTION_CHARACTER_NUMBER_4"]
        );
        update_option(
            "ninestarki_description_5",
            $nstarki_lang["TEXT_DESCRIPTION_CHARACTER_NUMBER_5"]
        );
        update_option(
            "ninestarki_description_6",
            $nstarki_lang["TEXT_DESCRIPTION_CHARACTER_NUMBER_6"]
        );
        update_option(
            "ninestarki_description_7",
            $nstarki_lang["TEXT_DESCRIPTION_CHARACTER_NUMBER_7"]
        );
        update_option(
            "ninestarki_description_8",
            $nstarki_lang["TEXT_DESCRIPTION_CHARACTER_NUMBER_8"]
        );
        update_option(
            "ninestarki_description_9",
            $nstarki_lang["TEXT_DESCRIPTION_CHARACTER_NUMBER_9"]
        );
		update_option(
            "ninestarki_first_install", false
        );
     }   
    
	$args = array(
			'type' => 'string', 
			'sanitize_callback' => 'sanitize_text_field',
			'default' => NULL,
			);
    
    register_setting("ninestarki_options_group", "ninestarki_language", $args);
    add_settings_field(
        "ninestarki_language_field",
        $nstarki_lang["TEXT_LANGUAGE"],
        function (){
			global $nstarki_taal;
            $value = $nstarki_taal;
            echo '<select name="ninestarki_language">';
            if (file_exists(dirname(__FILE__) . "/languages/custom-nsk.php")) {
            echo '<option value="custom" selected>* Custom language file installed *</option>';
            $value = "";
            }
            echo '<option value="en_EN"';
            if ($value == "en_EN") {
                echo " selected ";
            }
            echo ">English</option>";
            echo '<option value="es_ES"';
            if ($value == "es_ES") {
                echo " selected ";
            }
            echo ">Español</option>";
            echo '<option value="fr_FR"';
            if ($value == "fr_FR") {
                echo " selected ";
            }
            echo ">Français</option>";
            echo '<option value="de_DE"';
            if ($value == "de_DE") {
                echo " selected ";
            }
            echo ">Deutsch</option>";
            echo '<option value="hi_IN"';
            if ($value == "hi_IN") {
                echo " selected ";
            }
            echo ">हिन्दी</option>";
            echo '<option value="fa_IR"';
            if ($value == "fa_IR") {
                echo " selected ";
            }
            echo ">فارسی</option>";
            echo '<option value="ar_SA"';
            if ($value == "ar_SA") {
                echo " selected ";
            }
            echo ">عربي</option>";
            echo '<option value="zh_CN"';
            if ($value == "zh_CN") {
                echo " selected ";
            }
            echo ">中国人</option>";
            echo '<option value="jv_ID"';
            if ($value == "jv_ID") {
                echo " selected ";
            }
            echo ">Bahasa Indonesia (Jawa)</option>";
            echo '<option value="it_IT"';
            if ($value == "it_IT") {
                echo " selected ";
            }
            echo ">Italiano</option>";
            echo '<option value="ja_JP"';
            if ($value == "ja_JP") {
                echo " selected ";
            }
            echo ">日本語</option>";
            echo '<option value="nl_NL"';
            if ($value == "nl_NL") {
                echo " selected ";
            }
            echo ">Nederlands</option>";
            echo '<option value="ms_MY"';
            if ($value == "ms_MY") {
                echo " selected ";
            }
            echo ">Malaysia</option>";
            echo '<option value="pl_PL"';
            if ($value == "pl_PL") {
                echo " selected ";
            }
            echo ">Polski</option>";
            echo '<option value="pt_PT"';
            if ($value == "pt_PT") {
                echo " selected ";
            }
            echo ">Português</option>";
            echo '<option value="ru_RU"';
            if ($value == "ru_RU") {
                echo " selected ";
            }
            echo ">Русский</option>";
            echo '<option value="tr_TR"';
            if ($value == "tr_TR") {
                echo " selected ";
            }
            echo ">Türkçe</option>";
            echo "</select>";
        },
        "ninestarki-settings",
        "ninestarki_main_section"
    );
    register_setting("ninestarki_options_group", "ninestarki_restore_defaults", $args);
    add_settings_field(
        "ninestarki_restore_field",
        $nstarki_lang["TEXT_RESTORE-DEFAULTS"],
        function (){
            echo '<input type="checkbox" id="ninestarki_restore_defaults" name="ninestarki_restore_defaults" value="1" /><label for="ninestarki_restore_defaults"></label>';
        },
        "ninestarki-settings",
        "ninestarki_main_section"
    );
    register_setting("ninestarki_options_group", "ninestarki_title_year", [
        "type" => "string",
        "sanitize_callback" => "sanitize_text_field",
    ]);
    add_settings_field(
        "ninestarki_title_year_field",
        $nstarki_lang["TEXT_FIRST_NUMBER"],
        function (){
            global $nstarki_lang;
            $value = get_option(
                "ninestarki_title_year",
                $nstarki_lang["TEXT_NAME_FIRST_NUMBER"]
            );
            if ($value == "" || $value == null) {
                $value = $nstarki_lang["TEXT_NAME_FIRST_NUMBER"];
            }
            echo '<input type="text" name="ninestarki_title_year" value="' .
                esc_attr($value) .
                '" />';
        },
        "ninestarki-settings",
        "ninestarki_main_section"
    );
    register_setting("ninestarki_options_group", "ninestarki_title_month", [
        "type" => "string",
        "sanitize_callback" => "sanitize_text_field",
    ]);
    add_settings_field(
        "ninestarki_title_month_field",
        $nstarki_lang["TEXT_SECOND_NUMBER"],
        function (){
            global $nstarki_lang;
            $value = get_option(
                "ninestarki_title_month",
                $nstarki_lang["TEXT_NAME_SECOND_NUMBER"]
            );
            if ($value == "" || $value == null) {
                $value = $nstarki_lang["TEXT_NAME_SECOND_NUMBER"];
            }
            echo '<input type="text" name="ninestarki_title_month" value="' .
                esc_attr($value) .
                '" />';
        },
        "ninestarki-settings",
        "ninestarki_main_section"
    );
    register_setting(
        "ninestarki_options_group",
        "ninestarki_title_expression",
        [
            "type" => "string",
            "sanitize_callback" => "sanitize_text_field",
        ]
    );
    add_settings_field(
        "ninestarki_title_expression_field",
        $nstarki_lang["TEXT_THIRD_NUMBER"],
        function (){
            global $nstarki_lang;
            $value = get_option(
                "ninestarki_title_expression",
                $nstarki_lang["TEXT_NAME_THIRD_NUMBER"]
            );
            if ($value == "" || $value == null) {
                $value = $nstarki_lang["TEXT_NAME_THIRD_NUMBER"];
            }
            echo '<input type="text" name="ninestarki_title_expression" value="' .
                esc_attr($value) .
                '"/>';
        },
        "ninestarki-settings",
        "ninestarki_main_section"
    );
	
	
   register_setting("ninestarki_options_group", "ninestarki_character_first_number_1", [
        "type" => "string",
        "sanitize_callback" => "sanitize_text_field",
    ]);
 add_settings_field(
        "ninestarki_character_first_number_1_field",
        $nstarki_lang["TEXT_CHARACTER_FIRST_NUMBER1"],
        function (){
            global $nstarki_lang;
            $value = get_option(
                "ninestarki_character_first_number_1",
                $nstarki_lang["TEXT_NAME_FIRST_NUMBER_1"]
            );
            if ($value == "" || $value == null) {
                $value = $nstarki_lang["TEXT_NAME_FIRST_NUMBER_1"];
            }
            echo '<textarea rows="1" cols="50" name="ninestarki_character_first_number_1">' .
                esc_attr($value) .
                "</textarea>";
        },
        "ninestarki-settings",
        "ninestarki_main_section"
    );

    register_setting("ninestarki_options_group", "ninestarki_description_1", $args);
    add_settings_field(
        "ninestarki_description_1_field",
        $nstarki_lang["TEXT_CHARACTER_DESCRIPTION1"],
        function () {
            global $nstarki_lang;
            echo '<textarea rows="4" cols="50" name="ninestarki_description_1">' .
                esc_attr($nstarki_lang["TEXT_DESCRIPTION_CHARACTER_NUMBER_1"]) .
                "</textarea>";
        },
        "ninestarki-settings",
        "ninestarki_main_section"
    );
	
	register_setting("ninestarki_options_group", "ninestarki_character_first_number_2", [
        "type" => "string",
        "sanitize_callback" => "sanitize_text_field",
    ]);
 add_settings_field(
        "ninestarki_character_first_number_2_field",
        $nstarki_lang["TEXT_CHARACTER_FIRST_NUMBER2"],
        function (){
            global $nstarki_lang;
            $value = get_option(
                "ninestarki_character_first_number_2",
                $nstarki_lang["TEXT_NAME_FIRST_NUMBER_2"]
            );
            if ($value == "" || $value == null) {
                $value = $nstarki_lang["TEXT_NAME_FIRST_NUMBER_2"];
            }
            echo '<textarea rows="1" cols="50" name="ninestarki_character_first_number_2">' .
                esc_attr($value) .
                "</textarea>";
        },
        "ninestarki-settings",
        "ninestarki_main_section"
    );

    register_setting("ninestarki_options_group", "ninestarki_description_2", $args);
    add_settings_field(
        "ninestarki_description_2_field",
        $nstarki_lang["TEXT_CHARACTER_DESCRIPTION2"],
        function () {
            global $nstarki_lang;
            echo '<textarea rows="4" cols="50" name="ninestarki_description_2">' .
                esc_attr($nstarki_lang["TEXT_DESCRIPTION_CHARACTER_NUMBER_2"]) .
                "</textarea>";
        },
        "ninestarki-settings",
        "ninestarki_main_section"
    );
	
	register_setting("ninestarki_options_group", "ninestarki_character_first_number_3", [
        "type" => "string",
        "sanitize_callback" => "sanitize_text_field",
    ]);
 add_settings_field(
        "ninestarki_character_first_number_3_field",
        $nstarki_lang["TEXT_CHARACTER_FIRST_NUMBER3"],
        function (){
            global $nstarki_lang;
            $value = get_option(
                "ninestarki_character_first_number_3",
                $nstarki_lang["TEXT_NAME_FIRST_NUMBER_3"]
            );
            if ($value == "" || $value == null) {
                $value = $nstarki_lang["TEXT_NAME_FIRST_NUMBER_3"];
            }
            echo '<textarea rows="1" cols="50" name="ninestarki_character_first_number_3">' .
                esc_attr($value) .
                "</textarea>";
        },
        "ninestarki-settings",
        "ninestarki_main_section"
    );

    register_setting("ninestarki_options_group", "ninestarki_description_3", $args);
    add_settings_field(
        "ninestarki_description_3_field",
        $nstarki_lang["TEXT_CHARACTER_DESCRIPTION3"],
        function () {
            global $nstarki_lang;
            echo '<textarea rows="4" cols="50" name="ninestarki_description_3">' .
                esc_attr($nstarki_lang["TEXT_DESCRIPTION_CHARACTER_NUMBER_3"]) .
                "</textarea>";
        },
        "ninestarki-settings",
        "ninestarki_main_section"
    );
	
	register_setting("ninestarki_options_group", "ninestarki_character_first_number_4", [
        "type" => "string",
        "sanitize_callback" => "sanitize_text_field",
    ]);
 add_settings_field(
        "ninestarki_character_first_number_4_field",
        $nstarki_lang["TEXT_CHARACTER_FIRST_NUMBER4"],
        function (){
            global $nstarki_lang;
            $value = get_option(
                "ninestarki_character_first_number_4",
                $nstarki_lang["TEXT_NAME_FIRST_NUMBER_4"]
            );
            if ($value == "" || $value == null) {
                $value = $nstarki_lang["TEXT_NAME_FIRST_NUMBER_4"];
            }
            echo '<textarea rows="1" cols="50" name="ninestarki_character_first_number_4">' .
                esc_attr($value) .
                "</textarea>";
        },
        "ninestarki-settings",
        "ninestarki_main_section"
    );

    register_setting("ninestarki_options_group", "ninestarki_description_4", $args);
    add_settings_field(
        "ninestarki_description_4_field",
        $nstarki_lang["TEXT_CHARACTER_DESCRIPTION4"],
        function () {
            global $nstarki_lang;
            echo '<textarea rows="4" cols="50" name="ninestarki_description_4">' .
                esc_attr($nstarki_lang["TEXT_DESCRIPTION_CHARACTER_NUMBER_4"]) .
                "</textarea>";
        },
        "ninestarki-settings",
        "ninestarki_main_section"
    );
	
	register_setting("ninestarki_options_group", "ninestarki_character_first_number_5", [
        "type" => "string",
        "sanitize_callback" => "sanitize_text_field",
    ]);
 add_settings_field(
        "ninestarki_character_first_number_5_field",
        $nstarki_lang["TEXT_CHARACTER_FIRST_NUMBER5"],
        function (){
            global $nstarki_lang;
            $value = get_option(
                "ninestarki_character_first_number_5",
                $nstarki_lang["TEXT_NAME_FIRST_NUMBER_5"]
            );
            if ($value == "" || $value == null) {
                $value = $nstarki_lang["TEXT_NAME_FIRST_NUMBER_5"];
            }
            echo '<textarea rows="1" cols="50" name="ninestarki_character_first_number_5">' .
                esc_attr($value) .
                "</textarea>";
        },
        "ninestarki-settings",
        "ninestarki_main_section"
    );

    register_setting("ninestarki_options_group", "ninestarki_description_5", $args);
    add_settings_field(
        "ninestarki_description_5_field",
        $nstarki_lang["TEXT_CHARACTER_DESCRIPTION5"],
        function () {
            global $nstarki_lang;
            echo '<textarea rows="4" cols="50" name="ninestarki_description_5">' .
                esc_attr($nstarki_lang["TEXT_DESCRIPTION_CHARACTER_NUMBER_5"]) .
                "</textarea>";
        },
        "ninestarki-settings",
        "ninestarki_main_section"
    );
	
	register_setting("ninestarki_options_group", "ninestarki_character_first_number_6", [
        "type" => "string",
        "sanitize_callback" => "sanitize_text_field",
    ]);
 add_settings_field(
        "ninestarki_character_first_number_6_field",
        $nstarki_lang["TEXT_CHARACTER_FIRST_NUMBER6"],
        function (){
            global $nstarki_lang;
            $value = get_option(
                "ninestarki_character_first_number_6",
                $nstarki_lang["TEXT_NAME_FIRST_NUMBER_6"]
            );
            if ($value == "" || $value == null) {
                $value = $nstarki_lang["TEXT_NAME_FIRST_NUMBER_6"];
            }
            echo '<textarea rows="1" cols="50" name="ninestarki_character_first_number_6">' .
                esc_attr($value) .
                "</textarea>";
        },
        "ninestarki-settings",
        "ninestarki_main_section"
    );

    register_setting("ninestarki_options_group", "ninestarki_description_6", $args);
    add_settings_field(
        "ninestarki_description_6_field",
        $nstarki_lang["TEXT_CHARACTER_DESCRIPTION6"],
        function () {
            global $nstarki_lang;
            echo '<textarea rows="4" cols="50" name="ninestarki_description_6">' .
                esc_attr($nstarki_lang["TEXT_DESCRIPTION_CHARACTER_NUMBER_6"]) .
                "</textarea>";
        },
        "ninestarki-settings",
        "ninestarki_main_section"
    );
	
	register_setting("ninestarki_options_group", "ninestarki_character_first_number_7", [
        "type" => "string",
        "sanitize_callback" => "sanitize_text_field",
    ]);
 add_settings_field(
        "ninestarki_character_first_number_7_field",
        $nstarki_lang["TEXT_CHARACTER_FIRST_NUMBER7"],
        function (){
            global $nstarki_lang;
            $value = get_option(
                "ninestarki_character_first_number_7",
                $nstarki_lang["TEXT_NAME_FIRST_NUMBER_7"]
            );
            if ($value == "" || $value == null) {
                $value = $nstarki_lang["TEXT_NAME_FIRST_NUMBER_7"];
            }
            echo '<textarea rows="1" cols="50" name="ninestarki_character_first_number_7">' .
                esc_attr($value) .
                "</textarea>";
        },
        "ninestarki-settings",
        "ninestarki_main_section"
    );

    register_setting("ninestarki_options_group", "ninestarki_description_7", $args);
    add_settings_field(
        "ninestarki_description_7_field",
        $nstarki_lang["TEXT_CHARACTER_DESCRIPTION7"],
        function () {
            global $nstarki_lang;
            echo '<textarea rows="4" cols="50" name="ninestarki_description_7">' .
                esc_attr($nstarki_lang["TEXT_DESCRIPTION_CHARACTER_NUMBER_7"]) .
                "</textarea>";
        },
        "ninestarki-settings",
        "ninestarki_main_section"
    );
	
	register_setting("ninestarki_options_group", "ninestarki_character_first_number_8", [
        "type" => "string",
        "sanitize_callback" => "sanitize_text_field",
    ]);
 add_settings_field(
        "ninestarki_character_first_number_8_field",
        $nstarki_lang["TEXT_CHARACTER_FIRST_NUMBER8"],
        function (){
            global $nstarki_lang;
            $value = get_option(
                "ninestarki_character_first_number_8",
                $nstarki_lang["TEXT_NAME_FIRST_NUMBER_8"]
            );
            if ($value == "" || $value == null) {
                $value = $nstarki_lang["TEXT_NAME_FIRST_NUMBER_8"];
            }
            echo '<textarea rows="1" cols="50" name="ninestarki_character_first_number_8">' .
                esc_attr($value) .
                "</textarea>";
        },
        "ninestarki-settings",
        "ninestarki_main_section"
    );

    register_setting("ninestarki_options_group", "ninestarki_description_8", $args);
    add_settings_field(
        "ninestarki_description_8_field",
        $nstarki_lang["TEXT_CHARACTER_DESCRIPTION8"],
        function () {
            global $nstarki_lang;
            echo '<textarea rows="4" cols="50" name="ninestarki_description_8">' .
                esc_attr($nstarki_lang["TEXT_DESCRIPTION_CHARACTER_NUMBER_8"]) .
                "</textarea>";
        },
        "ninestarki-settings",
        "ninestarki_main_section"
    );
	
	register_setting("ninestarki_options_group", "ninestarki_character_first_number_9", [
        "type" => "string",
        "sanitize_callback" => "sanitize_text_field",
    ]);
 add_settings_field(
        "ninestarki_character_first_number_9_field",
        $nstarki_lang["TEXT_CHARACTER_FIRST_NUMBER9"],
        function (){
            global $nstarki_lang;
            $value = get_option(
                "ninestarki_character_first_number_9",
                $nstarki_lang["TEXT_NAME_FIRST_NUMBER_9"]
            );
            if ($value == "" || $value == null) {
                $value = $nstarki_lang["TEXT_NAME_FIRST_NUMBER_9"];
            }
            echo '<textarea rows="1" cols="50" name="ninestarki_character_first_number_9">' .
                esc_attr($value) .
                "</textarea>";
        },
        "ninestarki-settings",
        "ninestarki_main_section"
    );

    register_setting("ninestarki_options_group", "ninestarki_description_9", $args);
    add_settings_field(
        "ninestarki_description_9_field",
        $nstarki_lang["TEXT_CHARACTER_DESCRIPTION9"],
        function () {
            global $nstarki_lang;
            echo '<textarea rows="4" cols="50" name="ninestarki_description_9">' .
                esc_attr($nstarki_lang["TEXT_DESCRIPTION_CHARACTER_NUMBER_9"]) .
                "</textarea>";
        },
        "ninestarki-settings",
        "ninestarki_main_section"
    );
	
    add_settings_section(
        "ninestarki_main_section",
        "Make your own descriptions of the calculator.<br>Add Nine Star Ki tool in a page or widget by using this shortcode: [ninestarki]",
        null,
        "ninestarki-settings"
    );
}

add_action("admin_init", "ninestarki_register_settings");


//Add a Link to Your Plugin Settings Page in The WordPress Plugin List
add_filter( 'plugin_action_links_' . plugin_basename(__FILE__), 'nstarki_settings_link1' );
function nstarki_settings_link1( array $links ) {
    // Build and escape the URL.
    $url = esc_url(
        add_query_arg(
            "page",
            "ninestarki-settings",
            get_admin_url() . "admin.php"
        )
    );
	$settings_link = '<a href="' . $url . '">' . __('Settings', 'nine-star-ki') . '</a>';
      $links[] = $settings_link;
    return $links;
  }

//Add a Link to Your Plugin Settings Page in The WordPress Plugin List
add_filter( 'plugin_action_links_' . plugin_basename(__FILE__), 'nstarki_settings_link2' );
function nstarki_settings_link2( array $links ) {
	$settings_link = '<a href="https://wp-plugins.zodisign.fr/nine-star-ki-calculator/">Get Pro version</a>';
      $links[] = $settings_link;
    return $links;
  }

function nstarki_html_form_code()
{
	global $nstarki_lang;
	global $nstarki_lang_elementen;
	

    $jaargetallen = [
        1 => [9, 5, 7, 8, 1, 3, 4, 6, 2],
        2 => [1, 6, 8, 9, 2, 4, 5, 7, 3],
        3 => [2, 7, 9, 1, 3, 5, 6, 8, 4],
        4 => [3, 8, 1, 2, 4, 6, 7, 9, 5],
        5 => [4, 9, 2, 3, 5, 7, 8, 1, 6],
        6 => [5, 1, 3, 4, 6, 8, 9, 2, 7],
        7 => [6, 2, 4, 5, 7, 9, 1, 3, 8],
        8 => [7, 3, 5, 6, 8, 1, 2, 4, 9],
        9 => [8, 4, 6, 7, 9, 2, 3, 5, 1],
    ];

    // content plugin
    ?>
<div class="container-nsk">
<form action="<?php echo (!empty(esc_url(wp_kses_post(wp_unslash($_SERVER["REQUEST_URI"])))) ? esc_url(wp_kses_post(wp_unslash($_SERVER["REQUEST_URI"]))) : "/nine-star-ki/");
      ?>" method="post" name="formnsk" id="formnsk">
    <?php wp_nonce_field('formulier_verwerken'); ?>
<h1 class="ninestarki_title"><?php echo esc_html($nstarki_lang["PAGE_TITLE"]); ?></h1>
<p>
  <?php echo esc_html($nstarki_lang["TEXT_BRITHDATE"]); ?>
</p>
<div style="height: 80px">
	<?php
	if (isset($_POST["cf-submitted"])) {
    $retrieved_nonce = (!empty(wp_kses_post(wp_unslash($_REQUEST['_wpnonce']))) ? wp_kses_post(wp_unslash($_REQUEST['_wpnonce'])) : "");
        if (!wp_verify_nonce($retrieved_nonce, 'formulier_verwerken' ) ) die( 'Failed security check' );
    
    $geboortedatum = !empty(wp_kses_post(wp_unslash($_POST["geboortedatum"]))) ? wp_kses_post(wp_unslash($_POST["geboortedatum"])) : "1980-01-01";
	} else {
		$geboortedatum = "1980-01-01";
	}
	?>
<input type="date" name="geboortedatum" value="<?php echo esc_html($geboortedatum);?>" max="<?php echo esc_html(gmdate("Y") + 2); ?>-12-31" /> <input type="submit" name="cf-submitted" value="<?php echo esc_html(
      $nstarki_lang["TEXT_BUTTON_CALCULATE"]
  ); ?>">
</div>
<?php 
	if (isset($_POST["cf-submitted"])) {
    $retrieved_nonce = (!empty(wp_kses_post(wp_unslash($_REQUEST['_wpnonce']))) ? wp_kses_post(wp_unslash($_REQUEST['_wpnonce'])) : "");
        if (!wp_verify_nonce($retrieved_nonce, 'formulier_verwerken' ) ) die( 'Failed security check' );
    
    $geboortedatum = !empty(wp_kses_post(wp_unslash($_POST["geboortedatum"]))) ? wp_kses_post(wp_unslash($_POST["geboortedatum"])) : "1980-01-01";
	
	$datumtijd = strtotime($geboortedatum . " 12:00");

	$DD = gmdate('j',$datumtijd);
  	$MM = gmdate('n',$datumtijd);
   	$YY = gmdate('Y',$datumtijd);
	$HR = gmdate('H',$datumtijd);
	$MN = gmdate('i',$datumtijd);
	
    $TZ = 0;  // Timezone
 
    $LONDEG = 15; // lengtegraden
    $LONEW = 1; // -1 westerlengte
    $LONMIN = 0; // minuten + seconden
    $LON = ($LONDEG + $LONMIN / 60) * $LONEW; // minuten naar 0-100 voor berekening javascript

    // Start calculating
    //Software designed only for years after 1900
    $GEN = 1; //eval(formnsk.geslacht.value);
    $gon = [
        "-Water [Gui]",
        "+Wood [Jia]",
        "-Wood [Yi]",
        "+Fire [Bing]",
        "-Fire [Ding]",
        "+Earth [Wu]",
        "-Earth [Ji]",
        "+Metal [Geng]",
        "-Metal [Xin]",
        "+Water [Ren]",
        "-Water [Gui]",
    ];
    $ji = [
        "Pig [Hai]",
        "Rat [Zi]",
        "Ox [Chou]",
        "Tiger [Yin]",
        "Rabbit [Mao]",
        "Dragon [Chen]",
        "Snake [Si]",
        "Horse [Wu]",
        "Goat [Wei]",
        "Monkey [Shen]",
        "Rooster [You]",
        "Dog [Xu]",
        "Pig [Hai]",
        "Rat [Zi]",
    ];

    $HR = $HR + $MN / 60;
    if ($LON > -181 && $LON < 181) {
        $HR = $HR + ($LON / 15 - $TZ);
    }
    $AAA = 1;
    if ($YY <= 1585) {
        $AAA = 0;
    }
    $JD = -1 * floor((7 * (floor(($MM + 9) / 12) + $YY)) / 4);
    $S = 1;
    if ($MM - 9 < 0) {
        $S = -1;
    }
    $A = abs($MM - 9);
    $J1 = floor($YY + $S * floor($A / 7));
    $J1 = -1 * floor(((floor($J1 / 100) + 1) * 3) / 4);
    $JD = $JD + floor((275 * $MM) / 9) + $DD + $AAA * $J1;
    $JD = $JD + 1721027 + 2 * $AAA + 367 * $YY - 0.5;
    $JZJD = $JD + $HR / 24;
    $JD = $JD + $HR / 24 - $TZ / 24;
    $T = ($JD - 2451545.0) / 36525;
    $d = (2 * pi()) / 360;
    $M =
        357.5291 +
        35999.0503 * $T -
        0.0001559 * $T * $T -
        0.00000048 * $T * $T * $T;
    $L0 = 280.46645 + 36000.76983 * $T + 0.0003032 * $T * $T;
    $DL = (1.9146 - 0.004817 * $T - 0.000014 * $T * $T) * sin($d * $M);
    $DL =
        $DL +
        (0.019993 - 0.000101 * $T) * sin($d * 2 * $M) +
        0.00029 * sin($d * 3 * $M);
    $L = $L0 + $DL;

    $YEFL = 0;
    for ($i = 0; $L > 360; $i++) {
        $L = $L - 360;
    }
    for ($i = 0; $L < 0; $i++) {
        $L = $L + 360;
    }
    if ($L < 315 && ($MM == 1 || $MM == 2)) {
        $ys0 = $YY - 4;
        $yb0 = $YY - 4;
        $YEFL = 1;
    } else {
        $ys0 = $YY - 3;
        $yb0 = $YY - 3;
    }
    for ($i = 0; $ys0 > 10; $i++) {
        $ys0 = $ys0 - 10;
    }
    $ys = $gon[$ys0];
    for ($i = 0; $yb0 > 12; $i++) {
        $yb0 = $yb0 - 12;
    }
    if (
        $ys0 == 0 ||
        $ys0 == 2 ||
        $ys0 == 4 ||
        $ys0 == 6 ||
        $ys0 == 8 ||
        $ys0 == 10
    ) {
        $FW = -1 * $GEN;
    } else {
        $FW = 1 * $GEN;
    }
    $yb = $ji[$yb0];
    $ms0 = 1;
    for ($i = 0; $i < 6; $i++) {
        if ($ys0 == $i || $ys0 == $i + 5) {
            $ms0 = $ms0 + $i * 2;
            if ($ms0 > 10) {
                $ms0 = $ms0 - 10;
            }
        }
    }
    if (($L == 315 || $L > 315) && $L < 345) {
        $mb = $ji[3];
        $lpb0 = 3;
        $cb = $ji[6];
        $nsb = 2;
        if ($FW == 1) {
            $LP = (345 - $L) / 3;
        } else {
            $LP = ($L - 315) / 3;
        }
    }
    if ($L == 345 || $L > 345 || $L < 15) {
        $mb = $ji[4];
        $lpb0 = 4;
        $cb = $ji[7];
        $nsb = 3;
        $ms0 = $ms0 + 1;
        if ($FW == 1) {
            $LP = (375 - $L) / 3;
        } else {
            $LP = ($L - 345) / 3;
        }
        if ($LP > 11) {
            $LP = $LP - 120;
        }
        if ($LP < 0) {
            $LP = $LP + 120;
        }
    }
    if (($L == 15 || $L > 15) && $L < 45) {
        $mb = $ji[5];
        $lpb0 = 5;
        $cb = $ji[8];
        $nsb = 4;
        $ms0 = $ms0 + 2;
        if ($FW == 1) {
            $LP = (45 - $L) / 3;
        } else {
            $LP = ($L - 15) / 3;
        }
    }
    if (($L == 45 || $L > 45) && $L < 75) {
        $mb = $ji[6];
        $lpb0 = 6;
        $cb = $ji[9];
        $nsb = 5;
        $ms0 = $ms0 + 3;
        if ($FW == 1) {
            $LP = (75 - $L) / 3;
        } else {
            $LP = ($L - 45) / 3;
        }
    }
    if (($L == 75 || $L > 75) && $L < 105) {
        $mb = $ji[7];
        $lpb0 = 7;
        $cb = $ji[10];
        $nsb = 6;
        $ms0 = $ms0 + 4;
        if ($FW == 1) {
            $LP = (105 - $L) / 3;
        } else {
            $LP = ($L - 75) / 3;
        }
    }
    if (($L == 105 || $L > 105) && $L < 135) {
        $mb = $ji[8];
        $lpb0 = 8;
        $cb = $ji[11];
        $nsb = 7;
        $ms0 = $ms0 + 5;
        if ($FW == 1) {
            $LP = (135 - $L) / 3;
        } else {
            $LP = ($L - 105) / 3;
        }
    }
    if (($L == 135 || $L > 135) && $L < 165) {
        $mb = $ji[9];
        $lpb0 = 9;
        $cb = $ji[12];
        $nsb = 8;
        $ms0 = $ms0 + 6;
        if ($FW == 1) {
            $LP = (165 - $L) / 3;
        } else {
            $LP = ($L - 135) / 3;
        }
    }
    if (($L == 165 || $L > 165) && $L < 195) {
        $mb = $ji[10];
        $lpb0 = 10;
        $cb = $ji[1];
        $nsb = 9;
        $ms0 = $ms0 + 7;
        if ($FW == 1) {
            $LP = (195 - $L) / 3;
        } else {
            $LP = ($L - 165) / 3;
        }
    }
    if (($L == 195 || $L > 195) && $L < 225) {
        $mb = $ji[11];
        $lpb0 = 11;
        $cb = $ji[2];
        $nsb = 10;
        $ms0 = $ms0 + 8;
        if ($FW == 1) {
            $LP = (225 - $L) / 3;
        } else {
            $LP = ($L - 195) / 3;
        }
    }
    if (($L == 225 || $L > 225) && $L < 255) {
        $mb = $ji[12];
        $lpb0 = 12;
        $cb = $ji[3];
        $nsb = 11;
        $ms0 = $ms0 + 9;
        if ($FW == 1) {
            $LP = (255 - $L) / 3;
        } else {
            $LP = ($L - 225) / 3;
        }
    }
    if (($L == 255 || $L > 255) && $L < 285) {
        $mb = $ji[1];
        $lpb0 = 1;
        $cb = $ji[4];
        $nsb = 0;
        $ms0 = $ms0 + 10;
        if ($FW == 1) {
            $LP = (285 - $L) / 3;
        } else {
            $LP = ($L - 255) / 3;
        }
    }
    if (($L == 285 || $L > 285) && $L < 315) {
        $mb = $ji[2];
        $lpb0 = 2;
        $cb = $ji[5];
        $nsb = 1;
        $ms0 = $ms0 + 11;
        if ($FW == 1) {
            $LP = (315 - $L) / 3;
        } else {
            $LP = ($L - 285) / 3;
        }
    }
    if ($ms0 > 10) {
        $ms0 = $ms0 - 10;
    }

    $ms = $gon[$ms0];
    $cs = $gon[$ms0 + 1];
    $lps0 = $ms0;
    $ds0 = floor($JZJD + 0.5);
    $ds = $gon[substr($ds0, 6, 1)];
    $db0 = floor($JZJD - 12 * floor(($JZJD + 0.5) / 12) + 0.5) + 2;
    $db = $ji[$db0];
    $hs0 = 1;
    $hs1 = 0;

    for ($i = 1; $i < 5; $i++) {
        if (substr($ds0, 6, 1) == $i || substr($ds0, 6, 1) == $i + 5) {
            $hs1 = $hs0;
        }
        $hs0 = $hs0 + 2;
    }

    if (substr($ds0, 6, 1) == 0 || substr($ds0, 6, 1) == 5) {
        $hs1 = 9;
    }
    if ($HR == 23 || ($HR > 23 && $HR < 24)) {
        $hs1 = $hs1 + 2;
    }
    if (
        $HR == 23 ||
        ($HR > 23 && $HR < 24) ||
        ($HR == 00 || ($HR > 0 && $HR < 1) || $HR == 24)
    ) {
        $hb = $ji[1];
    }

    $hb0 = 2;
    for ($i = 1; $i < 23; $i++) {
        if ($HR == $i || ($HR > $i && $HR < $i + 2)) {
            $hb = $ji[$hb0];
            $hs1 = $hs1 + $hb0 - 1;
        }
        $i = $i + 1;
        $hb0 = $hb0 + 1;
    }
    if ($hs1 > 10) {
        $hs1 = $hs1 - 10;
    }

    $hs = $gon[$hs1];
    $LP = floor($LP * 100) / 100;

    $jaargetal = ((3007 - $YY) % 9) + 1;
    if ($YEFL == 1) {
        $jaargetal = $jaargetal + 1;
    }
    if ($jaargetal == 10) {
        $jaargetal = 1;
    }
    $smo = $nsb - 2;
    if ($smo < 0) {
        $smo = $smo + 12;
    }
    $nyb = $yb0 - 1;
    if ($nyb < 0) {
        $nyb = $nyb + 12;
    }
    if ($nyb % 3 == 0) {
        $maandgetal = ((25 - $smo) % 9) + 1;
    }
    if ($nyb % 3 == 1) {
        $maandgetal = ((22 - $smo) % 9) + 1;
    }
    if ($nyb % 3 == 2) {
        $maandgetal = ((19 - $smo) % 9) + 1;
    }
    if ($GEN == 1) {
        if ($jaargetal == 5) {
            $mng = 2;
        } else {
            $mng = $jaargetal;
        }
    } else {
        $mng = 6 - $jaargetal;
        if ($mng == 5) {
            $mng = 8;
        }
    }
    if ($mng < 1) {
        $mng = $mng + 9;
    }
    $str5 = "West group";
    if ($mng == 1 || $mng == 3 || $mng == 4 || $mng == 9) {
        $str5 = "East group";
    }
    // einde berekening

    // berekening uitingsgetal
    $zoekmaandgetal = [
        1 => [6, 8, 7, 6, 5, 4, 3, 2, 1, 9, 8, 7],
        2 => [9, 2, 1, 9, 8, 7, 6, 5, 4, 3, 2, 1],
        3 => [3, 5, 4, 3, 2, 1, 9, 8, 7, 6, 5, 4],
        4 => [6, 8, 7, 6, 5, 4, 3, 2, 1, 9, 8, 7],
        5 => [9, 2, 1, 9, 8, 7, 6, 5, 4, 3, 2, 1],
        6 => [3, 5, 4, 3, 2, 1, 9, 8, 7, 6, 5, 4],
        7 => [6, 8, 7, 6, 5, 4, 3, 2, 1, 9, 8, 7],
        8 => [9, 2, 1, 9, 8, 7, 6, 5, 4, 3, 2, 1],
        9 => [3, 5, 4, 3, 2, 1, 9, 8, 7, 6, 5, 4],
    ];

    $zoekuitingsgetal = [
        1 => [9, 7, 8, 9, 1, 2, 3, 4, 5, 6, 7, 8],
        2 => [7, 5, 6, 7, 8, 9, 1, 2, 3, 4, 5, 6],
        3 => [5, 3, 4, 5, 6, 7, 8, 9, 1, 2, 3, 4],
        4 => [3, 1, 2, 3, 4, 5, 6, 7, 8, 9, 1, 2],
        5 => [1, 8, 9, 1, 2, 3, 4, 5, 6, 7, 8, 9],
        6 => [8, 6, 7, 8, 9, 1, 2, 3, 4, 5, 6, 7],
        7 => [6, 4, 5, 6, 7, 8, 9, 1, 2, 3, 4, 5],
        8 => [4, 2, 3, 4, 5, 6, 7, 8, 9, 1, 2, 3],
        9 => [2, 9, 1, 2, 3, 4, 5, 6, 7, 8, 9, 1],
    ];

    $positiearray = 0;
    for ($i = 0; $i <= 11; $i++) {
        if ( $zoekmaandgetal[$jaargetal][$i] == $maandgetal ) {
            $positiearray = $i;
        }
    }

    $uitingsgetal = $zoekuitingsgetal[$jaargetal][$positiearray];
	// als maandgetal en jaargetal gelijk zijn is uitingsgetal daaraan gelijk
	for($i=1;$i <= 9; $i++) {
		if($jaargetal == $i && $maandgetal == $i) $uitingsgetal = $i;
		}
    ?>
<table class="tabel-nsk" id="tabeluitvoer" cellspacing="0" cellpadding="0" width="100%">
   <tr>
    <td class="tdoutput" width="33%"><?php echo esc_html(
        get_option("ninestarki_title_year", $nstarki_lang["TEXT_NAME_FIRST_NUMBER"])
    ); ?></td>
    <td class="tdoutput" width="34%"><?php echo esc_html(
        get_option("ninestarki_title_month", $nstarki_lang["TEXT_NAME_SECOND_NUMBER"])
    ); ?></td>
    <td class="tdoutput" width="33%"><?php echo esc_html(
        get_option("ninestarki_title_expression", $nstarki_lang["TEXT_NAME_THIRD_NUMBER"])
    ); ?></td>
  </tr>
<tr>
    <td class="tdoutput <?php echo 'element' . esc_html( $jaargetal ); ?>" width="33%">
        <?php echo esc_html($nstarki_lang_elementen[$jaargetal - 1])?>
        <br><span class="number-nsk"><?php echo esc_html($jaargetal); ?></span>
      </td>
    <td class="tdoutput <?php echo 'element' . esc_html($maandgetal); ?>" width="34%">
        <?php echo esc_html($nstarki_lang_elementen[$maandgetal - 1]); ?>
        <br><span class="number-nsk"><?php echo esc_html($maandgetal); ?></span>
      </td>
    <td class="tdoutput <?php echo 'element' . esc_html($uitingsgetal); ?>" width="33%">
        <?php echo esc_html($nstarki_lang_elementen[$uitingsgetal - 1]); ?>
        <br><span class="number-nsk"><?php echo esc_html($uitingsgetal); ?></span>
    </td>
  </tr>
<tr>
    <td colspan="3"><div class="outerbox_description">
        <div class="box_description">
          <?php echo "<h3>" . esc_html(get_option("ninestarki_character_first_number_$jaargetal", $jaargetal)) . " (" .  esc_html($nstarki_lang_elementen[$jaargetal - 1]) . esc_html($jaargetal) . 
              ")</h3><p>" .
              get_option("ninestarki_description_$jaargetal", $jaargetal) . "</p>"; ?>
        </div>
      </div></td>
  </tr>
</table>
<?php
function wpb_hook_javascript_nstarki() {
    ?>
    <script>
        document.getElementById("tabeluitvoer").scrollIntoView();
	</script>
    <?php
}
add_action('wp_footer', 'wpb_hook_javascript_nstarki');
}
?>
</form>
</div>
<?php
}
//end submit

//add css and script files
function nstarki_enqueue_plugin_styles_and_scripts()
{
    // Enqueue CSS
    wp_enqueue_style(
        "nskt-style",
        plugin_dir_url(__FILE__) . "css/nskt-styles.css",
        [], 
        '1.0'
    );
}
add_action("wp_enqueue_scripts", "nstarki_enqueue_plugin_styles_and_scripts");

function nstarki_cf_shortcode()
{
    ob_start();
    nstarki_html_form_code();
    return ob_get_clean();
}
add_shortcode("ninestarki", "nstarki_cf_shortcode");
?>
