<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
/**
 * Product card template.
 *
 * @var WC_Product $product
 * @var string     $table_label
 * @var array      $rows
 * @var bool       $show_attributes
 * @var array      $attribute_columns
 */
?>
<div class="price-editor__product">
    <div class="price-editor__product-info">
        <div class="price-editor__product-header">
            <div class="price-editor__image-wrapper">
                <?php echo wp_kses_post($product->get_image()); ?>
            </div>
            <div>
                <div class="price-editor__product-title">
                    <a class="price-editor__product-link" href="<?php echo esc_url(get_permalink($product->get_id())); ?>" target="_blank" rel="noopener noreferrer">
                        <?php echo esc_html($product->get_name()); ?>
                    </a>
                    <a class="price-editor__product-edit" href="<?php echo esc_url(get_edit_post_link($product->get_id())); ?>" target="_blank" rel="noopener noreferrer" aria-label="<?php echo esc_attr__('Edit product', 'nice-price-editor'); ?>">
                        <span class="dashicons dashicons-edit" aria-hidden="true"></span>
                    </a>
                </div>
                <div class="price-editor__product-type"><?php echo esc_html($table_label); ?></div>
            </div>
        </div>

        <?php nicepred_render_price_table($rows, $show_attributes, $attribute_columns); ?>
    </div>
</div>
