<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
/**
 * Price table template.
 *
 * @var array $rows
 * @var bool $show_attributes
 * @var array $attribute_columns
 */
?>
<div class="price-editor__variations-wrap">
    <table class="price-editor__variations-table<?php echo $show_attributes ? '' : ' price-editor__variations-table--simple'; ?>">
        <thead>
            <tr>
                <th class="id"><?php echo esc_html__('ID', 'nice-price-editor'); ?></th>
                <th class="sku"><?php echo esc_html__('SKU', 'nice-price-editor'); ?></th>
                <?php if ($show_attributes) : ?>
                    <?php foreach ($attribute_columns as $attribute_key => $attribute_label) : ?>
                        <th class="attribute" data-attribute="<?php echo esc_attr($attribute_key); ?>">
                            <?php echo esc_html($attribute_label); ?>
                        </th>
                    <?php endforeach; ?>
                <?php endif; ?>
                <th class="price"><?php echo esc_html__('Price', 'nice-price-editor'); ?></th>
                <th class="price"><?php echo esc_html__('New price', 'nice-price-editor'); ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($rows as $row) : ?>
                <tr class="price-editor__variation-line">
                    <td>
                        <span class="price-editor__variation-id price-editor__copyable" data-value="<?php echo esc_attr($row['id']); ?>">
                            <?php echo esc_html($row['id']); ?>
                        </span>
                    </td>
                    <td>
                        <span class="price-editor__variation-sku price-editor__copyable" data-value="<?php echo esc_attr($row['sku']); ?>">
                            <?php echo esc_html($row['sku']); ?>
                        </span>
                    </td>
                    <?php if ($show_attributes) : ?>
                        <?php $attribute_index = 0; ?>
                        <?php foreach ($attribute_columns as $attribute_key => $attribute_label) : ?>
                            <?php
                            $attribute_index++;
                            $palette_index = ($attribute_index - 1) % 6 + 1;
                            $attribute = isset($row['attributes'][$attribute_key]) ? $row['attributes'][$attribute_key] : null;
                            $value = $attribute ? $attribute['value'] : '';
                            ?>
                            <td class="price-editor__attr-cell price-editor__attr-cell--<?php echo esc_attr($palette_index); ?>">
                                <?php if ($value !== '') : ?>
                                    <span class="price-editor__attr-badge">
                                        <span class="price-editor__attr-value"><?php echo esc_html($value); ?></span>
                                    </span>
                                <?php endif; ?>
                            </td>
                        <?php endforeach; ?>
                    <?php endif; ?>
                    <td class="price-editor__current-price">
                        <span class="price-editor__copyable" data-value="<?php echo esc_attr($row['price_display']); ?>">
                            <?php echo esc_html($row['price_display']); ?>
                        </span>
                    </td>
                    <td class="price-editor__new-price-cell">
                        <input class="price-editor__new-price" inputmode="decimal" oninput="this.value = this.value.replace(/[^0-9.,]+/g, '')" />
                        <button class="price-editor__update-price price-editor__update-price--hidden" type="button">
                            <?php echo esc_html__('Save', 'nice-price-editor'); ?>
                        </button>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <?php
    $rows_count = is_array($rows) ? count($rows) : 0;
    $more_label = sprintf(
        /* translators: %d: number of variations. */
        __('See all %d', 'nice-price-editor'),
        $rows_count
    );
    ?>
    <button class="price-editor__variations-more" type="button">
        <span class="price-editor__variations-more-label"><?php echo esc_html($more_label); ?></span>
    </button>
</div>
