<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
/**
 * Pagination template.
 *
 * @var int $paged
 * @var int $max_num_pages
 * @var string $page
 * @var string $selected_category
 * @var string $filter_nonce
 * @var int $per_page
 */
$arrow_left = plugins_url('assets/chevron-left.svg', NICEPRED_PLUGIN_FILE);
$arrow_right = plugins_url('assets/chevron-right.svg', NICEPRED_PLUGIN_FILE);
$current_page = max(1, $paged);
$total_pages = (int) $max_num_pages;
$base_url = admin_url('admin.php');
$query_args = array(
    'page' => $page,
    'nicepred_filter_nonce' => $filter_nonce,
);
if ($selected_category !== '') {
    $query_args['category'] = $selected_category;
}
if (!empty($per_page)) {
    $query_args['per_page'] = $per_page;
}
$prev_link = $current_page > 1
    ? add_query_arg(array_merge($query_args, array('paged' => $current_page - 1)), $base_url)
    : '';
$next_link = $current_page < $total_pages
    ? add_query_arg(array_merge($query_args, array('paged' => $current_page + 1)), $base_url)
    : '';
?>
<nav class="price-editor__nav">
    <ul>
        <li>
            <?php if ($prev_link) : ?>
                <a class="price-editor__nav-link price-editor__nav-link--prev" href="<?php echo esc_url($prev_link); ?>">
                    <img src="<?php echo esc_url($arrow_left); ?>" alt="<?php echo esc_attr__('Back', 'nice-price-editor'); ?>" />
                </a>
            <?php else : ?>
                <span class="price-editor__nav-link price-editor__nav-link--disabled price-editor__nav-link--prev">
                    <img src="<?php echo esc_url($arrow_left); ?>" alt="<?php echo esc_attr__('Back', 'nice-price-editor'); ?>" />
                </span>
            <?php endif; ?>
        </li>
        <li>
            <?php if ($next_link) : ?>
                <a class="price-editor__nav-link price-editor__nav-link--next" href="<?php echo esc_url($next_link); ?>">
                    <img src="<?php echo esc_url($arrow_right); ?>" alt="<?php echo esc_attr__('Next', 'nice-price-editor'); ?>" />
                </a>
            <?php else : ?>
                <span class="price-editor__nav-link price-editor__nav-link--disabled price-editor__nav-link--next">
                    <img src="<?php echo esc_url($arrow_right); ?>" alt="<?php echo esc_attr__('Next', 'nice-price-editor'); ?>" />
                </span>
            <?php endif; ?>
        </li>
    </ul>
</nav>
