<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
/**
 * Category filter template.
 *
 * @var array  $categories
 * @var string $selected_category
 * @var string $page
 * @var int    $paged
 * @var int    $per_page
 * @var array  $per_page_options
 */
?>
<div class="price-editor__select-wrapper">
    <div class="price-editor__branding">
        <div class="price-editor__branding-title">
            <?php echo esc_html('Nice Price Editor'); ?>
        </div>
        <div class="price-editor__branding-tagline">
            <?php echo esc_html__('Quick price updates in WooCommerce', 'nice-price-editor'); ?>
        </div>
    </div>
    <form method="get" class="price-editor__filters">
        <?php wp_nonce_field( 'nicepred_filter_products', 'nicepred_filter_nonce' ); ?>
        <div class="price-editor__filter">
            <label class="price-editor__filter-label" for="nicepred-category">
                <?php echo esc_html__('Category', 'nice-price-editor'); ?>
            </label>
            <select id="nicepred-category" name="category" class="price-editor__select" onchange="this.form.paged.value=1;this.form.submit()">
                <option value="" <?php selected($selected_category, ''); ?>>
                    <?php echo esc_html__('-- all categories --', 'nice-price-editor'); ?>
                </option>
                <?php foreach ($categories as $category) : ?>
                    <option value="<?php echo esc_attr($category->slug); ?>" <?php selected($category->slug, $selected_category); ?>>
                        <?php echo esc_html($category->name); ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="price-editor__filter">
            <label class="price-editor__filter-label" for="nicepred-per-page">
                <?php echo esc_html__('Items', 'nice-price-editor'); ?>
            </label>
            <select id="nicepred-per-page" name="per_page" class="price-editor__select" onchange="this.form.paged.value=1;this.form.submit()">
                <?php foreach ($per_page_options as $option) : ?>
                    <option value="<?php echo esc_attr($option); ?>" <?php selected($per_page, $option); ?>>
                        <?php echo esc_html($option); ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
        <input type="hidden" name="page" value="<?php echo esc_attr($page); ?>">
        <input type="hidden" name="paged" value="<?php echo esc_attr($paged); ?>">
    </form>
</div>
