jQuery(document).ready(function ($) {
    const copyText = async (text) => {
        if (!text) {
            return false;
        }

        if (navigator.clipboard && navigator.clipboard.writeText) {
            try {
                await navigator.clipboard.writeText(text);
                return true;
            } catch (error) {
                // Fallback below.
            }
        }

        const $temp = $('<textarea readonly></textarea>');
        $temp.val(text);
        $temp.css({
            position: 'fixed',
            top: '-1000px',
            left: '-1000px',
            opacity: '0',
        });
        $('body').append($temp);
        $temp[0].focus();
        $temp[0].select();
        $temp[0].setSelectionRange(0, $temp.val().length);
        let copied = false;
        try {
            copied = document.execCommand('copy');
        } catch (error) {
            copied = false;
        }
        $temp.remove();
        return copied;
    };

    const toggleUpdateButton = ($input) => {
        const value = $input.val();
        const hasValue = typeof value === 'string' && value.trim().length > 0;
        $input.closest('.price-editor__new-price-cell').toggleClass('has-value', hasValue);
    };

    $('.price-editor__new-price').on('input', function () {
        toggleUpdateButton($(this));
    }).each(function () {
        toggleUpdateButton($(this));
    });

    $('button.price-editor__update-price').click(function () {
        const $row = $(this).closest('.price-editor__variation-line');
        const variationID = $row.find('.price-editor__variation-id').attr('data-value');
        const $input = $row.find('.price-editor__new-price');
        const newPrice = $input.val();

        if (newPrice === undefined || newPrice === null) {
            return;
        }

        const data = {
            action: 'nicepred_update_price',
            nonce: nicepredData.nonce,
            variationID: variationID,
            newPrice: newPrice,
        };

        $input.prop('disabled', true);
        $(this).prop('disabled', true);

        $.post(nicepredData.ajaxUrl, data)
            .done((response) => {
                if (!response || !response.success) {
                    return;
                }

                $input.val('');
                toggleUpdateButton($input);

                const updatedPrice = response.data.newPrice;
                const $priceCell = $row.find('.price-editor__current-price');
                const $priceSpan = $('<span class="price-editor__copyable"></span>');
                $priceSpan.attr('data-value', updatedPrice);
                $priceSpan.text(updatedPrice);
                $priceSpan.addClass('is-success');
                $priceCell.empty().append($priceSpan);

                setTimeout(() => {
                    $priceSpan.removeClass('is-success');
                }, 800);
            })
            .always(() => {
                $(this).prop('disabled', false);
                $input.prop('disabled', false);
            });
    });

    $('.price-editor__variations-table').on('click', '.price-editor__copyable', function () {
        const $target = $(this);
        const dataValue = $target.attr('data-value');
        const text = dataValue !== undefined && dataValue !== null && String(dataValue).length
            ? String(dataValue)
            : $target.text().trim();

        copyText(text).then((copied) => {
            if (!copied) {
                return;
            }

            $target.addClass('is-copied');
            setTimeout(() => {
                $target.removeClass('is-copied');
            }, 800);
        });
    });

    const maxHeightVar = getComputedStyle(document.body).getPropertyValue('--nicepred-variations-max-height');
    const maxHeight = parseInt(maxHeightVar, 10) || 280;

    const isSingleProduct = $('.price-editor__product').length === 1;

    $('.price-editor__variations-wrap').each(function () {
        const $wrap = $(this);
        const $more = $wrap.find('.price-editor__variations-more');

        if (isSingleProduct) {
            $wrap.removeClass('is-collapsed');
            $more.hide();
            return;
        }

        if (this.scrollHeight > maxHeight) {
            $wrap.addClass('is-collapsed');
            $more.show();
        } else {
            $more.hide();
        }
    });

    $('.price-editor__variations-more').click(function () {
        const $button = $(this);
        $button.closest('.price-editor__variations-wrap').removeClass('is-collapsed');
        $button.hide();
    });
});
