// Fancybox-Konfiguration
Fancybox.bind("[data-fancybox]", {
  Carousel: {
    transition: "slide",
  },
  Images: {
    zoom: false,
    protected: true,
  },
  showClass: "f-fadeIn",
  
  Toolbar: {
    items: {
      exifData: {
        tpl: `
        <button class="f-button exif-data-button" title="EXIF-Daten" data-exif-toggle="off">
          <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
            <path d="M23 19a2 2 0 0 1-2 2H3a2 2 0 0 1-2-2V8a2 2 0 0 1 2-2h4l2-3h6l2 3h4a2 2 0 0 1 2 2z"></path>
            <circle cx="12" cy="13" r="4"></circle>
          </svg>
        </button>
        `,
        click: function(event) {
          const button = document.querySelector('.exif-data-button');
          if (!button) {
            console.error("Konnte EXIF-Button nicht finden");
            return;
          }

          const isActive = button.getAttribute('data-exif-toggle') === 'on';
          const existingExifDisplay = document.querySelector('.fancybox-exif-display');
          if (existingExifDisplay) {
            existingExifDisplay.remove();
          }

          if (isActive) {
            button.setAttribute('data-exif-toggle', 'off');
            button.style.backgroundColor = '';
            return;
          }

          button.setAttribute('data-exif-toggle', 'on');
          button.style.backgroundColor = '#4a69bd';
          updateExifDisplay();
        },
      },
    },
    display: {
      left: ["infobar"],
      middle: [],
      right: [
        "iterateZoom",
        "exifData",
        "slideshow",
        "fullscreen",
        "thumbs",
        "close"
      ],
    },
  },
  
  on: {
    // Diese Funktion wird ausgefhrt, wenn die Fancybox geladen ist
    init: (fancybox) => {
      console.log("Fancybox initialisiert");
      
      // Bei jedem Bildwechsel EXIF-Daten aktualisieren
      fancybox.on("Carousel.change", (carousel, to, from) => {
        console.log(`Carousel change: von Slide ${from} zu ${to}`);
        updateExifDisplay();
      });
    },
  },
});

function updateExifDisplay() {
  try {
    const button = document.querySelector('.exif-data-button');
    if (!button || button.getAttribute('data-exif-toggle') !== 'on') {
      return;
    }

    const existingExifDisplay = document.querySelector('.fancybox-exif-display');
    if (existingExifDisplay) {
      existingExifDisplay.remove();
    }

    // Wichtig: Wir brauchen den AKTIVEN Slide
    const activeSlide = document.querySelector('.fancybox__slide.is-selected');
    if (!activeSlide) {
      console.error("Kein aktiver Slide gefunden");
      return;
    }

    const currentImage = activeSlide.querySelector('img');
    if (!currentImage) {
      console.error("Kein Bild im aktiven Slide gefunden");
      return;
    }

    const imgSrc = currentImage.src.split('?')[0];
    console.log("Aktuelles Bild URL:", imgSrc);

    // Finde den passenden EXIF-Daten-Block im Container
    const exifBlock = document.querySelector(`.exif-data[data-image-url="${imgSrc}"]`);
    
    let exifContent = null;
    if (exifBlock) {
      console.log("EXIF-Block gefunden fr URL:", imgSrc);
      exifContent = exifBlock.querySelector('.exif-content').innerHTML;
    } else {
      console.warn("Kein EXIF-Block gefunden fr URL:", imgSrc);
      // Versuche alternative Matching-Strategien
      const allExifBlocks = document.querySelectorAll('.exif-data');
      for (const block of allExifBlocks) {
        const blockUrl = block.getAttribute('data-image-url');
        if (blockUrl.includes(imgSrc) || imgSrc.includes(blockUrl)) {
          console.log("Verwandter EXIF-Block gefunden:", blockUrl);
          exifContent = block.querySelector('.exif-content').innerHTML;
          break;
        }
      }
    }

    // EXIF-Anzeige erstellen
    const exifDisplay = document.createElement('div');
    exifDisplay.className = 'fancybox-exif-display';
    exifDisplay.innerHTML = exifContent 
      ? `<div class="exif-content">${exifContent}</div>` 
      : '<div class="exif-content">Keinen container f&uuml;r EXIF-Daten gefunden</div>';

    // Styling
    Object.assign(exifDisplay.style, {
      position: 'absolute',
      bottom: '10px',
      right: '10px',
      left: 'auto',
      maxWidth: '40%',
      backgroundColor: 'rgba(0, 0, 0, 0.2)',
      color: 'white',
      padding: '8px 12px',
      fontSize: '13px',
      zIndex: '99999',
      textAlign: 'left',
      transition: 'all 0.3s ease',
      borderRadius: '4px',
      backdropFilter: 'blur(2px)',
      boxShadow: '0 2px 4px rgba(0,0,0,0.1)'
    });

    // Anzeige zum Container hinzufgen
    const container = document.querySelector('.fancybox__container');
    if (container) {
      container.appendChild(exifDisplay);
    }
  } catch (error) {
    console.error("Fehler beim Aktualisieren der EXIF-Anzeige:", error);
  }
}