<?php
/**
 * Ecommerce Preview Template
 *
 * @since 3.5.0
 *
 * @package Nextgen Gallery
 */

?>
<div class="nextgen-admin-content">

<div class="nextgen-admin-modal">
		<div class="nextgen-admin-modal-content">
		<h2>
			<?php esc_html_e( 'Built-In E-Commerce is Only Available in NextGEN PRO', 'nggallery' ); ?>
		</h2>
		<p>
			<?php esc_html_e( 'Get Paid for your images with built-in E-Commerce. NextGEN Pro adds a true image E-Commerce system to help you do just that. Accept PayPal, Stripe, and Checks!', 'nggallery' ); ?>
		</p>
		<div class="nextgen-admin-model-lists nextgen-clear">
			<ul class="left">
				<li><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" width="28px" height="28px" fill="#7cc048"><path d="M256 48a208 208 0 110 416 208 208 0 110-416zm0 464a256 256 0 100-512 256 256 0 100 512zm113-303c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-111 111-47-47c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l64 64c9.4 9.4 24.6 9.4 33.9 0L369 209z"></path></svg></i><?php esc_html_e( 'Sell from Originals', 'nggallery' ); ?></li>
				<li><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" width="28px" height="28px" fill="#7cc048"><path d="M256 48a208 208 0 110 416 208 208 0 110-416zm0 464a256 256 0 100-512 256 256 0 100 512zm113-303c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-111 111-47-47c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l64 64c9.4 9.4 24.6 9.4 33.9 0L369 209z"></path></svg></i><?php esc_html_e( 'Secure Payment Integration', 'nggallery' ); ?></li>
				<li><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" width="28px" height="28px" fill="#7cc048"><path d="M256 48a208 208 0 110 416 208 208 0 110-416zm0 464a256 256 0 100-512 256 256 0 100 512zm113-303c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-111 111-47-47c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l64 64c9.4 9.4 24.6 9.4 33.9 0L369 209z"></path></svg></i><?php esc_html_e( 'Test Transactions', 'nggallery' ); ?></li>
				<li><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" width="28px" height="28px" fill="#7cc048"><path d="M256 48a208 208 0 110 416 208 208 0 110-416zm0 464a256 256 0 100-512 256 256 0 100 512zm113-303c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-111 111-47-47c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l64 64c9.4 9.4 24.6 9.4 33.9 0L369 209z"></path></svg></i><?php esc_html_e( 'Secure Original Backups', 'nggallery' ); ?></li>
				<li><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" width="28px" height="28px" fill="#7cc048"><path d="M256 48a208 208 0 110 416 208 208 0 110-416zm0 464a256 256 0 100-512 256 256 0 100 512zm113-303c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-111 111-47-47c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l64 64c9.4 9.4 24.6 9.4 33.9 0L369 209z"></path></svg></i><?php esc_html_e( 'Optimized Checkout', 'nggallery' ); ?></li>

			</ul>
			<ul class="right">
				<li><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" width="28px" height="28px" fill="#7cc048"><path d="M256 48a208 208 0 110 416 208 208 0 110-416zm0 464a256 256 0 100-512 256 256 0 100 512zm113-303c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-111 111-47-47c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l64 64c9.4 9.4 24.6 9.4 33.9 0L369 209z"></path></svg></i><?php esc_html_e( 'Commissions', 'nggallery' ); ?></li>
				<li><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" width="28px" height="28px" fill="#7cc048"><path d="M256 48a208 208 0 110 416 208 208 0 110-416zm0 464a256 256 0 100-512 256 256 0 100 512zm113-303c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-111 111-47-47c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l64 64c9.4 9.4 24.6 9.4 33.9 0L369 209z"></path></svg></i><?php esc_html_e( 'Automated Tax Calculations', 'nggallery' ); ?></li>
				<li><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" width="28px" height="28px" fill="#7cc048"><path d="M256 48a208 208 0 110 416 208 208 0 110-416zm0 464a256 256 0 100-512 256 256 0 100 512zm113-303c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-111 111-47-47c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l64 64c9.4 9.4 24.6 9.4 33.9 0L369 209z"></path></svg></i><?php esc_html_e( 'Digital Downloads', 'nggallery' ); ?></li>
				<li><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" width="28px" height="28px" fill="#7cc048"><path d="M256 48a208 208 0 110 416 208 208 0 110-416zm0 464a256 256 0 100-512 256 256 0 100 512zm113-303c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-111 111-47-47c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l64 64c9.4 9.4 24.6 9.4 33.9 0L369 209z"></path></svg></i><?php esc_html_e( 'Much More!', 'nggallery' ); ?></li>

			</ul>
		</div>
		</div>
		<div class="nextgen-admin-modal-bonus">
			<svg class="check" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" width="28px" height="28px" fill="#7cc048"><path d="M256 48a208 208 0 110 416 208 208 0 110-416zm0 464a256 256 0 100-512 256 256 0 100 512zm113-303c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-111 111-47-47c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l64 64c9.4 9.4 24.6 9.4 33.9 0L369 209z"></path></svg>
			<p>
				<?php
				printf(
				// Translators: %1$s - Opening strong tag, do not translate. %2$s - Closing strong tag, do not translate. %3$s - Opening span tag, do not translate. %4$s - Closing strong tag, do not translate.
					esc_html__( '%1$sBonus%2$s: NextGEN Gallery Lite users get %3$s 50%% off%4$s regular price, automatically applied at checkout', 'nggallery' ),
					'<strong>',
					'</strong>',
					'<span class="nextgen-green"><strong>',
					'</strong></span>'
				);
				?>
			</p>
		</div>
		<div class="nextgen-admin-modal-button">
		<a href="<?php echo esc_url( M_Marketing::get_utm_link( 'https://www.imagely.com/lite', 'ecommercePage', 'upgrade' ) ); ?>" class="button nextgen-green-button" target="_blank" rel="noopener noreferrer">
		<?php esc_html_e( 'Upgrade to Pro and Unlock Ecommerce', 'nggallery' ); ?>
		</a>
		</div>
	</div>
<div class="wrap">
<div class="wrap ngg_settings_page" id="ngg_page_content" style="position: relative; visibility: visible;">
	<div class="ngg_page_content_header">
		<h3>Ecommerce Options</h3>
		<p>Good work. Keep making the web beautiful.</p>
	</div>
	<form method="POST" action="/wp-admin/admin.php?page=ngg_ecommerce_options">
		<input type="hidden" name="nonce" value="0d97acf2ed">
		<input type="hidden" name="action">
		<div class="responsive-menu-icon"></div>
		<div class="ngg_page_content_menu responsive-menu">
		<a href="javascript:void(0)" data-id="ngg-ecommerce-options" class="ngg_page_content_menu_active" style="display: flex; align-items: center; padding-right: 0px; position: relative;">
		General Options                <i class="fa fa-exclamation-triangle ngg-error-icon" aria-hidden="true" style="color: #ca090f; padding-right: 4px; padding-left: 4px; font-size: 12px !important;" title="Form contains errors, please fix these errors before saving."></i></a>
		<a href="javascript:void(0)" data-id="ngg-mail">
		E-mail             </a>
		<a href="javascript:void(0)" data-id="ngg-payment-gateways" style="display: block; padding-right: 20px;">
		Payment Gateway                </a>
		<a href="javascript:void(0)" data-id="ngg-ecommerce-printlab">
		Print Lab Integration              </a>
		<a href="javascript:void(0)" data-id="ngg-proofing">
		Proofing               </a>
		</div>
		<div class="ngg_page_content_main">
		<div data-id="ngg-ecommerce-options">
			<h3>General Options</h3>
			<table>
				<tbody>
					<tr id="tr_ecommerce_currency" class="">
					<td>
						<label for="ecommerce_currency">
						Currency		</label>
					</td>
					<td>
						<select id="ecommerce_currency" name="ecommerce[currency]" class="ecommerce_currency">
							<option value="840" selected="selected">US Dollar</option>
						</select>
					</td>
					</tr>
					<tr id="tr_ecommerce_page_checkout" class="">
					<td>
						<label for="ecommerce_page_checkout" title="This page requires the [ngg_pro_checkout] shortcode, which will be automatically added if not already present. Selecting &quot;Create new&quot; will create a new page that will appear in your Primary Menu unless you've customized your menu settings: http://codex.wordpress.org/Appearance_Menus_SubPanel" class="tooltip">
						Checkout page		</label>
					</td>
					<td>
						<select id="ecommerce_page_checkout" name="ecommerce[page_checkout]" class="ecommerce_page_checkout">
							<option value="" selected="selected">Create new</option>
							<option value="128">alb</option>
							<option value="102">new test</option>
							<option value="2">Sample Page</option>
							<option value="94">new test</option>
							<option value="99">new test</option>
						</select>
					</td>
					</tr>
					<tr id="tr_ecommerce_page_thanks" class="">
					<td>
						<label for="ecommerce_page_thanks" title="This page should have the [ngg_pro_order_details] shortcode, which will be automatically added if not already present. Selecting &quot;Create new&quot; will create a new page that will appear in your Primary Menu unless you've customized your menu settings: http://codex.wordpress.org/Appearance_Menus_SubPanel" class="tooltip">
						Thank-you page		</label>
					</td>
					<td>
						<select id="ecommerce_page_thanks" name="ecommerce[page_thanks]" class="ecommerce_page_thanks">
							<option value="" selected="selected">Create new</option>
							<option value="128">alb</option>
							<option value="102">new test</option>
							<option value="2">Sample Page</option>
							<option value="94">new test</option>
							<option value="99">new test</option>
						</select>
					</td>
					</tr>
					<tr id="tr_ecommerce_page_cancel" class="">
					<td>
						<label for="ecommerce_page_cancel" title="Selecting &quot;Create new&quot; will create a new page that will appear in your Primary Menu unless you've customized your menu settings: http://codex.wordpress.org/Appearance_Menus_SubPanel" class="tooltip">
						Cancel page		</label>
					</td>
					<td>
						<select id="ecommerce_page_cancel" name="ecommerce[page_cancel]" class="ecommerce_page_cancel">
							<option value="" selected="selected">Create new</option>
							<option value="128">alb</option>
							<option value="102">new test</option>
							<option value="2">Sample Page</option>
							<option value="94">new test</option>
							<option value="99">new test</option>
						</select>
					</td>
					</tr>
					<tr id="tr_ecommerce_page_digital_downloads" class="">
					<td>
						<label for="ecommerce_page_digital_downloads" title="This page requires the [ngg_pro_digital_downloads] shortcode, which will be automatically added if not already present. Selecting &quot;Create new&quot; will create a new page that will appear in your Primary Menu unless you've customized your menu settings: http://codex.wordpress.org/Appearance_Menus_SubPanel" class="tooltip">
						Digital downloads page		</label>
					</td>
					<td>
						<select id="ecommerce_page_digital_downloads" name="ecommerce[page_digital_downloads]" class="ecommerce_page_digital_downloads">
							<option value="" selected="selected">Create new</option>
							<option value="128">alb</option>
							<option value="102">new test</option>
							<option value="2">Sample Page</option>
							<option value="94">new test</option>
							<option value="99">new test</option>
						</select>
					</td>
					</tr>
					<tr id="tr_ecommerce_cart_menu_item" class="">
					<td>
						<label for="ecommerce_cart_menu_item" title="Determines the appearance of the Checkout page selected above when shown as an entry inside a menu. When a setting other than None is selected, the checkout page will be added to the first navigation menu registered by your theme." class="tooltip">
						Cart menu icon		</label>
					</td>
					<td>
						<select id="ecommerce_cart_menu_item" name="ecommerce[cart_menu_item]" class="ecommerce_cart_menu_item">
							<option value="none">None</option>
							<option value="icon">Icon Only</option>
							<option value="icon_with_items">Icon Only (When Cart Has Items)</option>
							<option value="icon_and_total">Icon &amp; Total</option>
							<option value="icon_and_total_with_items">Icon &amp; Total (When Cart Has Items)</option>
						</select>
					</td>
					</tr>
					<tr id="tr_ecommerce_default_pricelist" class="">
					<td>
						<label for="ecommerce_default_pricelist" title="New galleries will be assigned this pricelist" class="tooltip">
						Default pricelist		</label>
					</td>
					<td>
						<select id="ecommerce_default_pricelist" name="ecommerce[default_pricelist]" class="ecommerce_default_pricelist">
							<option value="" selected="selected">-- No default pricelist --</option>
						</select>
					</td>
					</tr>
					<tr id="tr_ecommerce_not_for_sale_msg" class="">
					<td>
						<label for="ecommerce_not_for_sale_msg">
						"Not for sale" Message		</label>
					</td>
					<td>
						<textarea id="ecommerce_not_for_sale_msg" name="ecommerce[not_for_sale_msg]" class="ecommerce[not_for_sale_msg]">Sorry, this image is not currently for sale.</textarea>
					</td>
					</tr>
					<tr id="tr_ecommerce_studio_name" class="">
					<td>
						<label for="ecommerce_studio_name">
						<strong>Studio Name</strong>		</label>
					</td>
					<td>
						<input type="text" id="ecommerce_studio_name" name="ecommerce[studio_name]" class="ecommerce_studio_name" value="" style="border: 1px solid red;">
						<span class="ngg-field-error-container ngg-field-error-container-input" title="Studio Name cannot be empty." style="display: inline;"><i class="fa fa-exclamation-triangle ngg-error-icon" aria-hidden="true"></i></span>
					</td>
					</tr>
					<tr id="tr_ecommerce_studio_street_address" class="">
					<td>
						<label for="ecommerce_studio_street_address">
						<strong>Studio Street Address</strong>		</label>
					</td>
					<td>
						<input type="text" id="ecommerce_studio_street_address" name="ecommerce[studio_street_address]" class="ecommerce_studio_street_address" value="" style="border: 1px solid red;">
						<span class="ngg-field-error-container ngg-field-error-container-input" title="Studio Street Address cannot be empty." style="display: inline;"><i class="fa fa-exclamation-triangle ngg-error-icon" aria-hidden="true"></i></span>
					</td>
					</tr>
					<tr id="tr_ecommerce_studio_address_line" class="">
					<td>
						<label for="ecommerce_studio_address_line">
						Studio Address Line #2		</label>
					</td>
					<td>
						<input type="text" id="ecommerce_studio_address_line" name="ecommerce[studio_address_line]" class="ecommerce_studio_address_line" value="">
					</td>
					</tr>
					<tr id="tr_ecommerce_studio_city" class="">
					<td>
						<label for="ecommerce_studio_city">
						<strong>Studio City</strong>		</label>
					</td>
					<td>
						<input type="text" id="ecommerce_studio_city" name="ecommerce[studio_city]" class="ecommerce_studio_city" value="" style="border: 1px solid red;">
						<span class="ngg-field-error-container ngg-field-error-container-input" title="Studio City cannot be empty." style="display: inline;"><i class="fa fa-exclamation-triangle ngg-error-icon" aria-hidden="true"></i></span>
					</td>
					</tr>
					<tr id="tr_ecommerce_home_country" class="">
					<td>
						<label for="ecommerce_home_country">
						<strong>Studio Country</strong>		</label>
					</td>
					<td>
						<select id="ecommerce_home_country" name="ecommerce[home_country]" class="ecommerce_home_country" style="width: 176px; border: 1px solid red;">
							<option value="" selected="selected">Select Country</option>
						</select>
						<span class="ngg-field-error-container" title="Studio Country cannot be empty." style="display: inline;"><i class="fa fa-exclamation-triangle ngg-error-icon" aria-hidden="true"></i></span>
					</td>
					</tr>
					<tr id="tr_ecommerce_home_state" class="" style="display: none;">
					<td>
						<label for="ecommerce_home_state">
						<strong>Studio State</strong>		</label>
					</td>
					<td>
						<input type="text" id="ecommerce_home_state" name="ecommerce[home_state]" class="ecommerce_home_state" value="">
						<select class="ecommerce_home_state state-generated-dropdown" id="" name="" style="display: none;">
							<option value="">Select Region</option>
						</select>
						<span class="ngg-field-error-container ngg-field-error-container-input" style="display: none;"><i class="fa fa-exclamation-triangle ngg-error-icon" aria-hidden="true"></i></span>
					</td>
					</tr>
					<tr id="tr_ecommerce_home_zip" class="" style="display: none;">
					<td>
						<label for="ecommerce_home_zip">
						<strong>Studio Postal Code</strong> (required for taxes)		</label>
					</td>
					<td>
						<input type="text" id="ecommerce_home_zip" name="ecommerce[home_zip]" class="ecommerce_home_zip" value="">
						<span class="ngg-field-error-container ngg-field-error-container-input" style="display: none;"><i class="fa fa-exclamation-triangle ngg-error-icon" aria-hidden="true"></i></span>
					</td>
					</tr>
					<tr id="tr_ecommerce_studio_email" class="">
					<td>
						<label for="ecommerce_studio_email">
						<strong>Studio Email</strong>		</label>
					</td>
					<td>
						<input type="text" id="ecommerce_studio_email" name="ecommerce[studio_email]" class="ecommerce_studio_email" value="" readonly="" onfocus="if (this.hasAttribute('readonly')) {this.removeAttribute('readonly'); this.blur(); this.trigger('focus');}" style="border: 1px solid red;">
						<span class="ngg-field-error-container ngg-field-error-container-input" title="Studio Email cannot be empty." style="display: inline;"><i class="fa fa-exclamation-triangle ngg-error-icon" aria-hidden="true"></i></span>
					</td>
					</tr>
					<tr>
					<td class="label_column">
						<label class="" for="ecommerce_domestic_shipping" title="">Domestic shipping for manual-fulfilled items</label>
					</td>
					<td>
						<select id="ecommerce_domestic_shipping" name="ecommerce[domestic_shipping]" class="ecommerce_domestic_shipping" style="width: 50%;">
							<option value="flat_rate">Flat Rate</option>
							<option value="percent_rate">Percentage Rate</option>
						</select>
						<input type="text" id="ecommerce_domestic_shipping_rate" name="ecommerce[domestic_shipping_rate]" class="ecommerce_domestic_shipping_rate show_on_flat_rate show_on_percent_rate" value="5" style="width: 30%;">
						<span class="show_on_flat_rate" style="">USD</span>
						<span class="show_on_percent_rate" style="display: none;">%</span>
					</td>
					</tr>
					<tr>
					<td class="label_column">
						<label class="" for="ecommerce_intl_shipping" title="">Allow International shipping for manual-fulfilled items</label>
					</td>
					<td>
						<select id="ecommerce_intl_shipping" name="ecommerce[intl_shipping]" class="ecommerce_intl_shipping" style="width: 50%;">
							<option selected="selected" value="disabled">Disabled</option>
							<option value="flat_rate">Flat Rate</option>
							<option value="percent_rate">Percentage Rate</option>
						</select>
						<input type="text" id="ecommerce_intl_shipping_rate" name="ecommerce[intl_shipping_rate]" class="ecommerce_intl_shipping_rate show_on_flat_rate show_on_percent_rate" value="40" style="width: 30%; display: none;">
						<span class="show_on_flat_rate" style="display: none;">USD</span>
						<span class="show_on_percent_rate" style="display: none;">%</span>
					</td>
					</tr>
					<tr id="tr_ecommerce_tax_enable" class="">
					<td>
						<label for="ecommerce_tax_enable" title="A valid NextGen Pro license is required to calculate sales tax." class="tooltip">
						Enable sales tax        </label>
					</td>
					<td>
						<input type="radio" id="ecommerce_tax_enable" name="ecommerce[tax_enable]" class="ecommerce_tax_enable" value="1" disabled="">
						<label for="ecommerce_tax_enable">Yes</label>
						&nbsp;
						<input type="radio" id="ecommerce_tax_enable_no" name="ecommerce[tax_enable]" class="ecommerce_tax_enable" value="0" disabled="" checked="checked">
						<label for="ecommerce_tax_enable_no">No</label>
					</td>
					</tr>
					<tr>
					<td colspan="2">
						<p class="sales-tax-note">SALES TAX NOTE: Sales tax is complex. <a href="https://www.imagely.com/docs/intro-to-sales-tax/" target="_blank" style="font-weight:bold;">CLICK HERE</a> to learn more about sales tax and how NextGEN Pro calculates it. Because we use a third party service (TaxJar), an active Pro license is required to enable sales tax.</p>
					</td>
					</tr>
					<tr id="tr_ecommerce_cookies_enable" class="">
					<td>
						<label for="ecommerce_cookies_enable" title="Cookies are adequate for most customers but can only hold a limited number (around 30) of products due to browser limitations. When disabled the browser localStorage API will be used which does not have this problem but cart contents will be different on example.com vs www.example.com as well as across HTTP/HTTPS" class="tooltip">
						Use cookies for cart storage		</label>
					</td>
					<td>
						<input type="radio" id="ecommerce_cookies_enable" name="ecommerce[cookies_enable]" class="ecommerce_cookies_enable" value="1" checked="checked">
						<label for="ecommerce_cookies_enable">Yes</label>
						&nbsp;
						<input type="radio" id="ecommerce_cookies_enable_no" name="ecommerce[cookies_enable]" class="ecommerce_cookies_enable" value="0">
						<label for="ecommerce_cookies_enable_no">No</label>
					</td>
					</tr>
					<tr id="tr_ecommerce_coupons_disabled" class="">
					<td>
						<label for="ecommerce_coupons_disabled">
						Hide coupons on checkout		</label>
					</td>
					<td>
						<input type="radio" id="ecommerce_coupons_disabled" name="ecommerce[coupons_disabled]" class="ecommerce_coupons_disabled" value="1">
						<label for="ecommerce_coupons_disabled">Yes</label>
						&nbsp;
						<input type="radio" id="ecommerce_coupons_disabled_no" name="ecommerce[coupons_disabled]" class="ecommerce_coupons_disabled" value="0" checked="checked">
						<label for="ecommerce_coupons_disabled_no">No</label>
					</td>
					</tr>
				</tbody>
			</table>
		</div>
		<div data-id="ngg-mail">
			<h3>E-mail</h3>
			<table>
				<tbody>
					<tr id="tr_ecommerce_email_notification_subject" class="">
					<td>
						<label for="ecommerce_email_notification_subject">
						Order notification e-mail subject:		</label>
					</td>
					<td>
						<input type="text" id="ecommerce_email_notification_subject" name="ecommerce[email_notification_subject]" class="ecommerce_email_notification_subject" placeholder="Subject" value="New Purchase!">
					</td>
					</tr>
					<tr id="tr_ecommerce_email_notification_body" class="">
					<td>
						<label for="ecommerce_email_notification_body" title="Wrap placeholders in %%param%%. Accepted placeholders: customer_name, email, total_amount, item_count, shipping_street_address, shipping_city, shipping_state, shipping_zip, shipping_country, order_id, hash, order_details_page, admin_email, blog_name, blog_description, blog_url, site_url, home_url, and file_list" class="tooltip">
						Order notification e-mail content:		</label>
					</td>
					<td>
						<textarea id="ecommerce_email_notification_body" name="ecommerce[email_notification_body]" class="ecommerce[email_notification_body]">You received a payment of %%total_amount%% from %%customer_name%% (%%email%%). For more details, visit: %%order_details_page%%
						%%gateway_admin_note%%
						Here is a comma separated list of the image file names. You can copy and
						paste this in your favorite image management software to quickly search for
						and find all selected images.
						Files: %%file_list%%</textarea>
					</td>
					</tr>
					<tr id="tr_ecommerce_enable_email_receipt" class="">
					<td>
						<label for="ecommerce_enable_email_receipt" title="If enabled a receipt will be sent to the customer after successful checkout" class="tooltip">
						Send e-mail receipt to customer?		</label>
					</td>
					<td>
						<input type="radio" id="ecommerce_enable_email_receipt" name="ecommerce[enable_email_receipt]" class="ecommerce_enable_email_receipt" value="1" checked="checked">
						<label for="ecommerce_enable_email_receipt">Yes</label>
						&nbsp;
						<input type="radio" id="ecommerce_enable_email_receipt_no" name="ecommerce[enable_email_receipt]" class="ecommerce_enable_email_receipt" value="0">
						<label for="ecommerce_enable_email_receipt_no">No</label>
					</td>
					</tr>
					<tr id="tr_ecommerce_email_receipt_subject" class="">
					<td>
						<label for="ecommerce_email_receipt_subject">
						E-mail subject:		</label>
					</td>
					<td>
						<input type="text" id="ecommerce_email_receipt_subject" name="ecommerce[email_receipt_subject]" class="ecommerce_email_receipt_subject" placeholder="Subject" value="Thank you for your purchase!">
					</td>
					</tr>
					<tr id="tr_ecommerce_email_receipt_body" class="">
					<td>
						<label for="ecommerce_email_receipt_body" title="Wrap placeholders in %%param%%. Accepted placeholders: customer_name, email, total_amount, item_count, shipping_street_address, shipping_city, shipping_state, shipping_zip, shipping_country, order_id, hash, order_details_page, admin_email, blog_name, blog_description, blog_url, site_url, and home_url" class="tooltip">
						E-mail content:		</label>
					</td>
					<td>
						<textarea id="ecommerce_email_receipt_body" name="ecommerce[email_receipt_body]" class="ecommerce[email_receipt_body]">Thank you for your order, %%customer_name%%.
						You ordered %%item_count%% items, and have been billed a total of %%total_amount%%.
						To review your order, please go to %%order_details_page%%.
						Thanks for shopping at %%site_url%%!</textarea>
					</td>
					</tr>
				</tbody>
			</table>
		</div>
		<div data-id="ngg-payment-gateways">
			<h3>Payment Gateway</h3>
			<table>
				<tbody>
					<tr id="tr_ecommerce_cheque_enable" class="ngg_payment_gateway_enable_row">
					<td>
						<label for="ecommerce_cheque_enable">
						Enable Checks		</label>
					</td>
					<td>
						<input type="radio" id="ecommerce_cheque_enable" name="ecommerce[cheque_enable]" class="ecommerce_cheque_enable" value="1">
						<label for="ecommerce_cheque_enable">Yes</label>
						&nbsp;
						<input type="radio" id="ecommerce_cheque_enable_no" name="ecommerce[cheque_enable]" class="ecommerce_cheque_enable" value="0" checked="checked">
						<label for="ecommerce_cheque_enable_no">No</label>
					</td>
					</tr>
					<tr id="tr_ecommerce_cheque_instructions" class="hidden">
					<td>
						<label for="ecommerce_cheque_instructions" title="Use this to inform users how to pay and where they should send their payment" class="tooltip">
						Instructions		</label>
					</td>
					<td>
						<textarea id="ecommerce_cheque_instructions" name="ecommerce[cheque_instructions]" class="ecommerce[cheque_instructions]">&lt;p&gt;Thanks very much for your purchase! We'll be in touch shortly via email to confirm your order and to provide details on payment.&lt;/p&gt;</textarea>
					</td>
					</tr>
					<tr id="tr_ecommerce_paypal_enable" class="ngg_payment_gateway_enable_row">
					<td>
						<label for="ecommerce_paypal_enable" title="Not all currencies are supported by all payment gateways. Please be sure to confirm your desired currency is supported by PayPal" class="tooltip">
						Enable PayPal Express Checkout		</label>
					</td>
					<td>
						<input type="radio" id="ecommerce_paypal_enable" name="ecommerce[paypal_enable]" class="ecommerce_paypal_enable" value="1">
						<label for="ecommerce_paypal_enable">Yes</label>
						&nbsp;
						<input type="radio" id="ecommerce_paypal_enable_no" name="ecommerce[paypal_enable]" class="ecommerce_paypal_enable" value="0" checked="checked">
						<label for="ecommerce_paypal_enable_no">No</label>
					</td>
					</tr>
					<tr id="tr_ecommerce_paypal_sandbox" class="hidden">
					<td>
						<label for="ecommerce_paypal_sandbox" title="If enabled transactions will use testing servers on which no currency is actually moved" class="tooltip">
						Use sandbox?		</label>
					</td>
					<td>
						<input type="radio" id="ecommerce_paypal_sandbox" name="ecommerce[paypal_sandbox]" class="ecommerce_paypal_sandbox" value="1" checked="checked">
						<label for="ecommerce_paypal_sandbox">Yes</label>
						&nbsp;
						<input type="radio" id="ecommerce_paypal_sandbox_no" name="ecommerce[paypal_sandbox]" class="ecommerce_paypal_sandbox" value="0">
						<label for="ecommerce_paypal_sandbox_no">No</label>
					</td>
					</tr>
					<tr id="tr_ecommerce_paypal_email" class="hidden">
					<td>
						<label for="ecommerce_paypal_email">
						<strong>Email</strong>		</label>
					</td>
					<td>
						<input type="text" id="ecommerce_paypal_email" name="ecommerce[paypal_email]" class="ecommerce_paypal_email" value="">
						<span class="ngg-field-error-container ngg-field-error-container-input" style="display: none;"><i class="fa fa-exclamation-triangle ngg-error-icon" aria-hidden="true"></i></span>
					</td>
					</tr>
					<tr id="tr_ecommerce_paypal_username" class="hidden">
					<td>
						<label for="ecommerce_paypal_username">
						<strong>API Username</strong>		</label>
					</td>
					<td>
						<input type="text" id="ecommerce_paypal_username" name="ecommerce[paypal_username]" class="ecommerce_paypal_username" value="">
						<span class="ngg-field-error-container ngg-field-error-container-input" style="display: none;"><i class="fa fa-exclamation-triangle ngg-error-icon" aria-hidden="true"></i></span>
					</td>
					</tr>
					<tr id="tr_ecommerce_paypal_password" class="hidden">
					<td>
						<label for="ecommerce_paypal_password">
						<strong>API Password</strong>		</label>
					</td>
					<td>
						<input type="password" id="ecommerce_paypal_password" name="ecommerce[paypal_password]" class="ecommerce_paypal_password" value="">
						<span class="ngg-field-error-container ngg-field-error-container-input" style="display: none;"><i class="fa fa-exclamation-triangle ngg-error-icon" aria-hidden="true"></i></span>
					</td>
					</tr>
					<tr id="tr_ecommerce_paypal_signature" class="hidden">
					<td>
						<label for="ecommerce_paypal_signature">
						<strong>API Signature</strong>		</label>
					</td>
					<td>
						<input type="text" id="ecommerce_paypal_signature" name="ecommerce[paypal_signature]" class="ecommerce_paypal_signature" value="">
						<span class="ngg-field-error-container ngg-field-error-container-input" style="display: none;"><i class="fa fa-exclamation-triangle ngg-error-icon" aria-hidden="true"></i></span>
					</td>
					</tr>
					<tr id="tr_ecommerce_paypal_std_enable" class="ngg_payment_gateway_enable_row">
					<td>
						<label for="ecommerce_paypal_std_enable" title="Not all currencies are supported by all payment gateways. Please be sure to confirm your desired currency is supported by PayPal" class="tooltip">
						Enable PayPal Standard		</label>
					</td>
					<td>
						<input type="radio" id="ecommerce_paypal_std_enable" name="ecommerce[paypal_std_enable]" class="ecommerce_paypal_std_enable" value="1">
						<label for="ecommerce_paypal_std_enable">Yes</label>
						&nbsp;
						<input type="radio" id="ecommerce_paypal_std_enable_no" name="ecommerce[paypal_std_enable]" class="ecommerce_paypal_std_enable" value="0" checked="checked">
						<label for="ecommerce_paypal_std_enable_no">No</label>
					</td>
					</tr>
					<tr id="tr_ecommerce_paypal_std_sandbox" class="hidden">
					<td>
						<label for="ecommerce_paypal_std_sandbox">
						Use Sandbox?		</label>
					</td>
					<td>
						<input type="radio" id="ecommerce_paypal_std_sandbox" name="ecommerce[paypal_std_sandbox]" class="ecommerce_paypal_std_sandbox" value="1" checked="checked">
						<label for="ecommerce_paypal_std_sandbox">Yes</label>
						&nbsp;
						<input type="radio" id="ecommerce_paypal_std_sandbox_no" name="ecommerce[paypal_std_sandbox]" class="ecommerce_paypal_std_sandbox" value="0">
						<label for="ecommerce_paypal_std_sandbox_no">No</label>
					</td>
					</tr>
					<tr id="tr_ecommerce_paypal_std_email" class="hidden">
					<td>
						<label for="ecommerce_paypal_std_email" title="Only PayPal Premier and Business accounts are supported" class="tooltip">
						<strong>Email</strong>		</label>
					</td>
					<td>
						<input type="text" id="ecommerce_paypal_std_email" name="ecommerce[paypal_std_email]" class="ecommerce_paypal_std_email" value="">
						<span class="ngg-field-error-container ngg-field-error-container-input" style="display: none;"><i class="fa fa-exclamation-triangle ngg-error-icon" aria-hidden="true"></i></span>
					</td>
					</tr>
					<tr id="tr_ecommerce_test_gateway_enable" class="ngg_payment_gateway_enable_row">
					<td>
						<label for="ecommerce_test_gateway_enable" title="Enables a gateway that does not collect payments and sends users directly to their order confirmation" class="tooltip">
						Enable Testing Gateway		</label>
					</td>
					<td>
						<input type="radio" id="ecommerce_test_gateway_enable" name="ecommerce[test_gateway_enable]" class="ecommerce_test_gateway_enable" value="1">
						<label for="ecommerce_test_gateway_enable">Yes</label>
						&nbsp;
						<input type="radio" id="ecommerce_test_gateway_enable_no" name="ecommerce[test_gateway_enable]" class="ecommerce_test_gateway_enable" value="0" checked="checked">
						<label for="ecommerce_test_gateway_enable_no">No</label>
					</td>
					</tr>
					<tr id="tr_stripe_enable" class="ngg_payment_gateway_enable_row">
					<td>
						<label for="stripe_enable" title="Not all currencies are supported by all payment gateways. Please be sure to confirm your desired currency is supported by Stripe" class="tooltip">
						Enable Stripe		</label>
					</td>
					<td>
						<input type="radio" id="stripe_enable" name="stripe[enable]" class="stripe_enable" value="1">
						<label for="stripe_enable">Yes</label>
						&nbsp;
						<input type="radio" id="stripe_enable_no" name="stripe[enable]" class="stripe_enable" value="0" checked="checked">
						<label for="stripe_enable_no">No</label>
					</td>
					</tr>
					<tr id="tr_stripe_key_public" class="hidden">
					<td>
						<label for="stripe_key_public">
						<strong>Public key</strong>		</label>
					</td>
					<td>
						<input type="text" id="stripe_key_public" name="stripe[key_public]" class="stripe_key_public" value="">
					</td>
					</tr>
					<tr id="tr_stripe_key_private" class="hidden">
					<td>
						<label for="stripe_key_private">
						<strong>Private key</strong>		</label>
					</td>
					<td>
						<input type="password" id="stripe_key_private" name="stripe[key_private]" class="stripe_key_private" value="">
					</td>
					</tr>
					<tr id="tr_paypal_checkout_enable" class="ngg_payment_gateway_enable_row">
					<td>
						<label for="paypal_checkout_enable" title="Not all currencies are supported by all payment gateways. Please be sure to confirm your desired currency is supported by PayPal Checkout" class="tooltip">
						Enable PayPal Checkout		</label>
					</td>
					<td>
						<input type="radio" id="paypal_checkout_enable" name="paypal_checkout[enable]" class="paypal_checkout_enable" value="1">
						<label for="paypal_checkout_enable">Yes</label>
						&nbsp;
						<input type="radio" id="paypal_checkout_enable_no" name="paypal_checkout[enable]" class="paypal_checkout_enable" value="0" checked="checked">
						<label for="paypal_checkout_enable_no">No</label>
					</td>
					</tr>
					<tr id="tr_paypal_checkout_sandbox" class="hidden">
					<td>
						<label for="paypal_checkout_sandbox">
						Use Sandbox		</label>
					</td>
					<td>
						<input type="radio" id="paypal_checkout_sandbox" name="paypal_checkout[sandbox]" class="paypal_checkout_sandbox" value="1" checked="checked">
						<label for="paypal_checkout_sandbox">Yes</label>
						&nbsp;
						<input type="radio" id="paypal_checkout_sandbox_no" name="paypal_checkout[sandbox]" class="paypal_checkout_sandbox" value="0">
						<label for="paypal_checkout_sandbox_no">No</label>
					</td>
					</tr>
					<tr id="tr_paypal_checkout_client_id" class="hidden">
					<td>
						<label for="paypal_checkout_client_id">
						<strong>Client ID</strong>		</label>
					</td>
					<td>
						<input type="text" id="paypal_checkout_client_id" name="paypal_checkout[client_id]" class="paypal_checkout_client_id" value="">
					</td>
					</tr>
					<tr id="tr_paypal_checkout_client_secret" class="hidden">
					<td>
						<label for="paypal_checkout_client_secret">
						<strong>Client secret</strong>		</label>
					</td>
					<td>
						<input type="password" id="paypal_checkout_client_secret" name="paypal_checkout[client_secret]" class="paypal_checkout_client_secret" value="">
					</td>
					</tr>
					<tr id="tr_paypal_checkout_instructions" class="hidden">
					<td colspan="2">
						<div id="ngg_pro_paypal_checkout_instructions">
							<p>See our <a href="https://www.imagely.com/docs/how-to-setup-paypal-checkout/" target="_blank" "="">documentation</a> on setting up PayPal Checkout.</p>
						</div>
					</td>
					</tr>
					<tr id="tr_ecommerce_braintree_enable" class="ngg_payment_gateway_enable_row">
					<td>
						<label for="ecommerce_braintree_enable" title="Not all currencies are supported by all payment gateways. Please be sure to confirm your desired currency is supported by Braintree" class="tooltip">
						Enable Braintree		</label>
					</td>
					<td>
						<input type="radio" id="ecommerce_braintree_enable" name="ecommerce[braintree_enable]" class="ecommerce_braintree_enable" value="1">
						<label for="ecommerce_braintree_enable">Yes</label>
						&nbsp;
						<input type="radio" id="ecommerce_braintree_enable_no" name="ecommerce[braintree_enable]" class="ecommerce_braintree_enable" value="0" checked="checked">
						<label for="ecommerce_braintree_enable_no">No</label>
					</td>
					</tr>
					<tr id="tr_ecommerce_braintree_sandbox" class="hidden">
					<td>
						<label for="ecommerce_braintree_sandbox">
						Use Sandbox		</label>
					</td>
					<td>
						<input type="radio" id="ecommerce_braintree_sandbox" name="ecommerce[braintree_sandbox]" class="ecommerce_braintree_sandbox" value="1" checked="checked">
						<label for="ecommerce_braintree_sandbox">Yes</label>
						&nbsp;
						<input type="radio" id="ecommerce_braintree_sandbox_no" name="ecommerce[braintree_sandbox]" class="ecommerce_braintree_sandbox" value="0">
						<label for="ecommerce_braintree_sandbox_no">No</label>
					</td>
					</tr>
					<tr id="tr_ecommerce_braintree_merchant_id" class="hidden">
					<td>
						<label for="ecommerce_braintree_merchant_id">
						<strong>Merchant ID</strong>		</label>
					</td>
					<td>
						<input type="text" id="ecommerce_braintree_merchant_id" name="ecommerce[braintree_merchant_id]" class="ecommerce_braintree_merchant_id" value="">
					</td>
					</tr>
					<tr id="tr_ecommerce_braintree_public_key" class="hidden">
					<td>
						<label for="ecommerce_braintree_public_key">
						<strong>Public key</strong>		</label>
					</td>
					<td>
						<input type="text" id="ecommerce_braintree_public_key" name="ecommerce[braintree_public_key]" class="ecommerce_braintree_public_key" value="">
					</td>
					</tr>
					<tr id="tr_ecommerce_braintree_private_key" class="hidden">
					<td>
						<label for="ecommerce_braintree_private_key">
						<strong>Private key</strong>		</label>
					</td>
					<td>
						<input type="password" id="ecommerce_braintree_private_key" name="ecommerce[braintree_private_key]" class="ecommerce_braintree_private_key" value="">
					</td>
					</tr>
					<tr id="tr_ecommerce_braintree_enable_paypal" class="hidden">
					<td>
						<label for="ecommerce_braintree_enable_paypal" title="PayPal is not enabled by default and must be configured first in your Brainree account." class="tooltip">
						Enable PayPal payments		</label>
					</td>
					<td>
						<input type="radio" id="ecommerce_braintree_enable_paypal" name="ecommerce[braintree_enable_paypal]" class="ecommerce_braintree_enable_paypal" value="1">
						<label for="ecommerce_braintree_enable_paypal">Yes</label>
						&nbsp;
						<input type="radio" id="ecommerce_braintree_enable_paypal_no" name="ecommerce[braintree_enable_paypal]" class="ecommerce_braintree_enable_paypal" value="0" checked="checked">
						<label for="ecommerce_braintree_enable_paypal_no">No</label>
					</td>
					</tr>
					<tr id="tr_ecommerce_braintree_pass_client_data" class="hidden">
					<td>
						<label for="ecommerce_braintree_pass_client_data" title="Braintree recommends that transactions include customer browser data for their fraud detection tools. Consult the Braintree Data Protection Addendum for more information regarding your own data protection compliance." class="tooltip">
						Send browser data to Braintree		</label>
					</td>
					<td>
						<input type="radio" id="ecommerce_braintree_pass_client_data" name="ecommerce[braintree_pass_client_data]" class="ecommerce_braintree_pass_client_data" value="1">
						<label for="ecommerce_braintree_pass_client_data">Yes</label>
						&nbsp;
						<input type="radio" id="ecommerce_braintree_pass_client_data_no" name="ecommerce[braintree_pass_client_data]" class="ecommerce_braintree_pass_client_data" value="0" checked="checked">
						<label for="ecommerce_braintree_pass_client_data_no">No</label>
					</td>
					</tr>
					<tr id="tr_braintree_instructions" class="hidden">
					<td colspan="2">
						<div id="ngg_pro_braintree_instructions">
							<p>See our <a href="https://www.imagely.com/docs/how-to-setup-braintree-checkout/" target="_blank" "="">documentation</a> on setting up Braintree.</p>
						</div>
					</td>
					</tr>
				</tbody>
			</table>
		</div>
		<div data-id="ngg-ecommerce-printlab">
			<h3>Print Lab Integration</h3>
			<p><strong>DO I NEED THIS?</strong> A credit card is needed only if you want to use automated print fulfillment.</p>
			<p><strong>WILL YOU CHARGE ME?</strong> You will not be charged now. Your card will only be charged if someone submits a print lab order on your site. At that point, you will be billed for print and shipping costs from the print lab. You would pay those costs yourself if you worked directly with the lab. We're just automating the process for you.</p>
			<p><strong>IS THIS SECURE?</strong> Assuming you've enabled SSL on your website, then yes. This form sends your card information directly to Stripe, one of the world's leading payment processors. It is stored securely at Stripe, not locally by WordPress or NextGEN Gallery. Note: Without SSL, this form is not 100% secure. You should also enable SSL before receiving payments from your own visitors.</p>
			<p><strong>AGREEMENT: By submitting your card here, you authorise Imagely to bill your card for the cost of print lab orders.</strong></p>
			<div class="ngg-stripe-status">
				<span class="stripe_connect_declined">No card on file.</span>
			</div>
			<div id="ngg-stripe-form" class="form-row" style="">
				<div id="card-element" class="StripeElement StripeElement--empty">
					<div class="__PrivateStripeElement" style="margin: 0px !important; padding: 0px !important; border: none !important; display: block !important; background: transparent !important; position: relative !important; opacity: 1 !important;">
					<iframe name="__privateStripeFrame1756" frameborder="0" allowtransparency="true" scrolling="no" role="presentation" allow="payment *" src="https://js.stripe.com/v3/elements-inner-card-3b3581feed732800f5d031951383415e.html#wait=false&amp;mids[guid]=NA&amp;mids[muid]=a5aae8ef-c857-485f-a30f-2ed7f0ff0845f2accd&amp;mids[sid]=cb74d4f4-09b7-4624-bbf1-0c3f6ae6cd500cd559&amp;hidePostalCode=true&amp;style[base][color]=%2332325d&amp;style[base][lineHeight]=24px&amp;style[base][fontFamily]=%22Helvetica+Neue%22%2C+Helvetica%2C+sans-serif&amp;style[base][fontSmoothing]=antialiased&amp;style[base][fontSize]=16px&amp;style[base][::placeholder][color]=%23aab7c4&amp;style[invalid][color]=%23fa755a&amp;style[invalid][iconColor]=%23fa755a&amp;rtl=false&amp;componentName=card&amp;keyMode=live&amp;apiKey=pk_live_yRBibCwDB4gh97T758I4VRYy&amp;referrer=https%3A%2F%2Fnextgen.localhost%2Fwp-admin%2Fadmin.php%3Fpage%3Dngg_ecommerce_options&amp;controllerId=__privateStripeController1751" title="Secure card payment input frame" style="border: none !important; margin: 0px !important; padding: 0px !important; width: 1px !important; min-width: 100% !important; overflow: hidden !important; display: block !important; user-select: none !important; transform: translate(0px) !important; color-scheme: light only !important; height: 24px;"></iframe><input class="__PrivateStripeElement-input" aria-hidden="true" aria-label=" " autocomplete="false" maxlength="1" style="border: none !important; display: block !important; position: absolute !important; height: 1px !important; top: -1px !important; left: 0px !important; padding: 0px !important; margin: 0px !important; width: 100% !important; opacity: 0 !important; background: transparent !important; pointer-events: none !important; font-size: 16px !important;">
					<div style="display: block !important; position: absolute !important; top: 50% !important; right: 0px !important; width: 0px !important; margin: 0px !important; padding: 0px !important; border: 0px !important; background: none !important; opacity: 1 !important; overflow: hidden !important;"><iframe name="cardButton1758" frameborder="0" allowtransparency="true" scrolling="no" src="https://js.stripe.com/v3/elements-inner-link-button-for-card-f60160469b6bf2db8e925e0e24420c04.html#locale=en&amp;style[foregroundColor]=%2332325d&amp;frameId=__privateStripeFrame1756&amp;publishableKey=pk_live_yRBibCwDB4gh97T758I4VRYy&amp;stripeJsId=a819a466-d72c-41fe-a836-82917904dceb&amp;mids[guid]=f20e1a05-7e7c-41c5-8035-a47316c5e5e47bacb8&amp;mids[muid]=a5aae8ef-c857-485f-a30f-2ed7f0ff0845f2accd&amp;mids[sid]=cb74d4f4-09b7-4624-bbf1-0c3f6ae6cd500cd559&amp;component=card" style="margin: 0px !important; user-select: none !important; transform: translate(0px) !important; color-scheme: light only !important; display: block !important; position: absolute !important; top: 0px !important; right: 0px !important; height: 0px !important; width: var(--stripeElementWidth) !important; padding: 0px !important; border: 0px !important; overflow: hidden !important; opacity: 1 !important;"></iframe></div>
					</div>
				</div>
				<div class="btn"><a id="update-card" href="#" class="stripe-connect light-blue"><span>Update</span></a></div>
				<!-- Used to display form errors -->
				<div id="card-errors" role="alert"></div>
			</div>
			<a data-nonce="96c1cb467f" id="delete-stripe-card" href="#" style="display:none" class="stripe-connect light-blue"><span>Remove card</span></a><i class="fas fa-lock ngg-stripe-lock"></i>
			<table>
			</table>
		</div>
		<div data-id="ngg-proofing">
			<h3>Proofing</h3>
			<table>
				<tbody>
					<tr id="tr_proofing_page_confirmation" class="">
					<td>
						<label for="proofing_page_confirmation" title="This page requires the [ngg_pro_proofing] shortcode, which will be automatically added if not already present. Selecting &quot;Create new&quot; will create a new page that will appear in your Primary Menu unless you've customized your menu settings: http://codex.wordpress.org/Appearance_Menus_SubPanel" class="tooltip">
						Confirmation page		</label>
					</td>
					<td>
						<select id="proofing_page_confirmation" name="proofing[page_confirmation]" class="proofing_page_confirmation">
							<option value="" selected="selected">Create new</option>
							<option value="128">alb</option>
							<option value="102">new test</option>
							<option value="2">Sample Page</option>
							<option value="94">new test</option>
							<option value="99">new test</option>
						</select>
					</td>
					</tr>
					<tr id="tr_proofing_trigger_text" class="">
					<td>
						<label for="proofing_trigger_text">
						Trigger text		</label>
					</td>
					<td>
						<input type="text" id="proofing_trigger_text" name="proofing[trigger_text]" class="proofing_trigger_text" value="Submit proofs">
					</td>
					</tr>
					<tr id="tr_proofing_user_confirmation_not_found" class="">
					<td>
						<label for="proofing_user_confirmation_not_found" title="This is displayed to users viewing the proofing page without a valid proofing to view" class="tooltip">
						Not found message		</label>
					</td>
					<td>
						<input type="text" id="proofing_user_confirmation_not_found" name="proofing[user_confirmation_not_found]" class="proofing_user_confirmation_not_found" value="Oops! This page usually displays details for image proofs, but you have not proofed any images yet. Please feel free to continue browsing. Thanks for visiting.">
					</td>
					</tr>
					<tr id="tr_proofing_user_confirmation_template" class="">
					<td>
						<label for="proofing_user_confirmation_template" title="Possible substition fields: user_name, user_email, proof_link, proof_details" class="tooltip">
						Confirmation template		</label>
					</td>
					<td>
						<textarea id="proofing_user_confirmation_template" name="proofing[user_confirmation_template]" class="proofing[user_confirmation_template]">&lt;p&gt;%%user_name%% has submitted the following images for proofing. &lt;a href="%%proof_link%%"&gt;Go back&lt;/a&gt;&lt;/p&gt;
						%%proof_details%%</textarea>
					</td>
					</tr>
					<tr id="tr_proofing_enable_user_email" class="">
					<td>
						<label for="proofing_enable_user_email">
						Send confirmation to users		</label>
					</td>
					<td>
						<input type="radio" id="proofing_enable_user_email" name="proofing[enable_user_email]" class="proofing_enable_user_email" value="1">
						<label for="proofing_enable_user_email">Yes</label>
						&nbsp;
						<input type="radio" id="proofing_enable_user_email_no" name="proofing[enable_user_email]" class="proofing_enable_user_email" value="0" checked="checked">
						<label for="proofing_enable_user_email_no">No</label>
					</td>
					</tr>
					<tr id="tr_proofing_user_email_subject" class="hidden">
					<td>
						<label for="proofing_user_email_subject">
						Confirmation subject		</label>
					</td>
					<td>
						<input type="text" id="proofing_user_email_subject" name="proofing[user_email_subject]" class="proofing_user_email_subject" value="Confirmation of image proof">
					</td>
					</tr>
					<tr id="tr_proofing_user_email_template" class="hidden">
					<td>
						<label for="proofing_user_email_template" title="Possible substition fields: user_name, user_email, proof_link" class="tooltip">
						Confirmation email		</label>
					</td>
					<td>
						<textarea id="proofing_user_email_template" name="proofing[user_email_template]" class="proofing[user_email_template]">Hello %%user_name%%,
						This is confirmation that you have selected and submitted the following
						images from one of our proofing galleries: %%proof_link%%
						Thanks very much!</textarea>
					</td>
					</tr>
					<tr id="tr_proofing_email_template" class="">
					<td>
						<label for="proofing_email_template" title="Possible substitution fields: admin, file_list, proof_link, user_name, user_email" class="tooltip">
						Admin email message		</label>
					</td>
					<td>
						<textarea id="proofing_email_template" name="proofing[email_template]" class="proofing[email_template]">Hi %%admin%% Administrator,
						%%user_name%% has submitted images from a proofing gallery.
						You can find the proofed images at %%proof_link%%
						Here is a comma separated list of the image file names. You can copy and
						paste this in your favorite image management software to quickly search for
						and find all selected images.
						Files: %%file_list%%</textarea>
					</td>
					</tr>
					<tr id="tr_proofing_lightbox_active_color" class="">
					<td>
						<label for="proofing_lightbox_active_color" title="When the NextGen Pro Lightbox is active an additional icon is added for image proofing, this controls the color of that icon for chosen images" class="tooltip">
						Pro Lightbox icon color		</label>
					</td>
					<td>
						<div class="wp-picker-container">
							<button type="button" class="button wp-color-result" aria-expanded="false" style="background-color: rgb(255, 255, 0);"><span class="wp-color-result-text">Select Color</span></button><span class="wp-picker-input-wrap hidden"><label><span class="screen-reader-text">Color value</span><input type="text" id="proofing_lightbox_active_color" name="proofing[lightbox_active_color]" class="proofing_lightbox_active_color nextgen_settings_field_colorpicker wp-color-picker" value="#ffff00" autocomplete="off"></label><input type="button" class="button button-small wp-picker-clear" value="Clear" aria-label="Clear color"></span>
							<div class="wp-picker-holder">
								<div class="iris-picker iris-border" style="display: none; width: 255px; height: 202.125px; padding-bottom: 23.2209px;">
								<div class="iris-picker-inner">
									<div class="iris-square" style="width: 182.125px; height: 182.125px;">
										<a class="iris-square-value ui-draggable ui-draggable-handle" href="#" style="left: 30.3542px; top: 0px;"><span class="iris-square-handle ui-slider-handle"></span></a>
										<div class="iris-square-inner iris-square-horiz" style="background-image: -webkit-linear-gradient(left, rgb(255, 0, 0), rgb(255, 128, 0), rgb(255, 255, 0), rgb(128, 255, 0), rgb(0, 255, 0), rgb(0, 255, 128), rgb(0, 255, 255), rgb(0, 128, 255), rgb(0, 0, 255), rgb(128, 0, 255), rgb(255, 0, 255), rgb(255, 0, 128), rgb(255, 0, 0));"></div>
										<div class="iris-square-inner iris-square-vert" style="background-image: -webkit-linear-gradient(top, rgba(0, 0, 0, 0), rgb(0, 0, 0));"></div>
									</div>
									<div class="iris-slider iris-strip" style="height: 205.346px; width: 28.2px; background-image: -webkit-linear-gradient(top, rgb(255, 255, 0), rgb(255, 255, 255));">
										<div class="iris-slider-offset ui-slider ui-corner-all ui-slider-vertical ui-widget ui-widget-content"><span tabindex="0" class="ui-slider-handle ui-corner-all ui-state-default" style="bottom: 100%;"></span></div>
									</div>
								</div>
								<div class="iris-palette-container"><a class="iris-palette" tabindex="0" style="background-color: rgb(0, 0, 0); height: 19.5784px; width: 19.5784px; margin-left: 0px;"></a><a class="iris-palette" tabindex="0" style="background-color: rgb(255, 255, 255); height: 19.5784px; width: 19.5784px; margin-left: 3.6425px;"></a><a class="iris-palette" tabindex="0" style="background-color: rgb(221, 51, 51); height: 19.5784px; width: 19.5784px; margin-left: 3.6425px;"></a><a class="iris-palette" tabindex="0" style="background-color: rgb(221, 153, 51); height: 19.5784px; width: 19.5784px; margin-left: 3.6425px;"></a><a class="iris-palette" tabindex="0" style="background-color: rgb(238, 238, 34); height: 19.5784px; width: 19.5784px; margin-left: 3.6425px;"></a><a class="iris-palette" tabindex="0" style="background-color: rgb(129, 215, 66); height: 19.5784px; width: 19.5784px; margin-left: 3.6425px;"></a><a class="iris-palette" tabindex="0" style="background-color: rgb(30, 115, 190); height: 19.5784px; width: 19.5784px; margin-left: 3.6425px;"></a><a class="iris-palette" tabindex="0" style="background-color: rgb(130, 36, 227); height: 19.5784px; width: 19.5784px; margin-left: 3.6425px;"></a></div>
								</div>
							</div>
						</div>
					</td>
					</tr>
				</tbody>
			</table>
		</div>
		</div>
		<p>
		<button type="submit" name="action_proxy" data-proxy-value="save" value="Save" class="button-primary ngg_save_settings_button" disabled="">
		Save Options               </button>
		</p>
	</form>
</div>
<div>
						</div>
