"use strict";
document.addEventListener('DOMContentLoaded', (event) => {
	var eleFooter = document.getElementById("nxt-footer");
	if(eleFooter && eleFooter.classList.contains("w-smart")){
		document.body.classList.add("smart-footer");
		nexterFooterSmart();
	}
	if(eleFooter && eleFooter.classList.contains("w-fixed") ) {
		nexterFooterFixed(eleFooter);
	}
	
});

var nexterFooterSmart = function(){
	var bodyContent = document.querySelector('#content.site-content'),
		offPreview = "off-preview";
	var winheight = window.innerHeight || (document.documentElement || document.body).clientHeight,
		scrollTop = window.pageYOffset || (document.documentElement || document.body.parentNode || document.body).scrollTop,
		bodyOuterheight = nexterOuterHeightFind(bodyContent);
	if ((scrollTop + winheight) >= (bodyOuterheight +10) && (200 < scrollTop)) {
		document.body.classList.add(offPreview);
	}else{
		document.body.classList.remove(offPreview);
	}
}

var nexterFooterFixed = function(el){
	var content = document.getElementById("content"),
	height = nexterOuterHeightFind(el);
	
	content.style.marginBottom = height+'px';
}

var nexterOuterHeightFind = function(elm){

    var elmHeight, elmMargin;
    if(document.all) {// IE
        elmHeight = elm.currentStyle.height;
        elmMargin = parseInt(elm.currentStyle.marginTop, 10) + parseInt(elm.currentStyle.marginBottom, 10);
    } else {// Mozilla
        elmHeight = document.defaultView.getComputedStyle(elm, '').getPropertyValue('height');
        elmMargin = parseInt(document.defaultView.getComputedStyle(elm, '').getPropertyValue('margin-top')) + parseInt(document.defaultView.getComputedStyle(elm, '').getPropertyValue('margin-bottom'));
    }
	
    return (parseInt(elmHeight,10)+elmMargin);
}

window.addEventListener('scroll', (event) => {
	var eleFooter = document.getElementById("nxt-footer");
	if(eleFooter && eleFooter.classList.contains("w-smart")){
		nexterFooterSmart();
	}
	if(eleFooter && eleFooter.classList.contains("w-fixed") ) {
		nexterFooterFixed(eleFooter);
	}
});