<?php
/**
 * Plugin Name: NextBrill Autopost
 * Plugin URI: https://nextbrill.com/product/nextbrill-autopost/
 * Description: AI-powered SEO blog post generator with OpenAI integration. Generate and publish posts from the queue. Pro version available with additional features.
 * Version: 1.0.0
 * Author: NextBrill
 * Author URI: https://nextbrill.com
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: nextbrill-autopost
 * Requires at least: 5.0
 * Requires PHP: 7.4
 */

if (!defined('ABSPATH')) {
    exit;
}

// Define constants
define('NBAPF_VERSION', '1.0.0');
define('NBAPF_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('NBAPF_PLUGIN_URL', plugin_dir_url(__FILE__));
define('NBAPF_PLUGIN_FILE', __FILE__);


// Include required files
require_once NBAPF_PLUGIN_DIR . 'includes/class-nbapf-activator.php';
require_once NBAPF_PLUGIN_DIR . 'includes/class-nbapf-deactivator.php';
require_once NBAPF_PLUGIN_DIR . 'includes/class-nbapf-admin.php';
require_once NBAPF_PLUGIN_DIR . 'includes/class-nbapf-queue.php';
require_once NBAPF_PLUGIN_DIR . 'includes/class-nbapf-scheduler.php';
require_once NBAPF_PLUGIN_DIR . 'includes/class-nbapf-generator.php';


// Activation/Deactivation hooks
register_activation_hook(__FILE__, array('NBAPF_Activator', 'activate'));
register_deactivation_hook(__FILE__, array('NBAPF_Deactivator', 'deactivate'));

// CRITICAL: Override WordPress capability checks for this plugin
add_filter('user_has_cap', 'nbapf_grant_access', 10, 4);
function nbapf_grant_access($allcaps, $caps, $args, $user) {
    // If user is logged in, grant them access to AutoPost
    if (is_user_logged_in()) {
        $allcaps['access_autopost'] = true;
    }
    return $allcaps;
}

// Add custom cron schedules for frequent processing
add_filter('cron_schedules', 'nbapf_add_cron_schedules');
function nbapf_add_cron_schedules($schedules) {
    $schedules['nbapf_every_minute'] = array(
        'interval' => 60, // 60 seconds
        'display' => __('Every Minute', 'nextbrill-autopost')
    );
    $schedules['nbapf_every_5minutes'] = array(
        'interval' => 300, // 5 minutes
        'display' => __('Every 5 Minutes', 'nextbrill-autopost')
    );
    return $schedules;
}

// Enqueue FAQ accordion assets on frontend (with inline header styles)
add_action('wp_enqueue_scripts', 'nbapf_enqueue_faq_assets');
function nbapf_enqueue_faq_assets() {
    wp_enqueue_style('nbapf-faq-css', NBAPF_PLUGIN_URL . 'public/css/faq-accordion.css', array(), NBAPF_VERSION);
    wp_add_inline_style('nbapf-faq-css', '.entry-content h2, .post-content h2, article h2 { font-size: 28px !important; max-font-size: 28px !important; } .entry-content h3, .post-content h3, article h3 { font-size: 24px !important; max-font-size: 24px !important; }');
    wp_enqueue_script('nbapf-faq-js', NBAPF_PLUGIN_URL . 'public/js/faq-accordion.js', array(), NBAPF_VERSION, true);
}

// Initialize plugin
function nbapf_init() {
    new NBAPF_Scheduler();
    
    // Only initialize admin interface when user is logged in
    if (is_user_logged_in()) {
        new NBAPF_Admin();
    }
}
add_action('plugins_loaded', 'nbapf_init');
