<?php
if (!defined('ABSPATH')) exit;

class NBAPF_Queue {

    /**
     * Whether there is a pending or processing item (user must complete before adding another).
     */
    public function has_pending_or_processing() {
        global $wpdb;
        $table = $wpdb->prefix . 'nbapf_queue';
        $table_escaped = esc_sql($table);
        // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared,WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching -- Table name safe, custom table
        $count = $wpdb->get_var("SELECT COUNT(*) FROM `{$table_escaped}` WHERE status IN ('pending', 'processing')");
        return (int) $count > 0;
    }

    public function add_to_queue($data) {
        global $wpdb;
        // No scheduling: process as soon as possible (scheduled_time = now).
        $scheduled_time = current_time('mysql');
        $interval_type = isset($data['publish_interval_type']) ? $data['publish_interval_type'] : 'days';
        $interval_value = isset($data['publish_interval_value']) ? (int) $data['publish_interval_value'] : 1;

        // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery -- Custom table operation, necessary for plugin functionality
        $result = $wpdb->insert($wpdb->prefix . 'nbapf_queue', array(
            'topic_title' => $data['topic_title'], 'focus_keyword' => $data['focus_keyword'],
            'secondary_keywords' => $data['secondary_keywords'] ?? '', 'internal_links' => $data['internal_links'] ?? '',
            'external_links' => $data['external_links'] ?? '', 'include_faq' => $data['include_faq'] ?? 0,
            'category' => $data['category'] ?? 0, 'tags' => $data['tags'] ?? '',
            'publish_interval_type' => $interval_type, 'publish_interval_value' => $interval_value,
            'featured_image_keyword' => $data['featured_image_keyword'] ?? '', 'desired_word_count' => $data['desired_word_count'] ?? 1500,
            'status' => 'pending', 'scheduled_time' => $scheduled_time, 'created_at' => current_time('mysql')
        ), array('%s', '%s', '%s', '%s', '%s', '%d', '%d', '%s', '%s', '%d', '%s', '%d', '%s', '%s', '%s'));
        
        return $result !== false;
    }
    
    public function get_all_items() {
        global $wpdb;
        // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching -- Custom table operation, real-time data needed
        return $wpdb->get_results("SELECT * FROM {$wpdb->prefix}nbapf_queue ORDER BY scheduled_time ASC");
    }
    
    public function get_statistics() {
        global $wpdb;
        $table = $wpdb->prefix . 'nbapf_queue';
        // Table name is safe as it comes from $wpdb->prefix which is controlled by WordPress
        $table_escaped = esc_sql($table);
        return array(
            // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared,WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching -- Table name is safe, custom table operation, real-time data needed
            'total' => $wpdb->get_var("SELECT COUNT(*) FROM `{$table_escaped}`"),
            // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared -- Table name is safe, comes from $wpdb->prefix
            'pending' => $wpdb->get_var($wpdb->prepare("SELECT COUNT(*) FROM `{$table_escaped}` WHERE status = %s", 'pending')),
            // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared -- Table name is safe, comes from $wpdb->prefix
            'processing' => $wpdb->get_var($wpdb->prepare("SELECT COUNT(*) FROM `{$table_escaped}` WHERE status = %s", 'processing')),
            // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared -- Table name is safe, comes from $wpdb->prefix
            'completed' => $wpdb->get_var($wpdb->prepare("SELECT COUNT(*) FROM `{$table_escaped}` WHERE status = %s", 'completed')),
            // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared -- Table name is safe, comes from $wpdb->prefix
            'failed' => $wpdb->get_var($wpdb->prepare("SELECT COUNT(*) FROM `{$table_escaped}` WHERE status = %s", 'failed'))
        );
    }
    
    public function delete_item($id) {
        global $wpdb;
        // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching -- Custom table operation, necessary for plugin functionality
        return $wpdb->delete($wpdb->prefix . 'nbapf_queue', array('id' => $id), array('%d'));
    }
}

