<?php
/**
 * Fired during plugin activation
 */

if (!defined('ABSPATH')) {
    exit;
}

class NBAPF_Activator {
    
    public static function activate() {
        global $wpdb;
        
        $charset_collate = $wpdb->get_charset_collate();
        
        // Create queue table
        $queue_table = $wpdb->prefix . 'nbapf_queue';
        $sql_queue = "CREATE TABLE IF NOT EXISTS $queue_table (
            id bigint(20) NOT NULL AUTO_INCREMENT,
            topic_title varchar(255) NOT NULL,
            focus_keyword varchar(100) NOT NULL,
            secondary_keywords text,
            internal_links text,
            external_links text,
            include_faq tinyint(1) DEFAULT 0,
            category bigint(20),
            tags text,
            publish_interval_type varchar(20) NOT NULL DEFAULT 'days',
            publish_interval_value int(11) NOT NULL DEFAULT 1,
            featured_image_keyword varchar(255),
            desired_word_count int(11) DEFAULT 1500,
            status varchar(50) NOT NULL DEFAULT 'pending',
            scheduled_time datetime DEFAULT NULL,
            post_id bigint(20) DEFAULT NULL,
            error_message text,
            created_at datetime DEFAULT CURRENT_TIMESTAMP,
            PRIMARY KEY (id),
            KEY status (status),
            KEY scheduled_time (scheduled_time)
        ) $charset_collate;";
        
        require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
        dbDelta($sql_queue);
        
        // Schedule cron event - use every minute for frequent processing
        if (!wp_next_scheduled('nbapf_process_queue')) {
            wp_schedule_event(time(), 'nbapf_every_minute', 'nbapf_process_queue');
        }
    }
}

