<?php
if (!defined('ABSPATH')) {
    exit;
}
?>
<div class="wrap">
    <h1>⚙️ Settings</h1>
    
    <?php
    // phpcs:ignore WordPress.Security.NonceVerification.Recommended -- GET parameters used for display messages only
    $nbapf_message = isset($_GET['message']) ? sanitize_text_field(wp_unslash($_GET['message'])) : '';
    if ($nbapf_message === 'settings_saved') :
    ?>
    <div class="notice notice-success is-dismissible">
        <p><strong>Success!</strong> Settings saved.</p>
    </div>
    <?php endif; ?>
    
    <form method="post" action="<?php echo esc_url( admin_url('admin-post.php') ); ?>" class="nbapf-form-card nbapf-form-card-narrow">
        <?php wp_nonce_field('nbapf-save-settings'); ?>
        <input type="hidden" name="action" value="nbapf_save_settings">
        
        <h2>OpenAI Configuration</h2>
        <table class="form-table">
            <tr>
                <th><label for="openai_api_key">API Key *</label></th>
                <td>
                    <input type="password" name="openai_api_key" id="openai_api_key" value="<?php echo esc_attr(get_option('nbapf_openai_api_key', '')); ?>" class="regular-text">
                    <p class="description">Get your API key from <a href="https://platform.openai.com/api-keys" target="_blank" rel="noopener noreferrer">OpenAI Platform</a></p>
                </td>
            </tr>
            <tr>
                <th><label for="openai_model">Model</label></th>
                <td>
                    <select name="openai_model" id="openai_model">
                        <option value="gpt-4" <?php selected(get_option('nbapf_openai_model', 'gpt-4'), 'gpt-4'); ?>>GPT-4</option>
                        <option value="gpt-3.5-turbo" <?php selected(get_option('nbapf_openai_model'), 'gpt-3.5-turbo'); ?>>GPT-3.5 Turbo</option>
                    </select>
                </td>
            </tr>
            <tr>
                <th><label for="use_dalle">Use DALL-E for Images</label></th>
                <td>
                    <input type="checkbox" name="use_dalle" id="use_dalle" value="1" <?php checked(get_option('nbapf_use_dalle'), true); ?>>
                    <label for="use_dalle">Generate featured images using DALL-E</label>
                </td>
            </tr>
        </table>
        
        <p class="submit">
            <button type="submit" class="button button-primary button-large">Save Settings</button>
        </p>
    </form>
    
    <div class="nbapf-pro-cta nbapf-pro-cta-sm">
        <h3>🚀 Upgrade to Pro</h3>
        <p>Get unlimited posts, priority support, and all premium features!</p>
        <a href="https://nextbrill.com/product/nextbrill-autopost/" target="_blank" rel="noopener noreferrer" class="button button-primary button-hero">Upgrade Now →</a>
    </div>
</div>
