<?php
if (!defined('ABSPATH')) {
    exit;
}
?>
<div class="wrap">
    <h1>📋 Queue</h1>
    
    <div class="notice notice-info nbapf-notice-info">
        <p>Process pending items below. <a href="https://nextbrill.com/product/nextbrill-autopost/" target="_blank" rel="noopener noreferrer">Pro version</a> adds bulk tools and priority support.</p>
    </div>
    
    <?php
    // phpcs:ignore WordPress.Security.NonceVerification.Recommended -- GET parameters used for display messages only
    $nbapf_message = isset($_GET['message']) ? sanitize_text_field(wp_unslash($_GET['message'])) : '';
    if ($nbapf_message === 'queue_processed') :
    ?>
    <div class="notice notice-success is-dismissible">
        <p><strong>Queue processed!</strong> Check the status of your posts below.</p>
    </div>
    <?php endif; ?>
    
    <?php if ($nbapf_message === 'item_deleted') : ?>
    <div class="notice notice-success is-dismissible">
        <p><strong>Item deleted!</strong> The queue item has been removed.</p>
    </div>
    <?php endif; ?>
    
    <div class="nbapf-queue-actions">
        <a href="<?php echo esc_url( wp_nonce_url(admin_url('admin-post.php?action=nbapf_process_now'), 'nbapf-process-now') ); ?>" class="button button-primary button-large">
            ⚡ Process Queue Now
        </a>
        <p class="description">Process the pending post now (no scheduling — one at a time).</p>
    </div>
    
    <div class="nbapf-queue-table-wrap">
        <table class="wp-list-table widefat fixed striped">
            <thead>
                <tr>
                    <th>Topic</th>
                    <th>Focus Keyword</th>
                    <th>Status</th>
                    <th>Added</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php if (empty($items)) : ?>
                <tr>
                    <td colspan="5" class="nbapf-queue-empty">
                        <p>No items in queue yet.</p>
                        <a href="<?php echo esc_url( admin_url('admin.php?page=nbapf-add-queue') ); ?>" class="button button-primary">Add Your First Post</a>
                    </td>
                </tr>
                <?php else : ?>
                    <?php foreach ($items as $nbapf_item) : ?>
                    <tr>
                        <td><strong><?php echo esc_html($nbapf_item->topic_title); ?></strong></td>
                        <td><?php echo esc_html($nbapf_item->focus_keyword); ?></td>
                        <td>
                            <?php
                            $nbapf_status_class = 'nbapf-status-' . esc_attr($nbapf_item->status);
                            ?>
                            <span class="nbapf-status-badge <?php echo esc_attr( $nbapf_status_class ); ?>">
                                <?php echo esc_html( strtoupper($nbapf_item->status) ); ?>
                            </span>
                            <?php if ($nbapf_item->status === 'failed' && !empty($nbapf_item->error_message)) : ?>
                                <br><small class="nbapf-status-error-msg"><?php echo esc_html($nbapf_item->error_message); ?></small>
                            <?php endif; ?>
                        </td>
                        <td><?php echo esc_html( date_i18n('M j, Y g:i A', strtotime($nbapf_item->created_at)) ); ?></td>
                        <td>
                            <?php if ($nbapf_item->post_id) : ?>
                                <a href="<?php echo esc_url( get_edit_post_link($nbapf_item->post_id) ); ?>" class="button button-small">Edit Post</a>
                            <?php endif; ?>
                            <a href="<?php echo esc_url( wp_nonce_url(admin_url('admin-post.php?action=nbapf_delete_queue_item&id=' . $nbapf_item->id), 'nbapf-delete-queue-item') ); ?>" class="button button-small nbapf-delete-queue-item" data-confirm="<?php echo esc_attr__( 'Delete this item?', 'nextbrill-autopost' ); ?>">Delete</a>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
    
    <div class="nbapf-pro-cta nbapf-pro-cta-sm">
        <h3>🚀 NextBrill Autopost Pro</h3>
        <p>Bulk tools and priority support — available as a separate product.</p>
        <a href="https://nextbrill.com/product/nextbrill-autopost/" target="_blank" rel="noopener noreferrer" class="button button-primary button-hero">Learn more →</a>
    </div>
</div>
