<?php
if (!defined('ABSPATH')) {
    exit;
}
?>
<div class="wrap">
    <h1>🚀 NextBrill Autopost - Dashboard</h1>
    
    <div class="notice notice-info nbapf-notice-info">
        <p>Add posts to your queue and let AI generate SEO-optimized content. <a href="https://nextbrill.com/product/nextbrill-autopost/" target="_blank" rel="noopener noreferrer">Pro version</a> adds bulk tools and priority support.</p>
    </div>
    
    <div class="nbapf-stats-grid">
        <div class="nbapf-stat-card nbapf-stat-total">
            <div class="nbapf-stat-number"><?php echo esc_html( $stats['total'] ?? 0 ); ?></div>
            <div class="nbapf-stat-label">Total Posts</div>
        </div>
        <div class="nbapf-stat-card nbapf-stat-pending">
            <div class="nbapf-stat-number"><?php echo esc_html( $stats['pending'] ?? 0 ); ?></div>
            <div class="nbapf-stat-label">Pending</div>
        </div>
        <div class="nbapf-stat-card nbapf-stat-completed">
            <div class="nbapf-stat-number"><?php echo esc_html( $stats['completed'] ?? 0 ); ?></div>
            <div class="nbapf-stat-label">Completed</div>
        </div>
        <div class="nbapf-stat-card nbapf-stat-failed">
            <div class="nbapf-stat-number"><?php echo esc_html( $stats['failed'] ?? 0 ); ?></div>
            <div class="nbapf-stat-label">Failed</div>
        </div>
    </div>
    
    <div class="nbapf-card nbapf-card-actions">
        <h2>Quick Actions</h2>
        <div class="nbapf-actions-grid">
            <a href="<?php echo esc_url( admin_url('admin.php?page=nbapf-add-queue') ); ?>" class="button button-primary button-hero nbapf-action-btn">
                <span class="nbapf-action-icon">➕</span>
                <span class="nbapf-action-text">Add to Queue</span>
            </a>
            <a href="<?php echo esc_url( admin_url('admin.php?page=nbapf-queue') ); ?>" class="button button-hero nbapf-action-btn">
                <span class="nbapf-action-icon">📋</span>
                <span class="nbapf-action-text">View Queue</span>
            </a>
            <a href="<?php echo esc_url( admin_url('admin.php?page=nbapf-settings') ); ?>" class="button button-hero nbapf-action-btn">
                <span class="nbapf-action-icon">⚙️</span>
                <span class="nbapf-action-text">Settings</span>
            </a>
        </div>
    </div>
    
    <div class="nbapf-how-section">
        <h3>📚 How It Works</h3>
        <div class="nbapf-how-grid">
            <div class="nbapf-how-step">
                <div class="nbapf-step-num">1️⃣</div>
                <strong>Add to Queue</strong>
                <p>Enter your topic, keywords, and preferences</p>
            </div>
            <div class="nbapf-how-step">
                <div class="nbapf-step-num">2️⃣</div>
                <strong>AI Generates</strong>
                <p>OpenAI creates SEO-optimized, high-quality content</p>
            </div>
            <div class="nbapf-how-step">
                <div class="nbapf-step-num">3️⃣</div>
                <strong>Auto Publish</strong>
                <p>Posts are published when you process the queue</p>
            </div>
        </div>
    </div>
    
    <div class="nbapf-pro-cta">
        <h2>🚀 NextBrill Autopost Pro</h2>
        <p>Bulk tools, priority support, and more — available as a separate product.</p>
        <a href="https://nextbrill.com/product/nextbrill-autopost/" target="_blank" rel="noopener noreferrer" class="button button-primary button-hero">Upgrade Now →</a>
    </div>
</div>
