<?php
if (!defined('ABSPATH')) {
    exit;
}
?>
<div class="wrap">
    <h1>➕ Add Post to Queue</h1>
    
    <?php
    // phpcs:ignore WordPress.Security.NonceVerification.Recommended -- GET used for display only
    $nbapf_message = isset($_GET['message']) ? sanitize_text_field(wp_unslash($_GET['message'])) : '';
    if ($nbapf_message === 'added_to_queue') :
    ?>
    <div class="notice notice-success is-dismissible">
        <p><strong>Success!</strong> Post added to queue. Process it from the Queue page, then you can add the next one.</p>
    </div>
    <?php endif; ?>
    
    <?php if ($nbapf_message === 'add_failed') : ?>
    <div class="notice notice-error is-dismissible">
        <p><strong>Failed.</strong> Topic title and focus keyword are required.</p>
    </div>
    <?php endif; ?>
    
    <?php if ($nbapf_message === 'complete_current_first') : ?>
    <div class="notice notice-warning is-dismissible">
        <p><strong>Finish the current post first.</strong> Complete or remove the item in the queue before adding another.</p>
    </div>
    <?php endif; ?>
    
    <?php if (!$can_add_post) : ?>
    <div class="notice notice-info nbapf-notice-info nbapf-notice-box">
        <p>You have a post in the queue. After it's published (or removed), you can add the next one here.</p>
        <a href="<?php echo esc_url( admin_url('admin.php?page=nbapf-queue') ); ?>" class="button button-primary">View Queue</a>
    </div>
    <?php else : ?>
    <div class="notice notice-info nbapf-notice-info">
        <p>Add one post at a time. When this one is completed and published, you can add the next. <a href="https://nextbrill.com/product/nextbrill-autopost/" target="_blank" rel="noopener noreferrer">Pro version</a> offers bulk and scheduling.</p>
    </div>
    
    <form method="post" action="<?php echo esc_url( admin_url('admin-post.php') ); ?>" class="nbapf-form-card">
        <?php wp_nonce_field('nbapf-add-to-queue'); ?>
        <input type="hidden" name="action" value="nbapf_add_to_queue">
        
        <table class="form-table">
            <tr>
                <th scope="row" class="nbapf-th-label"><label for="topic_title">Topic Title *</label></th>
                <td><input type="text" name="topic_title" id="topic_title" class="regular-text" required value=""></td>
            </tr>
            <tr>
                <th><label for="focus_keyword">Focus Keyword *</label></th>
                <td><input type="text" name="focus_keyword" id="focus_keyword" class="regular-text" required value=""></td>
            </tr>
            <tr>
                <th><label for="secondary_keywords">Secondary Keywords</label></th>
                <td><textarea name="secondary_keywords" id="secondary_keywords" rows="2" class="large-text" placeholder="keyword1, keyword2, keyword3"></textarea></td>
            </tr>
            <tr>
                <th><label for="internal_links">Internal Links</label></th>
                <td>
                    <textarea name="internal_links" id="internal_links" rows="3" class="large-text" placeholder="https://yoursite.com/page1&#10;One link per line"></textarea>
                    <p class="description">Enter internal links (one per line). AI will add these with relevant anchor text.</p>
                </td>
            </tr>
            <tr>
                <th><label for="external_links">External Links</label></th>
                <td>
                    <textarea name="external_links" id="external_links" rows="3" class="large-text" placeholder="https://example.com/page1&#10;One link per line (optional)"></textarea>
                    <p class="description">Optional. If empty, AI may add relevant external links.</p>
                </td>
            </tr>
            <tr>
                <th><label for="include_faq">Include FAQs</label></th>
                <td>
                    <label for="include_faq">
                        <input type="checkbox" name="include_faq" id="include_faq" value="1">
                        Include FAQ section (6 FAQs in accordion format)
                    </label>
                </td>
            </tr>
            <tr>
                <th><label for="desired_word_count">Word Count</label></th>
                <td><input type="number" name="desired_word_count" id="desired_word_count" value="1500" min="500" max="5000" class="nbapf-word-count-input"></td>
            </tr>
            <tr>
                <th><label for="category">Category</label></th>
                <td><?php wp_dropdown_categories(array('name' => 'category', 'id' => 'category', 'show_option_none' => '-- Select Category --', 'hide_empty' => 0)); ?></td>
            </tr>
            <tr>
                <th><label for="tags">Tags</label></th>
                <td><input type="text" name="tags" id="tags" class="regular-text" placeholder="tag1, tag2, tag3"></td>
            </tr>
        </table>
        
        <p class="submit">
            <button type="submit" class="button button-primary button-hero">Add Post to Queue</button>
        </p>
    </form>
    <?php endif; ?>
    
    <div class="nbapf-pro-cta nbapf-pro-cta-sm">
        <h3>🚀 NextBrill Autopost Pro</h3>
        <p>Bulk entry and scheduling — available as a separate product.</p>
        <a href="https://nextbrill.com/product/nextbrill-autopost/" target="_blank" rel="noopener noreferrer" class="button button-primary button-hero">Learn more →</a>
    </div>
</div>
