/**
 * Add to Queue page: dynamic post rows and count
 */
(function($) {
    'use strict';

    if (typeof nbapfAddQueue === 'undefined') {
        return;
    }

    $(function() {
        var maxPosts = nbapfAddQueue.maxPosts;
    var remainingPosts = nbapfAddQueue.remainingPosts;
    var postCount = 1;

    function updatePostCount() {
        $('#post-count').html('Posts: <strong>' + postCount + '</strong> / ' + maxPosts);

        if (postCount >= maxPosts) {
            $('#add-more-posts').prop('disabled', true).text('Maximum Posts Reached');
        } else {
            $('#add-more-posts').prop('disabled', false).text('➕ Add Another Post');
        }
    }

    $('#add-more-posts').on('click', function() {
        if (postCount >= maxPosts) {
            alert('Maximum ' + maxPosts + ' posts allowed (limited by remaining free posts)');
            return;
        }

        postCount++;

        var postHtml = '<div class="post-item nbapf-post-item" data-index="' + postCount + '">' +
            '<button type="button" class="remove-post nbapf-remove-post">✕ Remove</button>' +
            '<h3 class="nbapf-post-item-title">Post #' + postCount + '</h3>' +
            '<table class="form-table">' +
            '<tr><th class="nbapf-th"><label>Topic Title *</label></th>' +
            '<td><input type="text" name="posts[' + postCount + '][topic_title]" class="regular-text" required></td></tr>' +
            '<tr><th class="nbapf-th"><label>Focus Keyword *</label></th>' +
            '<td><input type="text" name="posts[' + postCount + '][focus_keyword]" class="regular-text" required></td></tr>' +
            '<tr><th class="nbapf-th"><label>Secondary Keywords</label></th>' +
            '<td><textarea name="posts[' + postCount + '][secondary_keywords]" rows="2" class="large-text" placeholder="keyword1, keyword2, keyword3"></textarea></td></tr>' +
            '<tr><th class="nbapf-th"><label>Internal Links</label></th>' +
            '<td><textarea name="posts[' + postCount + '][internal_links]" rows="3" class="large-text" placeholder="https://yoursite.com/page1&#10;https://yoursite.com/page2&#10;One link per line"></textarea>' +
            '<p class="description">Enter internal links (one per line)</p></td></tr>' +
            '<tr><th class="nbapf-th"><label>External Links</label></th>' +
            '<td><textarea name="posts[' + postCount + '][external_links]" rows="3" class="large-text" placeholder="https://example.com/page1&#10;https://example.com/page2&#10;One link per line (optional)"></textarea>' +
            '<p class="description">Enter external links (one per line). If empty, AI will add automatically.</p></td></tr>' +
            '<tr><th class="nbapf-th"><label>Include FAQs</label></th>' +
            '<td><label><input type="checkbox" name="posts[' + postCount + '][include_faq]" value="1"> Include FAQ section (up to 6 FAQs)</label></td></tr>' +
            '<tr><th class="nbapf-th"><label>Word Count</label></th>' +
            '<td><input type="number" name="posts[' + postCount + '][desired_word_count]" value="1500" min="500" max="5000" class="nbapf-word-count-input"></td></tr>' +
            '</table></div>';

        $('#posts-container').append(postHtml);
        updatePostCount();
    });

    $(document).on('click', '.remove-post', function() {
        $(this).closest('.post-item').remove();
        postCount--;
        updatePostCount();
        renumberPosts();
    });

    function renumberPosts() {
        $('.post-item').each(function(index) {
            var newIndex = index + 1;
            $(this).attr('data-index', newIndex);
            $(this).find('h3').first().text('Post #' + newIndex);

            $(this).find('input[name*="topic_title"]').attr('name', 'posts[' + newIndex + '][topic_title]');
            $(this).find('input[name*="focus_keyword"]').attr('name', 'posts[' + newIndex + '][focus_keyword]');
            $(this).find('textarea[name*="secondary_keywords"]').attr('name', 'posts[' + newIndex + '][secondary_keywords]');
            $(this).find('textarea[name*="internal_links"]').attr('name', 'posts[' + newIndex + '][internal_links]');
            $(this).find('textarea[name*="external_links"]').attr('name', 'posts[' + newIndex + '][external_links]');
            $(this).find('input[name*="include_faq"]').attr('name', 'posts[' + newIndex + '][include_faq]');
            $(this).find('input[name*="desired_word_count"]').attr('name', 'posts[' + newIndex + '][desired_word_count]');
        });
    }

    updatePostCount();
    });
})(jQuery);
