# Next Exit Chatbot

Tested up to:      6.8
Stable tag:        1.0.1
License:           GNU General Public License v3.0
License URI:       https://www.gnu.org/licenses/gpl-3.0.html
Tags:              Next Exit, chatbot, integration

A WordPress plugin that embeds the Next Exit chatbot.

## Description

A WordPress plugin that adds a Gutenberg block for embedding the Next Exit chatbot on your site. See the <a href="https://www.nextexit.ai">Next Exit site</a> for a description, <a href="http://www.nextexit.ai/privacy">Privacy Policy</a>, <a href="http://www.nextexit.ai/terms-of-service">Terms of Service</a>, and more information.

## External services

This plugin enables a service provided by *Next Exit, LLC*, a Tennessee limited liability company. [Terms of service](https://www.nextexit.ai/pages/terms-of-service) and [Privacy Policy](https://www.nextexit.ai/pages/privacy) can be found on [our website](https://www.nextexit.ai) at www.nextexit.ai.

The plugin enables a chatbot that is loaded from Google Cloud Storage, currently located at `https://storage.googleapis.com/www.nextexit.ai/nextexit-widget.umd.cjs`. The chatbot connects to our websocket server at `wss://5nb3qtfa9d.execute-api.us-west-2.amazonaws.com/production/`.

- Next Exit is an AI agent that helps to manage customers automatically by answering questions and booking meetings.
- The chatbot transmits the user's locale string to our servers when it is rendered in the browser. Data entered into the chatbot is transmitted to our websocket server when the user submits it.

## Features

- 🎯 **Gutenberg Block**: Easy drag-and-drop placement using the block editor
- ⚙️ **Simple Configuration**: Just enter your Firm ID in the block settings
- 🎨 **Visual Editor**: See exactly where the widget will appear
- 📱 **Responsive**: Works on all devices and themes
- 🔧 **Settings Page**: Set default Firm ID for all new blocks

## Usage

### Adding the Widget to a Page

1. **Edit a Page/Post:**
   - Open any page or post in the block editor (Gutenberg)

2. **Add the Block:**
   - Click the "+" button to add a new block
   - Search for "Next Exit Widget" and select it

3. **Configure the Widget:**
   - In the block settings panel (right sidebar), enter your **Firm ID**
   - The Firm ID is a GUID you get from the Next Exit portal

4. **Publish/Update:**
   - Save your changes and view the page
   - The widget will appear where you placed the block

### Global Settings

You can set a default Firm ID for all new widget blocks:

1. Go to **Settings → Next Exit Chatbot**
2. Enter your default Firm ID
3. Click **Save Changes**

This Firm ID will be pre-filled when creating new widget blocks, but can still be overridden in individual blocks.

## Requirements

- WordPress 5.0+ (for Gutenberg blocks)
- PHP 7.4+
- Modern web browser

## Support

For issues or questions, email <a href=mailto:support@nextexit.ai>Next Exit Support</a>.
- Check that your Firm ID is correct
- Ensure the target page loads properly
- Verify the widget script loads (check browser console)

## Changelog

### Version 1.0.0
- Initial release
