<?php
add_action( 'admin_menu', 'nexs_add_admin_menu' );
add_action( 'admin_init', 'nexs_settings_init' );


function nexs_add_admin_menu(  ) { 

	add_options_page( 'NExS App Embed', 'NExS App Embed', 'manage_options', 'nexs_app_embed', 'nexs_options_page' );

}


function nexs_settings_init(  ) { 

	register_setting( 'pluginPage', 'nexs_settings', array('sanitize_callback' =>  'sanitize_text_field') );

	add_settings_section(
		'nexs_pluginPage_section', 
		__( 'Settings for NExS embedded apps', 'nexs-app-embed' ), 
		'nexs_settings_section_callback', 
		'pluginPage'
	);

	add_settings_field( 
		'nexs_text_field_0', 
		__( 'NExS app host server', 'nexs-app-embed' ), 
		'nexs_text_field_0_render', 
		'pluginPage', 
		'nexs_pluginPage_section' 
	);

	add_settings_field( 
		'nexs_text_field_1', 
		__( 'NExS static files server', 'nexs-app-embed' ), 
		'nexs_text_field_1_render', 
		'pluginPage', 
		'nexs_pluginPage_section' 
	);

}


function nexs_text_field_0_render(  ) { 

	$options = get_option( 'nexs_settings' );
	?>
	<input type='text' size='50' name='nexs_settings[host]' value='<?php echo esc_attr($options['host']); ?>'>
	<?php

}


function nexs_text_field_1_render(  ) { 

	$options = get_option( 'nexs_settings' );
	?>
	<input type='text' size='50' name='nexs_settings[static]' value='<?php echo esc_attr($options['static']); ?>'>
	<?php

}


function nexs_settings_section_callback(  ) { 

	echo esc_html(__( 'Configuration options for embedding NExS apps on a page', 'nexs-app-embed' ));

}


function nexs_options_page(  ) { 

	?>
	<form action='options.php' method='post'>

		<h2>NExS App Embed</h2>

		<?php
		settings_fields( 'pluginPage' );
		do_settings_sections( 'pluginPage' );
		submit_button();
		?>

	</form>
	<?php

}

?>
