<?php
if (!defined('ABSPATH')) {
    exit;
}

$user_tickets = array();
if (is_user_logged_in()) {
    $user_tickets = NexlifyDesk_Tickets::get_user_tickets(get_current_user_id());
}

$submit_url = '';
if (class_exists('NexlifyDesk_Shortcodes') && method_exists('NexlifyDesk_Shortcodes', 'get_submit_ticket_url')) {
    $submit_url = NexlifyDesk_Shortcodes::get_submit_ticket_url();
}
?>
<div class="nexlifydesk-table-container">
    <header class="nexlifydesk-table-header">
        <h1><?php esc_html_e('Support Tickets', 'nexlifydesk'); ?></h1>
        <div class="nexlifydesk-header-actions">
            <?php if (!empty($submit_url) && $submit_url !== home_url()) : ?>
                <a href="<?php echo esc_url($submit_url); ?>" class="nexlifydesk-btn-primary">
                    <?php esc_html_e('New Ticket', 'nexlifydesk'); ?>
                </a>
            <?php endif; ?>
        </div>
    </header>

    <?php if (empty($user_tickets)) : ?>
        <div class="nexlifydesk-no-tickets-table">
            <div class="nexlifydesk-no-tickets-icon">📄</div>
            <h3><?php esc_html_e('No tickets found', 'nexlifydesk'); ?></h3>
            <p><?php esc_html_e('You haven\'t submitted any support tickets yet.', 'nexlifydesk'); ?></p>
            <?php if (!empty($submit_url) && $submit_url !== home_url()) : ?>
                <a href="<?php echo esc_url($submit_url); ?>" class="nexlifydesk-btn-primary">
                    <?php esc_html_e('Submit Your First Ticket', 'nexlifydesk'); ?>
                </a>
            <?php endif; ?>
        </div>
    <?php else : ?>
        <table class="nexlifydesk-ticket-table">
            <thead>
                <tr>
                    <th><?php esc_html_e('ID', 'nexlifydesk'); ?></th>
                    <th><?php esc_html_e('Subject', 'nexlifydesk'); ?></th>
                    <th><?php esc_html_e('Status', 'nexlifydesk'); ?></th>
                    <th><?php esc_html_e('Priority', 'nexlifydesk'); ?></th>
                    <th><?php esc_html_e('Date', 'nexlifydesk'); ?></th>
                    <th><?php esc_html_e('Actions', 'nexlifydesk'); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($user_tickets as $ticket) : ?>
                    <tr>
                        <td data-label="<?php esc_attr_e('ID', 'nexlifydesk'); ?>">#<?php echo esc_html($ticket->ticket_id); ?></td>
                        <td data-label="<?php esc_attr_e('Subject', 'nexlifydesk'); ?>" class="nexlifydesk-subject-cell">
                            <?php echo esc_html($ticket->subject); ?>
                            <?php if (!empty($ticket->message)) : ?>
                                <div class="nexlifydesk-ticket-preview">
                                    <?php echo esc_html(wp_trim_words($ticket->message, 15, '...')); ?>
                                </div>
                            <?php endif; ?>
                        </td>
                        <td data-label="<?php esc_attr_e('Status', 'nexlifydesk'); ?>">
                            <span class="nexlifydesk-status <?php echo esc_attr(str_replace('_', '-', $ticket->status)); ?>">
                                <?php echo esc_html(ucfirst(str_replace('_', ' ', $ticket->status))); ?>
                            </span>
                        </td>
                        <td data-label="<?php esc_attr_e('Priority', 'nexlifydesk'); ?>">
                            <span class="nexlifydesk-priority <?php echo esc_attr($ticket->priority); ?>">
                                <?php echo esc_html(ucfirst($ticket->priority)); ?>
                            </span>
                        </td>
                        <td data-label="<?php esc_attr_e('Date', 'nexlifydesk'); ?>">
                            <?php echo esc_html(date_i18n(get_option('date_format'), strtotime($ticket->created_at))); ?>
                        </td>
                        <td data-label="<?php esc_attr_e('Actions', 'nexlifydesk'); ?>">
                            <a href="<?php echo esc_url(add_query_arg('ticket_id', $ticket->ticket_id, get_permalink())); ?>" class="nexlifydesk-view-btn">
                                <?php esc_html_e('View', 'nexlifydesk'); ?>
                            </a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        
        <footer class="nexlifydesk-table-footer">
            <p>
                <?php
                printf(
                    /* translators: %s: Number of tickets */
                    esc_html__('Showing %s tickets', 'nexlifydesk'),
                    esc_html(count($user_tickets))
                );
                ?>
            </p>
        </footer>
    <?php endif; ?>
</div>