<?php
if (!defined('ABSPATH')) {
    exit;
}

$categories = NexlifyDesk_Tickets::get_categories();
$settings = get_option('nexlifydesk_settings', array());
$max_file_size = isset($settings['max_file_size']) ? (int)$settings['max_file_size'] : 2;
$allowed_types = isset($settings['allowed_file_types']) ? $settings['allowed_file_types'] : 'jpg,jpeg,png,pdf,doc,docx';
?>

<div class="nexlifydesk-frontend-ticket-form-ui">
    <div class="form-container">
        <div class="form-card">
            <?php if (is_user_logged_in()) : ?>
                <div class="form-header">
                    <h1><?php esc_html_e('Get Support', 'nexlifydesk'); ?></h1>
                    <p><?php esc_html_e("We're here to help you resolve any issues quickly", 'nexlifydesk'); ?></p>
                </div>

                <div id="nexlifydesk-message" style="display: none;"></div>

                <form id="nexlifydesk-new-ticket" method="post" enctype="multipart/form-data">
                    <div class="form-group">
                        <label for="ticket-subject">
                            <?php esc_html_e('Subject', 'nexlifydesk'); ?> 
                            <span class="required">*</span>
                        </label>
                        <input type="text" 
                               id="ticket-subject" 
                               name="subject" 
                               required 
                               placeholder="<?php esc_attr_e('Brief description of your issue', 'nexlifydesk'); ?>">
                    </div>

                    <div class="form-group">
                        <label for="ticket-message">
                            <?php esc_html_e('Message', 'nexlifydesk'); ?> 
                            <span class="required">*</span>
                        </label>
                        <textarea id="ticket-message" 
                                  name="message" 
                                  required 
                                  placeholder="<?php esc_attr_e('Please describe your issue in detail...', 'nexlifydesk'); ?>"></textarea>
                    </div>

                    <div class="form-row">
                        <div class="form-group">
                            <label for="ticket-category">
                                <?php esc_html_e('Category', 'nexlifydesk'); ?> 
                                <span class="required">*</span>
                            </label>
                            <select id="ticket-category" name="category_id" required>
                                <option value=""><?php esc_html_e('Select category', 'nexlifydesk'); ?></option>
                                <?php 
                                $default_category = isset($settings['default_category']) ? (int)$settings['default_category'] : 0;
                                if (!empty($categories)) : ?>
                                    <?php foreach ($categories as $category) : ?>
                                        <option value="<?php echo esc_attr($category->id); ?>" <?php selected((int)$default_category, (int)$category->id); ?>>
                                            <?php echo esc_html($category->name); ?>
                                        </option>
                                    <?php endforeach; ?>
                                <?php else : ?>
                                    <option value="1"><?php esc_html_e('General Support', 'nexlifydesk'); ?></option>
                                <?php endif; ?>
                            </select>
                        </div>

                        <div class="form-group">
                            <label for="ticket-priority">
                                <?php esc_html_e('Priority', 'nexlifydesk'); ?> 
                                <span class="required">*</span>
                            </label>
                            <select id="ticket-priority" name="priority" required>
                                <option value="low"><?php esc_html_e('Low', 'nexlifydesk'); ?></option>
                                <option value="medium" selected><?php esc_html_e('Medium', 'nexlifydesk'); ?></option>
                                <option value="high"><?php esc_html_e('High', 'nexlifydesk'); ?></option>
                                <option value="urgent"><?php esc_html_e('Urgent', 'nexlifydesk'); ?></option>
                            </select>
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="ticket-attachments">
                            <?php esc_html_e('Attachments', 'nexlifydesk'); ?>
                        </label>
                        <div class="file-input-wrapper">
                            <input type="file" 
                                   id="ticket-attachments" 
                                   name="attachments[]" 
                                   multiple 
                                   accept=".<?php echo esc_attr(str_replace(',', ',.', $allowed_types)); ?>">
                            <label for="ticket-attachments" class="file-input-label">
                                <svg class="upload-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12"></path>
                                </svg>
                                <span><?php esc_html_e('Click to upload files', 'nexlifydesk'); ?></span>
                                <small class="upload-hint">
                                    <?php esc_html_e('or drag and drop files here', 'nexlifydesk'); ?>
                                </small>
                            </label>
                        </div>
                        <p class="file-info">
                            <?php
                            $server_max_size = min(
                                wp_max_upload_size(),
                                wp_convert_hr_to_bytes(ini_get('post_max_size'))
                            );
                            $server_max_mb = round($server_max_size / 1024 / 1024, 1);
                            $plugin_max_mb = $max_file_size;
                            
                            $effective_max_mb = min($plugin_max_mb, $server_max_mb);
                            
                            printf(
                                /* translators: 1: Maximum file size in MB, 2: Allowed file types (comma separated) */
                                esc_html__('Max size: %1$sMB per file. Allowed types: %2$s', 'nexlifydesk'), 
                                esc_html($effective_max_mb), 
                                esc_html($allowed_types)
                            ); 
                            
                            if ($server_max_mb < $plugin_max_mb) {
                                echo '<br><small style="color: #d63638;">';
                                printf(
                                    /* translators: %s: Server maximum file size in MB */
                                    esc_html__('Server limit: %sMB', 'nexlifydesk'),
                                    esc_html($server_max_mb)
                                );
                                echo '</small>';
                            }
                            ?>
                        </p>
                    </div>

                    <input type="hidden" id="nexlifydesk-captcha-token" name="captcha_token" value="" />

                    <input type="hidden" name="action" value="nexlifydesk_submit_ticket">
                    <?php wp_nonce_field('nexlifydesk-ajax-nonce', 'nonce'); ?>

                    <button type="submit" id="submit-ticket-btn" class="submit-btn">
                        <span class="button-text"><?php esc_html_e('Submit Ticket', 'nexlifydesk'); ?></span>
                        <span class="button-spinner" style="display: none;"></span>
                    </button>
                </form>

            <?php else : ?>
                <div class="login-prompt">
                    <div class="form-header">
                        <h1><?php esc_html_e('Login Required', 'nexlifydesk'); ?></h1>
                        <p><?php esc_html_e('Please log in to submit a support ticket.', 'nexlifydesk'); ?></p>
                    </div>
                    <div class="login-actions">
                        <a href="<?php echo esc_url(wp_login_url(get_permalink())); ?>" class="login-btn primary">
                            <?php esc_html_e('Log In', 'nexlifydesk'); ?>
                        </a>
                        <?php if (get_option('users_can_register')) : ?>
                            <a href="<?php echo esc_url(wp_registration_url()); ?>" class="login-btn secondary">
                                <?php esc_html_e('Register', 'nexlifydesk'); ?>
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endif; ?>
        </div>

        <?php
        $ticket_submitted = 0;
        $ticket_number = '';
        $ticket_id = 0;
        $duplicate_detected = 0;
        
        // phpcs:ignore WordPress.Security.NonceVerification.Recommended -- GET parameters for display purposes only, no sensitive data processing
        if (isset($_GET['ticket_submitted']) && absint($_GET['ticket_submitted']) === 1) {
            $ticket_submitted = 1;
            // phpcs:ignore WordPress.Security.NonceVerification.Recommended -- GET parameters for display purposes only
            $ticket_number = isset($_GET['ticket_number']) ? sanitize_text_field(wp_unslash($_GET['ticket_number'])) : '';
            // phpcs:ignore WordPress.Security.NonceVerification.Recommended -- GET parameters for display purposes only
            $ticket_id = isset($_GET['ticket_id']) ? sanitize_text_field(wp_unslash($_GET['ticket_id'])) : '';
        }
        
        // phpcs:ignore WordPress.Security.NonceVerification.Recommended -- GET parameters for display purposes only, no sensitive data processing
        if (isset($_GET['duplicate_detected']) && absint($_GET['duplicate_detected']) === 1) {
            $duplicate_detected = 1;
            // phpcs:ignore WordPress.Security.NonceVerification.Recommended -- GET parameters for display purposes only
            $ticket_id = isset($_GET['ticket_id']) ? sanitize_text_field(wp_unslash($_GET['ticket_id'])) : '';
        }
        
        if ($ticket_submitted === 1) :
        ?>
        <div class="form-card success-message" style="margin-top: 30px;">
            <div class="form-header success-header">
                <h1><?php esc_html_e('Ticket Submitted!', 'nexlifydesk'); ?></h1>
                <p>
                    <?php
                    printf(
                        /* translators: %s: Ticket number */
                        esc_html__('Your ticket number is %s. We will be in touch shortly.', 'nexlifydesk'), // Fallback for non-JS users or direct URL access. 
                        '<strong>#' . esc_html($ticket_number) . '</strong>'
                    ); ?>
                </p>
            </div>
            <div class="success-actions">
                <?php
                $settings = get_option('nexlifydesk_settings', array());
                $ticket_page_ids = isset($settings['ticket_page_id']) ? $settings['ticket_page_id'] : array();
                if (!is_array($ticket_page_ids)) {
                    $ticket_page_ids = $ticket_page_ids ? array($ticket_page_ids) : array();
                }
                
                if (!empty($ticket_page_ids)) {
                    $ticket_page_url = get_permalink($ticket_page_ids[0]);
                    if ($ticket_page_url) {
                        $view_ticket_url = add_query_arg('ticket_id', $ticket_id, $ticket_page_url);
                        echo '<a href="' . esc_url($view_ticket_url) . '" class="view-ticket-btn">' . esc_html__('View Your Ticket', 'nexlifydesk') . '</a>';
                    }
                }
                ?>
            </div>
        </div>
        <?php endif; ?>
        
        <?php if ($duplicate_detected === 1) : ?>
        <div class="form-card success-message" style="margin-top: 30px; border-color: #ff9800;">
            <div class="form-header success-header">
                <h1><?php esc_html_e('Message Added to Existing Ticket', 'nexlifydesk'); ?></h1>
                <p>
                    <?php
                    printf(
                        /* translators: %s: Ticket ID */
                        esc_html__('We found a similar ticket from you. Your message has been added to ticket %s.', 'nexlifydesk'),
                        '<strong>#' . esc_html($ticket_id) . '</strong>'
                    ); ?>
                </p>
            </div>
            <div class="success-actions">
                <?php
                $settings = get_option('nexlifydesk_settings', array());
                $ticket_page_ids = isset($settings['ticket_page_id']) ? $settings['ticket_page_id'] : array();
                if (!is_array($ticket_page_ids)) {
                    $ticket_page_ids = $ticket_page_ids ? array($ticket_page_ids) : array();
                }
                
                if (!empty($ticket_page_ids)) {
                    $ticket_page_url = get_permalink($ticket_page_ids[0]);
                    if ($ticket_page_url) {
                        $view_ticket_url = add_query_arg('ticket_id', $ticket_id, $ticket_page_url);
                        echo '<a href="' . esc_url($view_ticket_url) . '" class="view-ticket-btn">' . esc_html__('View Your Ticket', 'nexlifydesk') . '</a>';
                    }
                }
                ?>
            </div>
        </div>
        <?php endif; ?>
    </div>
</div>