<?php
if (!defined('ABSPATH')) {
    exit;
}

if (!isset($reply) || !is_object($reply)) {
    return;
}
if (!isset($reply_user)) {
    $reply_user = get_userdata($reply->user_id);
}

$reply_message = isset($reply->message) ? $reply->message : '';
$reply_customer_details = nexlifydesk_extract_customer_details($reply_message);
$reply_customer_name = $reply_user ? $reply_user->display_name : ($reply_customer_details['name'] ?: __('Unknown', 'nexlifydesk'));
$clean_reply_message = $reply_customer_details['message'] ?: $reply_message;

if (!$reply_user || !is_object($reply_user) || !isset($reply_user->roles)) {
    $reply_user = (object) array(
        'display_name' => $reply_customer_name,
        'ID' => 0,
        'roles' => array()
    );
}

$is_admin = is_array($reply_user->roles) && in_array('administrator', $reply_user->roles);
$is_agent = is_array($reply_user->roles) && in_array('nexlifydesk_agent', $reply_user->roles);
$is_support = $is_admin || $is_agent;
$message_class = $is_support ? 'agent' : 'user';
$avatar_url = $reply_user && $reply_user->ID ? get_avatar_url($reply_user->ID) : get_avatar_url(0);
?>
<div class="message <?php echo esc_attr($message_class); ?>" data-reply-id="<?php echo esc_attr($reply->id); ?>" data-user-id="<?php echo esc_attr($reply->user_id); ?>">
    <div class="message-avatar">
        <?php echo get_avatar($reply_user ? $reply_user->ID : 0, 96); ?>
    </div>
    <div class="message-content">
        <div class="message-header">
            <strong><?php echo esc_html($reply_customer_name); ?></strong>
            <span class="timestamp"><?php echo esc_html(date_i18n(get_option('date_format') . ' ' . get_option('time_format'), strtotime($reply->created_at))); ?></span>
        </div>
        <div class="message-body">
            <?php echo nl2br(esc_html($clean_reply_message)); ?>
            
            <?php if (!empty($reply->attachments)) : ?>
                <div class="attachments">
                    <?php foreach ($reply->attachments as $attachment) : ?>
                        <div class="attachment">
                            <a href="<?php echo esc_url($attachment->file_path); ?>" target="_blank">
                                <span class="attachment-icon">📎</span>
                                <?php echo esc_html($attachment->file_name); ?>
                            </a>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>